#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#include "../include/os.h"
#ifdef __MSW__
# include <windows.h>
#endif

#include "obj.h"
#include "sound.h"
#include "sar.h"


void SARSceneSoundUpdate(
	sar_core_struct *core_ptr,
	Boolean engine_sounds,
	Boolean event_sounds,
	Boolean voice_sounds,
	Boolean music
);


/*
 *	Updates all sound resources on the core's scene structure and
 *	its objects with respect to the given sound conditions. Purpose
 *	for this function is to start ot stop sounds at startup or as the
 *	sound options change in the middle of a game.
 *
 *	The core structure's scene must be valid (not NULL).
 *	If the core structure's recorder is NULL and any given inputs
 *	suggest sound is to be enabled then the recorder will be
 *	initialized.
 */
void SARSceneSoundUpdate(
        sar_core_struct *core_ptr,
        Boolean engine_sounds,
        Boolean event_sounds,
        Boolean voice_sounds,
        Boolean music 
)
{
	int obj_num;
	const char *snd_path;
	sar_scene_struct *scene;
	snd_recorder_struct *recorder;
	sar_object_struct *obj_ptr;
	sar_object_aircraft_struct *obj_aircraft_ptr;
	void **snd_play_rtn;
	const char *sound_server_connect_arg = "127.0.0.1:9433";


	if(core_ptr == NULL)
	    return;

	scene = core_ptr->scene;
	recorder = core_ptr->recorder;

	/* Is recorder NULL? */
	if(recorder == NULL)
	{
	    /* Turn sound on? */
	    if(engine_sounds || event_sounds || voice_sounds ||
	       music
	    )
	    {
		/* Need to initialize recorder. */
		GWSetInputBusy(core_ptr->display);
		recorder = SoundInit(
		    SNDSERV_TYPE_Y,
		    sound_server_connect_arg,
		    NULL          /* Do not start sound server. */
		);
		if(recorder == NULL)
		{
		    char *buf;
		    int buf_len;

		    buf_len = 256 + ((sound_server_connect_arg == NULL) ?
			0 : strlen(sound_server_connect_arg)
		    );
		    buf = (char *)malloc(buf_len * sizeof(char));
		    if(buf != NULL)
			sprintf(buf,
"Unable to connect to sound server at:\n\n    %s",
			    sound_server_connect_arg
			);

		    GWOutputMessage(
			core_ptr->display,
			GWOutputMessageTypeError,
			"Sound initialization failed!",
			buf,
"Please check to make sure that your sound server\n\
is running and available at the specified address.\n\
Also make sure that you have sufficient permission\n\
to connect to it."
		    );
		    free(buf);
		}
		else
		{
		    core_ptr->recorder = recorder;

		    SoundChangeMode(
			core_ptr->recorder, core_ptr->audio_mode_name
		    );
		}
		GWSetInputReady(core_ptr->display);
	    }
	    else
	    {
		/* Recorder not initialized and sound is turn off. */
		return;
	    }
	}

	/* Scene structure must be valid. */
	if(scene == NULL)
	    return;




	/* Update sounds on the scene structure. */




	/* Update sounds on each object. */
	for(obj_num = 0; obj_num < core_ptr->total_objects; obj_num++)
	{
	    obj_ptr = core_ptr->object[obj_num];
	    if(obj_ptr == NULL)
		continue;

	    switch(obj_ptr->type)
	    {
	      case SAR_OBJ_TYPE_AIRCRAFT:
		obj_aircraft_ptr = (sar_object_aircraft_struct *)obj_ptr->data;
		if(obj_aircraft_ptr != NULL)
		{
#define DO_LOAD_ENGINE_SOUND	\
{ \
 if((*snd_play_rtn) == NULL) \
  SARObjLoadSound( \
   recorder, (snd_play_struct **)snd_play_rtn, \
   snd_path, SND_PLAY_OPTION_REPEATING \
  ); \
}
#define DO_UNLOAD_ENGINE_SOUND	\
{ \
 if((*snd_play_rtn) != NULL) \
 { \
  SoundStopPlay(recorder, *snd_play_rtn); \
  (*snd_play_rtn) = NULL; \
 } \
}

		    if(engine_sounds)
		    {
			/* Turn engine sounds on as needed. */

			snd_play_rtn = &obj_aircraft_ptr->engine_inside_sndplay;
			snd_path = obj_aircraft_ptr->engine_inside_sndpath;
			DO_LOAD_ENGINE_SOUND

                        snd_play_rtn = &obj_aircraft_ptr->engine_outside_sndplay;
                        snd_path = obj_aircraft_ptr->engine_outside_sndpath;
                        DO_LOAD_ENGINE_SOUND
		    }
		    else
		    {
			/* Turn engine sounds off as needed. */

                        snd_play_rtn = &obj_aircraft_ptr->engine_inside_sndplay;
			DO_UNLOAD_ENGINE_SOUND

                        snd_play_rtn = &obj_aircraft_ptr->engine_outside_sndplay;
                        DO_UNLOAD_ENGINE_SOUND
		    }
#undef DO_UNLOAD_ENGINE_SOUND
#undef DO_LOAD_ENGINE_SOUND


		}
		break;

/* Add support for other object types that have sound. */

	    }
	}


	return;
}
