##################################################################
# SecPanel
#
# Secure copy (SCP) related code
#
# Ver. 0.5.4
##################################################################

proc scptransfer {mode} {
    global env widget configs scpurl libdir termtype

    set connstring ""

    set dlr $widget(scpdirsr)
    set flr $widget(scpfilesr)
    set dll $widget(scpdirsl)
    set fll $widget(scpfilesl)

    set lactdir [.top34.fra35.ent45 get]
    set ractdir [.top34.fra37.ent44 get]

    switch -exact $mode {
	cptoremote {
	    if {[selection own] == $dll} {
		set rectag " -r "
		set lr $dll
	    } elseif {[selection own] == $fll} {
		set rectag ""
		set lr $fll
	    } else {
		showmessage "No files or directories selected on the local site" .top34
		return
	    }
	}
	cptolocal {
	    if {[selection own] == $dlr} {
		set rectag " -r "
		set lr $dlr
	    } elseif {[selection own] == $flr} {
		set rectag ""
		set lr $flr
	    } else {
		showmessage "No files or directories selected on the remote site" .top34
		return
	    }
	}
    }
    
    foreach cs [$lr curselection] {
	lappend resslist [$lr get $cs]
    }
    
    array set bools {
	"scpstats" "-q" \
		"scppres" "-p" \
		"scpverb" "-v" \
		"scpcomp" "-C"
    }

    foreach f [array names bools] {
	if [set configs($f)] {
	    set [set f]_tag "$bools($f) "
	} else {
	    set [set f]_tag " "
	}
    }

    if [info exists configs(scpport)] {
	if {$configs(scpport) != "" && $configs(scpport) != 22} {
	    set porttag " -P $configs(scpport) "
	} else {
	    set porttag ""
	}
    }

    if {$configs(sshver) == "OpenSSH"} {
	set progtag " -S $configs(sshbin) "
    } else {
	set progtag ""
    }

    set scpstring1 "$configs(scpbin) $progtag $porttag $scpstats_tag $scppres_tag $scpverb_tag $scpcomp_tag $rectag "
    set connstring "$connstring $scpstring1"

    regsub -all " " $ractdir "\\ " rpad1 
    regsub -all "\\(" $rpad1 "\\(" rpad2
    regsub -all "\\)" $rpad2 "\\)" rpad3
    regsub -all "\\\[" $rpad3 "\\\[" rpad4
    regsub -all "\\\]" $rpad4 "\\\]" rpad

    regsub -all " " $lactdir "\\ " lpad1
    regsub -all "\\(" $lpad1 "\\(" lpad2
    regsub -all "\\)" $lpad2 "\\)" lpad3
    regsub -all "\\\[" $lpad3 "\\\[" lpad4
    regsub -all "\\\]" $lpad4 "\\\]" lpad

    foreach r $resslist {
	if {$mode == "cptolocal"} {
	    regsub -all " " $r "\\ " rp1
	    regsub -all "\\(" $rp1 "\\(" rp2
	    regsub -all "\\)" $rp2 "\\)" rp
	    set scpstring2 "\"$scpurl:$rpad/$rp\" "
	} else {
	    set scpstring2 "\"$lactdir/$r\" "
	}
	set connstring "$connstring $scpstring2"
    }
    
    if {$mode == "cptolocal"} {
	set scpstring3 " \"$lactdir\""
    } else {
	set scpstring3 " \"$scpurl:$rpad\""
    }
    set connstring "$connstring $scpstring3"


    # <xterm selection and params>
    set defterm 1

    if $defterm {
	set usetermver "Xterm"
    } else {
	set usetermver $configs(termver)
    }
    
    set icontag ""
    
    set configs(xtermbin) $termtype([set usetermver]_path)
    set titlepar $termtype([set usetermver]_titlepar)
    set quotepar $termtype([set usetermver]_quotepar)
    set execpar $termtype([set usetermver]_execpar)
    if {[info exists termicon] && $termicon} {
	set icontag $termtype([set usetermver]_iconpar)
    }
    # </xterm selection and params>


    set runstring "exec $configs(xtermbin) $execpar $quotepar $libdir/secpanel.wait <CONNFILE> $quotepar"

    provrunfile term bg $connstring $runstring

    command_trace save "$connstring"

    if {$mode == "cptolocal"} {
	historyman write 3 "$scpurl -> Local"
    } else {
	historyman write 3 "Local -> $scpurl"
    }
}

proc scpAuth {sock} {
    global pass

    gets $sock passandport

    set serverpass [lindex [split $passandport] 1]

    if {$serverpass != $pass} {
	close $sock
	showmessage "Wrong authentication from remote ListServer\nHad to reject connection" .top17
	return
    } else {
	puts "in scpauth"
	close $sock
	scpman opengui
    }
}

proc Accept {sock addr port} {
    global pass

    fconfigure $sock -buffering line
    fileevent $sock readable "scpAuth $sock"
}

proc scptools {tool side} {
    global widget scplister configs scpurl

    set actdirl "[.top34.fra35.ent45 get]"
    set actdirr "[.top34.fra37.ent44 get]"

    set dlr $widget(scpdirsr)
    set flr $widget(scpfilesr)
    set dll $widget(scpdirsl)
    set fll $widget(scpfilesl)

    set ltext "local"
    set rtext "remote"

    switch -exact $tool {
	mkdir {

	    set newdir [askforuser md]
	    if {$newdir == "#####"} {
		return
	    }

	    switch -exact $side {
		l {
		    file mkdir "[set actdir[set side]]/$newdir"
		}
		r {
		    puts $scplister "++MakeDir [set actdir[set side]]/$newdir"
		}
	    }
	    scpswitchdir ent [set side]
	}
	delete {
	    if {[selection own] == [set dl[set side]]} {
		set lr [set dl[set side]]
	    } elseif {[selection own] == [set fl[set side]]} {
		set lr [set fl[set side]]
	    } else {
		showmessage "No files or directories selected on the [set [set side]text] site" .top34
		return
	    }
	    
	    foreach cs [$lr curselection] {
		lappend resslist "[set actdir[set side]]/[$lr get $cs]"
	    }
	    
	    if [showconfirm "Really delete $resslist?" ""] {
		switch -exact $side {
		    l {
			foreach f $resslist {
			    if {[catch {file delete $f} err] > 0} {
				showmessage "$err" .top34
			    }
			}
		    }
		    r {
			foreach f $resslist {
			    puts $scplister "++DelFile $f"
			}
		    }
		}
		scpswitchdir ent [set side]
	    }
	}
	list {
	    set text .top47.cpd48.03
	    Window show .top47
	    $text delete 1.0 end

	    if $configs(scpshowhidden) {
		set ls "la"
	    } else {
		set ls "l"
	    }

	    switch -exact $side {
		l {
		    if $configs(scpshowhidden) {
			set ls "la"
		    } else {
			set ls "l"
		    }
		    $text insert end "Contents of $actdirl\n\n"
		    update idletasks
		    set fl [open "| ls -$ls [quote_space $actdirl]" r]
		    while {[gets $fl line] >= 0} {
			$text insert end "$line\n"
		    }
		    close $fl
		}
		r {
		    $text insert end "Contents of $scpurl:$actdirr\n\n"
		    update idletasks
		    puts $scplister "++Listing$ls $actdirr"
		    while 1 {
			gets $scplister line
			if {$line == "+++++"} {
			    break
			}
			$text insert end "$line\n"
		    }
		}
	    }
	}
    }
}

proc scpman {mode} {
    global widget configs libdir env scplister \
	scpurl controlserver pass spversion wins termtype

    switch -exact $mode {
	"open" {
	    
	    if {[ $widget(scphosts) index end] <= 0} {
		showmessage "Please configure a new connection. There are no hosts to connect to!" .top17
		return
	    }
	    
	    if {[selection own] != $widget(scphosts)} {
		showmessage "Please select connection" .top17
		return
	    }

	    set actconn [retprof [$widget(scphosts) get active]]
	    source "$env(HOME)/.secpanel/profiles/$actconn.profile"

	    if {$user == "<ASKFORUSER>"} {
		set user [askforuser]
		if {$user == "#####"} {
		    return
		}
	    }

	    set scpurl "$user@$host"

	    # Launching Control-Server in SecPanel
	    if [info exists controlserver] {
		close $controlserver
	    }
	    set controlserver [socket -server "Accept" -myaddr 127.0.0.1 $configs(controllocalport)]
	    fconfigure $controlserver -buffering line

	    showstatus "Waiting for ListServer-Callback"

	    # Generating a password
	    set pass [expr {int(rand() * 1000 * [pid])}][expr {int(rand() * 1000 * [pid])}]

	    # Launching listserver on remote site
	    set lf [open "$libdir/listserver.[set configs(lsinterpret)]" r]
	    set currlf [open "$env(HOME)/.secpanel/.listserver.[set configs(lsinterpret)]" w]
	    while {[gets $lf line] >= 0} {
		if [regsub {<PASS-XXXXX>} $line $pass out] {
		    puts $currlf $out
		    continue
		}
		if [regsub {<listserverport-XXXXX>} $line $configs(listserverport) out] {
		    puts $currlf $out
		    continue
		}
		if [regsub {<controlremoteport-XXXXX>} $line $configs(controlremoteport) out] {
		    puts $currlf $out
		    continue
		}
		puts $currlf $line
	    }
	    close $currlf
	    close $lf

	    if [set configs(lsverbose)] {
		set lsverbosetag "-v"
	    } else {
		set lsverbosetag " "
	    }

	    if [info exists configs(scpport)] {
		if {$configs(scpport) != "" && $configs(scpport) != 22} {
		    set porttag " -p $configs(scpport) "
		} else {
		    set porttag ""
		}
	    }

	    # <xterm selection and params>
	    set defterm 1
	    
	    if $defterm {
		set usetermver "Xterm"
	    } else {
		set usetermver $configs(termver)
	    }
    
	    set icontag ""
	    
	    set configs(xtermbin) $termtype([set usetermver]_path)
	    set titlepar $termtype([set usetermver]_titlepar)
	    set quotepar $termtype([set usetermver]_quotepar)
	    set execpar $termtype([set usetermver]_execpar)
	    if {[info exists termicon] && $termicon} {
		set icontag $termtype([set usetermver]_iconpar)
	    }
	    # </xterm selection and params>

	    set waittag ""
	    set woption ""
	    if {[info exists configs(lswait)] && [set configs(lswait)] } {
		set waittag "$libdir/secpanel.wait"
		set woption "\'"
	    }

	    set connstring ""

	    set connstring "$connstring\#!/bin/bash\n\necho -e \"SecPanel $spversion ListServer\n\nIn this shell we get a connection for establishing\na graphical file listing.\n---------------------------------------------------------\n\n\""

	    if {$configs(lsinterpret) == "tcl"} {
		set connstring "$connstring\n$configs(sshbin) -C $lsverbosetag $porttag \
  		    -L $configs(scpguiport):127.0.0.1:$configs(listserverport) \
                    -R $configs(controlremoteport):127.0.0.1:$configs(controllocalport) \
  		    -l $user $host cat < $env(HOME)/.secpanel/.listserver.tcl \">\" .listserver\\; chmod +x .listserver\\; ./.listserver"
	    } elseif {$configs(lsinterpret) == "shellnc"} {
		set connstring "$connstring\n$configs(sshbin) -C $lsverbosetag $porttag \
  		    -L $configs(scpguiport):127.0.0.1:$configs(listserverport) \
                    -R $configs(controlremoteport):127.0.0.1:$configs(controllocalport) \
  		    -l $user $host cat < $env(HOME)/.secpanel/.listserver.shellnc \">\" .listserver\\; chmod +x .listserver\\; ./.listserver"
	    } else {
		puts "no valid lsinterpret"
		return
	    }

	    set runstring "exec $configs(xtermbin) $titlepar \"SecPanel ListServer\" \
		    $execpar $quotepar $waittag $woption <CONNFILE> $woption $quotepar"

	    provrunfile term bg $connstring $runstring


	    command_trace save "$connstring"
	    
	    historyman write 2 "$scpurl"
	    
	    exec rm -vf "$env(HOME)/.secpanel/.listserver.*"
	}
	"opengui" {
	    showstatus "Received CallBack from ListServer"
	    puts "Received CallBack from ListServer"

	    close $controlserver
	    unset controlserver

	    Window show .top34

	    if {[info exists configs(wingeom)] && $configs(wingeom)} {
		if [info exists wins(scp)] {
		    wm geometry ".top34" $wins(scp)
		}
	    }

	    .top34.fra46.lab47 config -text "$env(USER)@[info hostname]"
	    .top34.fra17.lab18 config -text "$scpurl"

	    .top34.fra48.but49 config -image [image create photo -file $libdir/images/arrow_right.gif]
	    .top34.fra48.but50 config -image [image create photo -file $libdir/images/arrow_left.gif]

	    if {[catch {set scplister [socket 127.0.0.1 $configs(scpguiport)]} err] > 0} {
		puts "opengui Error: $err"
	    }

	    fconfigure $scplister -buffering line
	    showstatus "Connected to ListServer"
	    puts $scplister "auth $pass"

	    
	    scplist $env(HOME) l
	    scplist "++InitListing" r
	}
	"close" {
	    puts $scplister "++CloseYourSelf"
	    close $scplister
	    destroyfilter .top34
	}
    }
}

proc scpswitchdir {y mode} {
    global widget env
    switch -exact $mode {
	l {
	    set actdir "[.top34.fra35.ent45 get]"
	    if {$y == "ent"} {
		if {$actdir == "~"} {
		    scplist "$env(HOME)" $mode
		} else {
		    scplist "$actdir" $mode
		}
		return
	    }
	}
	r {
	    set actdir "[.top34.fra37.ent44 get]"
	    if {$y == "ent"} {
		if {$actdir == "~"} {
		    scplist "++InitListing" r
		} else {
		    scplist "$actdir" $mode
		}
		return
	    }
	}
    }
    set dl $widget(scpdirs[set mode])
    set fl $widget(scpfiles[set mode])


    if {$actdir != "/"} {
	set seldir "$actdir/[$dl get [$dl nearest $y]]"
    } else {
	set seldir "/[$dl get [$dl nearest $y]]"
    }
    
    scplist $seldir $mode
}

proc scplist {actdir mode} {
    global widget scplister configs

    set dl $widget(scpdirs[set mode])
    set fl $widget(scpfiles[set mode])

    $dl delete 0 end
    $fl delete 0 end
    
    set pe [file split "$actdir"]
    set pl [llength $pe]
    
    if {[lindex $pe [expr $pl - 1]] == ".."} {
	set actdir "[eval file join [lrange $pe 0 [expr $pl - 3]]]"
    }
    
    if {$actdir != "/"} {
	$dl insert end ..
    }

    switch -exact $mode {
	"l" {
	    .top34.fra35.ent45 delete 0 end
	    .top34.fra35.ent45 insert 0 "$actdir"

	    # regsub -all "\\\[" $actdir "\\\[" actdir1
	    # regsub -all "\\\]" $actdir1 "\\\]" actdir

	    if $configs(scpshowhidden) {
		set gpat "glob -nocomplain \"$actdir/.*\" \"$actdir/*\""
	    } else {
		set gpat "glob -nocomplain \"$actdir/*\""
	    }

	    puts $gpat

	    foreach f [lsort [eval $gpat]] {

		if {[file tail "$f"] == ".." || [file tail "$f"] == "."} {
		    continue
		}
		if [file isdirectory "$f"] {
		    $dl insert end [file tail "$f"]
		} else {
		    $fl insert end [file tail "$f"]
		}
	    }
	}
	"r" {
	    puts $scplister "$actdir\t$configs(scpshowhidden)"

	    puts "fetching $actdir\t$configs(scpshowhidden)"

	    # Catching errors from ListServer...
	    set actdir "[string trimleft [gets $scplister] "+"]"

	    .top34.fra37.ent44 delete 0 end
	    .top34.fra37.ent44 insert 0 "$actdir"

	    while 1 {
		gets $scplister line
		if {$line == "+++++"} {
		    break
		}
		if [regsub {^\+\+ } $line "" ls] {
		    $dl insert end [file tail $ls]
		} else {
		    $fl insert end [file tail $ls]
		}
	    }
	}
    }
}
