#include <ipc_secure.h>
#include <lsm.h>

int shmsid (int shmid, security_id_t *sid)
{
	unsigned long args[2];
	long err = 0;

	args[0] = (unsigned long)shmid;
	args[1] = (unsigned long)sid;
	err = lsm(SELINUX_MAGIC, SELINUXCALL_SHMSID, args);
	if (err < 0) {
		*sid = SECINITSID_UNLABELED;
	}

	return err;
}
