#include <fs_secure.h>
#include <ss.h>
#include <stdlib.h>
#include <errno.h>

int main(int argc, char **argv)
{
	struct stat sb;
	security_id_t sid;
#define INITLEN 255
	char *context;
	int len, rc, i;


	if (argc < 2) {
		printf("usage:  %s pathname...\n", argv[0]);
		exit(1);
	}

	for (i = 1; i < argc; i++) {
		if (stat_secure(argv[i], &sb, &sid) < 0) {
			perror(argv[i]);
			exit(2);
		}

		printf("%s:  SID:  %d  ", argv[i], sid);

		context = malloc(INITLEN);
		if (!context) {
			perror("malloc");
			exit(2);
		}
		len = INITLEN;

		rc = security_sid_to_context(sid, context, &len);
		if (rc && errno == ENOSPC) {
			context = realloc(context, len);
			if (!context) {
				perror("realloc");
				exit(2);
			}
			rc = security_sid_to_context(sid, context, &len);
		}

		if (rc) {
			perror("security_sid_to_context");
			exit(2);
		}

		printf("Context:  %s\n", context);
	}

	exit(0);
}
