/*
 * Security Context Mapping Protocol
 *
 * Copyright (c) 2001-2002 James Morris <jmorris@intercode.com.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */
#ifndef _SCMP_H_
#define _SCMP_H_

#define SCMP_VERSION			1

#define SCMP_MSG_UNSPEC			0
#define SCMP_MSG_BASE			1
#define SCMP_MSG_MAP_REQ		2
#define SCMP_MSG_MAP_RES		3
#define SCMP_MSG_ERR_RES		4
#define SCMP_MSG_MAX			SCMP_MSG_ERR_RES

#define SCMP_ERR_UNSPEC			0	/* Unspecified error */
#define SCMP_ERR_LENGTH			1	/* Invalid message length */
#define SCMP_ERR_ADDRESS		2	/* Invalid payload address */
#define SCMP_ERR_VERSION		3	/* Invalid SCMP version */
#define SCMP_ERR_TYPE			4	/* Invalid mesage type */
#define SCMP_ERR_LOCAL			5	/* Local processing error */
#define SCMP_ERR_INTERNAL		6	/* Application error (bug) */
#define SCMP_ERR_RECORDS		7	/* Invalid # of records */
#define SCMP_ERR_CONTEXT		8	/* Security ctx lookup failed */
#define SCMP_ERR_SID			9	/* SID lookup failed */
#define SCMP_ERR_MAX			SCMP_ERR_SID

#define SCMP_CONTEXT_MAX		8192	/* Max len security context */
#define SCMP_RECORDS_MAX		3	/* Max records per message */

/*
 * Base message.
 */
struct scmp_msg_base
{
	u_int8_t version;
	u_int8_t type;
	u_int16_t len;
	u_int32_t peer;
	u_int32_t sequence;
	u_int32_t serial;
};

/*
 * Map attribute, context must be 32-bit aligned with right zero-padding.
 */
struct scmp_attr_map
{
	security_id_t sid;
	u_int16_t context_len;
	u_int16_t reserved;
	unsigned char context[0];
};

/*
 * Map request message.
 */
struct scmp_msg_map_req
{
	struct scmp_msg_base base;
	u_int16_t records;
	u_int16_t reserved;
	security_id_t sid[0];
};

/*
 * Map response message.
 */
struct scmp_msg_map_res
{
        struct scmp_msg_base base;
        u_int16_t records;
        u_int16_t reserved;
	struct scmp_attr_map map[0];
};

/*
 * Error response extension.
 */
struct scmp_msg_err_res
{
        struct scmp_msg_base base;
        struct scmp_msg_base orig;
        u_int16_t errcode;
	u_int16_t pointer;
};

/*
 * All messages and message attributes are 32-bit aligned, and right zero
 * padded if necessary.
 */

#define SCMP_ALIGNTO		4

#define SCMP_ALIGN(len)		((len + (SCMP_ALIGNTO - 1)) & ~(SCMP_ALIGNTO - 1))

#define SCMP_ALIGNED(len)	(!(len % SCMP_ALIGNTO))

#define SCMP_MSGLEN_MIN		SCMP_ALIGN(sizeof(struct scmp_msg_map_req) \
                                           + sizeof(security_id_t))

#define SCMP_MSGLEN_MAX		SCMP_ALIGN(sizeof(struct scmp_msg_base) \
                                           + SCMP_RECORDS_MAX \
                                           * (sizeof(struct scmp_attr_map) \
                                           + SCMP_CONTEXT_MAX))

#endif	/* _SCMP_H_ */
