#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <proc_secure.h>
#include <ss.h>

#ifndef PASSWD
#define PASSWD "/usr/bin/passwd"
#endif

#define SZ 255

char *passwd_argv[] = { PASSWD, NULL };

int main(int argc, char **argv) 
{
  struct passwd *pw;
  security_context_t context;
  char *p;
  security_id_t sid;
  uid_t ruid;
  int ret;
  unsigned int len;

  if (argc != 1) {
    fprintf(stderr, "%s:  wrapper does not accept arguments\n",
	    argv[0]);
    exit(1);
  }

  ruid = getuid();
  if (ruid < 0) {
    perror(argv[0]);
    exit(1);
  }

  pw = getpwuid(ruid);
  if (!pw) {
    fprintf(stderr, "%s:  no passwd entry for uid %d\n",
	    argv[0], ruid);
    exit(1);
  }

  sid = getsecsid();
  if (sid < 0) {
    perror(argv[0]);
    exit(1);
  }

  context = malloc(SZ);
  if (!context) {
    perror(argv[0]);
    exit(1);
  }

  len = SZ;
  ret = security_sid_to_context(sid, context, &len);
  if (ret) {
    if (len > SZ) {
      context = realloc(context, len);
      if (!context) {
	perror(argv[0]);
	exit(1);
      }
      ret = security_sid_to_context(sid, context, &len);
    }
    if (ret) {
      perror(argv[0]);
      exit(1);
    }
  }
  
  for (p = context; *p && *p != ':'; p++)
    ;
  *p = 0;
  if (strcmp(pw->pw_name, context) != 0) {
    fprintf(stderr, "%s:  Unix identity %s does not match Flask identity %s\n",
	    argv[0], pw->pw_name, context);
    exit(1);
  }

  execv(PASSWD, passwd_argv);
  perror(argv[0]);
  exit(1);
}
