#ifndef _SP_IO_H_
#define _SP_IO_H_

int OpenModem(struct pcinfo *pcinfo, int *fd);
int ResetModem(int fd, struct cbuf *cbuf, struct pcinfo *pcinfo);
int SendString (int fd, char *string);
int WaitString (int fd, char *msg, struct cbuf* cbuf);
int SafeRead (int fd, char * buf, int len);
char *PrintBytes (char * buf, int len);
int DialModem(int fd, struct cbuf* cbuf, struct pcinfo* pcinfo);
int WaitLine (int fd, struct cbuf* cbuf, int retries);
int StartPET(int fd, struct cbuf*cbuf, struct pcinfo *pcinfo);
int WaitPETReply (int fd, struct cbuf *cbuf);
int SendPETTransaction(int fd, struct cbuf*cbuf, char *field1, char *field2,
                      int protocol);
int MakePETPacket(char *buf, int *buflen, char *field1, char *field2, 
                  int protocol);
int SendBytes (int fd, char *bytes, int len);
int EndPETTransaction(int fd, struct cbuf *cbuf);
#ifdef UUCP_LOCKING
int LockTTY(char *ttyname);
int UnLockTTY(char * ttyname);
#endif
#ifdef WAIT_WORD
int Match(int fd, char *str, int retries);
#endif
int HangUpModem(int fd, struct cbuf *cbuf);
int send_pet_transaction(int fd, struct cbuf*cbuf, unsigned char * field_vec[],
                         int field_vec_len, int protocol);
int make_pet_block(char *buf, int *buf_len, char *data, int data_len, 
                   int protocol, int more);

#endif
