/***************************************************************************
 *  Module:      $Id: misc.c,v 2.17 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: misc functions for sendpage
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: misc.c,v $
Revision 2.17  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 2.16  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.15  1997/12/25 08:30:52  nemesis
code cleanups

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.1  1997/12/15 15:56:39  nemesis
Initial revision

 */

/*
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <stdlib.h>
*/
#include "sendpage.h"
#include "report.h"

char *modemResultCodes[] = {
  "OK",			/* 0 */
  "CONNECT",		/* 1 */
  "RING",		/* 2 */ 
  "NO CARRIER",	        /* 3 */
  "ERROR",		/* 4 */
  "CONNECT 1200",	/* 5 */
  "NO DIAL TONE",	/* 6 */ 
  "BUSY",		/* 7 */
  "NO ANSWER",	        /* 8 */    
  "RESERVED",		/* 9 */
  "CONNECT 2400",	/* 10 */
  "RINGING",		/* 11 */
  "VOICE",		/* 12 */
  "CONNECT 9600",	/* 13 */
};


/*********************************************************************
 * Function: GetLine
 *
 * Returns: 0 for good (a line ending in 0x0d was received)
 *          1 for good (eof)
 *			others for bad
 *
 *********************************************************************/
int GetLine (int fd, struct linebuf * lbuf) {
  extern int errno;
  int n, x, match;
  char *tmpp;
  
  match = 0;
  
  /* allocate the initial size */
  if (!lbuf->buf) {
    if (!(lbuf->buf = (char*) malloc((unsigned)ADD_LINE_BLOCKSIZE))) {
      perror("malloc");
      return -1; /* bad */
    }
    ++lbuf->nblocks;
  }
  
  /* clean up after the previous invocation */
  if (lbuf->len) {
    memcpy(lbuf->buf, lbuf->buf+lbuf->len, lbuf->bufused - lbuf->len);
    lbuf->bufused -= lbuf->len;
    lbuf->len = 0;
  }
  
  x = 0;
  while (1) {
    if ((n = read(fd, lbuf->buf+lbuf->bufused, (int)
		  (ADD_LINE_BLOCKSIZE*lbuf->nblocks-lbuf->bufused))) < 0) {
      perror("read");
      return -1; /* bad */
    }
    
    lbuf->bufused += n;
    for (;lbuf->len < lbuf->bufused; ++lbuf->len) {
      if (lbuf->buf[lbuf->len] == '\n') {
	match = 1;
	++ lbuf->len;
	break;
      }       
    }
    
    if (match) {
      if (lbuf->len)
	lbuf->len2 = lbuf->len - 1;
      else
	lbuf->len2 = 0;
      return 0; /* good */
    }
    
    /* if nothing was read, return what's here */
    if (!n) {
      lbuf->len2 = lbuf->len;
      return 1; /* good/eof */
    }
    
    /* add more buf space if needed */
    if (lbuf->bufused == (ADD_LINE_BLOCKSIZE*lbuf->nblocks)) {
      tmpp = lbuf->buf;
      if (!(lbuf->buf = 
	    (char*)realloc(lbuf->buf,
			   (unsigned)(++lbuf->nblocks*ADD_LINE_BLOCKSIZE)))) {
	perror("realloc");
	lbuf->buf = tmpp;
	return -1; /* bad */
      }
    }
    
  } /* while 1 */
} /* GetLine */

/*********************************************************************
 * Function: AddMessage
 *	Adds a string p of length len to a dynamically growing string str, and
 *	null terminates it.  This differs from AddToDynString() in that
 *  this still returns 1 string, not a list.
 *
 *	Returns:	0	good
 *		       !0	bad
 *
 *  The initial call should have msglist zero'd.
 *  The callee is responsible for free()ing the storage allocated
 *
 *********************************************************************/
int AddMessage(struct dynstring *str, char * p, int len) {
  char *tmpp;
  
  while (1) {
    /* allocate length bytes + ' ' + null char ?? */
    if ((len + 2 + str->bufused) > (str->nblocks * ADD_STR_BLOCKSIZE)) {
      if (!str->nblocks) { /* allocate original */
	if (!(str->buf = (char*) malloc((unsigned)(++str->nblocks *
						   ADD_STR_BLOCKSIZE)))) {
	  perror("malloc");
	  return -1; /* bad */
	}
      } else { /* allocate more */
	tmpp = str->buf;
	if (!(str->buf = 
	      (char*) realloc(str->buf, 
			      (unsigned)(++str->nblocks * ADD_STR_BLOCKSIZE)))) {
	  perror("realloc");
	  str->buf = tmpp; /* realloc null'd it */
	  if (str->buf)
	    free (str->buf);
	  str->buf = (char*)NULL;
	  return -1; /* bad */
	}
      } /* else */
    } else
      break; /* done allocating */
  } /* while allocating in ADD_STR_BLOCKSIZE blocks */
  
  memcpy(str->buf+str->bufused, p, len);
  str->buf[str->bufused+len] = '\n'; /* add enter between calls */
  str->buf[str->bufused+len+1] = 0; /* null terminate it */
  str->bufused += len+1; /* don't count null char in length used */
  
  return 0; /* good */
  
} /* AddMessage */

#ifdef DEBUG
#ifdef SYSV_MALLOC
void PrintMallinfo(struct mallinfo m) {
  printf("total space in arena=                                 %d\n",
	 m.arena);
  printf("number of ordinary blocks=                            %d\n", 
	 m.ordblks);
  printf("number of small blocks=                               %d\n", 
	 m.smblks);
  printf("number of holding blocks=                             %d\n", 
	 m.hblks);
  printf("space in holding block headers=                       %d\n", 
	 m.hblkhd);
  printf("space in small blocks in use=                         %d\n", 
	 m.usmblks);
  printf("space in free small blocks=                           %d\n", 
	 m.fsmblks);
  printf("space in ordinary blocks in use=                      %d\n", 
	 m.uordblks);
  printf("space in free ordinary blocks=                        %d\n", 
	 m.fordblks);
  printf("cost of enabling keep option=                         %d\n", 
	 m.keepcost);
#ifndef hpux
  printf("max size of small blocks=                             %d\n", 
	 m.mxfast);
  printf("number of small blocks in a holding block=            %d\n", 
	 m.nlblks);
  printf("small block rounding factor=                          %d\n", 
	 m.grain);
  printf("space (including overhead) allocated in ord. blocks=  %d\n", 
	 m.uordbytes);
  printf("number of ordinary blocks allocated=                  %d\n", 
	 m.allocated);
  printf("bytes used in maintaining the free tree=              %d\n", 
	 m.treeoverhead);
#endif /* hpux */

  printf("\n\n");
};

#endif /* SYSV_MALLOC */
#endif /* DEBUG */

/*********************************************************************
 * Function: pr_ModemResultCode
 *	print modem result codes in verbose format
 *********************************************************************/
char *pr_ModemResultCode(int code) {
  if (code > (sizeof(modemResultCodes)/sizeof(char*)))
    return "Unrecognized response";
  else
    return modemResultCodes[code];
} /* pr_ModemResultCode */

