/***************************************************************************
 *  Module:      $Id: mysignal.c,v 1.2 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: signal handling code for sendpage
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: mysignal.c,v $
Revision 1.2  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 1.1  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.15  1997/12/26 02:37:31  nemesis
code clean up, b* -> mem* funcs, finding NL -> # bug

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.1  1997/12/15 15:57:44  nemesis
Initial revision

 * Revision 1.3  1995/11/13  04:44:41  maf
 * *** empty log message ***
 *
 * Revision 1.2  1995/05/24  00:48:27  maf
 * added POSIX style signal handling with mysignal()
 *
 * Revision 1.1  1995/01/10  01:44:35  maf
 * Initial revision
 *
*/

#include "sendpage.h"

RETSIGTYPE sig_hup(int sig) {
  extern int need_readconfig;
  need_readconfig = 1;
}

RETSIGTYPE sig_usr1(int sig) {
  extern int need_runqueue;
  need_runqueue = 1;
}

RETSIGTYPE sig_alrm(int sig) {
  extern int need_runqueue;
  need_runqueue = 1;
}

RETSIGTYPE sig_quit(int sig) {
  extern int need_quit;
  need_quit = 1;
}

RETSIGTYPE sig_pipe(int sig) {
  extern int got_sigpipe;
  got_sigpipe = 1;
}

#ifdef HAVE_SIGACTION
/*********************************************************************
 * Function: mysignal()
 *  POSIX style signals.  
 *
 *	signal() has different semantics over different versions of unix.
 *	this emulates signal() with sigaction() to behave like BSD.
 *
 * From Stevens Advanced Programming in the UNIX environment
 *
 *********************************************************************/
void *mysignal(int signo, void *func) {
  struct sigaction act, oact;
	
  act.sa_handler = (void*)func;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  
  if (signo == SIGALRM) {
#ifdef	SA_INTERRUPT
    act.sa_flags |= SA_INTERRUPT; /* SunOS */
#endif
  } else {
#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART; /* SVR4, 4.3+BSD */
#endif
  }
  
  if (sigaction(signo, &act, &oact) < 0)
    return SIG_ERR;
  
  return oact.sa_handler;
} /* signal */
#endif /* HAVE_SIGACTION */

