/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "Sleep.h"
#include <QDBusInterface>

Sleep::Sleep(const bool isKDE, const Solid::PowerManagement::SleepState state) :
	AbstractThreadedAction(), isKDE(isKDE), state(state) {

}

void Sleep::run() {
	QDBusInterface* interface;
	if (isKDE) {
		interface = new QDBusInterface("org.kde.kded", "/modules/powerdevil", "org.kde.PowerDevil");
		interface->call("suspend", state);
	} else {
		interface = new QDBusInterface("org.freedesktop.UPower", "/org/freedesktop/UPower",
				"org.freedesktop.UPower", QDBusConnection::systemBus());
		interface->call(state == Solid::PowerManagement::SuspendState ? "Suspend" : "Hibernate");
	}
	delete interface;
}
