import string

strategies = {
        'exact'     : (0, 'Match words exactly'),
        'prefix'    : (1, 'Match prefixes'),
        'substring' : (2, 'Match substring occurring anywhere in word'),
        'suffix'    : (3, 'Match suffixes'),
        'soundex'   : (4, 'Match using SOUNDEX algorithm'),
        'lev'       : (5, 'Match words within Levenshtein distance one'),
        're'        : (6, 'POSIX 1003.2 regular expressions'),
        'fnmatch'   : (7, 'fnmatch-like (* ? as wildcards)'),
        'metaphone' : (8, 'metaphone algorithm')
        }


b64l = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
b64d = range(256)
for x in range(64):
	b64d[ord(b64l[x])] = x

def b64dec(str):
	nums = map(lambda c: b64d[ord(c)], str)
	nums.reverse()
	sum = 0
	for i in range(len(nums)):
		sum = sum + (64**i) * nums[i]
	return sum


def decb64(val):
    result = 7*[0]
    result[0] = b64l[ (val & 0xc0000000) >> 30 ]
    result[1] = b64l[ (val & 0x3f000000) >> 24 ]
    result[2] = b64l[ (val & 0x00fc0000) >> 18 ]
    result[3] = b64l[ (val & 0x0003f000) >> 12 ]
    result[4] = b64l[ (val & 0x00000fc0) >>  6 ]
    result[5] = b64l[ (val & 0x0000003f)       ]
    result[6] = 0

    r = 5
    for i in range(5):
        if result[i] != b64l[0]:
            r = i
            break

    result = string.join(result[r:-1], '')
    return result


CRLF = "\r\n"
TAB = "\t"

def quote_reply(s):
    s = string.replace(s, "\n.", "\n..")
    s = string.replace(s, "\n", CRLF)
    return s

