
/*
#    Sfront, a SAOL to C translator    
#    This file: fast note gliss control driver for sfront
#    Copyright (C) 1999  Regents of the University of California
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License (Version 2) as
#    published by the Free Software Foundation.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu
*/

#define CSYSI_BOTTOMNOTE 20
#define CSYSI_TOPNOTE 100
#define CSYSI_VELOCITY 64
#define CSYSI_LENGTH  60
#define CSYSI_NUMPFIELDS 2
/****************************************************************/
/****************************************************************/
/*             glissando control driver for sfront              */ 
/****************************************************************/

int csysi_flag = CSYSI_LENGTH;
int csysi_on = 0;
int csysi_note = CSYSI_BOTTOMNOTE;
int csysi_noteinc = 1;
int csysi_instr = 1;
float csysi_pfields[CSYSI_NUMPFIELDS];

/****************************************************************/
/*             initialization routine for control               */
/****************************************************************/

int csys_setup(void)
     
{
  return CSYS_DONE;
}

/****************************************************************/
/*             polling routine for new data                     */
/****************************************************************/

int csys_newdata(void)
     
{
  if (csysi_flag)
    {
      csysi_flag--;
      return CSYS_NONE;
    }

  csysi_flag = CSYSI_LENGTH;
  if (csysi_noteinc == 1)
    {
      csysi_on = !csysi_on;
      return CSYS_MIDIEVENTS;
    }
  else
    return CSYS_SASLEVENTS;

}

/****************************************************************/
/*                 processes a MIDI event                       */
/****************************************************************/


int csys_midievent(unsigned char * cmd,   unsigned char * ndata, 
	           unsigned char * vdata, unsigned short * extchan,
		   float * fval)

{

  if (csysi_on)
    {
      *cmd = CSYS_MIDI_NOTEON;
      *ndata = csysi_note;
    }
  else
    {
      *cmd = CSYS_MIDI_NOTEOFF;
      *ndata = csysi_note;
      csysi_note += csysi_noteinc;
      if ((csysi_note == CSYSI_TOPNOTE)||(csysi_note == CSYSI_BOTTOMNOTE))
	{
	  csysi_noteinc *= -1;
	}
    }

  *vdata =  CSYSI_VELOCITY;
  *extchan = 0;
  return CSYS_NONE;

}


/****************************************************************/
/*                 processes a SASL event                       */
/****************************************************************/

int csys_saslevent(unsigned char * cmd, unsigned char * priority,
		   unsigned short * id, unsigned short * label,
		   float * fval, unsigned int * pnum, float ** p)

{

  if (csysi_instr)
    {
      csysi_instr = 0;
      *cmd = CSYS_SASL_INSTR;
      *priority = 0;
      *id = CSYS_SASL_INSTR_spiano;
      *label = 5;
      *fval = 0.10;
      *pnum = CSYSI_NUMPFIELDS;
      csysi_pfields[0] = csysi_note;
      csysi_pfields[1] = CSYSI_VELOCITY;
      *p = &csysi_pfields[0];
      
      csysi_note += csysi_noteinc;
      if ((csysi_note == CSYSI_TOPNOTE)||(csysi_note == CSYSI_BOTTOMNOTE))
	{
	  csysi_noteinc *= -1;
	}
      return CSYS_SASLEVENTS;
    }
  else
    {
      csysi_instr = 1;
      *cmd = CSYS_SASL_CONTROL;
      *priority = 0;
      *id = CSYS_SASL_NOINSTR;
      *label = 5;
      *fval = 0;
      *pnum = CSYS_SASL_GBL_pedal;
      return CSYS_NONE;
    }
}

	
/****************************************************************/
/*                  closing routine for control                 */
/****************************************************************/

void csys_shutdown(void)
     
{
}

