
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (Version 2) as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * In sfront distribution, see file COPYING for the GNU General Public License
 *
 *Automatically generated library file nsys

 */

#include "tree.h"



void makenet_sfront(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Sfront-specific network functions";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           receives RTP, RTCP, and SIP packets                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_newdata(void) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct sockaddr_in ipaddr;";
  z[lc++]="  unsigned long ssrc;";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  int len, i, j;";
  z[lc++]="  unsigned char packet[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned char digest[NSYS_MD5_LENGTH];";
  z[lc++]="  unsigned char * p, * pmax;";
  z[lc++]="  unsigned char ptype, mlen;";
  z[lc++]="  unsigned char cmd = 0;";
  z[lc++]="  unsigned char ndata = 0;";
  z[lc++]="  unsigned char vdata = 0;";
  z[lc++]="  int fromlen = sizeof(struct sockaddr);";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int rtpcode, jcode, fec, prerec;";
  z[lc++]="  int nopacket = 1;";
  z[lc++]="  unsigned short status;";
  z[lc++]="  int fd = nsys_rtp_fd;";
  z[lc++]="";
  z[lc++]="  nsys_bufflen = nsys_buffcnt = 0;";
  z[lc++]="";
  z[lc++]="  nsys_netout_tstamp += ACYCLE;";
  z[lc++]="";
  z[lc++]="  if (netout_jsend_guard_time && ((--netout_jsend_guard_time) == 0))";
  z[lc++]="    nsys_netout_guard_tick();";
  z[lc++]=" ";
  z[lc++]="  while (1)";
  z[lc++]="    {";
  z[lc++]="      if ((len = recvfrom(fd, packet, NSYS_UDPMAXSIZE, 0, ";
  z[lc++]="			  (struct sockaddr *)&ipaddr, &fromlen)) <= 0)";
  z[lc++]="	{";
  z[lc++]="";
  z[lc++]="	  if ((errno == EAGAIN) && (fd == nsys_rtcp_fd))";
  z[lc++]="	    {";
  z[lc++]="	      if (nopacket && (time(NULL) > nsys_nexttime))";
  z[lc++]="		{";
  z[lc++]="		  nsys_netout_rtcptime();		  ";
  z[lc++]="		  if (nsys_powerup_mset)";
  z[lc++]="		    nsys_netin_clear_mset(nsys_buff, &nsys_bufflen, ";
  z[lc++]="					  NSYS_BUFFSIZE);";
  z[lc++]="		}";
  z[lc++]="	      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if ((errno == EAGAIN) && (fd == nsys_rtp_fd))";
  z[lc++]="	    {";
  z[lc++]="	      fd = nsys_rtcp_fd;";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  if (errno == EINTR)";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries: nsys_netin_newdata\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error reading Internet socket\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  /*****************/";
  z[lc++]="	  /* RTP fast path */";
  z[lc++]="	  /*****************/";
  z[lc++]="";
  z[lc++]="	  nopacket = 0;";
  z[lc++]="";
  z[lc++]="	  if ((fd == nsys_rtp_fd) && ";
  z[lc++]="	      (packet[NSYS_RTPLOC_BYTE1] == NSYS_RTPVAL_BYTE1))";
  z[lc++]="	    {	      ";
  z[lc++]="";
  z[lc++]="	      /***************************************/";
  z[lc++]="	      /* parse top of header to extract ssrc */";
  z[lc++]="	      /***************************************/";
  z[lc++]="";
  z[lc++]="	      if ((len < NSYS_RTPLEN_HDR) || (len <= NSYS_RTPSIZE_DIGEST))";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"Truncated RTP packet\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      ssrc = ntohl(*((unsigned long *)&(packet[NSYS_RTPLOC_SSRC])));";
  z[lc++]="	      ptype = packet[NSYS_RTPLOC_PTYPE] & NSYS_RTPVAL_CLRMARK;";
  z[lc++]="	      fec = (packet[NSYS_RTPLOC_PTYPE] < NSYS_RTPVAL_SETMARK);";
  z[lc++]="";
  z[lc++]="	      sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="	      ";
  z[lc++]="	      while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="		sptr = sptr->xtra;";
  z[lc++]="	      ";
  z[lc++]="	      if (!sptr)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"RTP packet from unknown source\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (((ipaddr.sin_addr.s_addr != sptr->rtp_addr->sin_addr.s_addr) ||";
  z[lc++]="		  (ipaddr.sin_port != sptr->rtp_addr->sin_port)) && ";
  z[lc++]="		  (sptr->alt_rtp_addr == NULL))";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"RTP packet from unknown IP/port\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /*********************/";
  z[lc++]="	      /* do authentication */";
  z[lc++]="	      /*********************/";
  z[lc++]="";
  z[lc++]="	      len -= NSYS_RTPSIZE_DIGEST;";
  z[lc++]="";
  z[lc++]="	      if (nsys_msession)";
  z[lc++]="		memcpy(&(packet[NSYS_RTPLOC_SSRC]), &nsys_myssrc_net, ";
  z[lc++]="		       sizeof(long));";
  z[lc++]="";
  z[lc++]="	      nsys_hmac_md5(packet, len, nsys_keydigest, digest);";
  z[lc++]="";
  z[lc++]="	      if (memcmp(&(packet[len]), digest, NSYS_RTPSIZE_DIGEST))";
  z[lc++]="		{		  ";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"Discarding unauthorized RTP packet\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /******************/";
  z[lc++]="	      /* process packet */";
  z[lc++]="	      /******************/";
  z[lc++]="";
  z[lc++]="	      if (ptype != sptr->ptype)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"RTP packet with incorrect ptype\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      len -= NSYS_RTPLEN_HDR;";
  z[lc++]="";
  z[lc++]="	      if (sptr->alt_rtp_addr)";
  z[lc++]="		{";
  z[lc++]="		  if ((ipaddr.sin_addr.s_addr != nsys_sip_rtp_inet_addr) ||";
  z[lc++]="		      (ipaddr.sin_port != nsys_sip_rtp_sin_port))";
  z[lc++]="		    {";
  z[lc++]="		      /* normal case */";
  z[lc++]="";
  z[lc++]="		      memcpy(sptr->rtp_addr,&ipaddr,sizeof(struct sockaddr_in));";
  z[lc++]="		    }";
  z[lc++]="		  else";
  z[lc++]="		    {";
  z[lc++]="		      /* source-forge trick which may later be implemented */";
  z[lc++]="";
  z[lc++]="		      memcpy(sptr->rtp_addr, &(sptr->alt_rtp_addr), ";
  z[lc++]="			     sizeof(struct sockaddr_in));";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  free(sptr->alt_rtp_addr);";
  z[lc++]="		  sptr->alt_rtp_addr = NULL;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      rtpcode = nsys_netin_rtpstats(sptr, packet);";
  z[lc++]="";
  z[lc++]="	      if (rtpcode == NSYS_RTPCODE_SECURITY)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"Possible RTP replay attack\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if ((len == 0) || ((rtpcode == NSYS_RTPCODE_DISCARD) && fec))";
  z[lc++]="		{";
  z[lc++]="		  if (len == 0)";
  z[lc++]="		    nsys_warning(NSYS_WARN_UNUSUAL, \"RTP payload empty\");";
  z[lc++]="		  else";
  z[lc++]="		    nsys_warning(NSYS_WARN_UNUSUAL, \"Out of order RTP packet\");";
  z[lc++]="		  continue;        ";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      p = packet + NSYS_RTPLEN_HDR;";
  z[lc++]="";
  z[lc++]="	      if ((rtpcode != NSYS_RTPCODE_NORMAL) && fec)";
  z[lc++]="		{";
  z[lc++]="";
  z[lc++]="		  jcode = nsys_netin_journal_recovery(sptr, rtpcode, p, len,";
  z[lc++]="						      nsys_buff, &nsys_bufflen,";
  z[lc++]="						      NSYS_BUFFSIZE);";
  z[lc++]="		  if (jcode == NSYS_JOURNAL_CORRUPTED)";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, \"RTP journal corrupt\");";
  z[lc++]="		      continue;";
  z[lc++]="		    }";
  z[lc++]="		  if (jcode == NSYS_JOURNAL_FILLEDBUFF)";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, \"RTP journal too big\");";
  z[lc++]="		      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="		    }";
  z[lc++]="";
  z[lc++]="		  /* NSYS_JOURNAL_RECOVERED falls through */";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /****************/";
  z[lc++]="	      /* RTP payload  */";
  z[lc++]="	      /****************/";
  z[lc++]="";
  z[lc++]="	      if ((mlen = ((*(p++)) & NSYS_SM_MLENMAX)) == 0)";
  z[lc++]="		continue;            ";
  z[lc++]="";
  z[lc++]="	      if (mlen > (--len))";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"RTP MIDI section trunction\");";
  z[lc++]="		  continue;            ";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      pmax = p + mlen;";
  z[lc++]="";
  z[lc++]="	      if ((*p) < CSYS_MIDI_NOTEOFF)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"RTP running status error\");";
  z[lc++]="		  continue;                     ";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      while (p < pmax)";
  z[lc++]="		{";
  z[lc++]="		  if ((NSYS_BUFFSIZE - nsys_bufflen) < 4)";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="				   \"RTP journal truncated MIDI commands\");";
  z[lc++]="		      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);	";
  z[lc++]="		    }";
  z[lc++]="		  if (((*p) >= CSYS_MIDI_NOTEOFF) && ";
  z[lc++]="		      ((0xF0 & (cmd = (*(p++)))) == CSYS_MIDI_SYSTEM))";
  z[lc++]="		    {";
  z[lc++]="		      nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="				   \"RTP MIDI System command in stream\");";
  z[lc++]="		      break;";
  z[lc++]="		    }";
  z[lc++]="		  if ((sptr->ontime == 0) &&";
  z[lc++]="		      ((0xF0 & cmd) == CSYS_MIDI_NOTEON) && p[1])";
  z[lc++]="		    {";
  z[lc++]="		      p += 2;";
  z[lc++]="		      continue;";
  z[lc++]="		    }";
  z[lc++]="		  nsys_buff[nsys_bufflen++] = cmd;";
  z[lc++]="		  nsys_buff[nsys_bufflen++] = (ndata = *(p++));";
  z[lc++]="		  if ( ((0xF0 & cmd) != CSYS_MIDI_PROGRAM) && ";
  z[lc++]="		       ((0xF0 & cmd) != CSYS_MIDI_CTOUCH))";
  z[lc++]="		    nsys_buff[nsys_bufflen++] = (vdata = *(p++));";
  z[lc++]="		  if (fec)";
  z[lc++]="		    nsys_netin_journal_trackstate(sptr, cmd, ndata, vdata);";
  z[lc++]="		  nsys_buff[nsys_bufflen++] = sptr->mset;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      /* if no room left for another MIDI command, leave */";
  z[lc++]="	      ";
  z[lc++]="	      if ((NSYS_BUFFSIZE - nsys_bufflen) < NSYS_SM_EXPANDMAX)";
  z[lc++]="		return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /***********************/";
  z[lc++]="	  /* handle RTCP packets */";
  z[lc++]="	  /***********************/";
  z[lc++]="";
  z[lc++]="	  if ((fd == nsys_rtcp_fd) && ";
  z[lc++]="	      (NSYS_RTCPVAL_BYTE1 == (packet[NSYS_RTCPLOC_BYTE1] ";
  z[lc++]="				      & NSYS_RTCPVAL_COOKIEMASK)))";
  z[lc++]="	    {";
  z[lc++]="	      if ((len -= NSYS_RTPSIZE_DIGEST) <= 0)";
  z[lc++]="		{";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP packet truncated\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="	      ";
  z[lc++]="	      if (nsys_msession)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(&ssrc, &(packet[NSYS_RTCPLOC_SSRC]), sizeof(long));";
  z[lc++]="		  memcpy(&(packet[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, ";
  z[lc++]="			 sizeof(long));";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      nsys_hmac_md5(packet, len, nsys_keydigest, digest);";
  z[lc++]="";
  z[lc++]="	      if (memcmp(&(packet[len]), digest, NSYS_RTPSIZE_DIGEST))";
  z[lc++]="		{		  ";
  z[lc++]="		  nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			       \"Discarding unauthorized RTCP packet\");";
  z[lc++]="		  continue;";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (nsys_msession)";
  z[lc++]="		memcpy(&(packet[NSYS_RTCPLOC_SSRC]), &ssrc, sizeof(long));";
  z[lc++]="	      ";
  z[lc++]="	      sptr = nsys_netin_rtcp(packet, len, &ipaddr);";
  z[lc++]="";
  z[lc++]="	      if (nsys_feclevel)";
  z[lc++]="		nsys_netin_journal_trimstate(sptr);";
  z[lc++]="	";
  z[lc++]="	      if (nsys_powerup_mset)";
  z[lc++]="		{";
  z[lc++]="		  nsys_netin_clear_mset(nsys_buff, &nsys_bufflen,";
  z[lc++]="					NSYS_BUFFSIZE);";
  z[lc++]="		  if ((NSYS_BUFFSIZE - nsys_bufflen) < NSYS_SM_EXPANDMAX)";
  z[lc++]="		    return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="		}";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  /***********************/";
  z[lc++]="	  /* handle SIP packets  */";
  z[lc++]="	  /***********************/";
  z[lc++]="";
  z[lc++]="	  packet[len] = '\\0';  /* null-terminate string */";
  z[lc++]="";
  z[lc++]="	  if (sscanf(packet, \"SIP/2.0 %hu\", &status) == 1)";
  z[lc++]="	    nsys_netin_reply(fd, &ipaddr, packet, status);";
  z[lc++]="	  else";
  z[lc++]="	    if (packet[NSYS_RTPLOC_BYTE1] == 'I')";
  z[lc++]="	      {";
  z[lc++]="		nsys_netin_invite(fd,  &ipaddr, packet);";
  z[lc++]="		if (nsys_powerup_mset)";
  z[lc++]="		  {";
  z[lc++]="		    nsys_netin_clear_mset(nsys_buff, &nsys_bufflen,";
  z[lc++]="					  NSYS_BUFFSIZE);";
  z[lc++]="		    if ((NSYS_BUFFSIZE - nsys_bufflen) < NSYS_SM_EXPANDMAX)";
  z[lc++]="		      return (nsys_bufflen ? NSYS_MIDIEVENTS : NSYS_DONE);";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	}";
  z[lc++]="    } ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          returns the next network MIDI command               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_midievent(unsigned char * cmd, unsigned char * ndata,";
  z[lc++]="                    unsigned char * vdata, unsigned short * extchan)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *cmd = nsys_buff[nsys_buffcnt];";
  z[lc++]="  *extchan = 0x0F & nsys_buff[nsys_buffcnt++];";
  z[lc++]="  *ndata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="";
  z[lc++]="  if ((((*cmd) & 0xF0) != CSYS_MIDI_PROGRAM) && ";
  z[lc++]="      (((*cmd) & 0xF0) != CSYS_MIDI_CTOUCH))";
  z[lc++]="    *vdata = nsys_buff[nsys_buffcnt++];";
  z[lc++]="";
  z[lc++]="  *extchan += (NSYS_NETSTART - CSYS_MIDI_NUMCHAN + ";
  z[lc++]="	       (nsys_buff[nsys_buffcnt++] << 4));";
  z[lc++]="  return (nsys_buffcnt == nsys_bufflen) ? NSYS_DONE : NSYS_MIDIEVENTS;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    sends RTP packets                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_midisend(unsigned char cmd, unsigned char ndata,";
  z[lc++]="		  unsigned char vdata, unsigned short extchan)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int jsize = 0;";
  z[lc++]="  unsigned char size, cbyte;";
  z[lc++]="  unsigned long tstamp;";
  z[lc++]="  unsigned short seqnum;";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  struct sockaddr * addr;";
  z[lc++]="  int alt = 0;";
  z[lc++]="  int jstart, dstart;";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* MIDI preprocessing */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  cbyte = cmd & 0xF0;";
  z[lc++]="";
  z[lc++]="  size =  (cbyte > CSYS_MIDI_SPECIAL) ? 3 : 0;";
  z[lc++]="  size -= ((cbyte == CSYS_MIDI_PROGRAM) || (cbyte == CSYS_MIDI_CTOUCH));";
  z[lc++]="";
  z[lc++]="  cmd = cbyte | (((unsigned char)extchan) & 0x0F);";
  z[lc++]="";
  z[lc++]="  if (nsys_msession && ";
  z[lc++]="      ((cbyte == CSYS_MIDI_NOTEON) || (cbyte == CSYS_MIDI_NOTEOFF)) && ";
  z[lc++]="      ((ndata += NSYS_MSESSION_INTERVAL) > 0x7F))";
  z[lc++]="    ndata = 0x7F;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* leave if no receivers */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if ((sptr = nsys_srcroot) == NULL)";
  z[lc++]="    { ";
  z[lc++]="      if (nsys_feclevel)";
  z[lc++]="	nsys_netout_journal_addhistory(cmd, ndata, vdata);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* fill in RTP header */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLOC_PTYPE] = sptr->ptype | nsys_netout_markbit;";
  z[lc++]="";
  z[lc++]="  tstamp = htonl((unsigned long)(nsys_netout_tstamp));";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_TSTAMP]), &tstamp, sizeof(long));";
  z[lc++]="";
  z[lc++]="  nsys_netout_seqnum = ((nsys_netout_seqnum != NSYS_RTPSEQ_HIGHEST) ?";
  z[lc++]="			(nsys_netout_seqnum + 1) : 1); ";
  z[lc++]="  seqnum = htons((unsigned short)(nsys_netout_seqnum & 0x0000FFFF));";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_SEQNUM]), &seqnum, ";
  z[lc++]="	 sizeof(short));";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill in command section of payload */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLEN_HDR] = size;";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 1] = cmd;";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 2] = ndata;";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLEN_HDR + 3] = vdata;";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill in journal section of payload */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_feclevel)";
  z[lc++]="    {";
  z[lc++]="      jstart = NSYS_RTPLEN_HDR + 1 + size;";
  z[lc++]="      jsize = nsys_netin_journal_create(&(nsys_netout_rtp_packet[jstart]),";
  z[lc++]="					NSYS_UDPMAXSIZE - NSYS_MD5_LENGTH ";
  z[lc++]="					- jstart);";
  z[lc++]="      nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* add authentication signature */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  dstart = NSYS_RTPLEN_HDR + 1 + size + jsize;";
  z[lc++]="  nsys_hmac_md5(nsys_netout_rtp_packet, dstart, nsys_keydigest, ";
  z[lc++]="		&(nsys_netout_rtp_packet[dstart]));";
  z[lc++]="";
  z[lc++]="  /********************************************/";
  z[lc++]="  /* calculate packet size, update statistics */";
  z[lc++]="  /********************************************/";
  z[lc++]="";
  z[lc++]="  nsys_sent_this = 1;";
  z[lc++]="  nsys_sent_packets++;";
  z[lc++]="  nsys_sent_octets += (size + 1 + jsize + NSYS_RTPSIZE_DIGEST);";
  z[lc++]="  size += (NSYS_RTPLEN_HDR + 1 + jsize + NSYS_RTPSIZE_DIGEST);     ";
  z[lc++]="";
  z[lc++]="  /***************************/";
  z[lc++]="  /* send packet to everyone */";
  z[lc++]="  /***************************/";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      addr = (struct sockaddr *) (alt ? sptr->alt_rtp_addr : sptr->rtp_addr);";
  z[lc++]="";
  z[lc++]="      /* when multiple payload types supported, see if *p*[NSYS_RTPLOC_PTYPE] */";
  z[lc++]="      /* differs from (sptr->ptype | nsys_netout_markbit) and reauthenticate  */";
  z[lc++]="";
  z[lc++]="      if (sendto(nsys_rtp_fd, nsys_netout_rtp_packet, size, 0, addr, ";
  z[lc++]="		 sizeof(struct sockaddr)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    continue;";
  z[lc++]="	  ";
  z[lc++]="	  if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_netout_newdata\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (!(alt = ((!alt) && sptr->alt_rtp_addr)))";
  z[lc++]="	sptr = sptr->next;";
  z[lc++]="    } ";
  z[lc++]="  while (alt || (sptr != nsys_srcroot));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              called at the end of control processing         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_endcycle(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]=" if (netout_jsend_guard_send) ";
  z[lc++]="   nsys_midisend(CSYS_MIDI_NOOP, 0, 0, 0);";
  z[lc++]=" ";
  z[lc++]=" if (nsys_graceful_exit && !graceful_exit)";
  z[lc++]="   graceful_exit = 1;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end  Sfront-specific network functions */";
  z[lc++]="";
  printlib(lc);
}


void makenet_include(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- constants and externs";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* network include files */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET_INCLUDE";
  z[lc++]="";
  z[lc++]="#define NSYS_NET_INCLUDE";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="";
  z[lc++]="#include <stdio.h> ";
  z[lc++]="#include <stdlib.h> ";
  z[lc++]="#include <errno.h> ";
  z[lc++]="#include <string.h> ";
  z[lc++]="#include <ctype.h>";
  z[lc++]="#include \"net_local.h\"";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* harmful on Solaris so we delete functionality */";
  z[lc++]="";
  z[lc++]="#if (!defined(sun) && !defined(__sun__))";
  z[lc++]="#include <sys/ioctl.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <unistd.h> ";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="#include <sys/types.h> ";
  z[lc++]="#include <sys/socket.h>";
  z[lc++]="#include <netdb.h>";
  z[lc++]="#include <arpa/inet.h>";
  z[lc++]="#include <netinet/in.h> ";
  z[lc++]="#include <net/if.h>";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                           Constants                                    */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/***********************/";
  z[lc++]="/* debug/warning flags */";
  z[lc++]="/***********************/";
  z[lc++]="";
  z[lc++]="#define NSYS_WARN_NONE     0    /* never warn about anything */";
  z[lc++]="#define NSYS_WARN_STANDARD 1    /* print connect messages    */";
  z[lc++]="#define NSYS_WARN_UNUSUAL  2    /* print unusual events      */";
  z[lc++]="";
  z[lc++]="#define NSYS_WARN   NSYS_WARN_UNUSUAL";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#define NSYS_JOURNAL_DEBUG_OFF 0";
  z[lc++]="#define NSYS_JOURNAL_DEBUG_ON 1";
  z[lc++]="";
  z[lc++]="#define NSYS_JOURNAL_DEBUG NSYS_JOURNAL_DEBUG_OFF";
  z[lc++]="";
  z[lc++]="#define NSYS_LATENOTES_DEBUG_OFF 0";
  z[lc++]="#define NSYS_LATENOTES_DEBUG_ON 1";
  z[lc++]="";
  z[lc++]="#define NSYS_LATENOTES_DEBUG NSYS_LATENOTES_DEBUG_OFF";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/* network constants */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="#define NSYS_MAXRETRY 256";
  z[lc++]="#define NSYS_DONE  0";
  z[lc++]="#define NSYS_ERROR 1";
  z[lc++]="";
  z[lc++]="#define NSYS_NONBLOCK 0";
  z[lc++]="#define NSYS_BLOCK    1";
  z[lc++]="";
  z[lc++]="#define NSYS_BUFFSIZE 1024";
  z[lc++]="";
  z[lc++]="/*****************************/";
  z[lc++]="/* default system parameters */";
  z[lc++]="/*****************************/";
  z[lc++]="";
  z[lc++]="#ifndef SO_BSDCOMPAT";
  z[lc++]="#define SO_BSDCOMPAT 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_MSETS";
  z[lc++]="#define NSYS_MSETS 5";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ACYCLE";
  z[lc++]="#define ACYCLE 42L";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ARATE";
  z[lc++]="#define ARATE 44100.0F";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef APPNAME";
  z[lc++]="#define APPNAME \"unknown\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef APPVERSION";
  z[lc++]="#define APPVERSION \"0.0\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NUMCHAN";
  z[lc++]="#define CSYS_MIDI_NUMCHAN  16";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NOOP";
  z[lc++]="#define CSYS_MIDI_NOOP     0x70";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_POWERUP";
  z[lc++]="#define CSYS_MIDI_POWERUP  0x73";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NOTEOFF";
  z[lc++]="#define CSYS_MIDI_NOTEOFF  0x80";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_NOTEON ";
  z[lc++]="#define CSYS_MIDI_NOTEON   0x90";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_PTOUCH  ";
  z[lc++]="#define CSYS_MIDI_PTOUCH   0xA0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC  ";
  z[lc++]="#define CSYS_MIDI_CC       0xB0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_PROGRAM ";
  z[lc++]="#define CSYS_MIDI_PROGRAM  0xC0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CTOUCH ";
  z[lc++]="#define CSYS_MIDI_CTOUCH   0xD0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_WHEEL ";
  z[lc++]="#define CSYS_MIDI_WHEEL    0xE0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_SYSTEM";
  z[lc++]="#define CSYS_MIDI_SYSTEM   0xF0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_BANKSELECT_MSB ";
  z[lc++]="#define CSYS_MIDI_CC_BANKSELECT_MSB  0x00";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_MODWHEEL_MSB";
  z[lc++]="#define CSYS_MIDI_CC_MODWHEEL_MSB    0x01";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_CHANVOLUME_MSB";
  z[lc++]="#define CSYS_MIDI_CC_CHANVOLUME_MSB  0x07";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_BANKSELECT_LSB ";
  z[lc++]="#define CSYS_MIDI_CC_BANKSELECT_LSB  0x20";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_SUSTAIN";
  z[lc++]="#define CSYS_MIDI_CC_SUSTAIN         0x40";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_ALLSOUNDOFF";
  z[lc++]="#define CSYS_MIDI_CC_ALLSOUNDOFF     0x78";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef CSYS_MIDI_CC_ALLNOTESOFF";
  z[lc++]="#define CSYS_MIDI_CC_ALLNOTESOFF     0x7B";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP";
  z[lc++]="#define NSYS_DISPLAY_RTCP         0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_HDR";
  z[lc++]="#define NSYS_DISPLAY_RTCP_HDR     0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_SRINFO";
  z[lc++]="#define NSYS_DISPLAY_RTCP_SRINFO  0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_SDES ";
  z[lc++]="#define NSYS_DISPLAY_RTCP_SDES    0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_RRINFO";
  z[lc++]="#define NSYS_DISPLAY_RTCP_RRINFO  0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_DISPLAY_RTCP_RRTCOMP";
  z[lc++]="#define NSYS_DISPLAY_RTCP_RRTCOMP 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* rtp defines */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="/* SSRC hash table constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_HASHSIZE 32         /* table size */";
  z[lc++]="#define NSYS_HASHMASK 31         /* table mask */";
  z[lc++]="";
  z[lc++]="/* preferred value for bidirectional RTP port */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTP_PORT     5004";
  z[lc++]="#define NSYS_RTP_MAXPORT 65535";
  z[lc++]="";
  z[lc++]="/* Based on Ethernet default MTU of 1500 bytes */";
  z[lc++]="";
  z[lc++]="#define NSYS_UDPMAXSIZE 1472  ";
  z[lc++]="#define NSYS_RTPMAXSIZE 1460";
  z[lc++]="";
  z[lc++]="/* masks for combing usec and sec for srand() seed */";
  z[lc++]="";
  z[lc++]="#define NSYS_USECMASK   (0x000FFFFF)   ";
  z[lc++]="#define NSYS_SECMASK    (0xFFF00000)";
  z[lc++]="#define NSYS_SECSHIFT   20";
  z[lc++]="";
  z[lc++]="/* positions of interesting parts of RTP header */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPLOC_BYTE1   0";
  z[lc++]="#define NSYS_RTPLOC_PTYPE   1";
  z[lc++]="#define NSYS_RTPLOC_SEQNUM  2";
  z[lc++]="#define NSYS_RTPLOC_TSTAMP  4";
  z[lc++]="#define NSYS_RTPLOC_SSRC    8";
  z[lc++]="";
  z[lc++]="/* extended sequence number constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPSEQ_MAXDIFF  4000        /* max number of lost packets */";
  z[lc++]="#define NSYS_RTPSEQ_HIGHEST  0xFFFFFFFF  /* highest sequence number    */";
  z[lc++]="#define NSYS_RTPSEQ_LOWLIMIT 4095        /* lo edge of 16-bit sequence */";
  z[lc++]="#define NSYS_RTPSEQ_HILIMIT  61440       /* hi edge of 16-bit sequence */";
  z[lc++]="#define NSYS_RTPSEQ_EXMASK   0xFFFF0000  /* masks out extension        */";
  z[lc++]="#define NSYS_RTPSEQ_LOMASK   0x0000FFFF  /* masks out 16-bit seqnum    */";
  z[lc++]="#define NSYS_RTPSEQ_EXINCR   0x00010000  /* increments extension       */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPSEQ_MAXLOSS   8388607    /* max number of lost packets */";
  z[lc++]="#define NSYS_RTPSEQ_MINLOSS  -8388608    /* min number of lost packets */";
  z[lc++]="#define NSYS_RTPSEQ_FMASK    0x00FFFFFF  /* bit mask to add fraction   */";
  z[lc++]="#define NSYS_RTPSEQ_TSIGN    0x00800000  /* bit mask for sign-extend   */";
  z[lc++]="";
  z[lc++]="/* other RTP constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPVAL_BYTE1   0x80  /* V=2, P=X=CC=0   */";
  z[lc++]="#define NSYS_RTPVAL_SETMARK 0x80  /* | to set marker */";
  z[lc++]="#define NSYS_RTPVAL_CLRMARK 0x7F  /* & to clr marker */";
  z[lc++]="#define NSYS_RTPVAL_CHKMARK 0x80  /* & to chk marker */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPLEN_HDR  12";
  z[lc++]="";
  z[lc++]="/* RTP known payload set size */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTP_PAYSIZE 1";
  z[lc++]="";
  z[lc++]="/* condition codes for a new RTP packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPCODE_NORMAL   0   /* seqnum directly follows last packet */";
  z[lc++]="#define NSYS_RTPCODE_LOSTONE  1   /* one packet has been lost            */";
  z[lc++]="#define NSYS_RTPCODE_LOSTMANY 2   /* many packets have been lost         */";
  z[lc++]="#define NSYS_RTPCODE_DISCARD  3   /* too late to use, or duplicate       */";
  z[lc++]="#define NSYS_RTPCODE_SECURITY 4   /* possible replay attack, discard     */";
  z[lc++]="";
  z[lc++]="/* number of bytes of digest to append */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTPSIZE_DIGEST   4";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* rtcp sizes */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="/* sizes of complete RTCP packets */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_BYE      8    /* BYE packet */";
  z[lc++]="#define NSYS_RTCPLEN_RREMPTY  8    /* RR with no  report    */";
  z[lc++]="#define NSYS_RTCPLEN_RR      32    /* RR with one report    */";
  z[lc++]="#define NSYS_RTCPLEN_SREMPTY 28    /* SR with no  reciept report */";
  z[lc++]="#define NSYS_RTCPLEN_SR      52    /* SR with one receipt report */";
  z[lc++]="#define NSYS_RTCPLEN_MINIMUM  8    /* the minimum packet size */";
  z[lc++]="";
  z[lc++]="/* sizes of RTCP headers */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_SRHDR    8";
  z[lc++]="#define NSYS_RTCPLEN_RRHDR    8";
  z[lc++]="#define NSYS_RTCPLEN_SDESHDR  4";
  z[lc++]="#define NSYS_RTCPLEN_BYEHDR   4";
  z[lc++]="";
  z[lc++]="/* sizes of RTCP segments */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_SENDER  20";
  z[lc++]="#define NSYS_RTCPLEN_REPORT  24";
  z[lc++]="";
  z[lc++]="/* sizes of SDES headers */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_SDES_CHUNKHDR  4";
  z[lc++]="#define NSYS_RTCPLEN_SDES_ITEMHDR   2";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* rtcp locations */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="/* interesting shared locations in RR/SR headers */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_BYTE1  0";
  z[lc++]="#define NSYS_RTCPLOC_PTYPE  1";
  z[lc++]="#define NSYS_RTCPLOC_LENGTH 2";
  z[lc++]="#define NSYS_RTCPLOC_SSRC   4";
  z[lc++]="";
  z[lc++]="/* locations of SR sender info */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_SR_NTPMSB  8";
  z[lc++]="#define NSYS_RTCPLOC_SR_NTPLSB 12";
  z[lc++]="#define NSYS_RTCPLOC_SR_TSTAMP 16";
  z[lc++]="#define NSYS_RTCPLOC_SR_PACKET 20";
  z[lc++]="#define NSYS_RTCPLOC_SR_OCTET  24";
  z[lc++]="";
  z[lc++]="/* interesting offsets into RR sender info */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_RR_SSRC       0";
  z[lc++]="#define NSYS_RTCPLOC_RR_FRACTLOSS  4";
  z[lc++]="#define NSYS_RTCPLOC_RR_NUMLOST    5";
  z[lc++]="#define NSYS_RTCPLOC_RR_HISEQ      8";
  z[lc++]="#define NSYS_RTCPLOC_RR_JITTER    12";
  z[lc++]="#define NSYS_RTCPLOC_RR_LASTSR    16";
  z[lc++]="#define NSYS_RTCPLOC_RR_DELAY     20";
  z[lc++]="";
  z[lc++]="/* interesting locations in an SDES packet ITEM */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLOC_SDESITEM_TYPE   0";
  z[lc++]="#define NSYS_RTCPLOC_SDESITEM_LENGTH 1";
  z[lc++]="";
  z[lc++]="/* interesting locations in RTCP BYE packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPLEN_BYE_SSRC       4";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* rtcp values */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_BYTE1   0x80        /* V=2, P=XC=0   */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_COUNTMASK   0x1F    /* mask for RC value  */";
  z[lc++]="#define NSYS_RTCPVAL_COOKIEMASK  0xE0    /* mask for VP bits  */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_SR   0xC8    /* RTCP sender */";
  z[lc++]="#define NSYS_RTCPVAL_RR   0xC9    /* RTCP receiver */";
  z[lc++]="#define NSYS_RTCPVAL_SDES 0xCA    /* RTCP source desc */";
  z[lc++]="#define NSYS_RTCPVAL_BYE  0xCB    /* RTCP bye */";
  z[lc++]="#define NSYS_RTCPVAL_APP  0xCC    /* RTCP APP packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_SDES_CNAME   0x01  /* CNAME for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_NAME    0x02  /* NAME  for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_EMAIL   0x03  /* EMAIL for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_PHONE   0x04  /* PHONE for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_LOC     0x05  /* LOC for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_TOOL    0x06  /* TOOL for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_NOTE    0x07  /* NOTE for SDES */";
  z[lc++]="#define NSYS_RTCPVAL_SDES_PRIV    0x08  /* PRIV for SDES */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPVAL_SDES_SIZE   9      /* number of SDES types */";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* rtcp control */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="/* RTCP and SIP INFO timer constants */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPTIME_INCR       5      /* 5 seconds between RTCP sends  */";
  z[lc++]="#define NSYS_RTCPTIME_SKIP       2      /* threshold for retransmit skip */";
  z[lc++]="#define NSYS_RTCPTIME_TIMEOUT   25      /* 25 second SSRC timeout        */";
  z[lc++]="#define NSYS_RTCPTIME_MLENGTH  300      /* 5 minute limit for msession   */";
  z[lc++]="#define NSYS_SIPINFO_TRIGGER     6      /* every 5 RTCP send a SIP INFO  */";
  z[lc++]="";
  z[lc++]="/* RTCP-monitored exceptions */";
  z[lc++]="";
  z[lc++]="#define NSYS_RTCPEX_RTPSIP       1     /* no response on SIP RTP channel */";
  z[lc++]="#define NSYS_RTCPEX_RTPNEXT      2     /* skip RTP retransmission cycle  */";
  z[lc++]="#define NSYS_RTCPEX_RTCPSIP      4     /* no response on SIP RTP channel */";
  z[lc++]="#define NSYS_RTCPEX_RTCPNEXT     8     /* skip RTCP retransmission cycle */";
  z[lc++]="#define NSYS_RTCPEX_NULLROOT     16    /* if nsys_srcroot == NULL        */";
  z[lc++]="#define NSYS_RTCPEX_SRCDUPL      32    /* SSRC clash                     */";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* mpeg4-samidi */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++*/";
  z[lc++]="/*  midi command payload */";
  z[lc++]="/*+++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_MLENMAX     63  /* max length of MIDI section */";
  z[lc++]="#define NSYS_SM_EXPANDMAX  186  /* worst case expansion       */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="/* recovery journal constants */";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETS 128  /* | to set S header bit   */";
  z[lc++]="#define NSYS_SM_CLRS 127  /* & to clear S header bit */";
  z[lc++]="#define NSYS_SM_CHKS 128  /* & to check S header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SETH 128  /* | to set H history bit   */";
  z[lc++]="#define NSYS_SM_CLRH 127  /* & to clear H history bit */";
  z[lc++]="#define NSYS_SM_CHKH 128  /* & to check H history bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_SLISTLEN 128  /* maximum S list size */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="/* recovery journal header */";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_SIZE 3       /* journal header size */";
  z[lc++]="#define NSYS_SM_JH_LOC_FLAGS 0  /* byte 0: flags       */";
  z[lc++]="#define NSYS_SM_JH_LOC_CHECK 1  /* bytes 1-2: checkpoint packet */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_CHANMASK 0x0F  /* to mask channel number  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_SETA  64  /* | to set A header bit   */";
  z[lc++]="#define NSYS_SM_JH_CLRA 191  /* & to clear A header bit */";
  z[lc++]="#define NSYS_SM_JH_CHKA  64  /* & to check A header bit   */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_JH_SETK  32  /* | to set K header bit   */";
  z[lc++]="#define NSYS_SM_JH_CLRK 223  /* & to clear K header bit */";
  z[lc++]="#define NSYS_SM_JH_CHKK  32  /* & to check K header bit   */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++*/";
  z[lc++]="/* channel header    */";
  z[lc++]="/*+++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_SIZE 3       /* channel header size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_LOC_FLAGS 0   /* location of S bit & channel */";
  z[lc++]="#define NSYS_SM_CH_LOC_LEN   0   /* location of 10-bit length */";
  z[lc++]="#define NSYS_SM_CH_LOC_TOC   2   /* location of table of contents */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_CHANMASK 0x78   /* to extract channel number  */";
  z[lc++]="#define NSYS_SM_CH_LENMASK  0x03FF /* to extract channel length  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_CHANSHIFT 3     /* to align channel number */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETP 128    /* Program Change (0xC) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRP 127    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKP 128    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETW  64    /* Pitch Wheel (0xE) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRW 191    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKW  64    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETN  32    /* NoteOff (0x8), NoteOn (0x9) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRN 223    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKN  32    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETA  16    /* Poly Aftertouch (0xA) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRA 239    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKA  16    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETT   8    /* Channel Aftertouch (0xD) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRT 247    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKT   8    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETC   4    /* Control Change (0xB) */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRC 251    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKC   4    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETF   2    /* Application-specific */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRF 253    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKF   2    ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CH_TOC_SETR   1    /* Reserved */";
  z[lc++]="#define NSYS_SM_CH_TOC_CLRR 254    ";
  z[lc++]="#define NSYS_SM_CH_TOC_CHKR   1    ";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter P (program change) */";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_SIZE 3               /* chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_LOC_PROGRAM 0        /* PROGRAM byte */";
  z[lc++]="#define NSYS_SM_CP_LOC_BANKCOARSE 1     /* BANK-COARSE byte */";
  z[lc++]="#define NSYS_SM_CP_LOC_BANKFINE   2     /* BANK-FINE byte */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_SETC 128             /* | to set C header bit   */";
  z[lc++]="#define NSYS_SM_CP_CLRC 127             /* & to clear C header bit */";
  z[lc++]="#define NSYS_SM_CP_CHKC 128             /* & to check C header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CP_SETF 128             /* | to set F header bit   */";
  z[lc++]="#define NSYS_SM_CP_CLRF 127             /* & to clear F header bit */";
  z[lc++]="#define NSYS_SM_CP_CHKF 128             /* & to check F header bit */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="/* chapter W (pitch wheel) */";
  z[lc++]="/*+++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CW_SIZE 2           /* chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CW_LOC_FIRST 0      /* FIRST  byte */";
  z[lc++]="#define NSYS_SM_CW_LOC_SECOND 1     /* SECOND byte */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CW_SETD 128         /* | to set D header bit   */";
  z[lc++]="#define NSYS_SM_CW_CLRD 127         /* & to clear D header bit */";
  z[lc++]="#define NSYS_SM_CW_CHKD 128         /* & to check D header bit */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++*/";
  z[lc++]="/* chapter N (notes) */";
  z[lc++]="/*+++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_SIZE  256         /* maximum chapter size (front) */";
  z[lc++]="#define NSYS_SM_CB_SIZE   16         /* maximum bitfield size  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_LOC_LENGTH   0    /* LENGTH  byte */";
  z[lc++]="#define NSYS_SM_CN_LOC_LOWHIGH  1    /* LOWHIGH byte */";
  z[lc++]="#define NSYS_SM_CN_LOC_LOGSTART 2    /* start of note logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_LOWMASK   0xF0    /* mask for LOW  */";
  z[lc++]="#define NSYS_SM_CN_HIGHMASK  0x0F    /* mask for HIGH */";
  z[lc++]="#define NSYS_SM_CN_LOWSHIFT     4    /* shift align for LOW */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_HDRSIZE 2         /* size of chapter n header */  ";
  z[lc++]="#define NSYS_SM_CN_LOGSIZE 2         /* size of each note log    */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_LOC_NUM 0         /* note number byte in each log  */";
  z[lc++]="#define NSYS_SM_CN_LOC_VEL 1         /* velocity byte in each log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_SETB 128          /* | to set B header bit   */";
  z[lc++]="#define NSYS_SM_CN_CLRB 127          /* & to clear B header bit */";
  z[lc++]="#define NSYS_SM_CN_CHKB 128          /* & to check B header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_SETY 128          /* | to set Y header bit   */";
  z[lc++]="#define NSYS_SM_CN_CLRY 127          /* & to clear Y header bit */";
  z[lc++]="#define NSYS_SM_CN_CHKY 128          /* & to check Y header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_ARRAYSIZE  128    /* size of note state arrays */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_BFMIN        0    /* minimum bitfield value    */";
  z[lc++]="#define NSYS_SM_CN_BFMAX       15    /* maximum bitfield value    */";
  z[lc++]="#define NSYS_SM_CN_BFSHIFT      3    /* note to bitfield byte shift */";
  z[lc++]="#define NSYS_SM_CN_BFMASK    0x07    /* mask for bit position      */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CN_MAXDELAY  0.025F   /* lifetime of Y bit (seconds)  */";
  z[lc++]="#define NSYS_SM_CN_RECDELAY  0.10F    /* receiver test for Y lifetime */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++*/";
  z[lc++]="/* chapter A (poly touch) */";
  z[lc++]="/*++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_SIZE  257         /* maximum chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_LOC_LENGTH   0    /* LENGTH byte */";
  z[lc++]="#define NSYS_SM_CA_LOC_LOGSTART 1    /* start of note logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_HDRSIZE 1         /* size of chapter a header */  ";
  z[lc++]="#define NSYS_SM_CA_LOGSIZE 2         /* size of each note log */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_LOC_NUM 0         /* NOTENUM byte in each log  */";
  z[lc++]="#define NSYS_SM_CA_LOC_PRESSURE 1    /* PRESSURE byte in each log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_SETF 128          /* | to set F header bit   */";
  z[lc++]="#define NSYS_SM_CA_CLRF 127          /* & to clear F header bit */";
  z[lc++]="#define NSYS_SM_CA_CHKF 128          /* & to check F header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_SETD 128          /* | to set D header bit   */";
  z[lc++]="#define NSYS_SM_CA_CLRD 127          /* & to clear D header bit */";
  z[lc++]="#define NSYS_SM_CA_CHKD 128          /* & to check D header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CA_ARRAYSIZE  128    /* size of ptouch state arrays */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter T (channel aftertouch) */";
  z[lc++]="/*++++++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CT_SIZE 1            /* chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CT_LOC_PRESSURE 0    /* PRESSURE byte */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter C (control change) */";
  z[lc++]="/*++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_SIZE  257         /* maximum chapter size */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_LOC_LENGTH   0    /* LENGTH byte */";
  z[lc++]="#define NSYS_SM_CC_LOC_LOGSTART 1    /* start of controller logs */ ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_HDRSIZE 1         /* size of chapter c header */  ";
  z[lc++]="#define NSYS_SM_CC_LOGSIZE 2         /* size of each controller log */  ";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_LOC_LNUM 0        /* CONTROLLER byte in each log  */";
  z[lc++]="#define NSYS_SM_CC_LOC_LVAL 1        /* VALUE/COUNT byte in each log */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_SETF 128          /* | to set F header bit   */";
  z[lc++]="#define NSYS_SM_CC_CLRF 127          /* & to clear F header bit */";
  z[lc++]="#define NSYS_SM_CC_CHKF 128          /* & to check F header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_SETD 128          /* | to set D header bit   */";
  z[lc++]="#define NSYS_SM_CC_CLRD 127          /* & to clear D header bit */";
  z[lc++]="#define NSYS_SM_CC_CHKD 128          /* & to check D header bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_ARRAYSIZE  128    /* size of controller state arrays */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_MODULO 0x7F       /* for updating COUNT state */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CC_SETP 128          /* | to set P COUNT state bit */";
  z[lc++]="#define NSYS_SM_CC_CLRP 127          /* & to clear P COUNT state bit */";
  z[lc++]="#define NSYS_SM_CC_CHKP 128          /* & to check P COUNT bit */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++++*/";
  z[lc++]="/* chapter F (app speciFic) */";
  z[lc++]="/*++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_HDRSIZE       2   /* size of chapter f header */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_LOC_LENGTH    0   /* LENGTH field */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_CF_LENMASK  0x03FF   /* mask for length field */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++++*/";
  z[lc++]="/* mpeg4-samidi: receiver */";
  z[lc++]="/*++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="/* number of MIDI channels to pre-allocate per receiver */";
  z[lc++]="";
  z[lc++]="#define NSYS_RECVCHAN  2";
  z[lc++]="";
  z[lc++]="/* constants to handle flag bit */";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_RV_SETF 128        /* | to set flag bit   */";
  z[lc++]="#define NSYS_SM_RV_CLRF 127        /* & to clear flag bit */";
  z[lc++]="#define NSYS_SM_RV_CHKF 128        /* & to check flag bit */";
  z[lc++]="";
  z[lc++]="/*++++++++++++++++++++++*/";
  z[lc++]="/* mpeg4-samidi: sender */";
  z[lc++]="/*++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_GUARD_ONTIME     NSYS_SM_CN_MAXDELAY";
  z[lc++]="#define NSYS_SM_GUARD_MINTIME    0.25F";
  z[lc++]="#define NSYS_SM_GUARD_STDTIME    0.10F";
  z[lc++]="#define NSYS_SM_GUARD_MAXTIME    1.0F";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#define NSYS_SM_FEC_NONE     0";
  z[lc++]="#define NSYS_SM_FEC_NOGUARD  1";
  z[lc++]="#define NSYS_SM_FEC_MINIMAL  2  ";
  z[lc++]="#define NSYS_SM_FEC_STANDARD 3  ";
  z[lc++]="#define NSYS_SM_FEC_EXTRA    4  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define NSYS_SM_LATETIME        0.040F     /* maximum lateness */";
  z[lc++]="#define NSYS_SM_LATEWINDOW        3.5F     /* time window for reset */";
  z[lc++]="";
  z[lc++]="/*+++++++++++++++++++++++++++++*/";
  z[lc++]="/* mpeg4-samidi: miscellaneous */";
  z[lc++]="/*+++++++++++++++++++++++++++++*/";
  z[lc++]="";
  z[lc++]="/* return values for nsys_netin_journal_recovery() */";
  z[lc++]="";
  z[lc++]="#define NSYS_JOURNAL_RECOVERED  0   /* must be zero */";
  z[lc++]="#define NSYS_JOURNAL_FILLEDBUFF 1";
  z[lc++]="#define NSYS_JOURNAL_CORRUPTED  2";
  z[lc++]="";
  z[lc++]="/*******/";
  z[lc++]="/* SIP */";
  z[lc++]="/*******/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_SIP_IP";
  z[lc++]="#define NSYS_SIP_IP          \"128.32.131.152\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_SIP_RTP_PORT";
  z[lc++]="#define NSYS_SIP_RTP_PORT    5060";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_SIP_RTCP_PORT";
  z[lc++]="#define NSYS_SIP_RTCP_PORT   5061";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define NSYS_HOSTNAMESIZE 256";
  z[lc++]="#define NSYS_SDPNATSIZE   128";
  z[lc++]="#define NSYS_CNAMESIZE     32";
  z[lc++]="";
  z[lc++]="#define NSYS_NETIN_SIPSTATE 0   /* SIP INVITE state machine states */";
  z[lc++]="#define NSYS_NETIN_SDPSTATE 1";
  z[lc++]="#define NSYS_NETIN_EOFSTATE 2";
  z[lc++]="#define NSYS_NETIN_ERRSTATE 3";
  z[lc++]="";
  z[lc++]="#define NSYS_SIP_RETRYMAX       5         /* max retry for initial connect */";
  z[lc++]="#define NSYS_SIP_AUTHRETRYMAX   4         /* max retry for authentication  */";
  z[lc++]="";
  z[lc++]="#define NSYS_SIP_UNIXTONTP      2208988800UL /* add to UNIX time for NTP (s) */";
  z[lc++]=" ";
  z[lc++]="";
  z[lc++]="/*******************/";
  z[lc++]="/* Crypto/Security */";
  z[lc++]="/*******************/";
  z[lc++]="";
  z[lc++]="#define NSYS_MD5_LENGTH     16   /* array size for an MD5 digest in binary */";
  z[lc++]="#define NSYS_MD5_ROUNDS  10000   /* number of MD5 passes for keydigest  */";
  z[lc++]="";
  z[lc++]="#define NSYS_BASE64_LENGTH  25   /* string size of a BASE64 MD5 digest     */";
  z[lc++]="#define NSYS_MKEY_LENGTH    32   /* length of random key for mirror        */";
  z[lc++]="";
  z[lc++]="#define NSYS_MAXLATETIME     5400   /* clocks no more than 90 minutes fast */";
  z[lc++]="#define NSYS_MAXSSESIONTIME 21600   /* session maxtime is 6 hours          */";
  z[lc++]="";
  z[lc++]="#define NSYS_MSESSION_NAME \"mirror\"  /* change if sfront hashes names  */";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_MSESSION_INTERVAL";
  z[lc++]="#define NSYS_MSESSION_INTERVAL  12   /* pitch shift for mirror         */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#define NSYS_MSESSION_MAXRTP  9000   /* maximum RTP packets in session  */";
  z[lc++]="#define NSYS_MSESSION_MAXRTCP  200   /* maximum RTCP packets in session */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                           Variable externs                             */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: network */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="extern int nsys_rtp_fd;               /* fd for rtp           */";
  z[lc++]="extern int nsys_rtcp_fd;              /* fd for rtcp          */";
  z[lc++]="extern int nsys_max_fd;               /* fd for select        */";
  z[lc++]="";
  z[lc++]="extern unsigned short nsys_rtp_port;  /* actual rtp port      */ ";
  z[lc++]="extern unsigned short nsys_rtcp_port; /* actual rtcp port     */ ";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_rtp_cseq;   /* rtp cseq number      */";
  z[lc++]="extern unsigned long nsys_rtcp_cseq;  /* rtcp cseq number     */";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: packets */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_netout_rtp_packet[];  /* rtp packet out */";
  z[lc++]="";
  z[lc++]="/* rtcp packets and lengths */";
  z[lc++]="";
  z[lc++]="extern unsigned char * netout_rtcp_packet_bye;";
  z[lc++]="extern unsigned char * netout_rtcp_packet_rrempty;";
  z[lc++]="extern unsigned char * netout_rtcp_packet_rr;";
  z[lc++]="extern unsigned char * netout_rtcp_packet_srempty;";
  z[lc++]="extern unsigned char * netout_rtcp_packet_sr;";
  z[lc++]="";
  z[lc++]="extern int netout_rtcp_len_bye;";
  z[lc++]="extern int netout_rtcp_len_rrempty;";
  z[lc++]="extern int netout_rtcp_len_rr;";
  z[lc++]="extern int netout_rtcp_len_srempty;";
  z[lc++]="extern int netout_rtcp_len_sr;";
  z[lc++]="";
  z[lc++]="extern char * sdes_typename[];            /* rtcp debug array */";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_netout_seqnum;  /* rtp output sequence number */";
  z[lc++]="extern unsigned long nsys_netout_tstamp;  /* rtp output timestamp */";
  z[lc++]="extern unsigned char nsys_netout_markbit; /* for setting markerbit */";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* rtp payload support  */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="typedef struct payinfo {";
  z[lc++]="";
  z[lc++]="  int pindex;               /* index into nsys_payload_types  */";
  z[lc++]="  unsigned char ptype;      /* RTP payload number */";
  z[lc++]="  char name[16];            /* name of payload    */";
  z[lc++]="  int srate;                /* audio sample rate  */";
  z[lc++]="";
  z[lc++]="} payinfo;";
  z[lc++]="";
  z[lc++]="extern struct payinfo nsys_payload_types[];";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* rtcp state */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="extern int nsys_sent_last;    /* a packet was sent last RTCP period     */";
  z[lc++]="extern int nsys_sent_this;    /* a packet was sent this RTCP period     */";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_sent_packets;  /* number of packets sent */";
  z[lc++]="extern unsigned long nsys_sent_octets;   /* number of octets sent */";
  z[lc++]="";
  z[lc++]="extern time_t nsys_nexttime;  /* time for next RTCP check               */";
  z[lc++]="extern int nsys_rtcp_ex;      /* status flags to check at RTCP time     */";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* identification */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="extern unsigned long nsys_myssrc;     /*  SSRC -- hostorder  */";
  z[lc++]="extern unsigned long nsys_myssrc_net; /*  SSRC -- netorder   */";
  z[lc++]="";
  z[lc++]="extern char * nsys_sessionname;";
  z[lc++]="extern char * nsys_sessionkey;";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_keydigest[];        /* digested key */";
  z[lc++]="extern unsigned char nsys_session_base64[];   /* signed session name */";
  z[lc++]="extern int nsys_msession;                     /* mirror session flag */";
  z[lc++]="extern int nsys_msessionmirror;               /* mirror in mirror session */";
  z[lc++]="";
  z[lc++]="extern int nsys_feclevel;";
  z[lc++]="extern int nsys_lateplay;";
  z[lc++]="extern float nsys_latetime;";
  z[lc++]="";
  z[lc++]="extern char nsys_clientname[];";
  z[lc++]="extern char nsys_clientip[];";
  z[lc++]="extern char * nsys_username;";
  z[lc++]="";
  z[lc++]="extern char nsys_cname[];";
  z[lc++]="extern unsigned char nsys_cname_len;";
  z[lc++]="";
  z[lc++]="extern int nsys_powerup_mset; ";
  z[lc++]="";
  z[lc++]="/***********/";
  z[lc++]="/* logging */";
  z[lc++]="/***********/";
  z[lc++]="";
  z[lc++]="extern int nsys_stderr_size;";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* MIDI input buffer */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_buff[];";
  z[lc++]="extern long nsys_bufflen;";
  z[lc++]="extern long nsys_buffcnt;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* mpeg4-samidi: recovery journal sender state */";
  z[lc++]="/*_____________________________________________*/";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* checkpoint management */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="extern unsigned long netout_jsend_checkpoint_seqnum;  /* current checkpoint */";
  z[lc++]="extern unsigned long netout_jsend_checkpoint_changed; /* 1 if changed */";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* S-list management */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="extern unsigned char * netout_jsend_slist[];";
  z[lc++]="extern int netout_jsend_slist_size;";
  z[lc++]="";
  z[lc++]="/*******************************/";
  z[lc++]="/* guard journal state machine */";
  z[lc++]="/*******************************/";
  z[lc++]="";
  z[lc++]="extern int netout_jsend_guard_send;    /* flag variable: send guard packet */";
  z[lc++]="extern int netout_jsend_guard_time;    /* guard packet timer state */";
  z[lc++]="extern int netout_jsend_guard_next;    /* reload value for timer */";
  z[lc++]="extern int netout_jsend_guard_ontime;  /* minimum delay time for noteon */ ";
  z[lc++]="extern int netout_jsend_guard_mintime; /* minimum delay time for (!noteon) */";
  z[lc++]="extern int netout_jsend_guard_maxtime; /* maximum delay time */ ";
  z[lc++]="";
  z[lc++]="/***************************/";
  z[lc++]="/* recovery journal header */";
  z[lc++]="/***************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char netout_jsend_header[];    /* journal header */";
  z[lc++]="";
  z[lc++]="/**************************/";
  z[lc++]="/* chanell journal record */";
  z[lc++]="/**************************/";
  z[lc++]="";
  z[lc++]="extern unsigned char netout_jsend_channel[];";
  z[lc++]="extern unsigned char netout_jsend_channel_size;";
  z[lc++]="";
  z[lc++]="/******************************************/";
  z[lc++]="/* structure holding sender channel state */";
  z[lc++]="/******************************************/";
  z[lc++]="";
  z[lc++]="typedef struct netout_jsend_state {";
  z[lc++]="";
  z[lc++]="  unsigned char  chan;  /* MIDI channel */";
  z[lc++]="  unsigned short clen;  /* first two bytes of cheader */";
  z[lc++]="";
  z[lc++]="  /* most recent MIDI commands, used for new source init */";
  z[lc++]="";
  z[lc++]="  unsigned char history_active;     /* flag for channel activity */";
  z[lc++]="  unsigned char history_cc_bankc;   /* current cc values */";
  z[lc++]="  unsigned char history_cc_bankf;";
  z[lc++]="  unsigned char history_cc_modwheel;";
  z[lc++]="  unsigned char history_cc_volume;";
  z[lc++]="";
  z[lc++]="  unsigned char history_program;       /* last program change */";
  z[lc++]="  unsigned char history_program_bankc;";
  z[lc++]="  unsigned char history_program_bankf;";
  z[lc++]="";
  z[lc++]="  /* sequence numbers -- 0 or highest seqnum */";
  z[lc++]="";
  z[lc++]="  unsigned long cheader_seqnum; ";
  z[lc++]="  unsigned long chapterp_seqnum;";
  z[lc++]="  unsigned long chapterw_seqnum;    ";
  z[lc++]="  unsigned long chaptert_seqnum;    ";
  z[lc++]="  unsigned long chaptern_seqnum;    ";
  z[lc++]="  unsigned long chaptern_seqarray[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="  unsigned long chaptera_seqnum;";
  z[lc++]="  unsigned long chaptera_seqarray[NSYS_SM_CA_ARRAYSIZE];";
  z[lc++]="  unsigned long chapterc_seqnum;";
  z[lc++]="  unsigned long chapterc_seqarray[NSYS_SM_CC_ARRAYSIZE];";
  z[lc++]="  ";
  z[lc++]="  /* sender state for chapter n */";
  z[lc++]="  ";
  z[lc++]="  unsigned char chapterb_low;      ";
  z[lc++]="  unsigned char chapterb_high;   ";
  z[lc++]="  unsigned long chaptern_logptr[NSYS_SM_CN_ARRAYSIZE]; /* note log position */";
  z[lc++]="  unsigned long chaptern_timer[NSYS_SM_CN_ARRAYSIZE];  /* Y timer values */";
  z[lc++]="  unsigned long chaptern_timernum;                     /* number of values */";
  z[lc++]="  int chaptern_sset;                                   /* S bit indicators */";
  z[lc++]="  ";
  z[lc++]="  /* sender state for chapter a */";
  z[lc++]="  ";
  z[lc++]="  unsigned long chaptera_logptr[NSYS_SM_CA_ARRAYSIZE];  /* log positions */";
  z[lc++]="  int chaptera_sset;                                    /* S bit indicators */";
  z[lc++]="  ";
  z[lc++]="  /* sender state for chapter c */";
  z[lc++]="  ";
  z[lc++]="  unsigned long chapterc_logptr[NSYS_SM_CC_ARRAYSIZE];  /* log positions */";
  z[lc++]="  int chapterc_sset;                                    /* S bit indicators */";
  z[lc++]="  ";
  z[lc++]="  unsigned char chapterc_allnotes;                    /* COUNT state holders */";
  z[lc++]="  unsigned char chapterc_allsound;";
  z[lc++]="  unsigned char chapterc_sustain;                  /* pcccccccc: p=1-->down */";
  z[lc++]="";
  z[lc++]="  /* sizes for dynamic chapters */";
  z[lc++]="  ";
  z[lc++]="  int chaptern_size;    /* chapter n */";
  z[lc++]="  int chapterb_size;    /* chapter n - bitfields */";
  z[lc++]="  int chaptera_size;    /* chapter c */";
  z[lc++]="  int chapterc_size;    /* chapter c */";
  z[lc++]="  ";
  z[lc++]="  /* holds current packet bytes */";
  z[lc++]="  ";
  z[lc++]="  unsigned char cheader[NSYS_SM_CH_SIZE];  /* chapter header */";
  z[lc++]="  unsigned char chapterp[NSYS_SM_CP_SIZE]; /* chapter p  */";
  z[lc++]="  unsigned char chapterw[NSYS_SM_CW_SIZE]; /* chapter w  */";
  z[lc++]="  unsigned char chaptern[NSYS_SM_CN_SIZE]; /* chapter n  */";
  z[lc++]="  unsigned char chapterb[NSYS_SM_CB_SIZE]; /* chapter n - bfields */";
  z[lc++]="  unsigned char chaptera[NSYS_SM_CA_SIZE]; /* chapter a  */";
  z[lc++]="  unsigned char chaptert[NSYS_SM_CT_SIZE]; /* chapter t  */";
  z[lc++]="  unsigned char chapterc[NSYS_SM_CC_SIZE]; /* chapter c  */";
  z[lc++]="  ";
  z[lc++]="} netout_jsend_state;";
  z[lc++]="";
  z[lc++]="extern netout_jsend_state netout_jsend[];";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* structure holding receiver channel state */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="typedef struct netout_jrecv_state {";
  z[lc++]="";
  z[lc++]="  /* chapter p */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterp_program;";
  z[lc++]="  unsigned char chapterp_bankc;";
  z[lc++]="  unsigned char chapterp_bankf;";
  z[lc++]="";
  z[lc++]="  /* chapter w */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterw_first;";
  z[lc++]="  unsigned char chapterw_second;";
  z[lc++]="";
  z[lc++]="  /* chapter n */";
  z[lc++]="";
  z[lc++]="  unsigned char chaptern_vel[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="  unsigned long chaptern_tstamp[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="  unsigned long chaptern_extseq[NSYS_SM_CN_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /* chapter a */";
  z[lc++]="";
  z[lc++]="  unsigned char chaptera_pressure[NSYS_SM_CC_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /* chapter t */";
  z[lc++]="";
  z[lc++]="  unsigned char chaptert_pressure;";
  z[lc++]="";
  z[lc++]="  /* chapter c */";
  z[lc++]="";
  z[lc++]="  unsigned char chapterc_sustain;";
  z[lc++]="  unsigned char chapterc_value[NSYS_SM_CC_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /* navigation */";
  z[lc++]="";
  z[lc++]="  unsigned char chan;";
  z[lc++]="  struct netout_jrecv_state * next;";
  z[lc++]="";
  z[lc++]="} netout_jrecv_state;";
  z[lc++]="";
  z[lc++]="extern netout_jrecv_state * nsys_recvfree;  /* receiver free list */";
  z[lc++]="";
  z[lc++]="/*******/";
  z[lc++]="/* SIP */";
  z[lc++]="/*******/";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_rtp_invite[];";
  z[lc++]="extern unsigned char nsys_rtcp_invite[];";
  z[lc++]="";
  z[lc++]="extern int nsys_rtp_sipretry;                  /* sip server retry counter */";
  z[lc++]="extern int nsys_rtcp_sipretry;                 ";
  z[lc++]="";
  z[lc++]="extern int nsys_rtp_authretry;                 /* reauthorization counter  */";
  z[lc++]="extern int nsys_rtcp_authretry;";
  z[lc++]="";
  z[lc++]="extern struct sockaddr_in nsys_sip_rtp_addr;   /* current SIP RTP channel */";
  z[lc++]="extern char nsys_sip_rtp_ip[];";
  z[lc++]="extern unsigned long nsys_sip_rtp_inet_addr;";
  z[lc++]="extern unsigned short nsys_sip_rtp_port;";
  z[lc++]="extern unsigned short nsys_sip_rtp_sin_port;";
  z[lc++]="";
  z[lc++]="extern struct sockaddr_in nsys_sip_rtcp_addr;  /* current SIP RTCP channel */";
  z[lc++]="extern char nsys_sip_rtcp_ip[];";
  z[lc++]="extern unsigned long nsys_sip_rtcp_inet_addr;";
  z[lc++]="extern unsigned short nsys_sip_rtcp_port;";
  z[lc++]="extern unsigned short nsys_sip_rtcp_sin_port;";
  z[lc++]="";
  z[lc++]="extern int nsys_graceful_exit;                 /* requests termination    */";
  z[lc++]="";
  z[lc++]="extern unsigned char nsys_rtp_info[];          /* SIP INFO packets        */";
  z[lc++]="extern unsigned char nsys_rtcp_info[];";
  z[lc++]="";
  z[lc++]="extern int nsys_behind_nat;                    /* 1 if behind a nat        */";
  z[lc++]="extern int nsys_sipinfo_count;                 /* INFO sending timer       */";
  z[lc++]="extern int nsys_sipinfo_toggle;                /* RTP/RTCP toggle          */";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* SSRC stack  */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="typedef struct source {";
  z[lc++]="";
  z[lc++]="  /* information */";
  z[lc++]="";
  z[lc++]="  int mset;                           /* MIDI extchan set  */";
  z[lc++]="  unsigned long ssrc;                 /* RTP SSRC number   */";
  z[lc++]="  unsigned long birthtime;            /* Time SSRC was born (UNIX)    */";
  z[lc++]="";
  z[lc++]="  unsigned long siptime;              /* SIP INVITE sessiontime (UNIX)    */";
  z[lc++]="  struct sockaddr_in * sdp_addr;      /* IP/port in SDP packet, unchanged */";
  z[lc++]="";
  z[lc++]="  struct sockaddr_in * rtp_addr;      /* RTP IP/port of source */";
  z[lc++]="  struct sockaddr_in * alt_rtp_addr;  /* RTP IP/port of NATing */";
  z[lc++]="";
  z[lc++]="  struct sockaddr_in * rtcp_addr;     /* RTCP IP/port of source */";
  z[lc++]="  struct sockaddr_in * alt_rtcp_addr; /* RTCP IP/port of NATing */";
  z[lc++]=" ";
  z[lc++]="  unsigned char ptype;                /* payload type to send/recv */";
  z[lc++]="  int pindex;                         /* index into nsys_payload_types[]  */";
  z[lc++]="  int srate;                          /* SDP-assigned srate        */";
  z[lc++]="";
  z[lc++]="  /* navigation */";
  z[lc++]="";
  z[lc++]="  struct source * xtra;               /* if hash clashes */";
  z[lc++]="  struct source * prev;               /* doubly-linked list */";
  z[lc++]="  struct source * next;";
  z[lc++]="";
  z[lc++]="  /* reception statistics */";
  z[lc++]="";
  z[lc++]="  unsigned long received;             /* total num packets received   */";
  z[lc++]="  unsigned long received_prior;       /* total at last SR/RR          */";
  z[lc++]="  unsigned long expected_prior;       /* total expected at last SR/RR */";
  z[lc++]="";
  z[lc++]="  unsigned long base_seq;             /* initial extended seq num   */";
  z[lc++]="  unsigned long hi_lobits;            /* highest seq num low 16b    */";
  z[lc++]="  unsigned long hi_ext;               /* highest extended seq num   */";
  z[lc++]="";
  z[lc++]="  /* rtcp items */";
  z[lc++]="";
  z[lc++]="  int j_delta;                        /* state variable for jitter  */";
  z[lc++]="  unsigned long jitter;               /* current jitter value       */";
  z[lc++]="  unsigned char lsr[4];               /* last SR timestamp received */";
  z[lc++]="  struct timeval arrival;             /* arrival time of last SR    */";
  z[lc++]="  time_t expire_rtcp;                 /* time to expire ssrc entry  */";
  z[lc++]="  char * cname;                       /* canonical name             */";
  z[lc++]="  unsigned long rtcp_received;        /* for DoS detection          */";
  z[lc++]="";
  z[lc++]="  /* time model */";
  z[lc++]="";
  z[lc++]="  int ontime;                         /* flags on-time RTP packets   */    ";
  z[lc++]="  unsigned long tm_convert;           /* local/remote time offset    */";
  z[lc++]="  unsigned long tm_margin;            /* maximum lateness allowed    */";
  z[lc++]="  unsigned long tm_lateflag;          /* congestion detection flag   */";
  z[lc++]="  unsigned long tm_latetime;          /* tstamp of first late packet */";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="  unsigned long tm_first;             /* temporary for printfs       */";
  z[lc++]="  FILE * tm_fd;                       /* file pointer for dat files  */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* journal items */";
  z[lc++]="";
  z[lc++]="  unsigned long last_hiseq_rec;       /* RTCP extended sequence number   */";
  z[lc++]="  unsigned long last_hiseq_ext;       /* local-adjusted RTCP ext seq num */";
  z[lc++]="";
  z[lc++]="  struct netout_jrecv_state";
  z[lc++]="  * jrecv[CSYS_MIDI_NUMCHAN];         /* reciever journal state */";
  z[lc++]="";
  z[lc++]="} source;";
  z[lc++]="";
  z[lc++]="extern struct source * nsys_srcfree;       /* mset ssrc tokens */";
  z[lc++]="extern struct source * nsys_ssrc[];        /* SSRC hash table  */";
  z[lc++]="extern struct source * nsys_srcroot;       /* points into nsys_ssrc */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                              Macros                                    */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* error-checking */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="#define  NSYS_ERROR_RETURN(x) do {\\";
  z[lc++]="      nsys_stderr_size+=fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      nsys_stderr_size+=fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      return NSYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  NSYS_ERROR_TERMINATE(x) do {\\";
  z[lc++]="      nsys_stderr_size+=fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));\\";
  z[lc++]="      epr(0,NULL,NULL, \"Network error -- \" x );}  while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                        Function Externs                                */";
  z[lc++]="/*________________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* error checking */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="extern void epr(int linenum, char * filename, char * token, char * message);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_siplib.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern int nsys_initsip(void);";
  z[lc++]="extern void nsys_netin_reply(int fd, struct sockaddr_in * addr, ";
  z[lc++]="			     unsigned char * packet, unsigned short status);";
  z[lc++]="";
  z[lc++]="extern void nsys_netin_invite(int fd, struct sockaddr_in * addr, ";
  z[lc++]="			      unsigned char * packet);";
  z[lc++]="";
  z[lc++]="extern void nsys_createsip(int fd, char * method, unsigned char * sip,";
  z[lc++]="			   char * natline, char * nonce);";
  z[lc++]="extern void nsys_sendsip(int fd, struct sockaddr_in * addr, ";
  z[lc++]="			 unsigned char * sip); ";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_netin_readmethod(int fd, struct sockaddr_in * addr, ";
  z[lc++]="					     unsigned char * packet); ";
  z[lc++]="extern void nsys_netin_ack(int fd, unsigned char * reply, ";
  z[lc++]="			   unsigned long callid, unsigned long cseq);";
  z[lc++]="extern int nsys_netin_replyparse(int fd, unsigned char * packet, ";
  z[lc++]="				 char *nonce, char * natline, ";
  z[lc++]="				 unsigned long * callid, unsigned long * cseq);";
  z[lc++]="extern void nsys_netin_redirect(int fd, unsigned char * packet,";
  z[lc++]="				unsigned short status);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_sipaddr(int fd, char * ip, unsigned short port);";
  z[lc++]="extern int nsys_netin_siporigin(int fd, struct sockaddr_in * addr);";
  z[lc++]="extern int nsys_netin_make_marray(struct payinfo ** marray, char * media);";
  z[lc++]="extern int nsys_netin_set_marray(char * line, struct payinfo marray[],";
  z[lc++]="				 int mlen);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_payvalid(struct payinfo marray[], int mlen, int fd);";
  z[lc++]="extern void nsys_netin_payset(struct source * sptr, struct payinfo marray[],";
  z[lc++]="			      int mlen);";
  z[lc++]="extern int nsys_netin_noreplay(char * ip, unsigned short port, ";
  z[lc++]="			       unsigned long sdp_time);";
  z[lc++]="extern void nsys_sip_shutdown(void);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_rtplib.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern int nsys_setup(int block);";
  z[lc++]="extern void nsys_shutdown(void);";
  z[lc++]="";
  z[lc++]="extern source * nsys_netin_addsrc(int fd, long ssrc,";
  z[lc++]="				  char * ip, unsigned short port);";
  z[lc++]="extern int nsys_netin_rtpstats(source * sptr, unsigned char * packet);";
  z[lc++]="extern void  nsys_warning(int level, char * message);";
  z[lc++]="extern void nsys_terminate_error(char * message); ";
  z[lc++]="extern void nsys_status(source * sptr, char * message);";
  z[lc++]="extern int nsys_netin_ptypevalid(unsigned char ptype);";
  z[lc++]="extern void nsys_netin_ptypeset(struct source * sptr, unsigned char ptype);";
  z[lc++]="extern netout_jrecv_state * nsys_netin_newrecv(unsigned char chan);";
  z[lc++]="extern char * nsys_find_clientip(char * ip);";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_rtcplib.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern source * nsys_netin_rtcp(unsigned char * packet, int len, ";
  z[lc++]="				struct sockaddr_in * ipaddr);";
  z[lc++]="extern int nsys_make_rtcp(void);";
  z[lc++]="extern int nsys_make_rtcpbye(void);";
  z[lc++]="extern void nsys_netout_rtcptime(void);";
  z[lc++]="extern void nsys_delete_ssrc(unsigned long ssrc, char * reason);";
  z[lc++]="extern source * nsys_harvest_ssrc(int fd, struct sockaddr_in * ipaddr);";
  z[lc++]="extern void nsys_late_windowcheck(source * sptr, unsigned long tstamp);";
  z[lc++]="extern char * nsys_netin_newcname(unsigned char * packet, int len);";
  z[lc++]="extern void nsys_netin_bye(unsigned char * packet, int len);";
  z[lc++]="extern int nsys_netout_excheck(void);";
  z[lc++]="extern void nsys_netout_keepalive(void);";
  z[lc++]="extern void nsys_netin_rtcp_display(unsigned char * packet, int len,";
  z[lc++]="				    struct timeval * now);";
  z[lc++]="extern void nsys_netout_rtcpreport(void);";
  z[lc++]="extern void nsys_netout_rtcpsend(unsigned char * p, int len);";
  z[lc++]="extern int nsys_netin_clear_mset(unsigned char * buff, long * fill,";
  z[lc++]="				 long size);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_rtcp_initpackets(void);";
  z[lc++]="extern void nsys_netout_rtcp_initrr(unsigned char * p, int len);";
  z[lc++]="extern void nsys_netout_rtcp_initsr(unsigned char * p, int len);";
  z[lc++]="extern void nsys_netout_rtcp_initsdes(unsigned char * p, int len);";
  z[lc++]="extern void nsys_netout_rtcp_initbye(unsigned char * p);";
  z[lc++]="extern void nsys_netin_rtcp_trunc(int sub);";
  z[lc++]="extern void nsys_netin_latenotes_open(source * sptr);";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* net_jsend.c */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_create(unsigned char * packet, int len);";
  z[lc++]="extern void nsys_netout_journal_addstate(unsigned char cmd,";
  z[lc++]="					unsigned char ndata,";
  z[lc++]="					unsigned char vdata);";
  z[lc++]="extern void nsys_netout_journal_addhistory(unsigned char cmd,";
  z[lc++]="					   unsigned char ndata,";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="extern void nsys_netin_journal_trimstate(source * lptr);";
  z[lc++]="extern void nsys_netout_midistate_init(void);";
  z[lc++]="extern void nsys_netout_guard_tick(void);";
  z[lc++]="extern void nsys_netout_journal_changecheck(void);";
  z[lc++]="extern void nsys_netout_journal_addprogram(netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata);";
  z[lc++]="extern void nsys_netout_journal_addpwheel(netout_jsend_state * jsend, ";
  z[lc++]="					  unsigned char ndata, ";
  z[lc++]="					  unsigned char vdata);";
  z[lc++]="extern void nsys_netout_journal_addnoteoff(netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata);";
  z[lc++]="extern void nsys_netout_journal_addnoteon(netout_jsend_state * jsend, ";
  z[lc++]="					  unsigned char ndata, ";
  z[lc++]="					  unsigned char vdata);";
  z[lc++]="extern void nsys_netout_journal_addptouch(netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata,";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="extern void nsys_netout_journal_addctouch(netout_jsend_state * jsend, ";
  z[lc++]="					  unsigned char ndata);";
  z[lc++]="extern void nsys_netout_journal_addcontrol(netout_jsend_state * jsend, ";
  z[lc++]="					   unsigned char ndata,";
  z[lc++]="					   unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimchapter(netout_jsend_state * jsend,";
  z[lc++]="					    int channel);";
  z[lc++]="extern void nsys_netout_journal_trimprogram(netout_jsend_state * jsend);";
  z[lc++]="extern void nsys_netout_journal_trimpwheel(netout_jsend_state * jsend);";
  z[lc++]="extern void nsys_netout_journal_trimctouch(netout_jsend_state * jsend);";
  z[lc++]="";
  z[lc++]="extern void nsys_netout_journal_trimallcontrol(netout_jsend_state * jsend);";
  z[lc++]="extern void nsys_netout_journal_trimpartcontrol(netout_jsend_state * jsend,";
  z[lc++]="						unsigned long minseq);";
  z[lc++]="extern void nsys_netout_journal_trimallptouch(netout_jsend_state * jsend);";
  z[lc++]="extern void nsys_netout_journal_trimpartptouch(netout_jsend_state * jsend,";
  z[lc++]="						unsigned long minseq);";
  z[lc++]="extern void nsys_netout_journal_trimallnote(netout_jsend_state * jsend);";
  z[lc++]="extern void nsys_netout_journal_trimpartnote(netout_jsend_state * jsend,";
  z[lc++]="					     unsigned long minseq);";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* net_recv.c */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_recovery(source * sptr, int rtpcode, ";
  z[lc++]="				       unsigned char * packet, int numbytes,";
  z[lc++]="				       unsigned char * buff, long * fill,";
  z[lc++]="				       long size);";
  z[lc++]="";
  z[lc++]="extern void nsys_netin_journal_trackstate(source * sptr, unsigned char cmd,";
  z[lc++]="					  unsigned char ndata, ";
  z[lc++]="					  unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_journal_addcmd(source * sptr, unsigned char * buff, ";
  z[lc++]="				     long * fill, long size,";
  z[lc++]="				     unsigned char cmd, unsigned char ndata,";
  z[lc++]="				     unsigned char vdata);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_program(source * sptr, unsigned char * p,";
  z[lc++]="				   netout_jrecv_state * jrecv,";
  z[lc++]="				   unsigned char * buff,  ";
  z[lc++]="				   long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_wheel(source * sptr, unsigned char * p,";
  z[lc++]="				 netout_jrecv_state * jrecv,";
  z[lc++]="				 unsigned char * buff,  ";
  z[lc++]="				 long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_notelog(source * sptr, unsigned char * p,";
  z[lc++]="				   netout_jrecv_state * jrecv, ";
  z[lc++]="				   unsigned char many,";
  z[lc++]="				   short loglen, unsigned char * checkptr,";
  z[lc++]="				   unsigned char * buff, ";
  z[lc++]="				   long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_bitfield(source * sptr, unsigned char * p,";
  z[lc++]="				    netout_jrecv_state * jrecv, ";
  z[lc++]="				    unsigned char low, unsigned char high,";
  z[lc++]="				    unsigned char * buff, long * fill,";
  z[lc++]="				    long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_ptouch(source * sptr, unsigned char * p,";
  z[lc++]="				  netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="				  unsigned char many, unsigned char * buff, ";
  z[lc++]="				  long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_ctouch(source * sptr, unsigned char * p,";
  z[lc++]="				  netout_jrecv_state * jrecv,";
  z[lc++]="				  unsigned char * buff,  ";
  z[lc++]="				  long * fill, long size);";
  z[lc++]="";
  z[lc++]="extern int nsys_netin_jrec_control(source * sptr, unsigned char * p,";
  z[lc++]="				   netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="				   unsigned char many, unsigned char * buff, ";
  z[lc++]="				   long * fill, long size);";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************/";
  z[lc++]="/* net_crypto.c */";
  z[lc++]="/****************/";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_md5(unsigned char * digest, unsigned char * text,";
  z[lc++]="				int len);";
  z[lc++]="";
  z[lc++]="extern char * nsys_hmac_md5(unsigned char* text, int text_len, ";
  z[lc++]="			    unsigned char * keydigest, unsigned char * digest);";
  z[lc++]="";
  z[lc++]="extern unsigned char * nsys_digest_base64(unsigned char * output, ";
  z[lc++]="					  unsigned char * input);";
  z[lc++]="";
  z[lc++]="extern int nsys_digest_syntaxcheck(char * s);";
  z[lc++]="";
  z[lc++]="#endif /* NSYS_NET_INCLUDE */";
  z[lc++]="";
  z[lc++]="/* end Network library -- constants and externs */";
  z[lc++]="";
  printlib(lc);
}


void makenet_globals(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- global variables";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: network */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="int nsys_rtp_fd;                  /* fd for rtp           */";
  z[lc++]="int nsys_rtcp_fd;                 /* fd for rtcp          */";
  z[lc++]="int nsys_max_fd;                  /* fd for select        */";
  z[lc++]="";
  z[lc++]="unsigned short nsys_rtp_port;     /* actual rtp port     */ ";
  z[lc++]="unsigned short nsys_rtcp_port;    /* actual rtcp port    */ ";
  z[lc++]="";
  z[lc++]="unsigned long nsys_rtp_cseq;      /* rtp cseq number      */";
  z[lc++]="unsigned long nsys_rtcp_cseq;     /* rtcp cseq number     */";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* rtp and rtcp: packets */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_rtp_packet[NSYS_UDPMAXSIZE];  /* rtp packet out */";
  z[lc++]="";
  z[lc++]="unsigned char * netout_rtcp_packet_rrempty;";
  z[lc++]="unsigned char * netout_rtcp_packet_rr;";
  z[lc++]="unsigned char * netout_rtcp_packet_srempty;";
  z[lc++]="unsigned char * netout_rtcp_packet_sr;";
  z[lc++]="unsigned char * netout_rtcp_packet_bye;";
  z[lc++]="";
  z[lc++]="int netout_rtcp_len_rrempty;";
  z[lc++]="int netout_rtcp_len_rr;";
  z[lc++]="int netout_rtcp_len_srempty;";
  z[lc++]="int netout_rtcp_len_sr;";
  z[lc++]="int netout_rtcp_len_bye;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="unsigned char nsys_netout_rtcp_packet[NSYS_UDPMAXSIZE]; /* rtcp packet out */";
  z[lc++]="int nsys_netout_rtcp_size;                              /* rtcp packet size*/";
  z[lc++]="";
  z[lc++]="char * sdes_typename[NSYS_RTCPVAL_SDES_SIZE] = {       /* rtcp debug array */";
  z[lc++]="  \"ILLEGAL\", \"Cname\", \"Name\", \"Email\", \"Phone\", ";
  z[lc++]="  \"Loc\", \"Tool\", \"Note\", \"Priv\" };";
  z[lc++]="";
  z[lc++]="unsigned long nsys_netout_seqnum;  /* rtp output sequence number */";
  z[lc++]="unsigned long nsys_netout_tstamp;  /* rtp output timestamp */";
  z[lc++]="unsigned char nsys_netout_markbit; /* for setting markerbit */";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* rtp payload support  */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="#if 0";
  z[lc++]="/* when adding new codecs, follow this sample  */";
  z[lc++]="/* remember to increment NSYS_RTP_PAYSIZE, and */";
  z[lc++]="/* get ordering correct.                       */";
  z[lc++]="";
  z[lc++]="struct payinfo nsys_payload_types[NSYS_RTP_PAYSIZE] = ";
  z[lc++]="{ ";
  z[lc++]="  {0, 97, \"X-MP4SA-1\", (int)(ARATE + 0.5F)},";
  z[lc++]="  {1, 96, \"X-MP4SA-0\", (int)(ARATE + 0.5F)}";
  z[lc++]="};";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="struct payinfo nsys_payload_types[NSYS_RTP_PAYSIZE] = ";
  z[lc++]="{ ";
  z[lc++]="  {0, 96, \"X-MP4SA-0\", (int)(ARATE + 0.5F)}";
  z[lc++]="};";
  z[lc++]="";
  z[lc++]="/**************/";
  z[lc++]="/* rtcp timer */";
  z[lc++]="/**************/";
  z[lc++]="";
  z[lc++]="int nsys_sent_last;       /* a packet was sent last RTCP period */";
  z[lc++]="int nsys_sent_this;       /* a packet was sent this RTCP period */";
  z[lc++]="";
  z[lc++]="unsigned long nsys_sent_packets;  /* number of packets sent */";
  z[lc++]="unsigned long nsys_sent_octets;   /* number of octets sent */";
  z[lc++]="";
  z[lc++]="time_t nsys_nexttime;     /* time for next RTCP check           */";
  z[lc++]="int nsys_rtcp_ex;         /* status flags to check at RTCP time */";
  z[lc++]="";
  z[lc++]="/******************/";
  z[lc++]="/* identification */";
  z[lc++]="/******************/";
  z[lc++]="";
  z[lc++]="unsigned long nsys_myssrc;        /*  SSRC -- hostorder  */";
  z[lc++]="unsigned long nsys_myssrc_net;    /*  SSRC -- netorder   */";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="char * nsys_sessionname;   ";
  z[lc++]="char * nsys_sessionkey;   ";
  z[lc++]="int nsys_feclevel = NSYS_SM_FEC_STANDARD;";
  z[lc++]="int nsys_lateplay;";
  z[lc++]="float nsys_latetime = NSYS_SM_LATETIME;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="unsigned char nsys_keydigest[NSYS_MD5_LENGTH];";
  z[lc++]="unsigned char nsys_session_base64[NSYS_BASE64_LENGTH];";
  z[lc++]="int nsys_msession;";
  z[lc++]="int nsys_msessionmirror;";
  z[lc++]="";
  z[lc++]="char nsys_clientname[NSYS_HOSTNAMESIZE];";
  z[lc++]="char nsys_clientip[16];";
  z[lc++]="char * nsys_username;";
  z[lc++]="";
  z[lc++]="char nsys_cname[NSYS_CNAMESIZE];";
  z[lc++]="unsigned char nsys_cname_len;";
  z[lc++]="int nsys_powerup_mset; ";
  z[lc++]="";
  z[lc++]="/***********/";
  z[lc++]="/* logging */";
  z[lc++]="/***********/";
  z[lc++]="";
  z[lc++]="int nsys_stderr_size;";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* MIDI input buffer */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_buff[NSYS_BUFFSIZE];";
  z[lc++]="long nsys_bufflen;";
  z[lc++]="long nsys_buffcnt;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* mpeg4-samidi: recovery journal sender state */";
  z[lc++]="/*_____________________________________________*/";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* checkpoint management */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="unsigned long netout_jsend_checkpoint_seqnum; /* current checkpoint */";
  z[lc++]="unsigned long netout_jsend_checkpoint_changed; /* 1 if changed */";
  z[lc++]="";
  z[lc++]="/*********************/";
  z[lc++]="/* S-list management */";
  z[lc++]="/*********************/";
  z[lc++]="";
  z[lc++]="unsigned char * netout_jsend_slist[NSYS_SM_SLISTLEN];";
  z[lc++]="int netout_jsend_slist_size;";
  z[lc++]="";
  z[lc++]="/*******************************/";
  z[lc++]="/* guard journal state machine */";
  z[lc++]="/*******************************/";
  z[lc++]="";
  z[lc++]="int netout_jsend_guard_send;    /* flag variable: send a guard packet */";
  z[lc++]="int netout_jsend_guard_time;    /* guard packet timer state */";
  z[lc++]="int netout_jsend_guard_next;    /* reload value for timer */";
  z[lc++]="int netout_jsend_guard_ontime;  /* minimum delay time for noteon */ ";
  z[lc++]="int netout_jsend_guard_mintime; /* minimum delay time for (!noteon) */";
  z[lc++]="int netout_jsend_guard_maxtime; /* maximum delay time */ ";
  z[lc++]="";
  z[lc++]="/***************************/";
  z[lc++]="/* recovery journal header */";
  z[lc++]="/***************************/";
  z[lc++]="";
  z[lc++]="unsigned char netout_jsend_header[NSYS_SM_JH_SIZE];   /* journal header */";
  z[lc++]="";
  z[lc++]="/**************************/";
  z[lc++]="/* channel journal record */";
  z[lc++]="/**************************/";
  z[lc++]="";
  z[lc++]="unsigned char netout_jsend_channel[CSYS_MIDI_NUMCHAN];";
  z[lc++]="unsigned char netout_jsend_channel_size;";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* sender channel state */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="netout_jsend_state netout_jsend[CSYS_MIDI_NUMCHAN];";
  z[lc++]="";
  z[lc++]="/**************************/";
  z[lc++]="/* receiver channel state */";
  z[lc++]="/**************************/";
  z[lc++]="";
  z[lc++]="netout_jrecv_state * nsys_recvfree;  ";
  z[lc++]="  ";
  z[lc++]="";
  z[lc++]="/*******/";
  z[lc++]="/* SIP */";
  z[lc++]="/*******/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_rtp_invite[NSYS_UDPMAXSIZE+1];";
  z[lc++]="unsigned char nsys_rtcp_invite[NSYS_UDPMAXSIZE+1];";
  z[lc++]="";
  z[lc++]="int nsys_rtp_sipretry;      /* sip server retry counter */";
  z[lc++]="int nsys_rtcp_sipretry;                 ";
  z[lc++]="";
  z[lc++]="int nsys_rtp_authretry;     /* reauthorization counter  */";
  z[lc++]="int nsys_rtcp_authretry;";
  z[lc++]="";
  z[lc++]="struct sockaddr_in nsys_sip_rtp_addr;   /* current SIP RTP channel */";
  z[lc++]="char nsys_sip_rtp_ip[16];";
  z[lc++]="unsigned long nsys_sip_rtp_inet_addr;";
  z[lc++]="unsigned short nsys_sip_rtp_port;";
  z[lc++]="unsigned short nsys_sip_rtp_sin_port;";
  z[lc++]="";
  z[lc++]="struct sockaddr_in nsys_sip_rtcp_addr;  /* current SIP RTCP channel */";
  z[lc++]="char nsys_sip_rtcp_ip[16];";
  z[lc++]="unsigned long nsys_sip_rtcp_inet_addr;";
  z[lc++]="unsigned short nsys_sip_rtcp_port;";
  z[lc++]="unsigned short nsys_sip_rtcp_sin_port;";
  z[lc++]="";
  z[lc++]="int nsys_graceful_exit;                 /* requests termination      */";
  z[lc++]="";
  z[lc++]="unsigned char nsys_rtp_info[NSYS_UDPMAXSIZE+1];  /* SIP INFO packets */";
  z[lc++]="unsigned char nsys_rtcp_info[NSYS_UDPMAXSIZE+1];";
  z[lc++]="";
  z[lc++]="int nsys_behind_nat;                      /* 1 if behind a nat        */";
  z[lc++]="int nsys_sipinfo_count;                   /* INFO sending timer       */";
  z[lc++]="int nsys_sipinfo_toggle;                  /* RTP/RTCP toggle          */";
  z[lc++]="";
  z[lc++]="/***************/";
  z[lc++]="/* SSRC stack  */";
  z[lc++]="/***************/";
  z[lc++]="";
  z[lc++]="struct source * nsys_srcfree = NULL;       /* mset ssrc tokens */";
  z[lc++]="struct source * nsys_ssrc[NSYS_HASHSIZE];  /* SSRC hash table  */";
  z[lc++]="struct source * nsys_srcroot = NULL;       /* points into nsys_ssrc */";
  z[lc++]="";
  z[lc++]="/* end Network library -- global variables */";
  printlib(lc);
}


void makenet_siplib(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- SIP functions";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 high-level SIP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]=" ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        initialize SIP address and INVITE packet              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_initsip(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* create SIP addresses */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if ((nsys_netin_sipaddr(nsys_rtp_fd, NSYS_SIP_IP,";
  z[lc++]="			  NSYS_SIP_RTP_PORT) != NSYS_DONE) ||";
  z[lc++]="      (nsys_netin_sipaddr(nsys_rtcp_fd, NSYS_SIP_IP,";
  z[lc++]="			  NSYS_SIP_RTCP_PORT) != NSYS_DONE))";
  z[lc++]="    return NSYS_ERROR;";
  z[lc++]="";
  z[lc++]="  nsys_rtp_cseq = nsys_rtcp_cseq = 1;";
  z[lc++]="";
  z[lc++]="  /***********************************/";
  z[lc++]="  /* create SIP packets and send off */";
  z[lc++]="  /***********************************/";
  z[lc++]="  ";
  z[lc++]="  nsys_createsip(nsys_rtp_fd, \"INVITE\", nsys_rtp_invite, NULL, NULL); ";
  z[lc++]="  nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_invite);";
  z[lc++]="";
  z[lc++]="  nsys_createsip(nsys_rtcp_fd, \"INVITE\", nsys_rtcp_invite, NULL, NULL);";
  z[lc++]="  nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_invite);";
  z[lc++]="";
  z[lc++]="  nsys_rtp_sipretry = nsys_rtcp_sipretry = 1;";
  z[lc++]="";
  z[lc++]="  nsys_behind_nat = 0;";
  z[lc++]="";
  z[lc++]="  nsys_createsip(nsys_rtp_fd,  \"INFO\", nsys_rtp_info,  NULL, NULL); ";
  z[lc++]="  nsys_createsip(nsys_rtcp_fd, \"INFO\", nsys_rtcp_info, NULL, NULL); ";
  z[lc++]="";
  z[lc++]="  return NSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 handle a SIP reply packet                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_reply(int fd, struct sockaddr_in * addr, ";
  z[lc++]="		      unsigned char * packet, unsigned short status)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char ack[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  char natline[NSYS_SDPNATSIZE];";
  z[lc++]="  char nonce[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned long callid, cseq;";
  z[lc++]="  char * invite;";
  z[lc++]="";
  z[lc++]="  /***********************/";
  z[lc++]="  /* SIP validity checks */";
  z[lc++]="  /***********************/";
  z[lc++]="";
  z[lc++]="  if (nsys_netin_siporigin(fd, addr) == NSYS_ERROR)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  if (nsys_netin_replyparse(fd, packet, nonce, natline, &callid, &cseq)";
  z[lc++]="      == NSYS_ERROR)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /*************************************/";
  z[lc++]="  /* ignore informational status codes */";
  z[lc++]="  /*************************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 100) && (status < 200))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /***************************/";
  z[lc++]="  /* all others receive acks */";
  z[lc++]="  /***************************/";
  z[lc++]="";
  z[lc++]="  nsys_netin_ack(fd, ack, callid, cseq);";
  z[lc++]="  nsys_sendsip(fd, addr, ack);";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* take no action if unexpected */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  if ((fd == nsys_rtp_fd) && ((nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP) == 0))";
  z[lc++]="    return;";
  z[lc++]="      ";
  z[lc++]="  if ((fd == nsys_rtcp_fd) && ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP) == 0))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* 200 OK --> clear flag */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 200) && (status < 300))";
  z[lc++]="    {  ";
  z[lc++]="      if (fd == nsys_rtp_fd)";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTPNEXT);";
  z[lc++]="	  nsys_rtp_authretry = 0;";
  z[lc++]="	  ";
  z[lc++]="	  if (nsys_rtcp_sipretry)";
  z[lc++]="	    nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			 \"SIP server contact successful, awaiting client SIP\");";
  z[lc++]="	  nsys_rtp_sipretry = 0;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTCPSIP | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="	  nsys_rtcp_authretry = 0;";
  z[lc++]="";
  z[lc++]="	  if (nsys_rtp_sipretry)";
  z[lc++]="	    nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			 \"SIP server contact successful, awaiting client SIP\");";
  z[lc++]="";
  z[lc++]="	  nsys_rtcp_sipretry = 0;";
  z[lc++]="	}";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* 401 -- resend INVITE */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if ((status == 401) && (nonce[0]))";
  z[lc++]="    {";
  z[lc++]="      if (((fd == nsys_rtp_fd) && ";
  z[lc++]="	   (nsys_rtp_authretry++ > NSYS_SIP_AUTHRETRYMAX)) || ";
  z[lc++]="	  ((fd == nsys_rtcp_fd) && ";
  z[lc++]="	   (nsys_rtcp_authretry++ > NSYS_SIP_AUTHRETRYMAX)))";
  z[lc++]="	{";
  z[lc++]="	  nsys_terminate_error(\"Initial SIP server authentication failure\");";
  z[lc++]="	  return;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (fd == nsys_rtp_fd)";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtp_cseq++;";
  z[lc++]="	  invite = nsys_rtp_invite;";
  z[lc++]="";
  z[lc++]="	  nsys_rtcp_ex |=  NSYS_RTCPEX_RTPSIP;";
  z[lc++]="	  ";
  z[lc++]="	  if (nsys_nexttime < (time(NULL) + NSYS_RTCPTIME_SKIP))";
  z[lc++]="	    nsys_rtcp_ex |= NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="";
  z[lc++]="	  nsys_createsip(nsys_rtp_fd, \"INFO\", nsys_rtp_info,  NULL, NULL); ";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_cseq++;";
  z[lc++]="	  invite = nsys_rtcp_invite;";
  z[lc++]="";
  z[lc++]="	  nsys_rtcp_ex |=  NSYS_RTCPEX_RTCPSIP;";
  z[lc++]="	  ";
  z[lc++]="	  if (nsys_nexttime < (time(NULL) + NSYS_RTCPTIME_SKIP))";
  z[lc++]="	    nsys_rtcp_ex |= NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="";
  z[lc++]="	  nsys_createsip(nsys_rtcp_fd, \"INFO\", nsys_rtcp_info, NULL, NULL); ";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      nsys_createsip(fd, \"INVITE\", invite, natline[0] ? natline : NULL,";
  z[lc++]="		     nonce[0] ? nonce : NULL);";
  z[lc++]="      nsys_sendsip(fd, NULL, invite);";
  z[lc++]="";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* 300 series --> do redirect */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 300) && (status < 400))";
  z[lc++]="    {";
  z[lc++]="      nsys_netin_redirect(fd, packet, status);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* 400 series --> buggy client */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 400) && (status < 500))";
  z[lc++]="    {";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, APPNAME \"/\" APPVERSION ";
  z[lc++]="		   \" is too out-of-date to function with SIP server\");";
  z[lc++]="";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Download new version at:\" ";
  z[lc++]="		   \" http://www.cs.berkeley.edu/~lazzaro/sa/index.html\");";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="			NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="";
  z[lc++]="      nsys_graceful_exit = 1;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* 500/600 series --> server down */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  if ((status >= 500) && (status < 700))";
  z[lc++]="    {";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"SIP server is overloaded, refusing new sessions\");";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Please try again later. Ending session\");";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="			NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="";
  z[lc++]="      nsys_graceful_exit = 1;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 handle a SIP INVITE packet                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_invite(int fd, struct sockaddr_in * addr, ";
  z[lc++]="		       unsigned char * packet)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  struct sockaddr_in ** aptr;";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  char media[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  char sname[NSYS_BASE64_LENGTH];";
  z[lc++]="  char tool[32] = \"unknown\";";
  z[lc++]="  struct payinfo * marray;";
  z[lc++]="  int mlen = 0;";
  z[lc++]="  char cname[32];";
  z[lc++]="  char dnsname[64];";
  z[lc++]="  char ip[16], nat_ip[16];";
  z[lc++]="  unsigned long ssrc, sdp_time, now;";
  z[lc++]="  unsigned short port, nat_port, ptype;";
  z[lc++]="  int state, len;";
  z[lc++]="  int has_nat, has_session, has_time, has_ssrc; ";
  z[lc++]="  int  has_dnsname, has_port, has_ip, has_map;";
  z[lc++]="";
  z[lc++]="  /*****************************************************************/";
  z[lc++]="  /* do weak and strong security checks, leave function if failure */";
  z[lc++]="  /*****************************************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_netin_siporigin(fd, addr) == NSYS_ERROR)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  if ((packet = nsys_netin_readmethod(fd, addr, packet)) == NULL)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /*************/";
  z[lc++]="  /* parse SDP */";
  z[lc++]="  /*************/";
  z[lc++]="";
  z[lc++]="  has_nat = has_session = has_time = has_ssrc = 0;";
  z[lc++]="  has_dnsname = has_port = has_ip = has_map = 0;";
  z[lc++]="  state = NSYS_NETIN_SDPSTATE;";
  z[lc++]="";
  z[lc++]="  while (state == NSYS_NETIN_SDPSTATE)";
  z[lc++]="    {";
  z[lc++]="      len = sscanf(packet, \"%1023[^\\n]\\n\", line);";
  z[lc++]="      if (len && (len != EOF))";
  z[lc++]="	{";
  z[lc++]="	  switch (line[0]) {";
  z[lc++]="	  case 'v':";
  z[lc++]="	    break;";
  z[lc++]="	  case 's':";
  z[lc++]="	    if ((sscanf(line, \"s = %24s\", sname) != 1) || ";
  z[lc++]="		(strcmp(nsys_session_base64, sname)))";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      has_session = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 't':";
  z[lc++]="	    if (sscanf(line, \"t = %lu\", &sdp_time) == 1)";
  z[lc++]="	      {";
  z[lc++]="		now = time(NULL);";
  z[lc++]="		sdp_time -= 2208988800UL;";
  z[lc++]="		has_time = 1;";
  z[lc++]="";
  z[lc++]="		if (!nsys_msession || nsys_msessionmirror)";
  z[lc++]="		  {";
  z[lc++]="		    if ((sdp_time > now) && ";
  z[lc++]="			((sdp_time - now) > NSYS_MAXLATETIME))";
  z[lc++]="		      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="		    if ((sdp_time < now) && ";
  z[lc++]="			((now-sdp_time) > NSYS_MAXSSESIONTIME))";
  z[lc++]="		      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  case 'o':";
  z[lc++]="	    if (sscanf(line, \"o = %31s %lu %*u IN IP4 %63s\", ";
  z[lc++]="		       cname, &ssrc, dnsname) != 3)";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      has_dnsname = has_ssrc = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 'm':";
  z[lc++]="	    if (sscanf(line, \"m = audio %hu RTP/AVP %[0-9 ]\", &port, media) != 2)";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		has_port = 1;";
  z[lc++]="		if ((mlen = nsys_netin_make_marray(&marray, media)) < 1)";
  z[lc++]="		  state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  case 'c':";
  z[lc++]="	    if ((sscanf(line, \"c = IN IP4 %15s\", ip) != 1) || ";
  z[lc++]="		!(strcmp(ip, \"127.0.0.1\") && ";
  z[lc++]="		  strcmp(ip, \"0.0.0.0\") &&";
  z[lc++]="		  strcmp(ip, \"255.255.255.255\")))";
  z[lc++]="	      state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="	    else";
  z[lc++]="	      has_ip = 1;";
  z[lc++]="	    break;";
  z[lc++]="	  case 'a':";
  z[lc++]="	    if (sscanf(line, \"a = nat : %15s %hu\", nat_ip, &nat_port) == 2)";
  z[lc++]="	      {";
  z[lc++]="		has_nat = strcmp(nat_ip, \"127.0.0.1\") && ";
  z[lc++]="		  strcmp(nat_ip, \"0.0.0.0\") &&";
  z[lc++]="		  strcmp(nat_ip, \"255.255.255.255\");";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	    if (sscanf(line, \"a = tool : %31[^\\n]\", tool) == 1)";
  z[lc++]="	      break;";
  z[lc++]="	    if (sscanf(line, \"a = rtpmap : %hu\", &ptype) == 1)";
  z[lc++]="	      {";
  z[lc++]="		if ((!mlen) || (!nsys_netin_set_marray(line, marray, mlen)))";
  z[lc++]="		  state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="		else";
  z[lc++]="		  has_map = 1;";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	  packet += strlen(line) + 1;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	state = NSYS_NETIN_EOFSTATE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************************************/";
  z[lc++]="  /* miscellaneous security/syntax checks */";
  z[lc++]="  /****************************************/";
  z[lc++]="";
  z[lc++]="  if (!(has_session && has_time && has_ssrc && has_dnsname";
  z[lc++]="	&& has_port && has_ip && has_map))";
  z[lc++]="    state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="";
  z[lc++]="  if ((strcmp(ip, nsys_clientip) == 0) && (strcmp(cname, nsys_username) == 0)";
  z[lc++]="      && (port == nsys_rtp_port) && (nsys_myssrc == ssrc))";
  z[lc++]="    state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="";
  z[lc++]="  if (nsys_msession && !nsys_msessionmirror && ";
  z[lc++]="      ((strcmp(nsys_sip_rtp_ip, ip) && (fd == nsys_rtp_fd)) || ";
  z[lc++]="       (strcmp(nsys_sip_rtcp_ip, ip) && (fd == nsys_rtcp_fd)) || has_nat ))";
  z[lc++]="    state = NSYS_NETIN_ERRSTATE;";
  z[lc++]="";
  z[lc++]="  if (state == NSYS_NETIN_EOFSTATE)";
  z[lc++]="    {  ";
  z[lc++]="      sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="      ";
  z[lc++]="      while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="	sptr = sptr->xtra;";
  z[lc++]="      ";
  z[lc++]="      if ((sptr == NULL) && nsys_netin_noreplay(ip, port, sdp_time) &&";
  z[lc++]="	  nsys_netin_payvalid(marray, mlen, fd) && ";
  z[lc++]="	  (sptr = nsys_netin_addsrc(fd, ssrc, ip, port)))";
  z[lc++]="	{";
  z[lc++]="	  ";
  z[lc++]="	  sptr->siptime = sdp_time;";
  z[lc++]="	  nsys_netin_payset(sptr, marray, mlen);";
  z[lc++]="	  sptr->last_hiseq_ext = netout_jsend_checkpoint_seqnum;";
  z[lc++]="";
  z[lc++]="	  if (nsys_msessionmirror)";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_SRCDUPL;";
  z[lc++]="	  ";
  z[lc++]="	  sptr->cname = calloc(strlen(cname) + strlen(dnsname) + 8,";
  z[lc++]="			       sizeof(char));";
  z[lc++]="	  sprintf(sptr->cname, \"%s@%s:%hu\", cname, dnsname, port);";
  z[lc++]="	  nsys_status(sptr, \"SIP INVITE accepted from\");";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (sptr && has_nat)";
  z[lc++]="	{";
  z[lc++]="	  if (fd == nsys_rtp_fd)";
  z[lc++]="	    aptr = &(sptr->alt_rtp_addr);";
  z[lc++]="	  else";
  z[lc++]="	    aptr = &(sptr->alt_rtcp_addr);";
  z[lc++]="	  ";
  z[lc++]="	  if (*aptr == NULL)";
  z[lc++]="	    {  ";
  z[lc++]="	      *aptr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="	      (*aptr)->sin_family = AF_INET;   ";
  z[lc++]="	    }";
  z[lc++]="	  (*aptr)->sin_port = htons(nat_port);";
  z[lc++]="	  (*aptr)->sin_addr.s_addr = inet_addr(nat_ip);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (state == NSYS_NETIN_ERRSTATE)";
  z[lc++]="    {		";
  z[lc++]="      sprintf(line, \"Discarding a SIP INVITE: probably a client/server bug\"); ";
  z[lc++]="      nsys_warning(NSYS_WARN_UNUSUAL, line);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               close down SIP server connection               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_sip_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char packet[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  fd_set set;";
  z[lc++]="  int rtp_flags, rtcp_flags;";
  z[lc++]="  struct timeval timeout, deadline;";
  z[lc++]="  int rtp_send = 1;";
  z[lc++]="  int rtcp_send = 1;";
  z[lc++]="  int waitcycles = 0;";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* create BYE packets */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  nsys_rtp_cseq++;";
  z[lc++]="  nsys_rtcp_cseq++;";
  z[lc++]="";
  z[lc++]="  nsys_createsip(nsys_rtp_fd, \"BYE\", nsys_rtp_invite, NULL, NULL);";
  z[lc++]="  nsys_createsip(nsys_rtcp_fd, \"BYE\", nsys_rtcp_invite, NULL, NULL);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* make sockets blocking */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  rtp_flags = fcntl(nsys_rtp_fd, F_GETFL);";
  z[lc++]="  rtcp_flags = fcntl(nsys_rtcp_fd, F_GETFL);";
  z[lc++]="";
  z[lc++]="  fcntl(nsys_rtp_fd,  F_SETFL, (~O_NONBLOCK) & rtp_flags );";
  z[lc++]="  fcntl(nsys_rtcp_fd, F_SETFL, (~O_NONBLOCK) & rtcp_flags);";
  z[lc++]="";
  z[lc++]="  /***********************************/";
  z[lc++]="  /* do three sends before giving up */";
  z[lc++]="  /***********************************/";
  z[lc++]="";
  z[lc++]="  while ((waitcycles++ < 3) && (rtp_send || rtcp_send))";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      if (rtp_send)";
  z[lc++]="	nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_invite);";
  z[lc++]="      if (rtcp_send)";
  z[lc++]="	nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_invite);";
  z[lc++]="";
  z[lc++]="      /* one second between resends */";
  z[lc++]="";
  z[lc++]="      gettimeofday(&deadline, NULL);";
  z[lc++]="      deadline.tv_sec++;";
  z[lc++]="      ";
  z[lc++]="      do {";
  z[lc++]="";
  z[lc++]="	FD_ZERO(&set);";
  z[lc++]="	FD_SET(nsys_rtp_fd, &set);";
  z[lc++]="	FD_SET(nsys_rtcp_fd, &set);";
  z[lc++]="";
  z[lc++]="	timeout.tv_sec = 0;";
  z[lc++]="	timeout.tv_usec = 200000;";
  z[lc++]=" ";
  z[lc++]="	select(nsys_max_fd, &set, NULL, NULL, &timeout);";
  z[lc++]="";
  z[lc++]="	if (FD_ISSET(nsys_rtp_fd, &set) &&";
  z[lc++]="	    (recv(nsys_rtp_fd, packet, NSYS_UDPMAXSIZE, 0) > 0) &&";
  z[lc++]="	    (packet[NSYS_RTPLOC_BYTE1] == 'S'))";
  z[lc++]="	  rtp_send = 0;";
  z[lc++]="";
  z[lc++]="	if (FD_ISSET(nsys_rtcp_fd, &set) &&";
  z[lc++]="	    (recv(nsys_rtcp_fd, packet, NSYS_UDPMAXSIZE, 0) > 0) &&";
  z[lc++]="	    (packet[NSYS_RTPLOC_BYTE1] == 'S'))";
  z[lc++]="	  rtcp_send = 0;";
  z[lc++]="";
  z[lc++]="	gettimeofday(&timeout, NULL);";
  z[lc++]="";
  z[lc++]="      } while ((rtcp_send | rtp_send) && ";
  z[lc++]="	       ((timeout.tv_sec < deadline.tv_sec) ||";
  z[lc++]="		((timeout.tv_sec == deadline.tv_sec) &&";
  z[lc++]="		 (timeout.tv_usec < deadline.tv_usec))));";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* restore socket status */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  fcntl(nsys_rtp_fd,  F_SETFL, rtp_flags);";
  z[lc++]="  fcntl(nsys_rtcp_fd, F_SETFL, rtcp_flags);";
  z[lc++]="";
  z[lc++]="}  ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level SIP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 create a SIP method packet                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_createsip(int fd, char * method, unsigned char * sip,";
  z[lc++]="		    char * natline, char * nonce) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char base64_digest[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char binary_digest[NSYS_MD5_LENGTH];";
  z[lc++]="  char media[4*NSYS_RTP_PAYSIZE + 1];";
  z[lc++]="  char nline[16+NSYS_BASE64_LENGTH];";
  z[lc++]="  int i, j, len, body, dpoint;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* create SIP headers */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  body = snprintf(sip, NSYS_UDPMAXSIZE+1,";
  z[lc++]="		  \"%s sip:%s@%s:%hu SIP/2.0\\n\"     /* INVITE or BYE method */";
  z[lc++]="		  \"i: %lu\\n\"                       /* Call-ID              */";
  z[lc++]="		  \"v: SIP/2.0/UDP %s:%hu\\n\"        /* Via                  */";
  z[lc++]="		  \"%s\"                             /* Content-Type         */";
  z[lc++]="		  \"f: sip:%s@%s\\n\"                 /* From                 */";
  z[lc++]="		  \"t: sip:%s@%s:%hu\\n\"             /* To                   */";
  z[lc++]="		  \"CSeq: %lu\\n\"                    /* CSeq                 */";
  z[lc++]="                  \"User-Agent: %s/%s\\n\",           /* User-Agent           */";
  z[lc++]="		  ";
  z[lc++]="		  /* SIP URL */";
  z[lc++]="		  ";
  z[lc++]="		  method, nsys_session_base64, ";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		  ";
  z[lc++]="		  /* Call-ID */";
  z[lc++]="		  ";
  z[lc++]="		  nsys_myssrc + (fd == nsys_rtcp_fd),";
  z[lc++]="		  ";
  z[lc++]="		  /* Via */";
  z[lc++]="";
  z[lc++]="		  nsys_clientip,";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_rtp_port : nsys_rtcp_port,";
  z[lc++]="		  ";
  z[lc++]="		  /* Content-Type */";
  z[lc++]="";
  z[lc++]="		  (method[2] == 'V') ? \"c: application/sdp\\n\" : \"\",";
  z[lc++]="";
  z[lc++]="		  /* From */";
  z[lc++]="";
  z[lc++]="		  nsys_username, nsys_clientname,";
  z[lc++]="		  ";
  z[lc++]="		  /* To */";
  z[lc++]="		  ";
  z[lc++]="		  nsys_session_base64, ";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		  ";
  z[lc++]="		  /* CSeq */";
  z[lc++]="";
  z[lc++]="		  (fd == nsys_rtp_fd) ? nsys_rtp_cseq : nsys_rtcp_cseq,";
  z[lc++]="";
  z[lc++]="		  /* User-Agent */";
  z[lc++]="";
  z[lc++]="		  APPNAME, APPVERSION";
  z[lc++]="";
  z[lc++]="		  );";
  z[lc++]="";
  z[lc++]="  if (body > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [1]\");";
  z[lc++]="";
  z[lc++]="  if (method[2] != 'V')               /* BYE/INFO currently have no body */";
  z[lc++]="    return; ";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* add Authorization */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  if (nonce)";
  z[lc++]="    {";
  z[lc++]="      body += snprintf(&(sip[body]), NSYS_UDPMAXSIZE+1-body,";
  z[lc++]="		       \"Authorization: SignSDP nonce=\\\"%s\\\", \"";
  z[lc++]="		       \"digest=\\\"012345678901234567890A==\\\"\\n\",";
  z[lc++]="		       nonce);";
  z[lc++]="      sprintf(nline, \"a=nonce:\\\"%s\\\"\\n\", nonce);";
  z[lc++]="      dpoint = body - 26;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    dpoint = 0;";
  z[lc++]="";
  z[lc++]="  if (body > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [2]\");";
  z[lc++]="";
  z[lc++]="  /***********/";
  z[lc++]="  /* add SDP */";
  z[lc++]="  /***********/";
  z[lc++]="";
  z[lc++]="  for (j = i = 0; i < NSYS_RTP_PAYSIZE; i++)";
  z[lc++]="    j += sprintf(&(media[j]), \"%hhu \", nsys_payload_types[i].ptype);";
  z[lc++]="";
  z[lc++]="  len = body + snprintf(&(sip[body]), NSYS_UDPMAXSIZE+1-body,";
  z[lc++]="		 \"\\n\"";
  z[lc++]="		 \"v=0\\n\"";
  z[lc++]="		 \"o=%s %lu 0 IN IP4 %s\\n\"          /* CNAME, SSRC, IP    */";
  z[lc++]="		 \"s=%s\\n\"                          /* sessionname        */";
  z[lc++]="		 \"a=tool:%s %s\\n\"                  /* SDP creator        */";
  z[lc++]="		 \"t=%lu 0\\n\"                       /* current time       */";
  z[lc++]="		 \"m=audio %i RTP/AVP %s\\n\"         /* media              */";
  z[lc++]="		 \"c=IN IP4 %s\\n\"                   /* ipnumber           */";
  z[lc++]="		 \"%s\"                              /* nonce, if needed   */";
  z[lc++]=" 		 \"%s\",                             /* nat, if needed     */";
  z[lc++]="";
  z[lc++]="		 /* SDP originator (o=) */";
  z[lc++]="";
  z[lc++]="		 nsys_username, nsys_myssrc, nsys_clientname,";
  z[lc++]="";
  z[lc++]="		 /* SDP session (s=) */";
  z[lc++]="";
  z[lc++]="		 nsys_session_base64,";
  z[lc++]="";
  z[lc++]="		 /* SDP tool (a=tool) */";
  z[lc++]="";
  z[lc++]="		 APPNAME, APPVERSION,";
  z[lc++]="";
  z[lc++]=" 		 /* NTP time */";
  z[lc++]="";
  z[lc++]="		 ((unsigned long) time(NULL)) + NSYS_SIP_UNIXTONTP,";
  z[lc++]="";
  z[lc++]="		 /* SDP media (m=) */";
  z[lc++]="";
  z[lc++]="		 nsys_rtp_port, media,";
  z[lc++]="";
  z[lc++]="		 /* SDP connection (c=) */";
  z[lc++]="";
  z[lc++]="		 nsys_clientip,";
  z[lc++]="			";
  z[lc++]="		 /* nonce line */";
  z[lc++]="";
  z[lc++]="		 nonce ? nline : \"\",";
  z[lc++]="";
  z[lc++]="		 /* nat line */";
  z[lc++]="";
  z[lc++]="		 natline ? natline : \"\"";
  z[lc++]="";
  z[lc++]="		 );";
  z[lc++]="";
  z[lc++]="  if (len > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [3]\");";
  z[lc++]="";
  z[lc++]="  /*******************/";
  z[lc++]="  /* append RTP maps */";
  z[lc++]="  /*******************/";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_RTP_PAYSIZE; i++)";
  z[lc++]="    {";
  z[lc++]="      len += snprintf(&(sip[len]), NSYS_UDPMAXSIZE+1 - len, ";
  z[lc++]="		      \"a=rtpmap:%hhu %s/%i\\n\", ";
  z[lc++]="		      nsys_payload_types[i].ptype, ";
  z[lc++]="		      nsys_payload_types[i].name, ";
  z[lc++]="		      nsys_payload_types[i].srate);";
  z[lc++]="";
  z[lc++]="      if ((len > NSYS_UDPMAXSIZE))";
  z[lc++]="	NSYS_ERROR_TERMINATE(\"SIP INVITE packet creation error [4]\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* compute digest, place in SIP header */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  if (nonce)";
  z[lc++]="    {    ";
  z[lc++]="      nsys_hmac_md5(&(sip[body + 1]), len - body - 1, ";
  z[lc++]="		    nsys_keydigest, binary_digest);";
  z[lc++]="      nsys_digest_base64(base64_digest, binary_digest);";
  z[lc++]="      for (i = 0; i < NSYS_BASE64_LENGTH - 1; i++)";
  z[lc++]="	sip[dpoint + i] = base64_digest[i];";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             reads an INVITE, generates an OK                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_netin_readmethod(int fd, struct sockaddr_in * addr, ";
  z[lc++]="				      unsigned char * packet) ";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  unsigned char local_base64[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char reply[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned char nonce[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char digest[NSYS_BASE64_LENGTH];";
  z[lc++]="  unsigned char local_binary[NSYS_MD5_LENGTH];";
  z[lc++]="  unsigned char text[14];";
  z[lc++]="  unsigned char * ret;";
  z[lc++]="  int found_invite, found_callid, found_reply, found_auth;";
  z[lc++]="  int num, len, first, overflow;";
  z[lc++]="  unsigned long callid, inreplyto;";
  z[lc++]="";
  z[lc++]="  first = 1;";
  z[lc++]="  overflow = len = found_invite = found_callid = found_reply = found_auth = 0;";
  z[lc++]="  nonce[0] = digest[0] = '\\0';";
  z[lc++]="";
  z[lc++]="  /***********************************************************/";
  z[lc++]="  /* extract Call-ID, In-Reply-To, Nonce and Digest from SIP */";
  z[lc++]="  /***********************************************************/";
  z[lc++]="";
  z[lc++]="  while ((num = sscanf(packet, \"%[^\\n]\\n\", line)) && (num != EOF))";
  z[lc++]="    {";
  z[lc++]="      if (first)";
  z[lc++]="	{";
  z[lc++]="	  first = 0;";
  z[lc++]="	  found_invite = (line == ((unsigned char *) strstr(line,\"INVITE\")));";
  z[lc++]="";
  z[lc++]="	  if ((len += strlen(\"SIP/2.0 200\\n\")) < NSYS_UDPMAXSIZE+1)";
  z[lc++]="	    strcpy(reply, \"SIP/2.0 200\\n\");";
  z[lc++]="	  else";
  z[lc++]="	    overflow = 1;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if ((len += strlen(line) + 1) < NSYS_UDPMAXSIZE+1)";
  z[lc++]="	    {";
  z[lc++]="	      strcat(reply, line);";
  z[lc++]="	      strcat(reply, \"\\n\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    overflow = 1;";
  z[lc++]="";
  z[lc++]="	  if ((line[0] == 'i') || (line[0] == 'C'))";
  z[lc++]="	    found_callid |= ((sscanf(line, \"i : %lu\", &callid) == 1) || ";
  z[lc++]="			     (sscanf(line, \"Call-ID : %lu\", &callid) == 1));";
  z[lc++]="	  if (line[0] == 'I')";
  z[lc++]="	    found_reply |= (sscanf(line, \"In-Reply-To : %lu\",&inreplyto) == 1);";
  z[lc++]="";
  z[lc++]="	  if (line[0] == 'A')";
  z[lc++]="	    found_auth |= ((sscanf(line, \"Authorization : SignSDP \" ";
  z[lc++]="				   \"nonce = \\\"%24[^\\\"]\\\" , \"";
  z[lc++]="				   \"digest = \\\"%24[^\\\"]\\\" , \",";
  z[lc++]="				   nonce, digest) == 2) || ";
  z[lc++]="			   (sscanf(line, \"Authorization : SignSDP \" ";
  z[lc++]="				   \"digest = \\\"%24[^\\\"]\\\" , \"";
  z[lc++]="				   \"nonce = \\\"%24[^\\\"]\\\" , \",";
  z[lc++]="				   digest, nonce) == 2));";
  z[lc++]="	}";
  z[lc++]="      packet += strlen(line) + 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ret = (num != EOF) ? packet + 1 : NULL;";
  z[lc++]="";
  z[lc++]="  if (found_invite && found_callid && found_reply && ";
  z[lc++]="      (inreplyto == (nsys_myssrc + (fd == nsys_rtcp_fd))))";
  z[lc++]="    {";
  z[lc++]="      memcpy(&(text[0]), &callid, 4);";
  z[lc++]="      memcpy(&(text[4]), &inreplyto, 4);";
  z[lc++]="      memcpy(&(text[8]), &(addr->sin_addr), 4);";
  z[lc++]="      memcpy(&(text[12]), &(addr->sin_port), 2);";
  z[lc++]="";
  z[lc++]="      nsys_hmac_md5(text, 14, nsys_keydigest, local_binary);";
  z[lc++]="      nsys_digest_base64(local_base64, local_binary);";
  z[lc++]="";
  z[lc++]="      if ((!found_auth) || strcmp(local_base64, nonce))";
  z[lc++]="	{";
  z[lc++]="	  sprintf(line, \"WWW-Authenticate: SignSDP nonce =\\\"%s\\\"\\n\",";
  z[lc++]="		  local_base64);";
  z[lc++]="";
  z[lc++]="	  if ((len += strlen(line)) < NSYS_UDPMAXSIZE+1)";
  z[lc++]="	    strcat(reply, line);";
  z[lc++]="	  else";
  z[lc++]="	    overflow = 1;";
  z[lc++]="";
  z[lc++]="	  reply[8] = '4'; reply[10] = '1';  /* 200 -> 401 */";
  z[lc++]="	  ret = NULL;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    ret = NULL;";
  z[lc++]="";
  z[lc++]="  if (ret && (nsys_msession == 0))";
  z[lc++]="    {";
  z[lc++]="      nsys_hmac_md5(ret, strlen(ret), nsys_keydigest, local_binary);";
  z[lc++]="      nsys_digest_base64(local_base64, local_binary);";
  z[lc++]="      if (strcmp(digest, local_base64))";
  z[lc++]="	ret = NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_sendsip(fd, NULL, reply);";
  z[lc++]="";
  z[lc++]="  if (!ret && found_auth)";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="		 \"Discarding a SIP INVITE: probably a client/server bug\");";
  z[lc++]="";
  z[lc++]="  if (overflow)";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="		 \"Send a truncated 200 or 401: probably a client/server bug\");";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           reads a final response, generate an ACK            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_ack(int fd, unsigned char * reply, ";
  z[lc++]="		    unsigned long callid, unsigned long cseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int len;";
  z[lc++]="";
  z[lc++]="  /****************************/";
  z[lc++]="  /* create top of ACK header */";
  z[lc++]="  /****************************/";
  z[lc++]="";
  z[lc++]="  len = snprintf(reply, NSYS_UDPMAXSIZE+1, ";
  z[lc++]="	  ";
  z[lc++]="		 \"ACK sip:%s@%s:%hu SIP/2.0\\n\"";
  z[lc++]="		 \"v: SIP/2.0/UDP %s:%hu\\n\"        /* Via                  */";
  z[lc++]="		 \"f: sip:%s@%s\\n\"                 /* From                 */";
  z[lc++]="		 \"t: sip:%s@%s:%hu\\n\"             /* To                   */";
  z[lc++]="		 \"i: %lu\\n\"                       /* Call-ID              */	";
  z[lc++]="		 \"CSeq: %lu\\n\" 	                  /* CSeq                 */";
  z[lc++]="		 \"User-Agent: %s/%s\\n\",           /* User-Agent           */";
  z[lc++]="";
  z[lc++]="		 /* method line */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_session_base64, ";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		 ";
  z[lc++]="		 /* Via */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_clientip,";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_rtp_port : nsys_rtcp_port,";
  z[lc++]="		 ";
  z[lc++]="		 /* From */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_username, nsys_clientname,";
  z[lc++]="		 ";
  z[lc++]="		 /* To */";
  z[lc++]="		 ";
  z[lc++]="		 nsys_session_base64, ";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_ip : nsys_sip_rtcp_ip,";
  z[lc++]="		 (fd == nsys_rtp_fd) ? nsys_sip_rtp_port : nsys_sip_rtcp_port,";
  z[lc++]="		 ";
  z[lc++]="		 /* Call-ID, CSeq */";
  z[lc++]="		 ";
  z[lc++]="		 callid, cseq,";
  z[lc++]="";
  z[lc++]="		 /* User-Agent */";
  z[lc++]="		 ";
  z[lc++]="		 APPNAME, APPVERSION";
  z[lc++]="";
  z[lc++]="		 );";
  z[lc++]="";
  z[lc++]="  if (len > NSYS_UDPMAXSIZE)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"SIP REPLY packet creation error [1]\");";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      read a SIP/2.0 reply packet, parse useful fields        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_replyparse(int fd, unsigned char * packet, ";
  z[lc++]="			  char * nonce, char * natline, ";
  z[lc++]="			  unsigned long * callid, unsigned long * cseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  unsigned short nat_port;";
  z[lc++]="  unsigned char nat_ip[16];";
  z[lc++]="  int found_callid = 0;";
  z[lc++]="  int found_cseq = 0;";
  z[lc++]="  int found_auth = 0;";
  z[lc++]="";
  z[lc++]="  natline[0] = '\\0';";
  z[lc++]="  nonce[0] = '\\0';";
  z[lc++]="";
  z[lc++]="  while (sscanf(packet,\"%[^\\n]\\n\",line) == 1)";
  z[lc++]="    {";
  z[lc++]="      packet += strlen(line) + 1;";
  z[lc++]="";
  z[lc++]="      if ((sscanf(line, \"i : %lu\", callid) == 1) || ";
  z[lc++]="	  (sscanf(line, \"Call-ID : %lu\", callid) == 1))";
  z[lc++]="	{";
  z[lc++]="	  if (found_callid || (*callid != (nsys_myssrc + (fd == nsys_rtcp_fd))))";
  z[lc++]="	    return NSYS_ERROR;";
  z[lc++]="	  found_callid = 1;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if ((sscanf(line, \"CSeq : %lu\", cseq) == 1))";
  z[lc++]="	{";
  z[lc++]="	  if (found_cseq)";
  z[lc++]="	    return NSYS_ERROR;";
  z[lc++]="	  found_cseq = 1;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="     if (sscanf(line, ";
  z[lc++]="		\"WWW-Authenticate : SignSDP nonce = \\\"%24[^\\\"]\\\"\",";
  z[lc++]="		nonce) == 1)";
  z[lc++]="       {";
  z[lc++]="	 if (found_auth || !nsys_digest_syntaxcheck(nonce))";
  z[lc++]="	   nonce[0] = '\\0';";
  z[lc++]="	 else";
  z[lc++]="	   found_auth = 1;";
  z[lc++]="       }";
  z[lc++]="     ";
  z[lc++]="     if ((sscanf(line, \"v : %*[^;]; received = %15[0-9.] ; rport = %hu \",";
  z[lc++]="		nat_ip, &nat_port) == 2) || ";
  z[lc++]="	 (sscanf(line, \"Via : %*[^;]; received = %15[0-9.] ; rport = %hu \",";
  z[lc++]="		 nat_ip, &nat_port) == 2))";
  z[lc++]="       {";
  z[lc++]="	 sprintf(natline, \"a=nat:%s %hu\\n\", nat_ip, nat_port);";
  z[lc++]="	 nsys_behind_nat = 1;";
  z[lc++]="       }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ((found_callid && found_cseq) ? NSYS_DONE : NSYS_ERROR);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      read a SIP/2.0 300-series packet, do redirection        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_redirect(int fd, unsigned char * packet, ";
  z[lc++]="			 unsigned short status) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="  int found = 0;";
  z[lc++]="  char ip[16];";
  z[lc++]="  unsigned short port;";
  z[lc++]="  char * invite;";
  z[lc++]="";
  z[lc++]="  /* find first contact address, extract IP and port */";
  z[lc++]="";
  z[lc++]="  while (sscanf(packet,\"%[^\\n]\\n\",line) == 1)";
  z[lc++]="    {";
  z[lc++]="      packet += strlen(line) + 1;";
  z[lc++]="      if ((found = (sscanf(line,\"m:%*[^@]@%15[^:]:%hu\", ip, &port) == 2)))";
  z[lc++]="	break;";
  z[lc++]="      if ((found = (sscanf(line,";
  z[lc++]="			   \"Contact:%*[^@]@%15[^:]:%hu\", ip, &port) == 2)))";
  z[lc++]="	break;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* handle incomplete redirect packets */";
  z[lc++]="";
  z[lc++]="  if ((!found) || (nsys_netin_sipaddr(fd, ip, port) != NSYS_DONE))";
  z[lc++]="    {      ";
  z[lc++]="      nsys_terminate_error(\"SIP redirection to an unavailable/unknown server\");";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="			NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* send INVITE to new server */";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Redirecting %s INVITE to %s:%hu, please stand by ...\\n\",";
  z[lc++]="	    fd == nsys_rtp_fd ? \"RTP\" : \"RTCP\", ip, port);";
  z[lc++]="  fflush(stderr);";
  z[lc++]="";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      invite = nsys_rtp_invite;";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="      nsys_rtcp_ex |=  NSYS_RTCPEX_RTPSIP;";
  z[lc++]="      nsys_rtp_authretry = 0;";
  z[lc++]="      nsys_createsip(nsys_rtp_fd,  \"INFO\", nsys_rtp_info,  NULL, NULL); ";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      invite = nsys_rtcp_invite;";
  z[lc++]="";
  z[lc++]="      nsys_rtcp_ex &= ~NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="      nsys_rtcp_ex |=  NSYS_RTCPEX_RTCPSIP;";
  z[lc++]="      nsys_rtcp_authretry = 0;";
  z[lc++]="      nsys_createsip(nsys_rtcp_fd, \"INFO\", nsys_rtcp_info, NULL, NULL); ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_createsip(fd, \"INVITE\", invite, NULL, NULL);";
  z[lc++]="  nsys_sendsip(fd, NULL, invite);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                   utility SIP functions                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             send a formatted SIP packet                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_sendsip(int fd, struct sockaddr_in * addr, unsigned char * sip) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int retry = 0;";
  z[lc++]="";
  z[lc++]="  if (addr == NULL)";
  z[lc++]="    addr = (fd == nsys_rtp_fd) ? &nsys_sip_rtp_addr : &nsys_sip_rtcp_addr;";
  z[lc++]="";
  z[lc++]="  while (sendto(fd, sip, strlen(sip) + 1, 0, (struct sockaddr *) addr,";
  z[lc++]="		sizeof(struct sockaddr)) == -1)";
  z[lc++]="    {";
  z[lc++]="      if (errno == EAGAIN)";
  z[lc++]="	continue;";
  z[lc++]="      ";
  z[lc++]="      if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	{";
  z[lc++]="	  if (++retry > NSYS_MAXRETRY)";
  z[lc++]="	    NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_sendsip\");";
  z[lc++]="	  continue;         ";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   sets a SIP address                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_sipaddr(int fd, char * ip, unsigned short port)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct sockaddr_in * addr;";
  z[lc++]="";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      addr = &nsys_sip_rtp_addr;";
  z[lc++]="      strcpy(nsys_sip_rtp_ip, ip);";
  z[lc++]="      nsys_sip_rtp_inet_addr = inet_addr(ip);";
  z[lc++]="      nsys_sip_rtp_port = port;";
  z[lc++]="      nsys_sip_rtp_sin_port = htons(port);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      addr = &nsys_sip_rtcp_addr;";
  z[lc++]="      strcpy(nsys_sip_rtcp_ip, ip);";
  z[lc++]="      nsys_sip_rtcp_inet_addr = inet_addr(ip);";
  z[lc++]="      nsys_sip_rtcp_port = port;";
  z[lc++]="      nsys_sip_rtcp_sin_port = htons(port);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  memset(&(addr->sin_zero), 0, 8);    ";
  z[lc++]="  addr->sin_family = AF_INET;   ";
  z[lc++]="  addr->sin_port = htons(port);";
  z[lc++]="  if ((addr->sin_addr.s_addr = inet_addr(ip)) == -1)";
  z[lc++]="    NSYS_ERROR_RETURN(\"Bad format for SIP address\");";
  z[lc++]="  ";
  z[lc++]="  return NSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              checks origin of incoming SIP                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_siporigin(int fd, struct sockaddr_in * addr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret = NSYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      if ((addr->sin_addr.s_addr == nsys_sip_rtp_inet_addr) && ";
  z[lc++]="	  (addr->sin_port == nsys_sip_rtp_sin_port))";
  z[lc++]="	ret = NSYS_DONE;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if ((addr->sin_addr.s_addr == nsys_sip_rtcp_inet_addr) && ";
  z[lc++]="	  (addr->sin_port == nsys_sip_rtcp_sin_port))";
  z[lc++]="	return ret = NSYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ret == NSYS_ERROR)";
  z[lc++]="    {";
  z[lc++]="      nsys_stderr_size += ";
  z[lc++]="	fprintf(stderr, \"Network advisory: SIP from unknown source %s:%hu\"";
  z[lc++]="		\" rejected\\n\", inet_ntoa(addr->sin_addr), ";
  z[lc++]="		ntohs(addr->sin_port));";
  z[lc++]="      fflush(stderr);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              makes an array of media payloads                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_make_marray(struct payinfo ** marray, char * media)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int size, i, len;";
  z[lc++]="  char * eptr, * cptr;";
  z[lc++]="";
  z[lc++]="  i = size = 0;";
  z[lc++]="  len = strlen(media);";
  z[lc++]="";
  z[lc++]="  while (i < len)";
  z[lc++]="    {";
  z[lc++]="      while ((i < len) && (media[i] == ' '))";
  z[lc++]="	i++;";
  z[lc++]="      size += (i < len);";
  z[lc++]="      while ((i < len) && (media[i] != ' '))";
  z[lc++]="	i++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!size)";
  z[lc++]="    return size;";
  z[lc++]="";
  z[lc++]=" *marray = calloc(size, sizeof(struct payinfo));";
  z[lc++]=" cptr = media;";
  z[lc++]="";
  z[lc++]=" for (i = 0; i < size; i++)";
  z[lc++]="   {";
  z[lc++]="     (*marray)[i].pindex = i;";
  z[lc++]="     (*marray)[i].ptype = (unsigned char)strtoul(cptr, &eptr, 10);";
  z[lc++]="     cptr = eptr;";
  z[lc++]="   }";
  z[lc++]="";
  z[lc++]=" return size;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 sets a media payloads                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_set_marray(char * line, struct payinfo marray[], int mlen)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short ptype;  /* sscanf needs a short, not a char */";
  z[lc++]="  char name[16];";
  z[lc++]="  int srate; ";
  z[lc++]="  int i, num;";
  z[lc++]="";
  z[lc++]="  num = sscanf(line, \"a=rtpmap:%hu %15[^/]/%i\", &ptype, name, &srate);";
  z[lc++]="";
  z[lc++]="  if ((num != 2) && (num != 3))";
  z[lc++]="    return 0;";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < mlen)";
  z[lc++]="    {";
  z[lc++]="      if (marray[i].ptype == (unsigned char)ptype)";
  z[lc++]="	break;";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (i == mlen)";
  z[lc++]="    return 0;";
  z[lc++]="";
  z[lc++]="  strcpy(marray[i].name, name);";
  z[lc++]="";
  z[lc++]="  if (num == 3)";
  z[lc++]="    marray[i].srate = srate;";
  z[lc++]="  else";
  z[lc++]="    marray[i].srate = -1;";
  z[lc++]="";
  z[lc++]="  return 1;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             checks validity of payload ptype                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_payvalid(struct payinfo marray[], int mlen, int fd) ";
  z[lc++]="			 ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="  char line[NSYS_UDPMAXSIZE+1];";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < mlen; i++)";
  z[lc++]="    for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="      if (!strcmp(marray[i].name, nsys_payload_types[j].name))";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_msession || (marray[i].srate == -1) || ";
  z[lc++]="	      (marray[i].srate == nsys_payload_types[j].srate))";
  z[lc++]="	    return 1;";
  z[lc++]="";
  z[lc++]="	  if (fd == nsys_rtp_fd)";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			   \"Rejecting an INVITE due to SAOL srate mismatch\");";
  z[lc++]="";
  z[lc++]="	      sprintf(line, \"(local srate %iHz, remote srate %iHz)\", ";
  z[lc++]="		      nsys_payload_types[j].srate, marray[i].srate);";
  z[lc++]="";
  z[lc++]="	      nsys_warning(NSYS_WARN_STANDARD, line);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  return 0;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="  if (fd == nsys_rtp_fd)";
  z[lc++]="    {";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Rejecting an INVITE, no common RTP payloads\");";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"(probably caused by local or remote out-of-date software)\");";
  z[lc++]="      nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		   \"Download new version at:\" ";
  z[lc++]="		   \" http://www.cs.berkeley.edu/~lazzaro/sa/index.html\");";
  z[lc++]="    }";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             sets payload information in source               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_payset(struct source * sptr, struct payinfo marray[],";
  z[lc++]="		       int mlen) ";
  z[lc++]="			 ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < mlen; i++)";
  z[lc++]="    for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="      if (!strcmp(marray[i].name, nsys_payload_types[j].name))";
  z[lc++]="	{";
  z[lc++]="	  sptr->ptype = marray[i].ptype;";
  z[lc++]="	  sptr->pindex = nsys_payload_types[j].pindex;";
  z[lc++]="	  if ((sptr->srate = marray[i].srate) < 0)";
  z[lc++]="	    sptr->srate = nsys_payload_types[j].srate;";
  z[lc++]="	  return;";
  z[lc++]="	}";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             checks for a SIP replay attack                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_noreplay(char * ip, unsigned short port, unsigned long sdp_time)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct source * sptr = nsys_srcroot;";
  z[lc++]="  struct sockaddr_in ipaddr;";
  z[lc++]="  int ret = 1;";
  z[lc++]="";
  z[lc++]="  if (sptr)";
  z[lc++]="    {";
  z[lc++]="      memset(&ipaddr, 0, sizeof(struct sockaddr_in));";
  z[lc++]="      ipaddr.sin_port = htons(port);";
  z[lc++]="      ipaddr.sin_family = AF_INET;  ";
  z[lc++]="      ipaddr.sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="";
  z[lc++]="      do {";
  z[lc++]="	if ((!memcmp(&ipaddr, sptr->sdp_addr, sizeof(struct sockaddr_in))) &&";
  z[lc++]="	    (sptr->siptime > sdp_time))";
  z[lc++]="	  ret = 0;";
  z[lc++]="      } while ((sptr = sptr->next) != nsys_srcroot);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end Network library -- SIP functions */";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makenet_rtplib(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- RTP functions";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 high-level RTP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]=" ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  sets up networking                          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_setup(int block) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct hostent * myinfo;";
  z[lc++]="  struct source * newsrc;";
  z[lc++]="  struct netout_jrecv_state * newrecv;";
  z[lc++]="  struct sockaddr_in iclient_addr; ";
  z[lc++]="  struct timeval tv;";
  z[lc++]="  unsigned char session_digest[NSYS_MD5_LENGTH];";
  z[lc++]="  int one = 1;";
  z[lc++]="  int i, rfd, bad_netconfig;";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* create RTP and RTCP sockets */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtp_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) ";
  z[lc++]="    NSYS_ERROR_RETURN(\"Couldn't create Internet RTP socket\");";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) ";
  z[lc++]="    NSYS_ERROR_RETURN(\"Couldn't create Internet RTCP socket\");";
  z[lc++]="";
  z[lc++]="  if (nsys_rtp_fd > nsys_rtcp_fd)";
  z[lc++]="    nsys_max_fd = nsys_rtp_fd + 1;";
  z[lc++]="  else";
  z[lc++]="    nsys_max_fd = nsys_rtcp_fd + 1;";
  z[lc++]="";
  z[lc++]="  /***************************/";
  z[lc++]="  /* find open ports for RTP */";
  z[lc++]="  /***************************/";
  z[lc++]="";
  z[lc++]="  memset(&(iclient_addr.sin_zero), 0, 8);    ";
  z[lc++]="  iclient_addr.sin_family = AF_INET;   ";
  z[lc++]="  iclient_addr.sin_addr.s_addr = htonl(INADDR_ANY);";
  z[lc++]="";
  z[lc++]="  nsys_rtp_port = NSYS_RTP_PORT - 2;";
  z[lc++]="";
  z[lc++]="  while ((nsys_rtp_port += 2) < NSYS_RTP_MAXPORT)";
  z[lc++]="    {";
  z[lc++]="      iclient_addr.sin_port = htons(nsys_rtp_port);";
  z[lc++]="      if (bind(nsys_rtp_fd, (struct sockaddr *)&iclient_addr,";
  z[lc++]="	       sizeof(struct sockaddr)) < 0)";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EADDRINUSE) || (errno == EADDRNOTAVAIL))";
  z[lc++]="	    continue;";
  z[lc++]="	  else";
  z[lc++]="	    NSYS_ERROR_RETURN(\"Couldn't bind Internet RTP socket\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_rtcp_port = nsys_rtp_port + 1;";
  z[lc++]="	  iclient_addr.sin_port = htons(nsys_rtcp_port);";
  z[lc++]="	  if (bind(nsys_rtcp_fd, (struct sockaddr *)&iclient_addr,";
  z[lc++]="		   sizeof(struct sockaddr)) < 0)";
  z[lc++]="	    {";
  z[lc++]="	      if ((errno == EADDRINUSE) || (errno == EADDRNOTAVAIL))";
  z[lc++]="		continue;";
  z[lc++]="	      else";
  z[lc++]="		NSYS_ERROR_RETURN(\"Couldn't bind Internet RTCP socket\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    break;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (nsys_rtp_port >= NSYS_RTP_MAXPORT)";
  z[lc++]="    NSYS_ERROR_RETURN(\"Couldn't find open ports for RTP/RTCP sockets\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /************************************************************/";
  z[lc++]="  /* set non-blocking status & shield ICMP ECONNREFUSED errno */";
  z[lc++]="  /************************************************************/";
  z[lc++]="";
  z[lc++]="  if (block == NSYS_NONBLOCK)";
  z[lc++]="    {";
  z[lc++]="      fcntl(nsys_rtp_fd, F_SETFL, O_NONBLOCK);";
  z[lc++]="      fcntl(nsys_rtcp_fd, F_SETFL, O_NONBLOCK);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  setsockopt(nsys_rtp_fd, SOL_SOCKET, SO_BSDCOMPAT, &one, sizeof(one));";
  z[lc++]="  setsockopt(nsys_rtcp_fd, SOL_SOCKET, SO_BSDCOMPAT, &one, sizeof(one));";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* pick SSRC, set CNAME */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  gettimeofday(&tv, 0);";
  z[lc++]="";
  z[lc++]="  srand((unsigned int)(((tv.tv_sec << NSYS_SECSHIFT) & NSYS_SECMASK)";
  z[lc++]="		       |(NSYS_USECMASK & tv.tv_usec)));";
  z[lc++]="";
  z[lc++]="  rfd = open(\"/dev/urandom\", O_RDONLY | O_NONBLOCK);";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0) || (read(rfd, &nsys_myssrc, sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_myssrc = (unsigned long)rand();";
  z[lc++]="";
  z[lc++]="  nsys_myssrc_net = htonl(nsys_myssrc);";
  z[lc++]="";
  z[lc++]="  bad_netconfig = 0;";
  z[lc++]="";
  z[lc++]="  if (gethostname(nsys_clientname, NSYS_HOSTNAMESIZE) < 0)";
  z[lc++]="    {";
  z[lc++]="      bad_netconfig = 1;";
  z[lc++]="      strcpy(nsys_clientname, \"not_known\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!bad_netconfig && (myinfo = gethostbyname(nsys_clientname)))";
  z[lc++]="    {";
  z[lc++]="      strcpy(nsys_clientip, inet_ntoa(*((struct in_addr *)myinfo->h_addr)));";
  z[lc++]="      bad_netconfig |= !strcmp(nsys_clientip, \"127.0.0.1\");";
  z[lc++]="      bad_netconfig |= !strcmp(nsys_clientip, \"0.0.0.0\");";
  z[lc++]="      bad_netconfig |= !strcmp(nsys_clientip, \"255.255.255.255\");";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    bad_netconfig = 1;";
  z[lc++]="";
  z[lc++]="  if (bad_netconfig)";
  z[lc++]="    {";
  z[lc++]="      if (nsys_find_clientip(nsys_clientip) == NULL)";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP number unknown.\");";
  z[lc++]="";
  z[lc++]="      if (!strcmp(nsys_clientip, \"127.0.0.1\"))";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP misconfiguration (loopback address).\");";
  z[lc++]="";
  z[lc++]="      if (!strcmp(nsys_clientip, \"0.0.0.0\"))";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP misconfiguration (0.0.0.0).\");";
  z[lc++]="";
  z[lc++]="      if (!strcmp(nsys_clientip, \"255.255.255.255\"))";
  z[lc++]="	NSYS_ERROR_RETURN(\"Machine IP misconfiguration (broadcast address).\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (getlogin())";
  z[lc++]="    strcpy((nsys_username = malloc(strlen(getlogin())+1)), getlogin());";
  z[lc++]="  else";
  z[lc++]="    nsys_username = \"unknown\";";
  z[lc++]="";
  z[lc++]="  snprintf(nsys_cname, NSYS_CNAMESIZE, \"%s@%s:%hu\",";
  z[lc++]="	   nsys_username, nsys_clientip, nsys_rtcp_port);";
  z[lc++]="  nsys_cname[NSYS_CNAMESIZE-1] = '\\0';";
  z[lc++]="  nsys_cname_len = (unsigned char) strlen(nsys_cname);";
  z[lc++]="";
  z[lc++]="  /************************************************************/";
  z[lc++]="  /* create digest sessionname, initialize authentication key */";
  z[lc++]="  /************************************************************/";
  z[lc++]="";
  z[lc++]="  nsys_msession = !strcmp(NSYS_MSESSION_NAME, nsys_sessionname);";
  z[lc++]="  nsys_msessionmirror = nsys_msession && !strcmp(\"mirror\", APPNAME);";
  z[lc++]="";
  z[lc++]="  if (nsys_sessionkey == NULL)";
  z[lc++]="    {";
  z[lc++]="      nsys_sessionkey = calloc(NSYS_MKEY_LENGTH + 1, 1);";
  z[lc++]="      i = 0;";
  z[lc++]="      while (i < NSYS_MKEY_LENGTH)";
  z[lc++]="	{";
  z[lc++]="	  if ((rfd < 0)|| (read(rfd, &(nsys_sessionkey[i]), sizeof(char)) < 0))";
  z[lc++]="	    nsys_sessionkey[i] = (char)((255.0F*rand()";
  z[lc++]="					 /(RAND_MAX+1.0F))-128.0F);";
  z[lc++]="	  i = (isprint((int)nsys_sessionkey[i])) ? i + 1 : i; ";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_md5(nsys_keydigest, nsys_sessionkey, strlen(nsys_sessionkey));";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_MD5_ROUNDS; i++)";
  z[lc++]="    nsys_md5(nsys_keydigest, nsys_keydigest, NSYS_MD5_LENGTH);";
  z[lc++]="";
  z[lc++]="  if (nsys_msession)";
  z[lc++]="    nsys_md5(session_digest, nsys_sessionname, strlen(nsys_sessionname));";
  z[lc++]="  else";
  z[lc++]="    nsys_hmac_md5(nsys_sessionname, strlen(nsys_sessionname), nsys_keydigest,";
  z[lc++]="		  session_digest);";
  z[lc++]="";
  z[lc++]="  nsys_digest_base64(nsys_session_base64, session_digest);";
  z[lc++]="";
  z[lc++]="  /*************************************/";
  z[lc++]="  /* create and send SIP invite packet */";
  z[lc++]="  /*************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_initsip() == NSYS_ERROR)";
  z[lc++]="    return NSYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* create mset slots */";
  z[lc++]="";
  z[lc++]="  for (i = NSYS_MSETS; i > 0; i--)";
  z[lc++]="    {";
  z[lc++]="      newsrc = calloc(1, sizeof(struct source));";
  z[lc++]="      newsrc->mset = i;";
  z[lc++]="      newsrc->next = nsys_srcfree;";
  z[lc++]="      nsys_srcfree = newsrc;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < NSYS_RECVCHAN*NSYS_MSETS; i++)";
  z[lc++]="    {";
  z[lc++]="      newrecv = calloc(1, sizeof(struct netout_jrecv_state));";
  z[lc++]="      newrecv->next = nsys_recvfree;";
  z[lc++]="      nsys_recvfree = newrecv;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* setup network output */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0)||(read(rfd, &(nsys_netout_tstamp), sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_netout_tstamp = (unsigned long) rand();";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0)||(read(rfd, &(nsys_netout_seqnum), sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_netout_seqnum = ((unsigned long) rand());";
  z[lc++]="";
  z[lc++]="  nsys_netout_seqnum &= 0x0000FFFF;";
  z[lc++]="  nsys_netout_seqnum = (!nsys_netout_seqnum) ? 1 : nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtp_packet[NSYS_RTPLOC_BYTE1] = NSYS_RTPVAL_BYTE1;";
  z[lc++]="";
  z[lc++]="  if (nsys_feclevel == NSYS_SM_FEC_NONE)";
  z[lc++]="    nsys_netout_markbit = NSYS_RTPVAL_SETMARK;";
  z[lc++]="";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_SSRC]), &nsys_myssrc_net,";
  z[lc++]="	 sizeof(long));";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* setup RTCP system */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initpackets();";
  z[lc++]="  nsys_nexttime = time(NULL) + NSYS_RTCPTIME_INCR;";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex  = NSYS_RTCPEX_NULLROOT;";
  z[lc++]="  nsys_rtcp_ex |= (NSYS_RTCPEX_RTCPSIP | NSYS_RTCPEX_RTPSIP); ";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* setup sa-midi packetization */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  netout_jsend_checkpoint_seqnum = nsys_netout_seqnum;";
  z[lc++]="  netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] = NSYS_SM_JH_SETA;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_MIDI_NUMCHAN; i++)";
  z[lc++]="    netout_jsend[i].chan = i;";
  z[lc++]="";
  z[lc++]="  nsys_netout_journal_changecheck();";
  z[lc++]="";
  z[lc++]="  switch (nsys_feclevel) {";
  z[lc++]="  case NSYS_SM_FEC_NONE:";
  z[lc++]="  case NSYS_SM_FEC_NOGUARD:";
  z[lc++]="    netout_jsend_guard_ontime  = 0;";
  z[lc++]="    netout_jsend_guard_mintime = 0;";
  z[lc++]="    netout_jsend_guard_maxtime = 0;";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_FEC_MINIMAL:";
  z[lc++]="    netout_jsend_guard_ontime  = 0;";
  z[lc++]="    netout_jsend_guard_mintime = (ARATE*NSYS_SM_GUARD_MINTIME)/ACYCLE;";
  z[lc++]="    netout_jsend_guard_maxtime = (ARATE*NSYS_SM_GUARD_MAXTIME)/ACYCLE;";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_FEC_STANDARD:";
  z[lc++]="    netout_jsend_guard_ontime  = 0;";
  z[lc++]="    netout_jsend_guard_mintime = (ARATE*NSYS_SM_GUARD_STDTIME)/ACYCLE;";
  z[lc++]="    netout_jsend_guard_maxtime = (ARATE*NSYS_SM_GUARD_MAXTIME)/ACYCLE;";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_SM_FEC_EXTRA:";
  z[lc++]="    netout_jsend_guard_ontime  = (ARATE*NSYS_SM_GUARD_ONTIME)/ACYCLE;";
  z[lc++]="    netout_jsend_guard_mintime = (ARATE*NSYS_SM_GUARD_STDTIME)/ACYCLE;";
  z[lc++]="    netout_jsend_guard_maxtime = (ARATE*NSYS_SM_GUARD_MAXTIME)/ACYCLE;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (rfd >= 0)";
  z[lc++]="    close(rfd);";
  z[lc++]="";
  z[lc++]="  return NSYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  tears down networking                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_shutdown(void) ";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="  struct source * sptr = nsys_srcroot;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  nsys_warning(NSYS_WARN_STANDARD, \"Shutdown in progress\");";
  z[lc++]="";
  z[lc++]="  /* send RTCP BYE command to all listeners */";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & NSYS_RTCPEX_NULLROOT) == 0)";
  z[lc++]="    nsys_netout_rtcpsend(netout_rtcp_packet_bye, ";
  z[lc++]="			 netout_rtcp_len_bye + NSYS_RTPSIZE_DIGEST);";
  z[lc++]="";
  z[lc++]="  /* send SIP BYE command to the SIP server */";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & (NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP)) == 0)";
  z[lc++]="    nsys_sip_shutdown();";
  z[lc++]="";
  z[lc++]="  /* close network FD's */";
  z[lc++]="";
  z[lc++]="  close(nsys_rtp_fd);";
  z[lc++]="  close(nsys_rtcp_fd);";
  z[lc++]="";
  z[lc++]="  nsys_warning(NSYS_WARN_STANDARD, \"Shutdown completed\");";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="";
  z[lc++]="  if (sptr)";
  z[lc++]="    do {";
  z[lc++]="      printf(\"mset%i packets expected: %i\\n\", sptr->mset,";
  z[lc++]="	     sptr->hi_ext - sptr->base_seq + 1);";
  z[lc++]="      printf(\"mset%i packets received: %i\\n\", sptr->mset,";
  z[lc++]="	     sptr->received);";
  z[lc++]="      if (sptr->tm_fd)";
  z[lc++]="	fclose(sptr->tm_fd);";
  z[lc++]="    } while ((sptr = sptr->next) != nsys_srcroot);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level RTP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              add new SSRC to send/receive list               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="source * nsys_netin_addsrc(int fd, long ssrc, char * ip, unsigned short port)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  struct sockaddr_in ipaddr;";
  z[lc++]="";
  z[lc++]="  if (nsys_srcfree == NULL)";
  z[lc++]="    {";
  z[lc++]="      memset(&ipaddr, 0, sizeof(struct sockaddr_in));";
  z[lc++]="      ipaddr.sin_port = htons(port);";
  z[lc++]="      ipaddr.sin_family = AF_INET;  ";
  z[lc++]="      ipaddr.sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="      if (nsys_harvest_ssrc(nsys_rtp_fd, &ipaddr) == NULL)";
  z[lc++]="	return NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex |= (nsys_myssrc == ssrc) ? NSYS_RTCPEX_SRCDUPL : 0;";
  z[lc++]="";
  z[lc++]="  sptr = nsys_srcfree;";
  z[lc++]="  nsys_srcfree = nsys_srcfree->next;";
  z[lc++]="  ";
  z[lc++]="  /* set ssrc and IP/port */";
  z[lc++]="";
  z[lc++]="  sptr->ssrc = ssrc;";
  z[lc++]="";
  z[lc++]="  /* unchanged, used to detect replay attacks */";
  z[lc++]="";
  z[lc++]="  sptr->sdp_addr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="  sptr->sdp_addr->sin_family = AF_INET;   ";
  z[lc++]="  sptr->sdp_addr->sin_port = htons(port);";
  z[lc++]="  sptr->sdp_addr->sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="";
  z[lc++]="  /* may be changed if NAT present */";
  z[lc++]="";
  z[lc++]="  sptr->rtp_addr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="  sptr->rtp_addr->sin_family = AF_INET;   ";
  z[lc++]="  sptr->rtp_addr->sin_port = htons(port);";
  z[lc++]="  sptr->rtp_addr->sin_addr.s_addr = inet_addr(ip);";
  z[lc++]="";
  z[lc++]="  sptr->rtcp_addr = calloc(1, sizeof(struct sockaddr_in));";
  z[lc++]="  sptr->rtcp_addr->sin_family = AF_INET;   ";
  z[lc++]="  sptr->rtcp_addr->sin_port = htons(port + 1);";
  z[lc++]="  sptr->rtcp_addr->sin_addr.s_addr = sptr->rtp_addr->sin_addr.s_addr;";
  z[lc++]="";
  z[lc++]="  sptr->alt_rtp_addr = sptr->alt_rtcp_addr = NULL;";
  z[lc++]="  sptr->cname = NULL;";
  z[lc++]="";
  z[lc++]="  if (nsys_srcroot)";
  z[lc++]="    {";
  z[lc++]="      nsys_srcroot->next->prev = sptr;";
  z[lc++]="      sptr->next = nsys_srcroot->next;";
  z[lc++]="      sptr->prev = nsys_srcroot;";
  z[lc++]="      nsys_srcroot->next = sptr;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      nsys_srcroot = sptr->prev = sptr->next = sptr;";
  z[lc++]="      nsys_rtcp_ex &= ~NSYS_RTCPEX_NULLROOT;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  sptr->xtra = nsys_ssrc[NSYS_HASHMASK & ssrc];";
  z[lc++]="  nsys_ssrc[NSYS_HASHMASK & ssrc] = sptr;";
  z[lc++]="";
  z[lc++]="  sptr->birthtime = time(NULL);";
  z[lc++]="  sptr->expire_rtcp = sptr->birthtime + NSYS_RTCPTIME_TIMEOUT;";
  z[lc++]="";
  z[lc++]="  nsys_netout_midistate_init();";
  z[lc++]="";
  z[lc++]="  return sptr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         updates RTCP info for a new RTP packet               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_rtpstats(source * sptr, unsigned char * packet)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long seq;";
  z[lc++]="  int seqinc, delta;";
  z[lc++]="  int rtpcode;";
  z[lc++]="";
  z[lc++]="  seq = ntohs(*((unsigned short *)&(packet[NSYS_RTPLOC_SEQNUM])));";
  z[lc++]="";
  z[lc++]="  delta = nsys_netout_tstamp - ";
  z[lc++]="    ntohl(*((unsigned long *)&(packet[NSYS_RTPLOC_TSTAMP])));";
  z[lc++]="   ";
  z[lc++]="  if (sptr->received++)";
  z[lc++]="    {";
  z[lc++]="      if (abs((seqinc = (seq - sptr->hi_lobits))) > NSYS_RTPSEQ_MAXDIFF)";
  z[lc++]="	{";
  z[lc++]="	  if ((seq < NSYS_RTPSEQ_LOWLIMIT) && ";
  z[lc++]="	      (sptr->hi_lobits > NSYS_RTPSEQ_HILIMIT))";
  z[lc++]="	    {";
  z[lc++]="	      /* wraparound */";
  z[lc++]="	      ";
  z[lc++]="	      seqinc = seq + (NSYS_RTPSEQ_LOMASK - sptr->hi_lobits) + 1;";
  z[lc++]="	      sptr->hi_ext += NSYS_RTPSEQ_EXINCR;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if ((sptr->hi_lobits < NSYS_RTPSEQ_LOWLIMIT) && ";
  z[lc++]="		  (seq < NSYS_RTPSEQ_HILIMIT))";
  z[lc++]="		{";
  z[lc++]="		  seqinc = 0;  /* out-of-order packets in wraparound */";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  /* possible replay attack -- discard packet */";
  z[lc++]="		  ";
  z[lc++]="		  sptr->received--;";
  z[lc++]="		  return NSYS_RTPCODE_SECURITY;";
  z[lc++]="		  ";
  z[lc++]="		  /* older behavior: something bad happened -- reset */";
  z[lc++]="		  ";
  z[lc++]="		  seqinc = 3;        ";
  z[lc++]="		  sptr->hi_ext = 0;";
  z[lc++]="		  sptr->base_seq = seq;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (seqinc <= 0)";
  z[lc++]="	rtpcode = NSYS_RTPCODE_DISCARD;   /* duplicate or out-of-order */";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  sptr->hi_lobits = seq;";
  z[lc++]="	  sptr->hi_ext &= NSYS_RTPSEQ_EXMASK;";
  z[lc++]="	  sptr->hi_ext += seq;";
  z[lc++]="	  ";
  z[lc++]="	  switch(seqinc) {";
  z[lc++]="	  case 1:";
  z[lc++]="	    rtpcode = NSYS_RTPCODE_NORMAL; ";
  z[lc++]="	    break;";
  z[lc++]="	  case 2:";
  z[lc++]="	    rtpcode = NSYS_RTPCODE_LOSTONE; ";
  z[lc++]="	    break;";
  z[lc++]="	  default:";
  z[lc++]="	    rtpcode = NSYS_RTPCODE_LOSTMANY; ";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      sptr->jitter += (abs(delta - sptr->j_delta) -";
  z[lc++]="		       ((sptr->jitter + 8) >> 4));";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      sptr->hi_ext = sptr->hi_lobits = sptr->base_seq = seq;";
  z[lc++]="      if (!(sptr->rtcp_received))";
  z[lc++]="	nsys_status(sptr, \"Media (RTP) flowing from\");";
  z[lc++]="      rtpcode = NSYS_RTPCODE_LOSTMANY;";
  z[lc++]="    }";
  z[lc++]="      ";
  z[lc++]="  sptr->j_delta = delta;";
  z[lc++]="";
  z[lc++]="  if (sptr->tm_margin)";
  z[lc++]="    {";
  z[lc++]="      sptr->ontime = (((signed long)(delta + sptr->tm_convert)) < 0);";
  z[lc++]="      if (sptr->ontime)";
  z[lc++]="	{";
  z[lc++]="	  if (sptr->tm_lateflag)";
  z[lc++]="	    sptr->tm_lateflag = 0;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  nsys_late_windowcheck(sptr, nsys_netout_tstamp - delta);";
  z[lc++]="	  sptr->ontime = !(sptr->tm_lateflag);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    sptr->ontime = 1;";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="";
  z[lc++]="  if (sptr->tm_margin)";
  z[lc++]="    {";
  z[lc++]="      fprintf(sptr->tm_fd, \"%f %f #\",";
  z[lc++]="	      (nsys_netout_tstamp - sptr->tm_first)/ARATE,";
  z[lc++]="	      ((int)(delta + sptr->tm_convert))/ARATE);";
  z[lc++]="";
  z[lc++]="      if ((packet[NSYS_RTPLEN_HDR] & NSYS_SM_MLENMAX) == 0)";
  z[lc++]="	fprintf(sptr->tm_fd, \"Empty\\n\");";
  z[lc++]="      else";
  z[lc++]="	switch(packet[NSYS_RTPLEN_HDR+1] & 0xF0) {";
  z[lc++]="	case CSYS_MIDI_NOTEOFF:";
  z[lc++]="	  fprintf(sptr->tm_fd, \"NoteOff\\n\");";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_NOTEON:";
  z[lc++]="	  if (packet[NSYS_RTPLEN_HDR+3])";
  z[lc++]="	    fprintf(sptr->tm_fd, \"NoteOn\\n\");";
  z[lc++]="	  else";
  z[lc++]="	    fprintf(sptr->tm_fd, \"NoteOff\\n\");";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_PTOUCH:";
  z[lc++]="	  fprintf(sptr->tm_fd, \"PTouch\\n\");";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CC:";
  z[lc++]="	  fprintf(sptr->tm_fd, \"CChange\\n\");";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_PROGRAM:";
  z[lc++]="	  fprintf(sptr->tm_fd, \"PChange\\n\");";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_CTOUCH:";
  z[lc++]="	  fprintf(sptr->tm_fd, \"CTouch\\n\");";
  z[lc++]="	  break;";
  z[lc++]="	case CSYS_MIDI_WHEEL:";
  z[lc++]="	  fprintf(sptr->tm_fd, \"PWheel\\n\");";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return rtpcode;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             prints out warning messages                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_warning(int level, char * message) ";
  z[lc++]="		";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if (NSYS_WARN > NSYS_WARN_NONE)";
  z[lc++]="";
  z[lc++]="  time_t now = time(NULL);";
  z[lc++]="";
  z[lc++]="  switch (level) {";
  z[lc++]="  case NSYS_WARN_STANDARD:";
  z[lc++]="    nsys_stderr_size += ";
  z[lc++]="      fprintf(stderr, \"Network status: %s %s\", message,";
  z[lc++]="	      nsys_msessionmirror ? ctime(&now) : \"\\n\");";
  z[lc++]="    fflush(stderr);";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_WARN_UNUSUAL:";
  z[lc++]="    if (NSYS_WARN >= NSYS_WARN_UNUSUAL)";
  z[lc++]="      {";
  z[lc++]="	nsys_stderr_size += ";
  z[lc++]="	  fprintf(stderr, \"Network advisory: %s %s\", message,";
  z[lc++]="		  nsys_msessionmirror ? ctime(&now) : \"\\n\");";
  z[lc++]="	fflush(stderr);";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="	";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             prints out status message for a source           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_status(source * sptr, char * message) ";
  z[lc++]="		";
  z[lc++]="{";
  z[lc++]="  time_t now = time(NULL);";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Network status: %s %s %s\", message, sptr->cname, ";
  z[lc++]="	    nsys_msessionmirror ? ctime(&now) : \"\\n\");";
  z[lc++]="";
  z[lc++]="  fflush(stderr);";
  z[lc++]="}";
  z[lc++]="	  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             prints out error-termination messages            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_terminate_error(char * message) ";
  z[lc++]="		";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Network status: Probable client/server bug found\\n\");";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"              : %s\\n\", message);";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"              : Please send bug details to\"";
  z[lc++]="	    \" lazzaro@cs.berkeley.edu -- thanks! --jl\\n\");";
  z[lc++]="  nsys_graceful_exit = 1;";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                   utility RTP functions                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             checks validity of payload ptype                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_ptypevalid(unsigned char ptype) ";
  z[lc++]="			 ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int j;";
  z[lc++]="";
  z[lc++]="  for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="    if (nsys_payload_types[j].ptype == ptype)";
  z[lc++]="     return 1;";
  z[lc++]="      ";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              fix payload for new RTP stream                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_ptypeset(struct source * sptr, unsigned char ptype)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int j;";
  z[lc++]="";
  z[lc++]="  for (j = 0; j < NSYS_RTP_PAYSIZE; j++)";
  z[lc++]="    if (nsys_payload_types[j].ptype == ptype)";
  z[lc++]="      {	  ";
  z[lc++]="	sptr->ptype  = ptype;";
  z[lc++]="	sptr->pindex = nsys_payload_types[j].pindex;";
  z[lc++]="	sptr->srate  = nsys_payload_types[j].srate;";
  z[lc++]="	return;";
  z[lc++]="      }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              return a new jrecv pointer                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="netout_jrecv_state * nsys_netin_newrecv(unsigned char chan)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  netout_jrecv_state * ret;";
  z[lc++]="";
  z[lc++]="  if (nsys_recvfree)";
  z[lc++]="    {";
  z[lc++]="      ret = nsys_recvfree;";
  z[lc++]="      nsys_recvfree = nsys_recvfree->next;";
  z[lc++]="      memset(ret, 0, sizeof(struct netout_jrecv_state));";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    ret = calloc(1, sizeof(struct netout_jrecv_state));";
  z[lc++]="";
  z[lc++]="  ret->chan = chan;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       determines client IP number, returns NULL on error     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="char * nsys_find_clientip(char * ip)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if (!defined(sun) && !defined(__sun__))  /* avoid Sys5/BSD issues */";
  z[lc++]="";
  z[lc++]="  char buf[32*sizeof(struct ifreq)];";
  z[lc++]="  struct ifconf ifc;";
  z[lc++]="  struct ifreq * ifr;";
  z[lc++]="  int s, n;";
  z[lc++]="";
  z[lc++]="  /* open a socket, get list of addresses */";
  z[lc++]="  ";
  z[lc++]="  if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)";
  z[lc++]="    return NULL;";
  z[lc++]="  ";
  z[lc++]="  ifc.ifc_len = sizeof(buf);";
  z[lc++]="  ifc.ifc_buf = (caddr_t) buf;";
  z[lc++]="  ";
  z[lc++]="  if (ioctl(s, SIOCGIFCONF, &ifc) < 0)";
  z[lc++]="    {";
  z[lc++]="      close(s);";
  z[lc++]="      return NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* look through addresses, return a useful one */";
  z[lc++]="";
  z[lc++]="  ifr = ifc.ifc_req;";
  z[lc++]="  ";
  z[lc++]="  for (n = ifc.ifc_len/sizeof(struct ifreq); --n >= 0; ifr++) ";
  z[lc++]="    {";
  z[lc++]="      if (ifr->ifr_addr.sa_family != AF_INET)";
  z[lc++]="	continue;";
  z[lc++]="      ";
  z[lc++]="      if (ioctl(s, SIOCGIFFLAGS, (char *) ifr) < 0)";
  z[lc++]="	continue;";
  z[lc++]="      ";
  z[lc++]="      if ((ifr->ifr_flags & IFF_UP) == 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      if (ifr->ifr_flags & IFF_LOOPBACK)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      if ((ifr->ifr_flags & (IFF_BROADCAST | IFF_POINTOPOINT)) == 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      if (ioctl(s, SIOCGIFADDR, (char *) ifr) < 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      close(s);";
  z[lc++]="      return strcpy(ip, ";
  z[lc++]="	     inet_ntoa(((struct sockaddr_in *)(&(ifr->ifr_addr)))->sin_addr));";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  close(s);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return NULL;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end Network library -- RTP functions */";
  printlib(lc);
}


void makenet_rtcplib(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- RTP functions";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 high-level RCTP functions                     */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]=" ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        application-level function to trigger RTCP sends      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcptime(void)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  if (nsys_behind_nat && (++nsys_sipinfo_count >= NSYS_SIPINFO_TRIGGER))";
  z[lc++]="    {";
  z[lc++]="      nsys_netout_keepalive();      /* resets nsys_sipinfo_count */";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_nexttime += NSYS_RTCPTIME_INCR; ";
  z[lc++]="";
  z[lc++]="  if (nsys_rtcp_ex && nsys_netout_excheck())";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcpreport();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              process received RTCP packet                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="source * nsys_netin_rtcp(unsigned char * packet, int len, ";
  z[lc++]="		     struct sockaddr_in * ipaddr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long ssrc, new_stamp, hiseq;";
  z[lc++]="  struct source * sptr = NULL;";
  z[lc++]="  int skip, overflow;";
  z[lc++]="  unsigned short sect_len;";
  z[lc++]="  int first = 0;";
  z[lc++]="  struct timeval now;";
  z[lc++]="  int offset;";
  z[lc++]="";
  z[lc++]="  gettimeofday(&now, 0);";
  z[lc++]="";
  z[lc++]="  if (NSYS_DISPLAY_RTCP)";
  z[lc++]="    nsys_netin_rtcp_display(packet, len, &now); ";
  z[lc++]="";
  z[lc++]="  while (len > 0)";
  z[lc++]="    {";
  z[lc++]="      if (len < NSYS_RTCPLEN_MINIMUM)";
  z[lc++]="	{";
  z[lc++]="	  nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP subpacket size subminimal\");";
  z[lc++]="	  return sptr;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* assume all sub-packets share ssrc, just look at first */";
  z[lc++]="";
  z[lc++]="      if (!first)";
  z[lc++]="	{";
  z[lc++]="	  first = 1;";
  z[lc++]="	  ssrc = ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SSRC])));";
  z[lc++]="	  sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="	  ";
  z[lc++]="	  while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="	    sptr = sptr->xtra;";
  z[lc++]="	  ";
  z[lc++]="	  if (!sptr)";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP packet source unknown\");";
  z[lc++]="	      return sptr;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  if (!(sptr->rtcp_received++))";
  z[lc++]="	    {";
  z[lc++]="	      if (!(sptr->received))";
  z[lc++]="		nsys_status(sptr, \"Media (RTCP) flowing from\");";
  z[lc++]="	      if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="		printf(\"%s is mset%i\\n\", sptr->cname, sptr->mset);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (((ipaddr->sin_addr.s_addr != sptr->rtcp_addr->sin_addr.s_addr) ||";
  z[lc++]="	      (ipaddr->sin_port != sptr->rtcp_addr->sin_port)) && ";
  z[lc++]="	      (sptr->alt_rtcp_addr == NULL))";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, ";
  z[lc++]="			   \"RTCP packet from unknown IP/port\");";
  z[lc++]="	      return NULL;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (sptr->alt_rtcp_addr)";
  z[lc++]="	    {  ";
  z[lc++]="	      if ((ipaddr->sin_addr.s_addr != nsys_sip_rtcp_inet_addr) ||";
  z[lc++]="		  (ipaddr->sin_port != nsys_sip_rtcp_sin_port))";
  z[lc++]="		{";
  z[lc++]="		  /* normal case */";
  z[lc++]="";
  z[lc++]="		  memcpy(sptr->rtcp_addr, ipaddr, sizeof(struct sockaddr_in));";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  /* source-forge trick which may later be implemented */";
  z[lc++]="";
  z[lc++]="		  memcpy(sptr->rtcp_addr, &(sptr->alt_rtcp_addr), ";
  z[lc++]="			 sizeof(struct sockaddr_in));";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      free(sptr->alt_rtcp_addr);";
  z[lc++]="	      sptr->alt_rtcp_addr = NULL;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  sptr->expire_rtcp = time(NULL) + NSYS_RTCPTIME_TIMEOUT;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /* process sub-packet */";
  z[lc++]="";
  z[lc++]="      memcpy(&(sect_len), &(packet[NSYS_RTCPLOC_LENGTH]), sizeof(short));";
  z[lc++]="      skip = 4 + 4*ntohs(sect_len);";
  z[lc++]="      if ((len -= skip) < 0)";
  z[lc++]="	{      ";
  z[lc++]="	  nsys_netin_rtcp_trunc(packet[NSYS_RTCPLOC_PTYPE]);";
  z[lc++]="	  return sptr;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      overflow = offset = 0;";
  z[lc++]="";
  z[lc++]="      switch (packet[NSYS_RTCPLOC_PTYPE]) {";
  z[lc++]="      case NSYS_RTCPVAL_SR:";
  z[lc++]="	if (NSYS_RTCPVAL_COUNTMASK & packet[NSYS_RTCPLOC_BYTE1])";
  z[lc++]="	  {";
  z[lc++]="	    offset = NSYS_RTCPLEN_SRHDR + NSYS_RTCPLEN_SENDER;";
  z[lc++]="	    overflow = (skip < NSYS_RTCPLEN_SR);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  overflow = (skip < NSYS_RTCPLEN_SREMPTY);";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_RR:";
  z[lc++]="	if (NSYS_RTCPVAL_COUNTMASK & packet[NSYS_RTCPLOC_BYTE1])";
  z[lc++]="	  {";
  z[lc++]="	    offset = NSYS_RTCPLEN_RRHDR; ";
  z[lc++]="	    overflow = (skip < NSYS_RTCPLEN_RR);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  overflow = (skip < NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      ";
  z[lc++]="      if (overflow)";
  z[lc++]="	{      ";
  z[lc++]="	  nsys_netin_rtcp_trunc(packet[NSYS_RTCPLOC_PTYPE]);";
  z[lc++]="	  return sptr;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (offset)";
  z[lc++]="	{";
  z[lc++]="	  memcpy(&hiseq, &(packet[offset+NSYS_RTCPLOC_RR_HISEQ]),sizeof(long));";
  z[lc++]="	  hiseq = ntohl(hiseq);";
  z[lc++]="";
  z[lc++]="	  if ((hiseq >= sptr->last_hiseq_rec) || ";
  z[lc++]="	      (sptr->last_hiseq_rec > ";
  z[lc++]="	       ((unsigned long) (NSYS_RTPSEQ_EXMASK | NSYS_RTPSEQ_HILIMIT))))";
  z[lc++]="	    {";
  z[lc++]="	      sptr->last_hiseq_ext = sptr->last_hiseq_rec = hiseq;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, \"Possible RTCP replay attack\");";
  z[lc++]="	      return NULL; ";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      switch (packet[NSYS_RTCPLOC_PTYPE]) {";
  z[lc++]="      case NSYS_RTCPVAL_SR:";
  z[lc++]="";
  z[lc++]="	/* create LSR value from NTP */";
  z[lc++]="";
  z[lc++]="	sptr->lsr[0] =  packet[NSYS_RTCPLOC_SR_NTPMSB + 2];";
  z[lc++]="	sptr->lsr[1] =  packet[NSYS_RTCPLOC_SR_NTPMSB + 3];";
  z[lc++]="	sptr->lsr[2] =  packet[NSYS_RTCPLOC_SR_NTPLSB];";
  z[lc++]="	sptr->lsr[3] =  packet[NSYS_RTCPLOC_SR_NTPLSB + 1];";
  z[lc++]="";
  z[lc++]="	sptr->arrival.tv_sec = now.tv_sec;";
  z[lc++]="	sptr->arrival.tv_usec = now.tv_usec;";
  z[lc++]="";
  z[lc++]="	memcpy(&new_stamp, &(packet[NSYS_RTCPLOC_SR_TSTAMP]), sizeof(long));";
  z[lc++]="	new_stamp = ntohl(new_stamp);";
  z[lc++]="";
  z[lc++]="	if (sptr->tm_margin)";
  z[lc++]="	  {";
  z[lc++]="	    if (((int)(new_stamp - nsys_netout_tstamp - sptr->tm_convert)) > 0)";
  z[lc++]="	      {";
  z[lc++]="		sptr->tm_convert = (new_stamp - nsys_netout_tstamp";
  z[lc++]="				    - sptr->tm_margin);";
  z[lc++]="		if (sptr->tm_lateflag)";
  z[lc++]="		  sptr->tm_lateflag = 0;";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      nsys_late_windowcheck(sptr, new_stamp);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    sptr->tm_margin = nsys_lateplay ? 0 : ARATE*nsys_latetime;";
  z[lc++]="	    sptr->tm_convert = (new_stamp - nsys_netout_tstamp -";
  z[lc++]="				sptr->tm_margin);";
  z[lc++]="	    if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="	      nsys_netin_latenotes_open(sptr);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_RR:";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_SDES:";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_BYE:";
  z[lc++]="	nsys_netin_bye(packet, skip);";
  z[lc++]="	return (sptr = NULL);";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_APP:";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="      packet += skip;     /* skip to next sub-packet */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return sptr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             top-level RTCP packet initializations            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initpackets(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int sdes_size;";
  z[lc++]="";
  z[lc++]="  /************************************/";
  z[lc++]="  /* calculate SDES CNAME packet size */";
  z[lc++]="  /************************************/";
  z[lc++]="";
  z[lc++]="  sdes_size = (NSYS_RTCPLEN_SDESHDR + NSYS_RTCPLEN_SDES_CHUNKHDR";
  z[lc++]="	       + NSYS_RTCPLEN_SDES_ITEMHDR + nsys_cname_len);";
  z[lc++]="  ";
  z[lc++]="  sdes_size += 4 - (sdes_size & 3);";
  z[lc++]="";
  z[lc++]="  if (!netout_rtcp_packet_bye)";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      /*********************/";
  z[lc++]="      /* create BYE packet */";
  z[lc++]="      /*********************/";
  z[lc++]="";
  z[lc++]="      netout_rtcp_len_bye = (NSYS_RTCPLEN_RREMPTY + sdes_size +";
  z[lc++]="			     NSYS_RTCPLEN_BYE);";
  z[lc++]="";
  z[lc++]="      netout_rtcp_packet_bye = malloc(netout_rtcp_len_bye + ";
  z[lc++]="				      NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="      /*********************/";
  z[lc++]="      /* create RR packets */";
  z[lc++]="      /*********************/";
  z[lc++]="";
  z[lc++]="      netout_rtcp_len_rrempty = NSYS_RTCPLEN_RREMPTY + sdes_size;";
  z[lc++]="      netout_rtcp_packet_rrempty = malloc(netout_rtcp_len_rrempty + ";
  z[lc++]="					  NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="      netout_rtcp_len_rr = NSYS_RTCPLEN_RR + sdes_size;";
  z[lc++]="      netout_rtcp_packet_rr = malloc(netout_rtcp_len_rr + ";
  z[lc++]="				     NSYS_MD5_LENGTH + 1);";
  z[lc++]="	  ";
  z[lc++]="      /*********************/";
  z[lc++]="      /* create SR packets */";
  z[lc++]="      /*********************/";
  z[lc++]="";
  z[lc++]="      netout_rtcp_len_srempty = NSYS_RTCPLEN_SREMPTY + sdes_size;";
  z[lc++]="      netout_rtcp_packet_srempty = malloc(netout_rtcp_len_srempty + ";
  z[lc++]="					  NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="      netout_rtcp_len_sr = NSYS_RTCPLEN_SR + sdes_size;";
  z[lc++]="      netout_rtcp_packet_sr = malloc(netout_rtcp_len_sr + ";
  z[lc++]="				     NSYS_MD5_LENGTH + 1);";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* initialize head of all RTCP packets */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initrr(netout_rtcp_packet_rrempty, NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="  nsys_netout_rtcp_initrr(netout_rtcp_packet_rr, NSYS_RTCPLEN_RR);";
  z[lc++]="  ";
  z[lc++]="  nsys_netout_rtcp_initsr(netout_rtcp_packet_srempty, NSYS_RTCPLEN_SREMPTY);";
  z[lc++]="  nsys_netout_rtcp_initsr(netout_rtcp_packet_sr, NSYS_RTCPLEN_SR);";
  z[lc++]="  ";
  z[lc++]="  nsys_netout_rtcp_initrr(netout_rtcp_packet_bye, NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="  ";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* initialize SDES of all RTCP packets */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(netout_rtcp_packet_rrempty";
  z[lc++]="			      [NSYS_RTCPLEN_RREMPTY]), sdes_size);";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(netout_rtcp_packet_rr";
  z[lc++]="			      [NSYS_RTCPLEN_RR]), sdes_size);";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(netout_rtcp_packet_srempty";
  z[lc++]="			      [NSYS_RTCPLEN_SREMPTY]), sdes_size);";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(netout_rtcp_packet_sr";
  z[lc++]="			      [NSYS_RTCPLEN_SR]), sdes_size);";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initsdes(&(netout_rtcp_packet_bye";
  z[lc++]="			      [NSYS_RTCPLEN_RREMPTY]), sdes_size);";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* initialize BYE packet, sign */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initbye(&(netout_rtcp_packet_bye";
  z[lc++]="			     [NSYS_RTCPLEN_RREMPTY + sdes_size]));";
  z[lc++]="";
  z[lc++]="  nsys_hmac_md5(netout_rtcp_packet_bye, netout_rtcp_len_bye, nsys_keydigest,";
  z[lc++]="		&(netout_rtcp_packet_bye[netout_rtcp_len_bye]));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               adds commands to reset an mset                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_clear_mset(unsigned char * buff, long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  source s;";
  z[lc++]="";
  z[lc++]="  if (!nsys_powerup_mset)";
  z[lc++]="    return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="";
  z[lc++]="  s.mset = nsys_powerup_mset;";
  z[lc++]="  nsys_powerup_mset = 0; ";
  z[lc++]=" ";
  z[lc++]="  return nsys_netin_journal_addcmd(&s, buff, fill, size, ";
  z[lc++]="				   CSYS_MIDI_POWERUP, 0, 0);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  second-level RTCP functions                 */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             handle special rtcptime cases                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netout_excheck(void) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  int print_exit, rfd;";
  z[lc++]="";
  z[lc++]="  if (nsys_rtcp_ex & (NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP))";
  z[lc++]="    {";
  z[lc++]="      print_exit = 0;";
  z[lc++]="";
  z[lc++]="      if (nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_rtcp_ex & NSYS_RTCPEX_RTPNEXT)";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_rtp_sipretry++ < NSYS_SIP_RETRYMAX)";
  z[lc++]="		nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_invite);";
  z[lc++]="	      else";
  z[lc++]="		print_exit = nsys_graceful_exit = 1;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_rtcp_ex & NSYS_RTCPEX_RTCPNEXT)";
  z[lc++]="	    nsys_rtcp_ex &= ~NSYS_RTCPEX_RTCPNEXT;";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_rtcp_sipretry++ < NSYS_SIP_RETRYMAX)";
  z[lc++]="		nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_invite);";
  z[lc++]="	      else";
  z[lc++]="		print_exit = nsys_graceful_exit = 1;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (print_exit)";
  z[lc++]="	nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="		     \"SIP server probably off-line, exiting\");";
  z[lc++]="      else";
  z[lc++]="	if (((nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP) && ";
  z[lc++]="	     ((nsys_rtcp_ex & NSYS_RTCPEX_RTPNEXT) == 0)) || ";
  z[lc++]="	    ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP) && ";
  z[lc++]="	     ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPNEXT) == 0)))";
  z[lc++]="	  nsys_warning(NSYS_WARN_STANDARD, ";
  z[lc++]="			 \"SIP server not responding, resending\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & NSYS_RTCPEX_SRCDUPL) == 0)";
  z[lc++]="    return (nsys_rtcp_ex & NSYS_RTCPEX_NULLROOT);";
  z[lc++]="";
  z[lc++]="  nsys_warning(NSYS_WARN_STANDARD, \"CSRC clash: reinitializing network\");";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex &= ~(NSYS_RTCPEX_RTPSIP | NSYS_RTCPEX_RTCPSIP | ";
  z[lc++]="		    NSYS_RTCPEX_RTPNEXT | NSYS_RTCPEX_RTCPNEXT);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* send RTCP BYE packet  */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if ((nsys_rtcp_ex & NSYS_RTCPEX_NULLROOT) == 0)";
  z[lc++]="    nsys_netout_rtcpsend(netout_rtcp_packet_bye, ";
  z[lc++]="			 netout_rtcp_len_bye + NSYS_RTPSIZE_DIGEST);";
  z[lc++]="";
  z[lc++]="  /*****************/";
  z[lc++]="  /* shut down SIP */";
  z[lc++]="  /*****************/";
  z[lc++]="";
  z[lc++]="  nsys_sip_shutdown();           ";
  z[lc++]="";
  z[lc++]="  /******************************************************************/";
  z[lc++]="  /* pick new ssrc value, send SIP INVITEs, set up RTP/RTCP packets */";
  z[lc++]="  /******************************************************************/";
  z[lc++]="";
  z[lc++]="  rfd = open(\"/dev/urandom\", O_RDONLY | O_NONBLOCK);";
  z[lc++]="";
  z[lc++]="  if ((rfd < 0) || (read(rfd, &nsys_myssrc, sizeof(unsigned long)) < 0))";
  z[lc++]="    nsys_myssrc = (unsigned long)rand();";
  z[lc++]="";
  z[lc++]="  nsys_myssrc_net = htonl(nsys_myssrc);";
  z[lc++]="";
  z[lc++]="  if (rfd)";
  z[lc++]="    close(rfd);";
  z[lc++]="";
  z[lc++]="  if (nsys_initsip() == NSYS_ERROR)";
  z[lc++]="    NSYS_ERROR_TERMINATE(\"Error sending SIP INVITE during CSRC clash\");";
  z[lc++]="";
  z[lc++]="  memcpy(&(nsys_netout_rtp_packet[NSYS_RTPLOC_SSRC]), &nsys_myssrc_net,";
  z[lc++]="	 sizeof(long));";
  z[lc++]="";
  z[lc++]="  nsys_nexttime = time(NULL) + NSYS_RTCPTIME_INCR;";
  z[lc++]="";
  z[lc++]="  nsys_netout_rtcp_initpackets();";
  z[lc++]="";
  z[lc++]="  nsys_sent_last = nsys_sent_last = 0;";
  z[lc++]="  nsys_sent_octets = nsys_sent_packets = 0;";
  z[lc++]="";
  z[lc++]="  if ((sptr = nsys_srcroot))";
  z[lc++]="    {";
  z[lc++]="      do ";
  z[lc++]="	{";
  z[lc++]="	  sptr->received = sptr->rtcp_received = sptr->received_prior = 0;";
  z[lc++]="	  sptr = sptr->next;";
  z[lc++]="	} ";
  z[lc++]="      while (sptr != nsys_srcroot);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* reset nsys_rtcp_ex */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  nsys_rtcp_ex = (nsys_srcroot == NULL) ? NSYS_RTCPEX_NULLROOT : 0;";
  z[lc++]="  nsys_rtcp_ex |= (NSYS_RTCPEX_RTCPSIP | NSYS_RTCPEX_RTPSIP); ";
  z[lc++]="";
  z[lc++]="  return (0);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sends out RTCP SR/RR reports                          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcpreport(void)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int len_empty, len_full, offset;";
  z[lc++]="  unsigned char * p_empty, * p_full;";
  z[lc++]="  int len = 0;";
  z[lc++]="  unsigned char * p = NULL;";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int alt = 0;";
  z[lc++]="  unsigned long dead_ssrc;";
  z[lc++]="  unsigned long expected, expected_this, received_this;";
  z[lc++]="  long num_lost;";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  struct sockaddr * addr;";
  z[lc++]="  struct timeval now;";
  z[lc++]="";
  z[lc++]="  sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  if (nsys_sent_this || nsys_sent_last)";
  z[lc++]="    {";
  z[lc++]="      nsys_sent_last = nsys_sent_this;";
  z[lc++]="      nsys_sent_this = 0;";
  z[lc++]="      ";
  z[lc++]="      offset = NSYS_RTCPLEN_SRHDR + NSYS_RTCPLEN_SENDER;";
  z[lc++]="      len_empty = netout_rtcp_len_srempty;";
  z[lc++]="      p_empty = netout_rtcp_packet_srempty;";
  z[lc++]="      len_full = netout_rtcp_len_sr;";
  z[lc++]="      p_full = netout_rtcp_packet_sr;";
  z[lc++]="";
  z[lc++]="      gettimeofday(&now, 0);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_NTPMSB])) =";
  z[lc++]="	htonl(0x83aa7e80 + now.tv_sec);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_NTPLSB])) =";
  z[lc++]="	htonl((unsigned long) ";
  z[lc++]="	      (((((unsigned long)(now.tv_usec << 12))/15625) << 14))); ";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_TSTAMP])) =";
  z[lc++]="	htonl(nsys_netout_tstamp);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_PACKET])) =";
  z[lc++]="	htonl(nsys_sent_packets);";
  z[lc++]="";
  z[lc++]="      *((unsigned long *) &(netout_rtcp_packet_sr[NSYS_RTCPLOC_SR_OCTET])) =";
  z[lc++]="	htonl(nsys_sent_octets);";
  z[lc++]="";
  z[lc++]="      memcpy(&(netout_rtcp_packet_srempty[NSYS_RTCPLEN_SRHDR]), ";
  z[lc++]="	     &(netout_rtcp_packet_sr[NSYS_RTCPLEN_SRHDR]), ";
  z[lc++]="	     NSYS_RTCPLEN_SENDER);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      offset = NSYS_RTCPLEN_RRHDR;";
  z[lc++]="";
  z[lc++]="      len_empty = netout_rtcp_len_rrempty;";
  z[lc++]="      p_empty = netout_rtcp_packet_rrempty;";
  z[lc++]="      len_full = netout_rtcp_len_rr;";
  z[lc++]="      p_full = netout_rtcp_packet_rr;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      if (!alt)";
  z[lc++]="	{";
  z[lc++]="	  addr = (struct sockaddr *)(sptr->rtcp_addr);";
  z[lc++]="	  if (time(NULL) > sptr->expire_rtcp)";
  z[lc++]="	    {";
  z[lc++]="	      dead_ssrc = sptr->ssrc;";
  z[lc++]="	      if ((sptr = sptr->next) == nsys_srcroot)";
  z[lc++]="		sptr = NULL;";
  z[lc++]="	      nsys_delete_ssrc(dead_ssrc, ";
  z[lc++]="			       \"RTCP silent too long, deleting\");";
  z[lc++]="	      if (sptr)";
  z[lc++]="		continue;";
  z[lc++]="	      else";
  z[lc++]="		break;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (sptr->received > sptr->received_prior)";
  z[lc++]="	    {";
  z[lc++]="";
  z[lc++]="	      p = p_full;";
  z[lc++]="	      len = len_full;";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_SSRC])) =";
  z[lc++]="		htonl(sptr->ssrc);";
  z[lc++]="";
  z[lc++]="	      expected = sptr->hi_ext - sptr->base_seq + 1;";
  z[lc++]="";
  z[lc++]="	      expected_this = expected - sptr->expected_prior;";
  z[lc++]="	      sptr->expected_prior = expected;";
  z[lc++]="";
  z[lc++]="	      received_this = sptr->received - sptr->received_prior;";
  z[lc++]="	      sptr->received_prior = sptr->received;";
  z[lc++]="";
  z[lc++]="	      num_lost = expected - sptr->received;";
  z[lc++]="	      ";
  z[lc++]="	      if (num_lost < NSYS_RTPSEQ_MINLOSS)";
  z[lc++]="		num_lost = NSYS_RTPSEQ_MINLOSS;";
  z[lc++]="";
  z[lc++]="	      if (num_lost > NSYS_RTPSEQ_MAXLOSS)";
  z[lc++]="		num_lost = NSYS_RTPSEQ_MAXLOSS;";
  z[lc++]="";
  z[lc++]="	      num_lost &= NSYS_RTPSEQ_FMASK;";
  z[lc++]="";
  z[lc++]="	      if (((expected_this - received_this) > 0) && expected_this)";
  z[lc++]="		num_lost |= ((((expected_this - received_this) << 8)";
  z[lc++]="			      /expected_this) << 24);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_FRACTLOSS])) =";
  z[lc++]="		htonl((unsigned long) num_lost);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_HISEQ])) =";
  z[lc++]="		htonl(sptr->hi_ext);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_JITTER])) =";
  z[lc++]="		htonl((unsigned long)(sptr->jitter >> 4));";
  z[lc++]="";
  z[lc++]="	      memcpy(&(p[offset + NSYS_RTCPLOC_RR_LASTSR]), sptr->lsr, 4);";
  z[lc++]="";
  z[lc++]="	      gettimeofday(&now, 0);";
  z[lc++]="";
  z[lc++]="	      *((unsigned long *) &(p[offset + NSYS_RTCPLOC_RR_DELAY])) =";
  z[lc++]="		(sptr->arrival.tv_sec == 0) ? 0 : ";
  z[lc++]="		htonl((unsigned long)";
  z[lc++]="		      (((now.tv_sec - sptr->arrival.tv_sec) << 16) +";
  z[lc++]="		       (((now.tv_usec - sptr->arrival.tv_usec) << 10) ";
  z[lc++]="			/15625)));";
  z[lc++]="";
  z[lc++]="	      sptr->received_prior = sptr->received;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      p = p_empty;";
  z[lc++]="	      len = len_empty;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  nsys_hmac_md5(p, len, nsys_keydigest, &(p[len]));";
  z[lc++]="	  len += NSYS_RTPSIZE_DIGEST;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	addr = (struct sockaddr *)(sptr->alt_rtcp_addr);";
  z[lc++]="      ";
  z[lc++]="      if (sendto(nsys_rtcp_fd, p, len, 0, addr, ";
  z[lc++]="		 sizeof(struct sockaddr)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    continue;";
  z[lc++]="	  ";
  z[lc++]="	  if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_netout_rtcptime\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (!(alt = ((!alt) && sptr->alt_rtcp_addr)))";
  z[lc++]="	sptr = sptr->next;";
  z[lc++]="    } ";
  z[lc++]="  while (alt || (sptr != nsys_srcroot));";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  sends out RTCP packets                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcpsend(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int alt = 0;";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  struct sockaddr * addr;";
  z[lc++]="";
  z[lc++]="  sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      addr = (alt ? (struct sockaddr *)(sptr->alt_rtcp_addr) : ";
  z[lc++]="	      (struct sockaddr *)(sptr->rtcp_addr));";
  z[lc++]="      ";
  z[lc++]="      if (sendto(nsys_rtcp_fd, p, len, 0, addr, ";
  z[lc++]="		 sizeof(struct sockaddr)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  if (errno == EAGAIN)";
  z[lc++]="	    continue;";
  z[lc++]="	  ";
  z[lc++]="	  if ((errno == EINTR) || (errno == ENOBUFS))";
  z[lc++]="	    {";
  z[lc++]="	      if (++retry > NSYS_MAXRETRY)";
  z[lc++]="		NSYS_ERROR_TERMINATE(\"Too many I/O retries -- nsys_netout_rtcptime\");";
  z[lc++]="	      continue;         ";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  NSYS_ERROR_TERMINATE(\"Error writing Internet socket\");";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (!(alt = ((!alt) && sptr->alt_rtcp_addr)))";
  z[lc++]="	sptr = sptr->next;";
  z[lc++]="    } ";
  z[lc++]="  while (alt || (sptr != nsys_srcroot));";
  z[lc++]="  ";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             sends out keepalive SIP INFO packets             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_keepalive(void)";
  z[lc++]="";
  z[lc++]="{        ";
  z[lc++]="  if (nsys_sipinfo_toggle && ((nsys_rtcp_ex & NSYS_RTCPEX_RTPSIP) == 0))";
  z[lc++]="    nsys_sendsip(nsys_rtp_fd, NULL, nsys_rtp_info);";
  z[lc++]="  else";
  z[lc++]="    if ((nsys_rtcp_ex & NSYS_RTCPEX_RTCPSIP) == 0)";
  z[lc++]="      nsys_sendsip(nsys_rtcp_fd, NULL, nsys_rtcp_info);";
  z[lc++]="  ";
  z[lc++]="  nsys_sipinfo_count = 0;";
  z[lc++]="  nsys_sipinfo_toggle = !nsys_sipinfo_toggle;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              display received RTCP packet information        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_rtcp_display(unsigned char * packet, int len, ";
  z[lc++]="			     struct timeval * now) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if NSYS_DISPLAY_RTCP";
  z[lc++]="";
  z[lc++]="  int error, complen;";
  z[lc++]="  unsigned long csrc, current, sent, delay;";
  z[lc++]="  long lost;";
  z[lc++]="  unsigned char contents, slen, offset;";
  z[lc++]="  unsigned char * p;";
  z[lc++]="";
  z[lc++]="  if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="    {";
  z[lc++]="      printf(\"processing RTCP payload -- %i bytes\\n\", len);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  error = 0;";
  z[lc++]="  while ((len > 0) && !error)";
  z[lc++]="    {";
  z[lc++]="      contents = offset = 0;";
  z[lc++]="      complen = ntohs(*((unsigned short *)&(packet[NSYS_RTCPLOC_LENGTH])));";
  z[lc++]="      switch (packet[NSYS_RTCPLOC_PTYPE]) {";
  z[lc++]="      case NSYS_RTCPVAL_SR:";
  z[lc++]="	contents = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="	if (contents)";
  z[lc++]="	  offset = NSYS_RTCPLEN_SRHDR + NSYS_RTCPLEN_SENDER;";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    csrc = ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SSRC])));";
  z[lc++]="	    printf(\"type SR (%i bytes) from SSRC %lu with %hhu reception reports\\n\",";
  z[lc++]="		   4*complen + 4, csrc, contents);";
  z[lc++]="	  }";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_SRINFO)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"NTP time %f, RTP timestamp %lu\\n\", ";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_NTPMSB])))";
  z[lc++]="		   + (ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_NTPLSB])))";
  z[lc++]="		      /(4294967296.0)), (unsigned long)";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_TSTAMP]))));";
  z[lc++]="	    printf(\"Total packets %lu, total octets %lu\\n\", (unsigned long)";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_PACKET]))),";
  z[lc++]="		   (unsigned long) ";
  z[lc++]="		   ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SR_OCTET]))));";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_RR:";
  z[lc++]="	contents = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="	if (contents)";
  z[lc++]="	  offset = NSYS_RTCPLEN_RRHDR;";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    csrc = ntohl(*((unsigned long *)&(packet[NSYS_RTCPLOC_SSRC])));";
  z[lc++]="	    printf(\"type RR (%i bytes) -- from SSRC %lu with %hhu reception reports\\n\",";
  z[lc++]="		   4*complen + 4, csrc, contents);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_SDES:";
  z[lc++]="	contents = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"type SDES (%i bytes) -- %hhu chunks\\n\", 4*complen + 4,";
  z[lc++]="		   contents);";
  z[lc++]="	  }";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_SDES)";
  z[lc++]="	  {";
  z[lc++]="	    p = packet + NSYS_RTCPLEN_SDES_CHUNKHDR;";
  z[lc++]="	    while (contents--)";
  z[lc++]="	      {";
  z[lc++]="		/* add fail-safe for bad packets */";
  z[lc++]="		";
  z[lc++]="		csrc = ntohl(*((unsigned long *)p));";
  z[lc++]="		printf(\"SDES for CSRC %lu\\n\", csrc);";
  z[lc++]="		p += 4;";
  z[lc++]="		while (p[NSYS_RTCPLOC_SDESITEM_TYPE] != '\\0')";
  z[lc++]="		  {";
  z[lc++]="		    printf(\"%s: \", (p[NSYS_RTCPLOC_SDESITEM_TYPE] < ";
  z[lc++]="				    NSYS_RTCPVAL_SDES_SIZE) ? ";
  z[lc++]="			   sdes_typename[p[NSYS_RTCPLOC_SDESITEM_TYPE]] : ";
  z[lc++]="			   \"Illegal\");";
  z[lc++]="		    slen = p[NSYS_RTCPLOC_SDESITEM_LENGTH];";
  z[lc++]="		    p += 2;";
  z[lc++]="		    while (slen--)";
  z[lc++]="		      putchar(*(p++));";
  z[lc++]="		    printf(\"\\n\");";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_BYE:";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"type BYE (%i bytes)\\n\", 4*complen + 4);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case NSYS_RTCPVAL_APP:	";
  z[lc++]="	if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="	  {";
  z[lc++]="	    printf(\"type APP\\n\");";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	printf(\"error parsing PTYPE %i (%i bytes)\\n\",";
  z[lc++]="	       packet[NSYS_RTCPLOC_PTYPE], complen);";
  z[lc++]="	error = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="      if (offset && NSYS_DISPLAY_RTCP_RRINFO)";
  z[lc++]="	{";
  z[lc++]="	  printf(\"reception quality from SSRC %lu\\n\",(unsigned long)";
  z[lc++]="		 ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset+NSYS_RTCPLOC_RR_SSRC]))));";
  z[lc++]="";
  z[lc++]="	  printf(\"fraction lost: %f,\", ";
  z[lc++]="		 (packet[offset+NSYS_RTCPLOC_RR_FRACTLOSS]/256.0F));";
  z[lc++]="";
  z[lc++]="	  memcpy(&lost, &(packet[offset+NSYS_RTCPLOC_RR_FRACTLOSS]),";
  z[lc++]="		 sizeof(long));";
  z[lc++]="	  lost = (signed long)ntohl((unsigned long)lost);";
  z[lc++]="";
  z[lc++]="	  if (((lost &= NSYS_RTPSEQ_FMASK) & NSYS_RTPSEQ_TSIGN))";
  z[lc++]="	    lost |= (~NSYS_RTPSEQ_FMASK);";
  z[lc++]="";
  z[lc++]="	  printf(\" total lost packets %li\\n\", lost);";
  z[lc++]="";
  z[lc++]="	  printf(\"highest sequence number received %lu\\n\", (unsigned long)";
  z[lc++]="		 ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset+NSYS_RTCPLOC_RR_HISEQ]))));";
  z[lc++]="	  printf(\"jitter: %f ms\\n\", (1000/ARATE)*(unsigned long)";
  z[lc++]="		 ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset + NSYS_RTCPLOC_RR_JITTER]))));";
  z[lc++]="";
  z[lc++]="	  current = now->tv_sec;";
  z[lc++]="	  current = (current + 32384) << 16;";
  z[lc++]="	  current += (((unsigned long)now->tv_usec) << 10)/15625;";
  z[lc++]="	  sent = ntohl(*((unsigned long *)";
  z[lc++]="			 &(packet[offset + NSYS_RTCPLOC_RR_LASTSR])));";
  z[lc++]="	  delay = ntohl(*((unsigned long *)";
  z[lc++]="			  &(packet[offset + NSYS_RTCPLOC_RR_DELAY])));";
  z[lc++]="	  if (sent || delay)";
  z[lc++]="	    {";
  z[lc++]="	      if (current > sent)";
  z[lc++]="		printf(\"Estimated round-trip time: %f milliseconds\\n\",";
  z[lc++]="		       1000.0F*(current - sent - delay)/65536.0F);";
  z[lc++]="	      else";
  z[lc++]="		printf(\"Estimated round-trip time: %f milliseconds (flip)\\n\",";
  z[lc++]="		       1000.0F*(sent - current - delay)/65536.0F);";
  z[lc++]="	      if (NSYS_DISPLAY_RTCP_RRTCOMP)";
  z[lc++]="		{";
  z[lc++]="		  printf(\"    Components\\n\");";
  z[lc++]="		  printf(\"     Current time %fs\\n\", current/65536.0F);";
  z[lc++]="		  printf(\"        Sent time %fs\\n\", sent/65536.0F);";
  z[lc++]="		  printf(\"       Delay time %fs\\n\", delay/65536.0F);";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (error)";
  z[lc++]="	break;";
  z[lc++]="";
  z[lc++]="      complen = 4*complen + 4;";
  z[lc++]="      len -= complen;";
  z[lc++]="      packet += complen;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (error)";
  z[lc++]="    printf(\"error processing RTCP payload\\n\");";
  z[lc++]="  else";
  z[lc++]="    if (NSYS_DISPLAY_RTCP_HDR)";
  z[lc++]="      printf(\"RTCP payload succesfully processed \\n\\n\");";
  z[lc++]="";
  z[lc++]="  printf(\"\\n\");";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   parse new SDES cname subpacket item -- presently not used  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="char * nsys_netin_newcname(unsigned char * packet, int len) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char slen;";
  z[lc++]="  char * ret, * rptr;";
  z[lc++]="";
  z[lc++]="  packet += 8;    /* skip header, assume one csrc */";
  z[lc++]="  len -= 8; ";
  z[lc++]="";
  z[lc++]="  while ((len > 0) && ";
  z[lc++]="	 (packet[NSYS_RTCPLOC_SDESITEM_TYPE] != NSYS_RTCPVAL_SDES_CNAME))";
  z[lc++]="    {";
  z[lc++]="      slen = packet[NSYS_RTCPLOC_SDESITEM_LENGTH];";
  z[lc++]="      len -= 2 + slen;";
  z[lc++]="      packet +=  2 + slen;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((len <= 0) || ";
  z[lc++]="      (packet[NSYS_RTCPLOC_SDESITEM_TYPE] != NSYS_RTCPVAL_SDES_CNAME))";
  z[lc++]="    return NULL;";
  z[lc++]="";
  z[lc++]="  slen = packet[NSYS_RTCPLOC_SDESITEM_LENGTH];";
  z[lc++]="  rptr = ret = calloc(slen + 1, sizeof(char));";
  z[lc++]="  packet += 2;";
  z[lc++]="";
  z[lc++]="  while (slen)";
  z[lc++]="    {";
  z[lc++]="      *(rptr++) = *(packet++);";
  z[lc++]="      slen--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_stderr_size += ";
  z[lc++]="    fprintf(stderr, \"Adding session member: %s\\n\", ret);";
  z[lc++]="  fflush(stderr);";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   parse new BYE subpacket                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_bye(unsigned char * packet, int len) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char sc;";
  z[lc++]="  unsigned long ssrc;";
  z[lc++]="";
  z[lc++]="  if ((len -= 4) <= 0)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  sc = packet[NSYS_RTCPLOC_BYTE1] & NSYS_RTCPVAL_COUNTMASK;";
  z[lc++]="";
  z[lc++]="  while (sc && ((len -= 4) >= 0))";
  z[lc++]="    {";
  z[lc++]="      packet += 4;";
  z[lc++]="      memcpy(&ssrc, packet, sizeof(long));";
  z[lc++]="      ssrc = ntohl(ssrc);";
  z[lc++]="      nsys_delete_ssrc(ssrc, \"RTCP BYE received, deleting\");";
  z[lc++]="      sc--;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                     initialize RR packets                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initrr(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  memset(p, 0, len);";
  z[lc++]="";
  z[lc++]="  /* Version 2, no padding, 0 or 1 reception reports */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = NSYS_RTCPVAL_BYTE1 + (len > NSYS_RTCPLEN_RREMPTY);";
  z[lc++]="";
  z[lc++]="  /* PTYPE RR */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_RR;";
  z[lc++]="";
  z[lc++]="  /* length is number of 32-bit words - 1, in network byte order */";
  z[lc++]="";
  z[lc++]="  nlen = htons((len >> 2) - 1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                     initialize SR packets                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initsr(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  memset(p, 0, len);";
  z[lc++]="";
  z[lc++]="  /* Version 2, no padding, 0 or 1 reception reports */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = NSYS_RTCPVAL_BYTE1 + (len > NSYS_RTCPLEN_SREMPTY);";
  z[lc++]="";
  z[lc++]="  /* PTYPE SR */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_SR;";
  z[lc++]="";
  z[lc++]="  /* length is number of 32-bit words - 1, in network byte order */";
  z[lc++]="";
  z[lc++]="  nlen = htons((len >> 2) - 1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   initialize SDES packets                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initsdes(unsigned char * p, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  memset(p, 0, len);  /* zero-pads end of chunklist */";
  z[lc++]="";
  z[lc++]="  /* one SSRC chunk */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = 1 + NSYS_RTCPVAL_BYTE1;";
  z[lc++]="";
  z[lc++]="  /* PTYPE SDES */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_SDES;";
  z[lc++]="";
  z[lc++]="  /* length is number of 32-bit words - 1, in network byte order */";
  z[lc++]="";
  z[lc++]="  nlen = htons((len >> 2) - 1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  p += NSYS_RTCPLEN_SDESHDR;";
  z[lc++]="  memcpy(p, &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="  p += NSYS_RTCPLEN_SDES_CHUNKHDR;";
  z[lc++]="  p[NSYS_RTCPLOC_SDESITEM_TYPE] = NSYS_RTCPVAL_SDES_CNAME;";
  z[lc++]="  p[NSYS_RTCPLOC_SDESITEM_LENGTH] = nsys_cname_len;";
  z[lc++]="";
  z[lc++]="  p += NSYS_RTCPLEN_SDES_ITEMHDR;";
  z[lc++]="";
  z[lc++]="  strcpy(p, nsys_cname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                   initialize BYE packets                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_rtcp_initbye(unsigned char * p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short nlen;";
  z[lc++]="";
  z[lc++]="  /* Version 2, no padding, 1 BYE */";
  z[lc++]="  ";
  z[lc++]="  p[NSYS_RTCPLOC_BYTE1] = NSYS_RTCPVAL_BYTE1 + 1;";
  z[lc++]="";
  z[lc++]="  /* PTYPE SR */";
  z[lc++]="";
  z[lc++]="  p[NSYS_RTCPLOC_PTYPE] = NSYS_RTCPVAL_BYE;";
  z[lc++]="";
  z[lc++]="  /* BYE is 8 bytes long --> 2 - 1 words --> 1 word len field */";
  z[lc++]="";
  z[lc++]="  nlen = htons(1);";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_LENGTH]), &nlen, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="  /* SSRC of packet sender, in network byte order */";
  z[lc++]="";
  z[lc++]="  memcpy(&(p[NSYS_RTCPLOC_SSRC]), &nsys_myssrc_net, sizeof(long));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level RTCP functions                    */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*                   delete an ssrc                            */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_delete_ssrc(unsigned long ssrc, char * reason)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  struct source * sptr;";
  z[lc++]="  struct source * last;";
  z[lc++]="  int mset, i;";
  z[lc++]="  last = NULL;";
  z[lc++]="  sptr = nsys_ssrc[ssrc & NSYS_HASHMASK];";
  z[lc++]="";
  z[lc++]="  /**************/";
  z[lc++]="  /* find match */";
  z[lc++]="  /**************/";
  z[lc++]="";
  z[lc++]="  while (sptr && (sptr->ssrc != ssrc))";
  z[lc++]="    {";
  z[lc++]="      last = sptr;";
  z[lc++]="      sptr = sptr->xtra;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* leave if no match */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  if (sptr == NULL)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /***************/";
  z[lc++]="  /* update xtra */";
  z[lc++]="  /***************/";
  z[lc++]="";
  z[lc++]="  if (last)";
  z[lc++]="    last->xtra = sptr->xtra;";
  z[lc++]="  else";
  z[lc++]="    nsys_ssrc[ssrc & NSYS_HASHMASK] = sptr->xtra;";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* update prev, next */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  if ((sptr == nsys_srcroot) && (sptr->prev == nsys_srcroot))";
  z[lc++]="    {";
  z[lc++]="      nsys_srcroot = NULL;";
  z[lc++]="      nsys_rtcp_ex |= NSYS_RTCPEX_NULLROOT;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      sptr->prev->next = sptr->next;";
  z[lc++]="      sptr->next->prev = sptr->prev;";
  z[lc++]="      if (nsys_srcroot == sptr)";
  z[lc++]="	nsys_srcroot = sptr->next;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_status(sptr, reason);";
  z[lc++]="";
  z[lc++]="  free(sptr->cname);";
  z[lc++]="  free(sptr->sdp_addr);";
  z[lc++]="  free(sptr->rtp_addr);";
  z[lc++]="  free(sptr->alt_rtp_addr);";
  z[lc++]="  free(sptr->rtcp_addr);";
  z[lc++]="  free(sptr->alt_rtcp_addr);";
  z[lc++]="";
  z[lc++]="  nsys_powerup_mset = mset = sptr->mset;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_MIDI_NUMCHAN; i++)";
  z[lc++]="    if (sptr->jrecv[i])";
  z[lc++]="      {";
  z[lc++]="	sptr->jrecv[i]->next = nsys_recvfree;";
  z[lc++]="	nsys_recvfree = sptr->jrecv[i];";
  z[lc++]="      }";
  z[lc++]="  ";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="  printf(\"mset%i packets expected: %i\\n\", sptr->mset,";
  z[lc++]="	 sptr->hi_ext - sptr->base_seq + 1);";
  z[lc++]="  printf(\"mset%i packets received: %i\\n\", sptr->mset,";
  z[lc++]="	 sptr->received);";
  z[lc++]="  fclose(sptr->tm_fd);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  memset(sptr, 0, sizeof(struct source));";
  z[lc++]="  ";
  z[lc++]="  sptr->mset = mset;";
  z[lc++]="  sptr->next = nsys_srcfree;";
  z[lc++]="  nsys_srcfree = sptr;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*               harvest an unused ssrc slot                   */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="source * nsys_harvest_ssrc(int fd, struct sockaddr_in * ipaddr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  source * sptr, * oldptr;";
  z[lc++]="  unsigned long now, oldtime;";
  z[lc++]="  int found = 0;";
  z[lc++]="";
  z[lc++]="  /* sanity checks */";
  z[lc++]="";
  z[lc++]="  if ((nsys_srcfree != NULL) || (nsys_srcroot == NULL)) ";
  z[lc++]="    return NULL;";
  z[lc++]="";
  z[lc++]="  oldtime = 0;";
  z[lc++]="  now = time(NULL);";
  z[lc++]="";
  z[lc++]="  oldptr = sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="";
  z[lc++]="    if ((fd == nsys_rtp_fd) && ";
  z[lc++]="	(sptr->alt_rtp_addr == NULL) && sptr->rtp_addr && ";
  z[lc++]="	!memcmp(ipaddr, sptr->rtp_addr, sizeof(struct sockaddr_in)))";
  z[lc++]="      {";
  z[lc++]="	found = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    ";
  z[lc++]="    if ((fd == nsys_rtcp_fd) && ";
  z[lc++]="	(sptr->alt_rtcp_addr == NULL) && sptr->rtcp_addr && ";
  z[lc++]="	!memcmp(ipaddr, sptr->rtcp_addr, sizeof(struct sockaddr_in)))";
  z[lc++]="      {";
  z[lc++]="	found = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    if ((sptr->birthtime - now) >= oldtime)";
  z[lc++]="      {";
  z[lc++]="	oldptr = sptr;";
  z[lc++]="	oldtime = sptr->birthtime - now;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    sptr = sptr->next;";
  z[lc++]="    ";
  z[lc++]="  } while (sptr != nsys_srcroot);";
  z[lc++]="";
  z[lc++]="  if (found)";
  z[lc++]="    nsys_delete_ssrc(sptr->ssrc, ";
  z[lc++]="		     \"Remote client restarted, deleting old entry for\");";
  z[lc++]="  else";
  z[lc++]="    nsys_delete_ssrc(oldptr->ssrc, ";
  z[lc++]="		     \"Too many players, increase -bandsize value.\"";
  z[lc++]="		     \" Deleting oldest player\");";
  z[lc++]="";
  z[lc++]="  return nsys_srcfree;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*   state update when an RTP/RTCP packet arrive too late      */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_late_windowcheck(source * sptr, unsigned long tstamp)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned long tdiff;";
  z[lc++]="";
  z[lc++]="  if (sptr->tm_lateflag)";
  z[lc++]="    {";
  z[lc++]="      tdiff = nsys_netout_tstamp - sptr->tm_latetime;";
  z[lc++]="      if (tdiff > (unsigned long)(ARATE*NSYS_SM_LATEWINDOW))";
  z[lc++]="	{";
  z[lc++]="	  sptr->tm_lateflag = 0;";
  z[lc++]="	  sptr->tm_convert = tstamp - nsys_netout_tstamp - sptr->tm_margin;";
  z[lc++]="	  nsys_warning(NSYS_WARN_UNUSUAL, \"Resetting late packet detection\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      sptr->tm_latetime = nsys_netout_tstamp;";
  z[lc++]="      sptr->tm_lateflag = 1;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*      print warning message for truncated RTCP packet        */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_rtcp_trunc(int sub)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch (sub) {";
  z[lc++]="  case NSYS_RTCPVAL_SR:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SR subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_RR:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP RR subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_SDES:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SDES subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_BYE:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SDES subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  case NSYS_RTCPVAL_APP:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP SDES subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    nsys_warning(NSYS_WARN_UNUSUAL, \"RTCP unknown subpacket truncated\");";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/*         initialize debug files for latenotes                */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_latenotes_open(source * sptr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="				";
  z[lc++]="  sptr->tm_first = nsys_netout_tstamp;";
  z[lc++]="  ";
  z[lc++]="  switch (sptr->mset) {";
  z[lc++]="  case 1:";
  z[lc++]="    sptr->tm_fd = fopen(\"mset1.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  case 2:";
  z[lc++]="    sptr->tm_fd = fopen(\"mset2.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  case 3:";
  z[lc++]="    sptr->tm_fd = fopen(\"mset3.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    sptr->tm_fd = fopen(\"toomany.dat\", \"w\");";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  fprintf(sptr->tm_fd,\"1\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"#\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"pairs\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"remote%i\\n\", sptr->mset);";
  z[lc++]="  fprintf(sptr->tm_fd,\"*\\n\");";
  z[lc++]="  fprintf(sptr->tm_fd,\"*\\n\");";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end Network library -- RTCP functions */";
  printlib(lc);
}


void makenet_jsend(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- samidi sender journal functions";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     high-level functions: sending recovery journals          */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*      generate recovery journal for an RTP packet             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_create(unsigned char * packet, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char * p = packet;";
  z[lc++]="  int i, j, channel;";
  z[lc++]="  netout_jsend_state * jsend;";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* add journal header to packet */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  memcpy(p, netout_jsend_header, NSYS_SM_JH_SIZE);";
  z[lc++]="  p += NSYS_SM_JH_SIZE;";
  z[lc++]="  len -= NSYS_SM_JH_SIZE;";
  z[lc++]="";
  z[lc++]="  /****************************/";
  z[lc++]="  /* add chapter(s) if needed */";
  z[lc++]="  /****************************/";
  z[lc++]="";
  z[lc++]="  for (channel = 0; channel < netout_jsend_channel_size; channel++)";
  z[lc++]="    {";
  z[lc++]="      jsend = &(netout_jsend[netout_jsend_channel[channel]]);";
  z[lc++]="";
  z[lc++]="      if (jsend->cheader_seqnum)";
  z[lc++]="	{	  ";
  z[lc++]="";
  z[lc++]="	  if ((len -= (NSYS_SM_CH_LENMASK & jsend->clen)) < 0)";
  z[lc++]="	    {";
  z[lc++]="	      len += (NSYS_SM_CH_LENMASK & jsend->clen);";
  z[lc++]="";
  z[lc++]="	      if (packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_JH_CHANMASK)";
  z[lc++]="		packet[NSYS_SM_JH_LOC_FLAGS]--;";
  z[lc++]="	      else";
  z[lc++]="		packet[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_JH_SETA;";
  z[lc++]="";
  z[lc++]="	      nsys_warning(NSYS_WARN_UNUSUAL, \"Sending an incomplete journal\");";
  z[lc++]="	      continue;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  memcpy(p, jsend->cheader, NSYS_SM_CH_SIZE);";
  z[lc++]="	  p += NSYS_SM_CH_SIZE;";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter P */";
  z[lc++]="	  /*************/";
  z[lc++]="";
  z[lc++]="	  if (jsend->chapterp_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chapterp, NSYS_SM_CP_SIZE);";
  z[lc++]="	      p += NSYS_SM_CP_SIZE;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter W */";
  z[lc++]="	  /*************/";
  z[lc++]="";
  z[lc++]="	  if (jsend->chapterw_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chapterw, NSYS_SM_CW_SIZE);";
  z[lc++]="	      p += NSYS_SM_CW_SIZE;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter N */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptern_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      if (jsend->chaptern_timernum)";
  z[lc++]="		{";
  z[lc++]="		  j = jsend->chaptern_timernum;";
  z[lc++]="		  for (i = jsend->chaptern_size - NSYS_SM_CN_HDRSIZE; ";
  z[lc++]="		       i >= NSYS_SM_CN_HDRSIZE; i -= NSYS_SM_CN_LOGSIZE)";
  z[lc++]="		    if (jsend->chaptern[i+1] & NSYS_SM_CN_CHKY)";
  z[lc++]="		      {";
  z[lc++]="			if (jsend->chaptern_timer[NSYS_SM_CLRS & ";
  z[lc++]="						 jsend->chaptern[i]]";
  z[lc++]="			    < nsys_netout_tstamp)";
  z[lc++]="			  {";
  z[lc++]="			    jsend->chaptern[i+1] &= NSYS_SM_CN_CLRY;";
  z[lc++]="			    jsend->chaptern_timernum--;";
  z[lc++]="			  }";
  z[lc++]="			if ((--j) == 0)";
  z[lc++]="			  break;";
  z[lc++]="		      }";
  z[lc++]="		}";
  z[lc++]="	      memcpy(p, jsend->chaptern, jsend->chaptern_size);";
  z[lc++]="	      p += jsend->chaptern_size;";
  z[lc++]="	      if (jsend->chaptern_sset)";
  z[lc++]="		{";
  z[lc++]="		  for (i = NSYS_SM_CN_HDRSIZE; i < jsend->chaptern_size;";
  z[lc++]="		       i += NSYS_SM_CN_LOGSIZE)";
  z[lc++]="		    jsend->chaptern[i] |= NSYS_SM_SETS;";
  z[lc++]="		  jsend->chaptern_sset = 0;";
  z[lc++]="		}";
  z[lc++]="	      if (jsend->chapterb_size)";
  z[lc++]="		{";
  z[lc++]="		  memcpy(p, &(jsend->chapterb[jsend->chapterb_low]),";
  z[lc++]="			 jsend->chapterb_size);";
  z[lc++]="		  p += jsend->chapterb_size;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	  	  ";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter A */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptera_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chaptera, jsend->chaptera_size);";
  z[lc++]="	      p += jsend->chaptera_size;";
  z[lc++]="	      if (jsend->chaptera_sset)";
  z[lc++]="		{";
  z[lc++]="		  for (i = NSYS_SM_CA_HDRSIZE; i < jsend->chaptera_size;";
  z[lc++]="		       i += NSYS_SM_CA_LOGSIZE)";
  z[lc++]="		    jsend->chaptera[i] |= NSYS_SM_SETS;";
  z[lc++]="		  jsend->chaptera_sset = 0;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter T */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chaptert_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chaptert, NSYS_SM_CT_SIZE);";
  z[lc++]="	      p += NSYS_SM_CT_SIZE;";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  /*************/";
  z[lc++]="	  /* Chapter C */";
  z[lc++]="	  /*************/";
  z[lc++]="	  ";
  z[lc++]="	  if (jsend->chapterc_seqnum)";
  z[lc++]="	    {";
  z[lc++]="	      memcpy(p, jsend->chapterc, jsend->chapterc_size);";
  z[lc++]="	      p += jsend->chapterc_size;";
  z[lc++]="	      if (jsend->chapterc_sset)";
  z[lc++]="		{";
  z[lc++]="		  for (i = NSYS_SM_CC_HDRSIZE; i < jsend->chapterc_size;";
  z[lc++]="		       i += NSYS_SM_CC_LOGSIZE)";
  z[lc++]="		    jsend->chapterc[i] |= NSYS_SM_SETS;";
  z[lc++]="		  jsend->chapterc_sset = 0;";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************/";
  z[lc++]="  /* set S flags  */";
  z[lc++]="  /****************/";
  z[lc++]="";
  z[lc++]="  while (netout_jsend_slist_size > 0)";
  z[lc++]="    *(netout_jsend_slist[--netout_jsend_slist_size]) |= NSYS_SM_SETS; ";
  z[lc++]="";
  z[lc++]="  return (p - packet);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            sender state: add a new MIDI event                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addstate(unsigned char cmd, unsigned char ndata,";
  z[lc++]="				  unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char chan = 0x0F & cmd;";
  z[lc++]="  netout_jsend_state * jsend;";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_send = 0;";
  z[lc++]="";
  z[lc++]="  if (netout_jsend_checkpoint_changed)";
  z[lc++]="    {";
  z[lc++]="      netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_JH_CLRK;";
  z[lc++]="      netout_jsend_checkpoint_changed = 0;";
  z[lc++]="    }";
  z[lc++]="  if ((cmd &= 0xF0) == CSYS_MIDI_NOOP)";
  z[lc++]="    {";
  z[lc++]="      netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_SETS;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  jsend = &(netout_jsend[chan]);";
  z[lc++]="";
  z[lc++]="  if (jsend->cheader_seqnum == 0)";
  z[lc++]="    {  ";
  z[lc++]="      netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] = ((unsigned char)";
  z[lc++]="						   netout_jsend_channel_size);";
  z[lc++]="      netout_jsend_channel[netout_jsend_channel_size++] = chan;";
  z[lc++]="      jsend->clen = ((((unsigned short)chan) << (NSYS_SM_CH_CHANSHIFT + 8)) |";
  z[lc++]="		     NSYS_SM_CH_SIZE);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsend->cheader_seqnum = nsys_netout_seqnum;";
  z[lc++]="  netout_jsend_slist[netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->cheader[NSYS_SM_CH_LOC_FLAGS]);";
  z[lc++]="";
  z[lc++]="  switch (cmd) {";
  z[lc++]="  case CSYS_MIDI_PROGRAM:";
  z[lc++]="    nsys_netout_journal_addprogram(jsend, ndata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_WHEEL:";
  z[lc++]="    nsys_netout_journal_addpwheel(jsend, ndata, vdata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_NOTEON:";
  z[lc++]="    if (vdata)";
  z[lc++]="      {      ";
  z[lc++]="	nsys_netout_journal_addnoteon(jsend, ndata, vdata);";
  z[lc++]="	return;";
  z[lc++]="      }";
  z[lc++]="  case CSYS_MIDI_NOTEOFF:";
  z[lc++]="    nsys_netout_journal_addnoteoff(jsend, ndata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_PTOUCH:";
  z[lc++]="    nsys_netout_journal_addptouch(jsend, ndata, vdata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_CTOUCH:";
  z[lc++]="    nsys_netout_journal_addctouch(jsend, ndata);";
  z[lc++]="    return;";
  z[lc++]="  case CSYS_MIDI_CC:";
  z[lc++]="    nsys_netout_journal_addcontrol(jsend, ndata, vdata);";
  z[lc++]="    return;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            sender state: adds history information            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addhistory(unsigned char cmd, unsigned char ndata,";
  z[lc++]="				    unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char chan = 0x0F & cmd;";
  z[lc++]="  netout_jsend_state * jsend;";
  z[lc++]="";
  z[lc++]="  cmd &= 0xF0;";
  z[lc++]="";
  z[lc++]="  if ((cmd != CSYS_MIDI_PROGRAM) && (cmd != CSYS_MIDI_CC))";
  z[lc++]="    return;";
  z[lc++]="  ";
  z[lc++]="  jsend = &(netout_jsend[chan]);";
  z[lc++]="";
  z[lc++]="  if (jsend->history_active == 0)";
  z[lc++]="    jsend->history_active = 1;";
  z[lc++]="";
  z[lc++]="  switch (cmd & 0xF0) {";
  z[lc++]="  case CSYS_MIDI_PROGRAM:";
  z[lc++]="    jsend->history_program = ndata | NSYS_SM_SETH;";
  z[lc++]="    jsend->history_program_bankc = jsend->history_cc_bankc;";
  z[lc++]="    jsend->history_program_bankf = jsend->history_cc_bankf;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC:  ";
  z[lc++]="    switch (ndata) {";
  z[lc++]="    case CSYS_MIDI_CC_BANKSELECT_MSB:";
  z[lc++]="      jsend->history_cc_bankc = vdata | NSYS_SM_SETH;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_BANKSELECT_LSB:";
  z[lc++]="      jsend->history_cc_bankf = vdata | NSYS_SM_SETH;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_MODWHEEL_MSB:";
  z[lc++]="      jsend->history_cc_modwheel = vdata | NSYS_SM_SETH;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_CHANVOLUME_MSB:";
  z[lc++]="      jsend->history_cc_volume = vdata | NSYS_SM_SETH;";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*    sender state:  trim journal, update checkpoint packet     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_journal_trimstate(source * lptr)";
  z[lc++]="";
  z[lc++]="{ ";
  z[lc++]="  unsigned long minseq;";
  z[lc++]="  source * minsource;";
  z[lc++]="  source * sptr;";
  z[lc++]="  int channel;";
  z[lc++]="  netout_jsend_state * jsend;";
  z[lc++]="";
  z[lc++]="  /********************************************/";
  z[lc++]="  /* localize extension to new last_hiseq_ext */";
  z[lc++]="  /********************************************/";
  z[lc++]="";
  z[lc++]="  if (lptr)";
  z[lc++]="    {";
  z[lc++]="      lptr->last_hiseq_ext &= NSYS_RTPSEQ_LOMASK;";
  z[lc++]="      lptr->last_hiseq_ext |= (nsys_netout_seqnum & NSYS_RTPSEQ_EXMASK);";
  z[lc++]="      if (lptr->last_hiseq_ext > nsys_netout_seqnum)";
  z[lc++]="	lptr->last_hiseq_ext -= NSYS_RTPSEQ_EXINCR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /********************************************/";
  z[lc++]="  /* find source with smallest last_hiseq_ext */";
  z[lc++]="  /********************************************/";
  z[lc++]="";
  z[lc++]="  if (nsys_srcroot == NULL)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  minsource = NULL;";
  z[lc++]="  minseq = NSYS_RTPSEQ_HIGHEST;";
  z[lc++]="  sptr = nsys_srcroot;";
  z[lc++]="";
  z[lc++]="  /* later handle 32-bit wraparound correctly */";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="    if (minseq > sptr->last_hiseq_ext)";
  z[lc++]="      {";
  z[lc++]="	minsource = sptr;";
  z[lc++]="	minseq = sptr->last_hiseq_ext;";
  z[lc++]="      }";
  z[lc++]="  } while ((sptr = sptr->next) != nsys_srcroot);";
  z[lc++]="";
  z[lc++]="  /***************************************/";
  z[lc++]="  /* return if checkpoint is still valid */";
  z[lc++]="  /***************************************/";
  z[lc++]="";
  z[lc++]="  if ((minseq == NSYS_RTPSEQ_HIGHEST) || ";
  z[lc++]="      (minseq == netout_jsend_checkpoint_seqnum))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  /**********************/";
  z[lc++]="  /* update checkpoint  */";
  z[lc++]="  /**********************/";
  z[lc++]="";
  z[lc++]="  netout_jsend_checkpoint_seqnum = minseq;";
  z[lc++]="  nsys_netout_journal_changecheck();";
  z[lc++]="";
  z[lc++]="  if (netout_jsend_channel_size == 0)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  for (channel = netout_jsend_channel_size - 1; channel >= 0; channel--)";
  z[lc++]="    {";
  z[lc++]="      jsend = &(netout_jsend[netout_jsend_channel[channel]]);";
  z[lc++]="";
  z[lc++]="      /*******************************/";
  z[lc++]="      /* drop entire channel, or ... */";
  z[lc++]="      /*******************************/";
  z[lc++]="";
  z[lc++]="      if (jsend->cheader_seqnum <= minseq)";
  z[lc++]="	{";
  z[lc++]="	  nsys_netout_journal_trimchapter(jsend, channel);";
  z[lc++]="";
  z[lc++]="	  if (netout_jsend_channel_size)";
  z[lc++]="	    continue;";
  z[lc++]="	  else";
  z[lc++]="	    break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*****************************************/";
  z[lc++]="      /* ... drop chapters from channel header */";
  z[lc++]="      /*****************************************/";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterp_seqnum && (jsend->chapterp_seqnum <= minseq))";
  z[lc++]="	nsys_netout_journal_trimprogram(jsend);";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterw_seqnum && (jsend->chapterw_seqnum <= minseq))";
  z[lc++]="	nsys_netout_journal_trimpwheel(jsend);";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptert_seqnum && (jsend->chaptert_seqnum <= minseq))";
  z[lc++]="	nsys_netout_journal_trimctouch(jsend);";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterc_seqnum && (jsend->chapterc_seqnum <= minseq))";
  z[lc++]="	nsys_netout_journal_trimallcontrol(jsend); ";
  z[lc++]="";
  z[lc++]="      if (jsend->chapterc_seqnum)";
  z[lc++]="	nsys_netout_journal_trimpartcontrol(jsend, minseq);";
  z[lc++]="      ";
  z[lc++]="      if (jsend->chaptera_seqnum && (jsend->chaptera_seqnum <= minseq))";
  z[lc++]="	nsys_netout_journal_trimallptouch(jsend); ";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptera_seqnum)";
  z[lc++]="	nsys_netout_journal_trimpartptouch(jsend, minseq);";
  z[lc++]="      ";
  z[lc++]="      if (jsend->chaptern_seqnum && (jsend->chaptern_seqnum <= minseq))";
  z[lc++]="	nsys_netout_journal_trimallnote(jsend); ";
  z[lc++]="";
  z[lc++]="      if (jsend->chaptern_seqnum)";
  z[lc++]="	nsys_netout_journal_trimpartnote(jsend, minseq); ";
  z[lc++]="";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons(jsend->clen);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /****************/";
  z[lc++]="  /* housekeeping */";
  z[lc++]="  /****************/";
  z[lc++]="";
  z[lc++]="  if (netout_jsend_channel_size == 0)";
  z[lc++]="    {";
  z[lc++]="      netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_JH_SETA;";
  z[lc++]="      netout_jsend_slist_size =  0;";
  z[lc++]="";
  z[lc++]="      /* uncomment to disable keep-alive empty-journal RTP packets */ ";
  z[lc++]="      /* netout_jsend_guard_time = netout_jsend_guard_send = 0;    */";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] &= (~NSYS_SM_JH_CHANMASK);";
  z[lc++]="      netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= ";
  z[lc++]="	(unsigned char)(netout_jsend_channel_size - 1);";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               ticks down the guard packet timer              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_guard_tick(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  /* enable conditional to disable keep-alive empty-journal RTP packets */";
  z[lc++]="";
  z[lc++]="  if (1 || netout_jsend_channel_size)";
  z[lc++]="    {";
  z[lc++]="      netout_jsend_guard_send = 1;";
  z[lc++]="      netout_jsend_guard_time = netout_jsend_guard_next;";
  z[lc++]="      if ((netout_jsend_guard_next <<= 1) > netout_jsend_guard_maxtime)";
  z[lc++]="	netout_jsend_guard_next = netout_jsend_guard_maxtime;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         add initialization state to recovery journal         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_midistate_init(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int slist_size = netout_jsend_slist_size;";
  z[lc++]="  unsigned long seqsafe;";
  z[lc++]="  netout_jsend_state * jsend;";
  z[lc++]="  unsigned char i, cmd, ndata, vdata, bankc, bankf;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /* seqnum updated so an rtcp packet doesn't delete inits */";
  z[lc++]="";
  z[lc++]="  seqsafe = nsys_netout_seqnum;      ";
  z[lc++]="  nsys_netout_seqnum = ((nsys_netout_seqnum != NSYS_RTPSEQ_HIGHEST) ?";
  z[lc++]="			(nsys_netout_seqnum + 1) : 1); ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /* load recovery journal with initial values */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_MIDI_NUMCHAN; i++)";
  z[lc++]="    {";
  z[lc++]="      jsend = &(netout_jsend[i]);";
  z[lc++]="";
  z[lc++]="      if (jsend->history_active == 0)";
  z[lc++]="	continue;";
  z[lc++]="";
  z[lc++]="      /***********************/";
  z[lc++]="      /* MIDI Program Change */ ";
  z[lc++]="      /***********************/";
  z[lc++]="      ";
  z[lc++]="      bankc = jsend->history_cc_bankc;    /* save before overwrite happens */";
  z[lc++]="      bankf = jsend->history_cc_bankf;";
  z[lc++]="";
  z[lc++]="      if (jsend->history_program)";
  z[lc++]="	{";
  z[lc++]="	  if (jsend->history_program_bankc)";
  z[lc++]="	    {";
  z[lc++]="	      cmd = CSYS_MIDI_CC | i;";
  z[lc++]="	      ndata = CSYS_MIDI_CC_BANKSELECT_MSB;";
  z[lc++]="	      vdata = NSYS_SM_CLRH & jsend->history_program_bankc;";
  z[lc++]="	      nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  if (jsend->history_program_bankf)";
  z[lc++]="	    {";
  z[lc++]="	      cmd = CSYS_MIDI_CC | i;";
  z[lc++]="	      ndata = CSYS_MIDI_CC_BANKSELECT_LSB;";
  z[lc++]="	      vdata = NSYS_SM_CLRH & jsend->history_program_bankf;";
  z[lc++]="	      nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  cmd = CSYS_MIDI_PROGRAM | i;";
  z[lc++]="	  ndata = NSYS_SM_CLRH & jsend->history_program;";
  z[lc++]="	  vdata = 0;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /************************/";
  z[lc++]="      /* MIDI Control Changes */ ";
  z[lc++]="      /************************/";
  z[lc++]="";
  z[lc++]="      cmd = CSYS_MIDI_CC | i;";
  z[lc++]="";
  z[lc++]="      if (bankc)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_BANKSELECT_MSB;";
  z[lc++]="	  vdata = NSYS_SM_CLRH & bankc;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (bankf)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_BANKSELECT_LSB;";
  z[lc++]="	  vdata = NSYS_SM_CLRH & bankf;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->history_cc_modwheel)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_MODWHEEL_MSB;";
  z[lc++]="	  vdata = NSYS_SM_CLRH & jsend->history_cc_modwheel;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (jsend->history_cc_volume)";
  z[lc++]="	{";
  z[lc++]="	  ndata = CSYS_MIDI_CC_CHANVOLUME_MSB;";
  z[lc++]="	  vdata = NSYS_SM_CLRH & jsend->history_cc_volume;";
  z[lc++]="	  nsys_netout_journal_addstate(cmd, ndata, vdata);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      while (netout_jsend_slist_size > slist_size)";
  z[lc++]="	*(netout_jsend_slist[--netout_jsend_slist_size]) |= NSYS_SM_SETS;";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (slist_size == 0)";
  z[lc++]="    netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_SETS;";
  z[lc++]="  ";
  z[lc++]="  while (slist_size > 0)";
  z[lc++]="    *(netout_jsend_slist[--slist_size]) &= NSYS_SM_CLRS;";
  z[lc++]="";
  z[lc++]="  nsys_netout_seqnum = seqsafe;   /* restore nsys_netout_seqnum */";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_send = 1;    ";
  z[lc++]="  netout_jsend_guard_time = netout_jsend_guard_mintime;";
  z[lc++]="  netout_jsend_guard_next = (netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*      second-level journal functions: addstate chapters       */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               add MIDI Program Change chapter                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addprogram(netout_jsend_state * jsend, ";
  z[lc++]="				    unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  jsend->chapterp[NSYS_SM_CP_LOC_PROGRAM] = ndata;";
  z[lc++]="  jsend->chapterp[NSYS_SM_CP_LOC_BANKCOARSE] = jsend->history_cc_bankc;";
  z[lc++]="  jsend->chapterp[NSYS_SM_CP_LOC_BANKFINE] = jsend->history_cc_bankf;";
  z[lc++]="    ";
  z[lc++]="  nsys_netout_journal_addhistory(CSYS_MIDI_PROGRAM | jsend->chan, ndata, 0);";
  z[lc++]="";
  z[lc++]="  netout_jsend_slist[netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chapterp[NSYS_SM_CP_LOC_PROGRAM]);";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterp_seqnum)";
  z[lc++]="    jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETP;";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons((jsend->clen += NSYS_SM_CP_SIZE));";
  z[lc++]="    }";
  z[lc++]="  jsend->chapterp_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_time = netout_jsend_guard_mintime;";
  z[lc++]="  netout_jsend_guard_next = (netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               add MIDI Pitch Wheel chapter                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addpwheel(netout_jsend_state * jsend, ";
  z[lc++]="				unsigned char ndata, unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  jsend->chapterw[NSYS_SM_CW_LOC_FIRST] = ndata;";
  z[lc++]="  jsend->chapterw[NSYS_SM_CW_LOC_SECOND] = vdata;";
  z[lc++]="";
  z[lc++]="  netout_jsend_slist[netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chapterw[NSYS_SM_CW_LOC_FIRST]);";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterw_seqnum)";
  z[lc++]="    jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETW;";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons((jsend->clen += NSYS_SM_CW_SIZE));";
  z[lc++]="    }";
  z[lc++]="  jsend->chapterw_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_time = netout_jsend_guard_mintime;";
  z[lc++]="  netout_jsend_guard_next = (netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI NoteOff chapter                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addnoteoff(netout_jsend_state * jsend, ";
  z[lc++]="				 unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char bitfield;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  bitfield = (ndata >> NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  ";
  z[lc++]="  /******************************/";
  z[lc++]="  /* initialize chapter and TOC */";
  z[lc++]="  /******************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptern_size = NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->chapterb_size = 1;";
  z[lc++]="      jsend->chapterb_low = bitfield;";
  z[lc++]="      jsend->chapterb_high = bitfield;";
  z[lc++]="      ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LENGTH] = 0;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="      jsend->chapterb[bitfield] = 0;";
  z[lc++]="      ";
  z[lc++]="      jsend->clen += 1 + NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETN;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /***************************/";
  z[lc++]="  /* delete expired note log */";
  z[lc++]="  /***************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqarray[ndata] && ";
  z[lc++]="      ((i = jsend->chaptern_logptr[ndata]) < NSYS_SM_CN_SIZE))";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chaptern[i+NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY)";
  z[lc++]="	jsend->chaptern_timernum--;";
  z[lc++]="      memmove(&(jsend->chaptern[i]), ";
  z[lc++]="	      &(jsend->chaptern[i + NSYS_SM_CN_LOGSIZE]),";
  z[lc++]="	      jsend->chaptern_size - i - NSYS_SM_CN_LOGSIZE);";
  z[lc++]="      jsend->chaptern_size -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]--;";
  z[lc++]="      jsend->clen -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="      while (i < jsend->chaptern_size)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptern_logptr[jsend->chaptern[i] & NSYS_SM_CLRS] ";
  z[lc++]="	    -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	  i += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /********************************/";
  z[lc++]="  /* add bitfield bytes if needed */";
  z[lc++]="  /********************************/";
  z[lc++]="  ";
  z[lc++]="  if ((jsend->chapterb_low == NSYS_SM_CN_BFMAX) && ";
  z[lc++]="      (jsend->chapterb_high == NSYS_SM_CN_BFMIN))";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterb_size = 1;";
  z[lc++]="      jsend->chapterb_low = bitfield;";
  z[lc++]="      jsend->chapterb_high = bitfield;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="      jsend->chapterb[bitfield] = 0;";
  z[lc++]="      jsend->clen++;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (bitfield > jsend->chapterb_high)";
  z[lc++]="    {";
  z[lc++]="      memset(&(jsend->chapterb[jsend->chapterb_high + 1]), 0,";
  z[lc++]="	     (bitfield - jsend->chapterb_high));";
  z[lc++]="      jsend->chapterb_size += (bitfield - jsend->chapterb_high);";
  z[lc++]="      jsend->clen += (bitfield - jsend->chapterb_high);";
  z[lc++]="      jsend->chapterb_high = bitfield;	  ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  if (bitfield < jsend->chapterb_low)";
  z[lc++]="    {";
  z[lc++]="      memset(&(jsend->chapterb[bitfield]), 0,";
  z[lc++]="	     (jsend->chapterb_low - bitfield));";
  z[lc++]="      jsend->chapterb_size += (jsend->chapterb_low - bitfield);";
  z[lc++]="      jsend->clen += (jsend->chapterb_low - bitfield);";
  z[lc++]="      jsend->chapterb_low = bitfield;	  ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /*****************/";
  z[lc++]="  /* update slists */";
  z[lc++]="  /*****************/";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptern[NSYS_SM_CN_LOC_LENGTH] &= NSYS_SM_CLRS; ";
  z[lc++]="  netout_jsend_slist[netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]);";
  z[lc++]="  ";
  z[lc++]="  /******************************************************************/";
  z[lc++]="  /* set correct bit in bitfield byte, update channel/chapter state */";
  z[lc++]="  /******************************************************************/";
  z[lc++]="  ";
  z[lc++]="  jsend->chapterb[bitfield] |= (1 << ((~ndata) & NSYS_SM_CN_BFMASK));";
  z[lc++]="  jsend->chaptern_logptr[ndata] = (NSYS_SM_CN_SIZE + bitfield);";
  z[lc++]="  ";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptern_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chaptern_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_time = netout_jsend_guard_mintime;";
  z[lc++]="  netout_jsend_guard_next = (netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               add MIDI NoteOn chapter                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addnoteon(netout_jsend_state * jsend, ";
  z[lc++]="				   unsigned char ndata, unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* initialize chapter and TOC */";
  z[lc++]="  /******************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqnum == 0)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptern_size = NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->chapterb_size = 0;";
  z[lc++]="      jsend->chapterb_low = NSYS_SM_CN_BFMAX;";
  z[lc++]="      jsend->chapterb_high = NSYS_SM_CN_BFMIN;";
  z[lc++]="      ";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LENGTH] = NSYS_SM_CN_SETB;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	 jsend->chapterb_high);";
  z[lc++]="      ";
  z[lc++]="      jsend->clen += NSYS_SM_CN_HDRSIZE;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETN;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /*********************************/";
  z[lc++]="  /* zero expired NoteOff bitfield */";
  z[lc++]="  /*********************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqarray[ndata] && ";
  z[lc++]="      ((i = (jsend->chaptern_logptr[ndata] - NSYS_SM_CN_SIZE)) >= 0))";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptern_seqarray[ndata] = 0;";
  z[lc++]="      jsend->chapterb[i] &= ~(1 << ((~ndata) & NSYS_SM_CN_BFMASK));";
  z[lc++]="      if ((jsend->chapterb[i] == 0) && ";
  z[lc++]="	  ((i == jsend->chapterb_low) || ";
  z[lc++]="	   (i == jsend->chapterb_high)))";
  z[lc++]="	{";
  z[lc++]="	  while (jsend->chapterb_size && ";
  z[lc++]="		 (jsend->chapterb[jsend->chapterb_low] == 0))";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chapterb_low++;";
  z[lc++]="	      jsend->chapterb_size--;";
  z[lc++]="	      jsend->clen--;";
  z[lc++]="	    }";
  z[lc++]="	  while (jsend->chapterb_size && ";
  z[lc++]="		 (jsend->chapterb[jsend->chapterb_high] == 0))";
  z[lc++]="	    {";
  z[lc++]="	      jsend->chapterb_high--;";
  z[lc++]="	      jsend->chapterb_size--;";
  z[lc++]="	      jsend->clen--;";
  z[lc++]="	    }";
  z[lc++]="	  if (jsend->chapterb_size == 0)";
  z[lc++]="	    {	  ";
  z[lc++]="	      jsend->chapterb_low = NSYS_SM_CN_BFMAX;";
  z[lc++]="	      jsend->chapterb_high = NSYS_SM_CN_BFMIN;";
  z[lc++]="	    }";
  z[lc++]="	  jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="	    ((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="	     jsend->chapterb_high);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /********************/";
  z[lc++]="  /* add new note log */";
  z[lc++]="  /********************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptern_seqarray[ndata] == 0)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptern[jsend->chaptern_size +";
  z[lc++]="		     NSYS_SM_CN_LOC_NUM] = ndata;";
  z[lc++]="      jsend->chaptern[jsend->chaptern_size +";
  z[lc++]="		     NSYS_SM_CN_LOC_VEL] = (vdata | NSYS_SM_CN_SETY);";
  z[lc++]="      jsend->chaptern_logptr[ndata] = jsend->chaptern_size;";
  z[lc++]="      jsend->chaptern_timernum++;";
  z[lc++]="      jsend->chaptern_size += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="      jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]++;";
  z[lc++]="      jsend->clen += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      i = jsend->chaptern_logptr[ndata];";
  z[lc++]="      if (!(jsend->chaptern[i+NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY))";
  z[lc++]="	jsend->chaptern_timernum++;";
  z[lc++]="      jsend->chaptern[i+NSYS_SM_CN_LOC_NUM] = ndata;";
  z[lc++]="      jsend->chaptern[i+NSYS_SM_CN_LOC_VEL] = (vdata|NSYS_SM_CN_SETY);";
  z[lc++]="    }";
  z[lc++]="  jsend->chaptern_timer[ndata] = (nsys_netout_tstamp + (int)";
  z[lc++]="				  (ARATE * NSYS_SM_CN_MAXDELAY));";
  z[lc++]="  ";
  z[lc++]="  /********************************/";
  z[lc++]="  /* update channel/chapter state */";
  z[lc++]="  /********************************/";
  z[lc++]="  ";
  z[lc++]="  *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="    htons(jsend->clen);";
  z[lc++]="  jsend->chaptern_sset = 1;";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptern_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chaptern_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  if (netout_jsend_guard_ontime)";
  z[lc++]="    {";
  z[lc++]="      netout_jsend_guard_time = netout_jsend_guard_ontime;";
  z[lc++]="      netout_jsend_guard_next = netout_jsend_guard_mintime;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI Poly Touch chapter                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addptouch(netout_jsend_state * jsend, ";
  z[lc++]="				    unsigned char ndata,";
  z[lc++]="				    unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /*****************************/";
  z[lc++]="  /* initialize chapter header */";
  z[lc++]="  /*****************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptera_seqnum)";
  z[lc++]="    jsend->chaptera[NSYS_SM_CA_LOC_LENGTH] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptera_size = NSYS_SM_CA_HDRSIZE;";
  z[lc++]="      jsend->chaptera[NSYS_SM_CA_LOC_LENGTH] = 0;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETA;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /**************************/";
  z[lc++]="  /* add new controller log */";
  z[lc++]="  /**************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptera_seqarray[ndata] == 0)";
  z[lc++]="    {";
  z[lc++]="      /* put data in chapter a and update state variables */";
  z[lc++]="      ";
  z[lc++]="      if (jsend->chaptera_seqnum)";
  z[lc++]="	jsend->chaptera[NSYS_SM_CA_LOC_LENGTH]++;";
  z[lc++]="      ";
  z[lc++]="      jsend->chaptera[jsend->chaptera_size + ";
  z[lc++]="		     NSYS_SM_CA_LOC_NUM] = ndata;";
  z[lc++]="      jsend->chaptera[jsend->chaptera_size + ";
  z[lc++]="		     NSYS_SM_CA_LOC_PRESSURE] = vdata;";
  z[lc++]="      ";
  z[lc++]="      jsend->chaptera_logptr[ndata] = jsend->chaptera_size;";
  z[lc++]="      jsend->chaptera_size += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="      ";
  z[lc++]="      jsend->clen += (NSYS_SM_CA_LOGSIZE + (jsend->chaptera_seqnum ? 0 :";
  z[lc++]="					    NSYS_SM_CA_HDRSIZE));";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons(jsend->clen);";
  z[lc++]="      ";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      i = jsend->chaptera_logptr[ndata];";
  z[lc++]="      jsend->chaptera[i + NSYS_SM_CA_LOC_NUM] = ndata;";
  z[lc++]="      jsend->chaptera[i + NSYS_SM_CA_LOC_PRESSURE] = vdata;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /*****************/";
  z[lc++]="  /* update slists */";
  z[lc++]="  /*****************/";
  z[lc++]="  ";
  z[lc++]="  netout_jsend_slist[netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chaptera[NSYS_SM_CA_LOC_LENGTH]);";
  z[lc++]="  jsend->chaptera_sset = 1;";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptera_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chaptera_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_time = netout_jsend_guard_mintime;";
  z[lc++]="  netout_jsend_guard_next = (netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI Channel Touch chapter              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addctouch(netout_jsend_state * jsend, ";
  z[lc++]="				 unsigned char ndata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  jsend->chaptert[NSYS_SM_CT_LOC_PRESSURE] = ndata;";
  z[lc++]="";
  z[lc++]="  netout_jsend_slist[netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chaptert[NSYS_SM_CT_LOC_PRESSURE]);";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chaptert_seqnum)";
  z[lc++]="    jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETT;";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons((jsend->clen += NSYS_SM_CT_SIZE));";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  jsend->chaptert_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_time = netout_jsend_guard_mintime;";
  z[lc++]="  netout_jsend_guard_next = (netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  add MIDI Controller chapter                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_addcontrol(netout_jsend_state * jsend, ";
  z[lc++]="				    unsigned char ndata,";
  z[lc++]="				    unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /*****************************/";
  z[lc++]="  /* initialize chapter header */";
  z[lc++]="  /*****************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterc_seqnum)";
  z[lc++]="    jsend->chapterc[NSYS_SM_CC_LOC_LENGTH] &= NSYS_SM_CLRS;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterc_size = NSYS_SM_CC_HDRSIZE;";
  z[lc++]="      jsend->chapterc[NSYS_SM_CC_LOC_LENGTH] = 0;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_TOC] |= NSYS_SM_CH_TOC_SETC;";
  z[lc++]="    }";
  z[lc++]="    ";
  z[lc++]="  /**************************/";
  z[lc++]="  /* update ancillary state */";
  z[lc++]="  /**************************/";
  z[lc++]="";
  z[lc++]="  nsys_netout_journal_addhistory(CSYS_MIDI_CC | jsend->chan, ndata, vdata);";
  z[lc++]="";
  z[lc++]="  switch (ndata) {";
  z[lc++]="  case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="    if (!(jsend->chapterc_allnotes = ((jsend->chapterc_allnotes + 1)  ";
  z[lc++]="				      & NSYS_SM_CC_MODULO)))";
  z[lc++]="      jsend->chapterc_allnotes++;";
  z[lc++]="    vdata = jsend->chapterc_allnotes;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="    if (!(jsend->chapterc_allsound = ((jsend->chapterc_allsound + 1)";
  z[lc++]="				      & NSYS_SM_CC_MODULO)))";
  z[lc++]="      jsend->chapterc_allsound++;";
  z[lc++]="    vdata = jsend->chapterc_allsound;";
  z[lc++]="    break;";
  z[lc++]="  case CSYS_MIDI_CC_SUSTAIN:";
  z[lc++]="    if (vdata == 0)";
  z[lc++]="      jsend->chapterc_sustain &= NSYS_SM_CC_CLRP;  /* pedal lifted, clear p */";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	if (jsend->chapterc_sustain & NSYS_SM_CC_CHKP)";
  z[lc++]="	  vdata = jsend->chapterc_sustain & NSYS_SM_CC_CLRP;  /* still down */";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    /* pedal was lifted, now depressed --> update ccccccc */";
  z[lc++]="";
  z[lc++]="	    if (!(jsend->chapterc_sustain = ";
  z[lc++]="		  (jsend->chapterc_sustain + 1) & NSYS_SM_CC_MODULO))";
  z[lc++]="	      jsend->chapterc_sustain++; ";
  z[lc++]="";
  z[lc++]="	    vdata = jsend->chapterc_sustain;";
  z[lc++]="	    jsend->chapterc_sustain |= NSYS_SM_CC_SETP;";
  z[lc++]="	  }";
  z[lc++]="      }";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  /**************************/";
  z[lc++]="  /* add new controller log */";
  z[lc++]="  /**************************/";
  z[lc++]="  ";
  z[lc++]="  if (jsend->chapterc_seqarray[ndata] == 0)";
  z[lc++]="    {";
  z[lc++]="      /* put data in chapter c and update state variables */";
  z[lc++]="      ";
  z[lc++]="      if (jsend->chapterc_seqnum)";
  z[lc++]="	jsend->chapterc[NSYS_SM_CC_LOC_LENGTH]++;";
  z[lc++]="      ";
  z[lc++]="      jsend->chapterc[jsend->chapterc_size + ";
  z[lc++]="		     NSYS_SM_CC_LOC_LNUM] = ndata;";
  z[lc++]="      jsend->chapterc[jsend->chapterc_size + ";
  z[lc++]="		     NSYS_SM_CC_LOC_LVAL] = vdata;";
  z[lc++]="      ";
  z[lc++]="      jsend->chapterc_logptr[ndata] = jsend->chapterc_size;";
  z[lc++]="      jsend->chapterc_size += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="      ";
  z[lc++]="      jsend->clen += (NSYS_SM_CC_LOGSIZE + (jsend->chapterc_seqnum ? 0 :";
  z[lc++]="					    NSYS_SM_CC_HDRSIZE));";
  z[lc++]="      ";
  z[lc++]="      *((unsigned short *) &(jsend->cheader[NSYS_SM_CH_LOC_LEN])) = ";
  z[lc++]="	htons(jsend->clen);";
  z[lc++]="      ";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      i = jsend->chapterc_logptr[ndata];";
  z[lc++]="      jsend->chapterc[i + NSYS_SM_CC_LOC_LNUM] = ndata;";
  z[lc++]="      jsend->chapterc[i + NSYS_SM_CC_LOC_LVAL] = vdata;";
  z[lc++]="      jsend->cheader[NSYS_SM_CH_LOC_FLAGS] &= NSYS_SM_CLRS;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /*****************/";
  z[lc++]="  /* update slists */";
  z[lc++]="  /*****************/";
  z[lc++]="  ";
  z[lc++]="  netout_jsend_slist[netout_jsend_slist_size++] = ";
  z[lc++]="    &(jsend->chapterc[NSYS_SM_CC_LOC_LENGTH]);";
  z[lc++]="  jsend->chapterc_sset = 1;";
  z[lc++]="  ";
  z[lc++]="  jsend->chapterc_seqarray[ndata] = nsys_netout_seqnum;";
  z[lc++]="  jsend->chapterc_seqnum = nsys_netout_seqnum;";
  z[lc++]="";
  z[lc++]="  netout_jsend_guard_time = netout_jsend_guard_mintime;";
  z[lc++]="  netout_jsend_guard_next = (netout_jsend_guard_mintime << ";
  z[lc++]="			     (nsys_feclevel == NSYS_SM_FEC_MINIMAL));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*      second-level journal functions: trimstate chapters      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                  trim entire chapter                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimchapter(netout_jsend_state * jsend, ";
  z[lc++]="				     int channel)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k;";
  z[lc++]="";
  z[lc++]="  memset(jsend->cheader, 0, NSYS_SM_CH_SIZE);";
  z[lc++]="  jsend->cheader_seqnum = 0;";
  z[lc++]="  jsend->chapterp_seqnum = 0;";
  z[lc++]="  jsend->chapterw_seqnum = 0;";
  z[lc++]="  jsend->chaptert_seqnum = 0;";
  z[lc++]="";
  z[lc++]="  jsend->chapterc_seqnum = 0;";
  z[lc++]="  while (jsend->chapterc_size > NSYS_SM_CC_HDRSIZE)";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterc_size -= NSYS_SM_CC_LOGSIZE;";
  z[lc++]="      i = jsend->chapterc[jsend->chapterc_size];";
  z[lc++]="	      jsend->chapterc_seqarray[NSYS_SM_CC_CLRF & i] = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsend->chaptera_seqnum = 0;";
  z[lc++]="  while (jsend->chaptera_size > NSYS_SM_CA_HDRSIZE)";
  z[lc++]="    {";
  z[lc++]="      jsend->chaptera_size -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="      i = jsend->chaptera[jsend->chaptera_size];";
  z[lc++]="	      jsend->chaptera_seqarray[NSYS_SM_CA_CLRF & i] = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsend->chaptern_seqnum = 0;";
  z[lc++]="  for (j = NSYS_SM_CN_HDRSIZE; j < jsend->chaptern_size;";
  z[lc++]="       j += NSYS_SM_CN_LOGSIZE)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptern[j];";
  z[lc++]="      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="    }";
  z[lc++]="  i = (jsend->chapterb_low << NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  for (j = jsend->chapterb_low; j <= jsend->chapterb_high; j++)";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chapterb[j])";
  z[lc++]="	for (k = 128; k >= 1; k = (k >> 1))";
  z[lc++]="	  {";
  z[lc++]="	    if (jsend->chapterb[j] & k)";
  z[lc++]="	      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="	    i++;";
  z[lc++]="	  }";
  z[lc++]="      else";
  z[lc++]="	i += 8;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  jsend->chapterc_sset = 0;";
  z[lc++]="  jsend->chaptera_sset = 0;";
  z[lc++]="  jsend->chaptern_sset = 0;";
  z[lc++]="  jsend->chaptern_timernum = 0;";
  z[lc++]="";
  z[lc++]="  if (channel < (--netout_jsend_channel_size))";
  z[lc++]="    memmove(&(netout_jsend_channel[channel]), ";
  z[lc++]="	    &(netout_jsend_channel[channel+1]),";
  z[lc++]="	    sizeof(unsigned char)* (netout_jsend_channel_size -";
  z[lc++]="				    channel));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim program change chapter                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimprogram(netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  jsend->chapterp_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRP;";
  z[lc++]="  jsend->clen -= NSYS_SM_CP_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim pitch wheel chapter                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpwheel(netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  jsend->chapterw_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRW;";
  z[lc++]="  jsend->clen -= NSYS_SM_CW_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim channel touch chapter                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimctouch(netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  jsend->chaptert_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRT;";
  z[lc++]="  jsend->clen -= NSYS_SM_CT_SIZE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire controller chapter               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallcontrol(netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  jsend->chapterc_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRC;";
  z[lc++]="  jsend->clen -= jsend->chapterc_size;";
  z[lc++]="  j = NSYS_SM_CC_HDRSIZE;";
  z[lc++]="  while (j < jsend->chapterc_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CC_CLRF & jsend->chapterc[j];";
  z[lc++]="      jsend->chapterc_seqarray[i] = 0;";
  z[lc++]="      j += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="  jsend->chapterc_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 partially trim controller chapter            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartcontrol(netout_jsend_state * jsend, ";
  z[lc++]="					 unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = NSYS_SM_CC_HDRSIZE;";
  z[lc++]="  while (j < jsend->chapterc_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CC_CLRF & jsend->chapterc[j];";
  z[lc++]="      if (jsend->chapterc_seqarray[i] <= minseq)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chapterc_seqarray[i] = 0;";
  z[lc++]="	  memmove(&(jsend->chapterc[j]), ";
  z[lc++]="		  &(jsend->chapterc[j + NSYS_SM_CC_LOGSIZE]),";
  z[lc++]="		  jsend->chapterc_size - j - NSYS_SM_CC_LOGSIZE);";
  z[lc++]="	  jsend->clen -= NSYS_SM_CC_LOGSIZE;";
  z[lc++]="	  jsend->chapterc_size -= NSYS_SM_CC_LOGSIZE;";
  z[lc++]="	  jsend->chapterc[NSYS_SM_CC_LOC_LENGTH]--;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chapterc_logptr[i] = j;";
  z[lc++]="	  j += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire poly touch chapter               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallptouch(netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  jsend->chaptera_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRA;";
  z[lc++]="  jsend->clen -= jsend->chaptera_size;";
  z[lc++]="  j = NSYS_SM_CA_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptera_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CA_CLRF & jsend->chaptera[j];";
  z[lc++]="      jsend->chaptera_seqarray[i] = 0;";
  z[lc++]="      j += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="  jsend->chaptera_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 partially trim poly touch chapter            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartptouch(netout_jsend_state * jsend, ";
  z[lc++]="					unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = NSYS_SM_CA_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptera_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CA_CLRF & jsend->chaptera[j];";
  z[lc++]="      if (jsend->chaptera_seqarray[i] <= minseq)";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptera_seqarray[i] = 0;";
  z[lc++]="	  memmove(&(jsend->chaptera[j]), ";
  z[lc++]="		  &(jsend->chaptera[j + NSYS_SM_CA_LOGSIZE]),";
  z[lc++]="		  jsend->chaptera_size - j - NSYS_SM_CA_LOGSIZE);";
  z[lc++]="	  jsend->clen -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	  jsend->chaptera_size -= NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	  jsend->chaptera[NSYS_SM_CA_LOC_LENGTH]--;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptera_logptr[i] = j;";
  z[lc++]="	  j += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire note chapter                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimallnote(netout_jsend_state * jsend) ";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  int i, j, k;";
  z[lc++]="";
  z[lc++]="  jsend->chaptern_seqnum = 0;";
  z[lc++]="  jsend->cheader[NSYS_SM_CH_LOC_TOC] &= NSYS_SM_CH_TOC_CLRN;";
  z[lc++]="  jsend->clen -= (jsend->chaptern_size + jsend->chapterb_size);";
  z[lc++]="  ";
  z[lc++]="  for (j = NSYS_SM_CN_HDRSIZE; j < jsend->chaptern_size;";
  z[lc++]="       j += NSYS_SM_CN_LOGSIZE)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptern[j];";
  z[lc++]="      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="    }";
  z[lc++]="  i = (jsend->chapterb_low << NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  for (j = jsend->chapterb_low; j <= jsend->chapterb_high; j++)";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chapterb[j])";
  z[lc++]="	for (k = 128; k >= 1; k = (k >> 1))";
  z[lc++]="	  {";
  z[lc++]="	    if (jsend->chapterb[j] & k) ";
  z[lc++]="	      jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="	    i++;";
  z[lc++]="	  }";
  z[lc++]="      else";
  z[lc++]="	i += 8;";
  z[lc++]="    }";
  z[lc++]="  jsend->chaptern_timernum = 0;";
  z[lc++]="  jsend->chaptern_sset = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 trim entire note chapter                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_trimpartnote(netout_jsend_state * jsend, ";
  z[lc++]="				      unsigned long minseq)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k;";
  z[lc++]="";
  z[lc++]="  /* first prune note logs */";
  z[lc++]="  ";
  z[lc++]="  j = NSYS_SM_CN_HDRSIZE;";
  z[lc++]="  while (j < jsend->chaptern_size)";
  z[lc++]="    {";
  z[lc++]="      i = NSYS_SM_CLRS & jsend->chaptern[j];";
  z[lc++]="      if (jsend->chaptern_seqarray[i] <= minseq)";
  z[lc++]="	{	  ";
  z[lc++]="	  if (jsend->chaptern[i+NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY)";
  z[lc++]="	    jsend->chaptern_timernum--;";
  z[lc++]="	  jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="	  memmove(&(jsend->chaptern[j]), ";
  z[lc++]="		  &(jsend->chaptern[j + NSYS_SM_CN_LOGSIZE]),";
  z[lc++]="		  jsend->chaptern_size - j - NSYS_SM_CN_LOGSIZE);";
  z[lc++]="	  jsend->clen -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	  jsend->chaptern_size -= NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	  jsend->chaptern[NSYS_SM_CN_LOC_LENGTH]--;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  jsend->chaptern_logptr[i] = j;";
  z[lc++]="	  j += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /* then prune bitfields */";
  z[lc++]="  ";
  z[lc++]="  i = (jsend->chapterb_low << NSYS_SM_CN_BFSHIFT);";
  z[lc++]="  for (j = jsend->chapterb_low; j <= jsend->chapterb_high; j++)";
  z[lc++]="    {";
  z[lc++]="      if (jsend->chapterb[j])";
  z[lc++]="	for (k = 128; k >= 1; k = (k >> 1))";
  z[lc++]="	  {";
  z[lc++]="	    if ((jsend->chapterb[j] & k) && ";
  z[lc++]="		(jsend->chaptern_seqarray[i] <= minseq))";
  z[lc++]="	      {";
  z[lc++]="		jsend->chaptern_seqarray[i] = 0;";
  z[lc++]="		jsend->chapterb[j] &= ~k;";
  z[lc++]="	      }";
  z[lc++]="	    i++;";
  z[lc++]="	  }";
  z[lc++]="      else";
  z[lc++]="	i += 8;";
  z[lc++]="      if ((j == jsend->chapterb_low) && ";
  z[lc++]="	  (jsend->chapterb[j] == 0))";
  z[lc++]="	{";
  z[lc++]="	  jsend->chapterb_low++;";
  z[lc++]="	  jsend->chapterb_size--;";
  z[lc++]="	  jsend->clen--;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  while (jsend->chapterb_size && ";
  z[lc++]="	 (jsend->chapterb[jsend->chapterb_high] == 0))";
  z[lc++]="    {";
  z[lc++]="      jsend->chapterb_high--;";
  z[lc++]="      jsend->chapterb_size--;";
  z[lc++]="      jsend->clen--;";
  z[lc++]="    }";
  z[lc++]="  if (jsend->chapterb_size == 0)";
  z[lc++]="    {	 ";
  z[lc++]="      jsend->chapterb_low = NSYS_SM_CN_BFMAX;";
  z[lc++]="      jsend->chapterb_high = NSYS_SM_CN_BFMIN;";
  z[lc++]="    }";
  z[lc++]="  jsend->chaptern[NSYS_SM_CN_LOC_LOWHIGH] = ";
  z[lc++]="    ((jsend->chapterb_low << NSYS_SM_CN_LOWSHIFT) |";
  z[lc++]="     jsend->chapterb_high);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*      second-level journal functions: miscellaneous           */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           updates state after checkpoint change              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netout_journal_changecheck(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned short check_seqnum_net;";
  z[lc++]="";
  z[lc++]="  netout_jsend_checkpoint_changed = 1;";
  z[lc++]="  netout_jsend_header[NSYS_SM_JH_LOC_FLAGS] |= NSYS_SM_JH_SETK;";
  z[lc++]="  check_seqnum_net = htons((unsigned short) (NSYS_RTPSEQ_LOMASK &";
  z[lc++]="					     netout_jsend_checkpoint_seqnum));";
  z[lc++]="  memcpy(&(netout_jsend_header[NSYS_SM_JH_LOC_CHECK]),";
  z[lc++]="	 &check_seqnum_net, sizeof(unsigned short));";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level journal functions                 */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* end Network library -- sender journal functions */";
  printlib(lc);
}


void makenet_jrecv(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- samidi receiver journal functions";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#ifndef NSYS_NET";
  z[lc++]="#include \"net_include.h\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     high-level functions: receiving recovery journals        */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          main routine for parsing recovery journal           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_recovery(source * sptr, int rtpcode, ";
  z[lc++]="				unsigned char * packet,";
  z[lc++]="				int numbytes, unsigned char * buff,  ";
  z[lc++]="				long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  netout_jrecv_state * jrecv;";
  z[lc++]="  int numchan, bflag, i, j;";
  z[lc++]="  short chanlen, loglen;";
  z[lc++]="  unsigned char chapters, chan, low, high, many;";
  z[lc++]="  unsigned char * checkptr, * p;";
  z[lc++]="";
  z[lc++]="  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="    {";
  z[lc++]="      printf(\"\\ndoing recovery for mset%i (fill: %i)\\n\", sptr->mset, ";
  z[lc++]="	     (j = (*fill))); ";
  z[lc++]="";
  z[lc++]="#if (NSYS_LATENOTES_DEBUG == NSYS_LATENOTES_DEBUG_ON)";
  z[lc++]="      if (sptr->tm_margin)";
  z[lc++]="	printf(\"Time: %f\\n\", (nsys_netout_tstamp - sptr->tm_first)/ARATE);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="      fflush(stdout);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((numbytes -= (1 + ((NSYS_SM_MLENMAX & (*packet))))) < NSYS_SM_JH_SIZE) ";
  z[lc++]="    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="  packet += 1 + (NSYS_SM_MLENMAX & (*packet));";
  z[lc++]="  many = (rtpcode == NSYS_RTPCODE_LOSTMANY);";
  z[lc++]="";
  z[lc++]="  if ((packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_JH_CHKA) || ";
  z[lc++]="      ((packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_CHKS) && (!many)))";
  z[lc++]="    return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="";
  z[lc++]="  numchan =  (packet[NSYS_SM_JH_LOC_FLAGS] & NSYS_SM_JH_CHANMASK) + 1;";
  z[lc++]="  checkptr = &(packet[NSYS_SM_JH_LOC_CHECK]);";
  z[lc++]="";
  z[lc++]="  numbytes -= NSYS_SM_JH_SIZE;";
  z[lc++]="  packet += NSYS_SM_JH_SIZE;";
  z[lc++]="";
  z[lc++]="  while (numchan--)";
  z[lc++]="    {";
  z[lc++]="      if (numbytes < NSYS_SM_CH_SIZE)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      chan = ((packet[NSYS_SM_CH_LOC_FLAGS] & NSYS_SM_CH_CHANMASK)";
  z[lc++]="	      >> NSYS_SM_CH_CHANSHIFT);";
  z[lc++]="";
  z[lc++]="      if ((jrecv = sptr->jrecv[chan]) == NULL)";
  z[lc++]="	jrecv = sptr->jrecv[chan] = nsys_netin_newrecv(chan);";
  z[lc++]="";
  z[lc++]="      chapters = packet[NSYS_SM_CH_LOC_TOC];";
  z[lc++]="      chanlen = *((short *)&(packet[NSYS_SM_CH_LOC_FLAGS]));";
  z[lc++]="      chanlen = ntohs((unsigned short)chanlen) & NSYS_SM_CH_LENMASK;";
  z[lc++]="      ";
  z[lc++]="      if ((numbytes -= chanlen) < 0)";
  z[lc++]="	return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="      p = packet + NSYS_SM_CH_SIZE;";
  z[lc++]="      packet += chanlen;";
  z[lc++]="";
  z[lc++]="      /*****************************/";
  z[lc++]="      /* chapter P: Program Change */";
  z[lc++]="      /*****************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETP)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CP_SIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CP_LOC_PROGRAM] & NSYS_SM_CHKS)) || many) && ";
  z[lc++]="	      nsys_netin_jrec_program(sptr, p, jrecv, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CP_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter W: Pitch Wheel */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETW)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CW_SIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CW_LOC_FIRST] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_wheel(sptr, p, jrecv, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CW_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter N: Note On/Off */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETN)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CN_HDRSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen = p[NSYS_SM_CN_LOC_LENGTH] & NSYS_SM_CN_CLRB;";
  z[lc++]="	  bflag = !(p[NSYS_SM_CN_LOC_LENGTH] & NSYS_SM_CN_CHKB);";
  z[lc++]="	  low = ((p[NSYS_SM_CN_LOC_LOWHIGH] & NSYS_SM_CN_LOWMASK) >>";
  z[lc++]="		 NSYS_SM_CN_LOWSHIFT);";
  z[lc++]="	  high = (p[NSYS_SM_CN_LOC_LOWHIGH] & NSYS_SM_CN_HIGHMASK);";
  z[lc++]="";
  z[lc++]="	  if ((chanlen -= (loglen*NSYS_SM_CN_LOGSIZE + ";
  z[lc++]="			   ((low <= high) ? (high - low + 1) : 0))) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CN_HDRSIZE;";
  z[lc++]="";
  z[lc++]="	  if (loglen)";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_netin_jrec_notelog(sptr, p, jrecv, many, loglen,";
  z[lc++]="					  checkptr, buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	      p += loglen*NSYS_SM_CN_LOGSIZE;";
  z[lc++]="	    }";
  z[lc++]="	  if ((bflag || many) && (low <= high))";
  z[lc++]="	    {	      ";
  z[lc++]="	      if (nsys_netin_jrec_bitfield(sptr, p, jrecv, low, high,";
  z[lc++]="					   buff, fill, size))";
  z[lc++]="		return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  p += (low <= high) ? (high - low + 1) : 0;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter A: Poly Touch */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETA)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CA_HDRSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ";
  z[lc++]="	  loglen = (p[NSYS_SM_CA_LOC_LENGTH] & NSYS_SM_CLRS) + 1;";
  z[lc++]="";
  z[lc++]="	  if ((chanlen -= loglen*NSYS_SM_CA_LOGSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CA_LOC_LENGTH] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_ptouch(sptr, p, jrecv, loglen, many,";
  z[lc++]="				     buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += (NSYS_SM_CA_HDRSIZE + loglen*NSYS_SM_CA_LOGSIZE);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /****************************/";
  z[lc++]="      /* chapter T: Channel Touch */";
  z[lc++]="      /****************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETT)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CT_SIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  if (((!(p[NSYS_SM_CT_LOC_PRESSURE] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_ctouch(sptr, p, jrecv, buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += NSYS_SM_CT_SIZE;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /**************************/";
  z[lc++]="      /* chapter C: Controllers */";
  z[lc++]="      /**************************/";
  z[lc++]="";
  z[lc++]="      if (chapters & NSYS_SM_CH_TOC_SETC)";
  z[lc++]="	{";
  z[lc++]="	  if ((chanlen -= NSYS_SM_CC_HDRSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="";
  z[lc++]="	  loglen = (p[NSYS_SM_CC_LOC_LENGTH] & NSYS_SM_CLRS) + 1;";
  z[lc++]="";
  z[lc++]="	  if ((chanlen -= loglen*NSYS_SM_CC_LOGSIZE) < 0)";
  z[lc++]="	    return NSYS_JOURNAL_CORRUPTED;";
  z[lc++]="	  ";
  z[lc++]="	  if (((!(p[NSYS_SM_CC_LOC_LENGTH] & NSYS_SM_CHKS)) || many) &&";
  z[lc++]="	      nsys_netin_jrec_control(sptr, p, jrecv, loglen, many,";
  z[lc++]="				      buff, fill, size))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="	  p += (NSYS_SM_CC_HDRSIZE + loglen*NSYS_SM_CC_LOGSIZE);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="    {";
  z[lc++]="      printf(\"recovery (fill: %li):\", (*fill));";
  z[lc++]="      for (i = 0; j + i < (*fill); i++)";
  z[lc++]="	printf(\" %hhu\", buff[j - (*fill) + i]);";
  z[lc++]="      printf(\"\\n\");";
  z[lc++]="      fflush(stdout);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            receiver state: add a new MIDI event              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_netin_journal_trackstate(source * sptr, unsigned char cmd,";
  z[lc++]="				   unsigned char ndata, unsigned char vdata)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  netout_jrecv_state * jrecv;";
  z[lc++]="";
  z[lc++]="  if ((jrecv = sptr->jrecv[cmd & 0x0F]) == NULL)";
  z[lc++]="    jrecv = sptr->jrecv[cmd & 0x0F] = nsys_netin_newrecv(cmd & 0x0F);";
  z[lc++]="";
  z[lc++]="  switch (cmd & 0xF0) {";
  z[lc++]="";
  z[lc++]="  case CSYS_MIDI_PROGRAM:";
  z[lc++]="    jrecv->chapterp_program = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="    jrecv->chapterp_bankc = NSYS_SM_RV_CLRF & ";
  z[lc++]="      jrecv->chapterc_value[CSYS_MIDI_CC_BANKSELECT_MSB];";
  z[lc++]="    jrecv->chapterp_bankf = NSYS_SM_RV_CLRF & ";
  z[lc++]="      jrecv->chapterc_value[CSYS_MIDI_CC_BANKSELECT_LSB];";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case CSYS_MIDI_WHEEL:";
  z[lc++]="    jrecv->chapterw_first = ndata | NSYS_SM_RV_SETF;";
  z[lc++]="    jrecv->chapterw_second = vdata;";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case CSYS_MIDI_NOTEOFF:";
  z[lc++]="    jrecv->chaptern_vel[ndata] = NSYS_SM_RV_SETF;";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case CSYS_MIDI_NOTEON:";
  z[lc++]="    if (vdata)";
  z[lc++]="      {";
  z[lc++]="	jrecv->chaptern_vel[ndata] = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="	jrecv->chaptern_tstamp[ndata] = nsys_netout_tstamp;";
  z[lc++]="	jrecv->chaptern_extseq[ndata] = sptr->hi_ext;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      jrecv->chaptern_vel[ndata] = NSYS_SM_RV_SETF;";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case CSYS_MIDI_PTOUCH:";
  z[lc++]="    jrecv->chaptera_pressure[ndata] = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case CSYS_MIDI_CTOUCH:";
  z[lc++]="    jrecv->chaptert_pressure = ndata | NSYS_SM_RV_SETF;";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case CSYS_MIDI_CC:";
  z[lc++]="    switch (ndata) {";
  z[lc++]="    case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="    case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="      jrecv->chapterc_value[ndata] = ((jrecv->chapterc_value[ndata] + 1) |   ";
  z[lc++]="				      NSYS_SM_RV_SETF);";
  z[lc++]="      if (jrecv->chapterc_value[ndata] == NSYS_SM_RV_SETF)";
  z[lc++]="	jrecv->chapterc_value[ndata]++;";
  z[lc++]="      break;";
  z[lc++]="    case CSYS_MIDI_CC_SUSTAIN:";
  z[lc++]="      if (vdata)";
  z[lc++]="	{";
  z[lc++]="	  if ((jrecv->chapterc_value[ndata] & NSYS_SM_CC_CLRF) == 0)";
  z[lc++]="	    {";
  z[lc++]="	      if (!(jrecv->chapterc_sustain = ";
  z[lc++]="		    (jrecv->chapterc_sustain + 1) & NSYS_SM_CC_MODULO))";
  z[lc++]="		jrecv->chapterc_sustain++;";
  z[lc++]="	    }";
  z[lc++]="	  vdata = jrecv->chapterc_sustain;";
  z[lc++]="	}";
  z[lc++]="      /* falls through */";
  z[lc++]="    default:";
  z[lc++]="      jrecv->chapterc_value[ndata] = vdata | NSYS_SM_RV_SETF;";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 second-level receiver functions              */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter P (program change)             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_program(source * sptr, unsigned char * p,";
  z[lc++]="			  netout_jrecv_state * jrecv,";
  z[lc++]="			  unsigned char * buff,  ";
  z[lc++]="			  long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy, vel, yflag;";
  z[lc++]="";
  z[lc++]="  vel = (p[NSYS_SM_CP_LOC_PROGRAM] & NSYS_SM_CLRS);";
  z[lc++]="  newx = (p[NSYS_SM_CP_LOC_BANKCOARSE] & NSYS_SM_CP_CLRC);";
  z[lc++]="  newy = (p[NSYS_SM_CP_LOC_BANKFINE] & NSYS_SM_CP_CLRF);";
  z[lc++]="  ";
  z[lc++]="  if ((jrecv->chapterp_program == 0) || ";
  z[lc++]="      (newx != jrecv->chapterp_bankc) || ";
  z[lc++]="      (newy != jrecv->chapterp_bankf) ||";
  z[lc++]="      (vel != (jrecv->chapterp_program & NSYS_SM_RV_CLRF)))";
  z[lc++]="    {";
  z[lc++]="      yflag = ((newx != (NSYS_SM_CLRS & jrecv->chapterc_value";
  z[lc++]="			 [CSYS_MIDI_CC_BANKSELECT_MSB])) ||";
  z[lc++]="	       (newy != (NSYS_SM_CLRS & jrecv->chapterc_value";
  z[lc++]="			 [CSYS_MIDI_CC_BANKSELECT_LSB])) ||";
  z[lc++]="	       (jrecv->chapterc_value";
  z[lc++]="		[CSYS_MIDI_CC_BANKSELECT_MSB] == 0) ||";
  z[lc++]="	       (jrecv->chapterc_value";
  z[lc++]="		[CSYS_MIDI_CC_BANKSELECT_LSB] == 0));";
  z[lc++]="      ";
  z[lc++]="      /* if needed, change bank-switch values */";
  z[lc++]="      ";
  z[lc++]="      if (yflag)";
  z[lc++]="	{			  ";
  z[lc++]="	  if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_MSB";
  z[lc++]="					, newx)) ";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_LSB";
  z[lc++]="					, newy))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      /* do program change */";
  z[lc++]="      ";
  z[lc++]="      if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="				    jrecv->chan | CSYS_MIDI_PROGRAM,";
  z[lc++]="				    vel, 0))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      /* if changed, reset bank-switch values */";
  z[lc++]="      ";
  z[lc++]="      if (yflag)";
  z[lc++]="	{";
  z[lc++]="	  if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_MSB";
  z[lc++]="					, jrecv->chapterc_value";
  z[lc++]="					[CSYS_MIDI_CC_BANKSELECT_MSB])) ";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="					jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					CSYS_MIDI_CC_BANKSELECT_LSB";
  z[lc++]="					, jrecv->chapterc_value";
  z[lc++]="					[CSYS_MIDI_CC_BANKSELECT_LSB]))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"PChange %hhu [%hhu,%hhu] --> %hhu [%hhu, %hhu]\\n\",";
  z[lc++]="	       jrecv->chapterp_program & NSYS_SM_RV_CLRF,";
  z[lc++]="	       jrecv->chapterp_bankc, jrecv->chapterp_bankf,";
  z[lc++]="	       vel, newx, newy);";
  z[lc++]="      ";
  z[lc++]="      jrecv->chapterp_program = vel | NSYS_SM_RV_SETF;";
  z[lc++]="      jrecv->chapterp_bankc = newx ;";
  z[lc++]="      jrecv->chapterp_bankf = newy ;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter W (pitch wheel)                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_wheel(source * sptr, unsigned char * p,";
  z[lc++]="			  netout_jrecv_state * jrecv,";
  z[lc++]="			  unsigned char * buff,  ";
  z[lc++]="			  long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy;";
  z[lc++]="";
  z[lc++]="  newx = p[NSYS_SM_CW_LOC_FIRST] & NSYS_SM_CLRS;";
  z[lc++]="  newy = p[NSYS_SM_CW_LOC_SECOND] & NSYS_SM_CLRS;";
  z[lc++]="  ";
  z[lc++]="  if ((newx != (jrecv->chapterw_first & NSYS_SM_RV_CLRF)) || ";
  z[lc++]="      (newy != jrecv->chapterw_second) || ";
  z[lc++]="      (jrecv->chapterw_first == 0))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="				    jrecv->chan | CSYS_MIDI_WHEEL,";
  z[lc++]="				    newx, newy))";
  z[lc++]="	return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"PWheel (%hhu, %hhu) --> (%hhu, %hhu)\\n\", ";
  z[lc++]="	       jrecv->chapterw_first & NSYS_SM_CLRS,";
  z[lc++]="	       jrecv->chapterw_second, newx, newy);";
  z[lc++]="      ";
  z[lc++]="      jrecv->chapterw_first = newx | NSYS_SM_RV_SETF;";
  z[lc++]="      jrecv->chapterw_second = newy;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process Note Logs of chapter N                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_notelog(source * sptr, unsigned char * p,";
  z[lc++]="			    netout_jrecv_state * jrecv, unsigned char many, ";
  z[lc++]="			    short loglen, unsigned char * checkptr,";
  z[lc++]="			    unsigned char * buff, ";
  z[lc++]="			    long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy, vel;";
  z[lc++]="  int yflag, noteon, noteoff;";
  z[lc++]="  unsigned long check_ext = 0;";
  z[lc++]="";
  z[lc++]="  while (loglen)";
  z[lc++]="    {";
  z[lc++]="      if ((!(p[NSYS_SM_CN_LOC_NUM] & NSYS_SM_CHKS)) || many)";
  z[lc++]="	{		      ";
  z[lc++]="	  newx = p[NSYS_SM_CN_LOC_NUM] & NSYS_SM_CLRS;";
  z[lc++]="	  newy = p[NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CLRY;";
  z[lc++]="	  yflag = (p[NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY);";
  z[lc++]="	  vel = jrecv->chaptern_vel[newx] & NSYS_SM_RV_CLRF;";
  z[lc++]="	  ";
  z[lc++]="	  /* todo: tstamp and exseq checks for vel == newy case,  */";
  z[lc++]="	  /*       NoteOn cull if journal packet arrived too late */";
  z[lc++]="	  ";
  z[lc++]="	  /* logic for deciding to do a NoteOff command ";
  z[lc++]="	   *";
  z[lc++]="	   * Note is presently on, and logged note is a NoteOff";
  z[lc++]="	   * or a NoteOn with a different velocity. Later add";
  z[lc++]="	   * other tests.";
  z[lc++]="	   */";
  z[lc++]="	  ";
  z[lc++]="	  noteoff = ((vel != 0) && (vel != newy));";
  z[lc++]="	  ";
  z[lc++]="	  /* logic for deciding to do a NoteOn command ";
  z[lc++]="	   *";
  z[lc++]="	   * Log command is a NoteOn and has arrived recently, and";
  z[lc++]="	   * has a different value than currently playing note.";
  z[lc++]="	   *";
  z[lc++]="	   */";
  z[lc++]="	  ";
  z[lc++]="	  noteon = (newy != 0) && (vel != newy) && yflag && sptr->ontime;";
  z[lc++]="	  ";
  z[lc++]="	  /* tests for NoteOn with same value as current note */";
  z[lc++]="	  ";
  z[lc++]="	  if ((vel == newy) && newy)";
  z[lc++]="	    {";
  z[lc++]="	      ";
  z[lc++]="	      /* prepare extended checkpoint packet number */";
  z[lc++]="	      ";
  z[lc++]="	      if (checkptr)";
  z[lc++]="		{";
  z[lc++]="		  check_ext = ntohs(*((unsigned short *)checkptr)); ";
  z[lc++]="		  ";
  z[lc++]="		  if (check_ext < sptr->hi_lobits)";
  z[lc++]="		    check_ext |= (sptr->hi_ext & NSYS_RTPSEQ_EXMASK);";
  z[lc++]="		  else";
  z[lc++]="		    check_ext |= ((sptr->hi_ext & NSYS_RTPSEQ_EXMASK)";
  z[lc++]="				  - NSYS_RTPSEQ_EXINCR);";
  z[lc++]="		  checkptr = NULL;";
  z[lc++]="		}";
  z[lc++]="	      ";
  z[lc++]="	      /* ";
  z[lc++]="	       * Test one: is NoteOn recent, and the current";
  z[lc++]="	       * playing note dated? If so, NoteOff and NoteOn";
  z[lc++]="	       */";
  z[lc++]="	      ";
  z[lc++]="	      if (yflag && (NSYS_SM_CN_RECDELAY < ";
  z[lc++]="			    (nsys_netout_tstamp - ";
  z[lc++]="			     jrecv->chaptern_tstamp[newx])))";
  z[lc++]="		{";
  z[lc++]="		  noteon = 1;";
  z[lc++]="		  noteoff = 1;";
  z[lc++]="		  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		    printf(\"TS-\");";
  z[lc++]="		}";
  z[lc++]="	      ";
  z[lc++]="	      else";
  z[lc++]="		{";
  z[lc++]="		  ";
  z[lc++]="		  /* ";
  z[lc++]="		   * Test two: does playing note predate checkpoint? ";
  z[lc++]="		   * If so, they are different: do NoteOff & perhaps";
  z[lc++]="		   * NoteOn";
  z[lc++]="		   */";
  z[lc++]="		  ";
  z[lc++]="		  if (jrecv->chaptern_extseq[newx] < check_ext)";
  z[lc++]="		    {";
  z[lc++]="		      noteoff = 1;";
  z[lc++]="		      noteon = (yflag != 0);";
  z[lc++]="		      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="			printf(\"EX-\");";
  z[lc++]="		    }";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="	  ";
  z[lc++]="	  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	    printf(\"NoteLog %hhu: %s(%hhu, %hhu); Actions:%s%s%s\\n\", ";
  z[lc++]="		   newx, (p[NSYS_SM_CN_LOC_VEL] & NSYS_SM_CN_CHKY) ";
  z[lc++]="		   ? \"#\" : \"-\", vel, newy, ";
  z[lc++]="		   (noteoff) ? \" NoteOff\" : \"\",";
  z[lc++]="		   (noteon) ? \" NoteOn\" : \"\",";
  z[lc++]="		   !(noteon || noteoff) ? \" None\" : \"\");";
  z[lc++]="	  ";
  z[lc++]="	  /* do NoteOff, then NoteOn, if needed */";
  z[lc++]="	  ";
  z[lc++]="	  if (noteoff && (nsys_netin_journal_addcmd";
  z[lc++]="			  (sptr, buff, fill, size,";
  z[lc++]="			   jrecv->chan | CSYS_MIDI_NOTEOFF, newx, 0)))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  ";
  z[lc++]="	  if (noteon && (nsys_netin_journal_addcmd";
  z[lc++]="			 (sptr, buff, fill, size,";
  z[lc++]="			  jrecv->chan | CSYS_MIDI_NOTEON, newx, newy)))";
  z[lc++]="	    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	  ";
  z[lc++]="	  /* update state if needed */";
  z[lc++]="	  ";
  z[lc++]="	  if (noteoff || (vel != newy)) ";
  z[lc++]="	    {";
  z[lc++]="	      jrecv->chaptern_vel[newx] = newy | NSYS_SM_RV_SETF;";
  z[lc++]="	      jrecv->chaptern_tstamp[newx] = nsys_netout_tstamp;";
  z[lc++]="	      jrecv->chaptern_extseq[newx] = sptr->hi_ext; ";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      loglen--;";
  z[lc++]="      p += NSYS_SM_CN_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process bitfields of chapter N                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_bitfield(source * sptr, unsigned char * p,";
  z[lc++]="			     netout_jrecv_state * jrecv, unsigned char low, ";
  z[lc++]="			     unsigned char high, unsigned char * buff, ";
  z[lc++]="			     long * fill, long size)";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="  unsigned char newx, bitfield;";
  z[lc++]="";
  z[lc++]="  while (low <= high)";
  z[lc++]="    {	      ";
  z[lc++]="      i = 0;";
  z[lc++]="      bitfield = 128;";
  z[lc++]="      while (bitfield)";
  z[lc++]="	{";
  z[lc++]="	  if ((*p) & bitfield)";
  z[lc++]="	    {";
  z[lc++]="	      newx = (low << NSYS_SM_CN_BFSHIFT) + i;";
  z[lc++]="	      ";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"Bitfield %hhu: (%hhu); \", newx,  ";
  z[lc++]="		       jrecv->chaptern_vel[newx]);";
  z[lc++]="	      ";
  z[lc++]="	      if (jrecv->chaptern_vel[newx] != NSYS_SM_RV_SETF)";
  z[lc++]="		{";
  z[lc++]="		  if (nsys_netin_journal_addcmd ";
  z[lc++]="		      (sptr, buff, fill, size, ";
  z[lc++]="		       jrecv->chan | CSYS_MIDI_NOTEOFF, newx, 0))";
  z[lc++]="		    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="		  jrecv->chaptern_vel[newx] = NSYS_SM_RV_SETF;";
  z[lc++]="		  ";
  z[lc++]="		  if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		    printf(\" Actions: NoteOff\");";
  z[lc++]="		  ";
  z[lc++]="		}";
  z[lc++]="	      ";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"\\n\");";
  z[lc++]="	    }";
  z[lc++]="	  bitfield >>= 1;";
  z[lc++]="	  i++;";
  z[lc++]="	}";
  z[lc++]="      low++;";
  z[lc++]="      p++;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter P (poly touch)                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_ptouch(source * sptr, unsigned char * p,";
  z[lc++]="			   netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="			   unsigned char many, unsigned char * buff, ";
  z[lc++]="			   long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy;";
  z[lc++]="";
  z[lc++]="  p += NSYS_SM_CA_HDRSIZE;";
  z[lc++]="  while (loglen)";
  z[lc++]="    {";
  z[lc++]="      if ((!(p[NSYS_SM_CA_LOC_NUM] & NSYS_SM_CA_CHKF)) || many)";
  z[lc++]="	{";
  z[lc++]="	  newx = p[NSYS_SM_CA_LOC_NUM] & NSYS_SM_CC_CLRF;";
  z[lc++]="	  newy = p[NSYS_SM_CA_LOC_PRESSURE] & NSYS_SM_CC_CLRD;";
  z[lc++]="	  if (((jrecv->chaptera_pressure[newx] & NSYS_SM_RV_CLRF)";
  z[lc++]="	       != newy) || (jrecv->chaptera_pressure[newx] == 0))";
  z[lc++]="	    {";
  z[lc++]="	      if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="					    jrecv->chan | CSYS_MIDI_PTOUCH,";
  z[lc++]="					    newx, newy))";
  z[lc++]="		  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	      ";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"PTouchLog %hhu: %hhu --> %hhu\\n\", newx, ";
  z[lc++]="		       jrecv->chaptera_pressure[newx] &";
  z[lc++]="		       NSYS_SM_RV_CLRF, newy);";
  z[lc++]="	      ";
  z[lc++]="	      jrecv->chaptera_pressure[newx] = (newy |";
  z[lc++]="						NSYS_SM_RV_SETF);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      loglen--;";
  z[lc++]="      p += NSYS_SM_CA_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter T (channel touch)              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_ctouch(source * sptr, unsigned char * p,";
  z[lc++]="			   netout_jrecv_state * jrecv,";
  z[lc++]="			   unsigned char * buff,  ";
  z[lc++]="			   long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx;";
  z[lc++]="";
  z[lc++]="  newx = p[NSYS_SM_CT_LOC_PRESSURE] & NSYS_SM_CLRS;";
  z[lc++]="  if ((newx != (jrecv->chaptert_pressure & NSYS_SM_RV_CLRF)) ||";
  z[lc++]="      (jrecv->chaptert_pressure == 0))";
  z[lc++]="    {";
  z[lc++]="      if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="				    jrecv->chan | CSYS_MIDI_CTOUCH,";
  z[lc++]="				    newx, 0))";
  z[lc++]="	  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="      ";
  z[lc++]="      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="	printf(\"CTouch (%hhu) --> (%hhu)\\n\", ";
  z[lc++]="	       jrecv->chaptert_pressure & NSYS_SM_RV_CLRF, newx);";
  z[lc++]="      ";
  z[lc++]="      jrecv->chaptert_pressure = newx | NSYS_SM_RV_SETF;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               process chapter C (controllers)                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_jrec_control(source * sptr, unsigned char * p,";
  z[lc++]="			   netout_jrecv_state * jrecv, short loglen,";
  z[lc++]="			   unsigned char many, unsigned char * buff, ";
  z[lc++]="			   long * fill, long size)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char newx, newy;";
  z[lc++]="";
  z[lc++]="  p += NSYS_SM_CC_HDRSIZE;";
  z[lc++]="  while (loglen)";
  z[lc++]="    {";
  z[lc++]="      if ((!(p[NSYS_SM_CC_LOC_LNUM] & NSYS_SM_CC_CHKF)) || many)";
  z[lc++]="	{";
  z[lc++]="	  newx = p[NSYS_SM_CC_LOC_LNUM] & NSYS_SM_CC_CLRF;";
  z[lc++]="	  newy = p[NSYS_SM_CC_LOC_LVAL] & NSYS_SM_CC_CLRD;";
  z[lc++]="	  if (((jrecv->chapterc_value[newx] & NSYS_SM_RV_CLRF)";
  z[lc++]="	       != newy) || (jrecv->chapterc_value[newx] == 0))";
  z[lc++]="	    {";
  z[lc++]="";
  z[lc++]="	      switch (newx) {    ";
  z[lc++]="	      case CSYS_MIDI_CC_ALLSOUNDOFF:";
  z[lc++]="	      case CSYS_MIDI_CC_ALLNOTESOFF:";
  z[lc++]="		newy = 0;";
  z[lc++]="		break;";
  z[lc++]="	      case CSYS_MIDI_CC_SUSTAIN:";
  z[lc++]="		if (newy)";
  z[lc++]="		  {";
  z[lc++]="		    jrecv->chapterc_sustain = newy;";
  z[lc++]="		    if (jrecv->chapterc_value[newx] & NSYS_SM_RV_CLRF)";
  z[lc++]="		      newy = 0;  /* later, recover full off->on cycle */";
  z[lc++]="		    else";
  z[lc++]="		      newy = 64; /* normal case, recover the lost pedal on */";
  z[lc++]="		  }";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	      if (nsys_netin_journal_addcmd(sptr, buff, fill, size,";
  z[lc++]="					    jrecv->chan | CSYS_MIDI_CC,";
  z[lc++]="					    newx, newy))";
  z[lc++]="		  return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="	      ";
  z[lc++]="	      if (NSYS_JOURNAL_DEBUG == NSYS_JOURNAL_DEBUG_ON)";
  z[lc++]="		printf(\"CntrlLog %hhu: %hhu --> %hhu\\n\", newx, ";
  z[lc++]="		       jrecv->chapterc_value[newx] & NSYS_SM_CLRS,";
  z[lc++]="		       newy);";
  z[lc++]="	      ";
  z[lc++]="	      jrecv->chapterc_value[newx] = (p[NSYS_SM_CC_LOC_LVAL] |";
  z[lc++]="					     NSYS_SM_RV_SETF);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      loglen--;";
  z[lc++]="      p += NSYS_SM_CC_LOGSIZE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                  low-level journal functions                 */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           adds a new MIDI command to the buffer              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_netin_journal_addcmd(source * sptr, unsigned char * buff, ";
  z[lc++]="			      long * fill, long size,";
  z[lc++]="			      unsigned char cmd, unsigned char ndata,";
  z[lc++]="			      unsigned char vdata)";
  z[lc++]="			      ";
  z[lc++]="{";
  z[lc++]="  int threebyte;";
  z[lc++]="  long idx;";
  z[lc++]="";
  z[lc++]="  threebyte = (((cmd & 0xF0) != CSYS_MIDI_PROGRAM) && ";
  z[lc++]="	       ((cmd & 0xF0) != CSYS_MIDI_CTOUCH));";
  z[lc++]="";
  z[lc++]="  if ((size - (*fill)) < (3 + threebyte))";
  z[lc++]="    return NSYS_JOURNAL_FILLEDBUFF;";
  z[lc++]="";
  z[lc++]="  idx = *fill;";
  z[lc++]="";
  z[lc++]="  buff[idx++] = cmd;";
  z[lc++]="  buff[idx++] = ndata;";
  z[lc++]="";
  z[lc++]="  if (threebyte)";
  z[lc++]="    buff[idx++] = vdata;";
  z[lc++]="";
  z[lc++]="  buff[idx++] = (unsigned char)(sptr->mset);";
  z[lc++]="";
  z[lc++]="  *fill = idx;";
  z[lc++]="";
  z[lc++]="  return NSYS_JOURNAL_RECOVERED;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/* end Network library -- receiver journal functions */";
  printlib(lc);
}


void makenet_crypto(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Network library -- crypto functions";
  z[lc++]="#    Copyright (C) 1999 Regents of the University of California";
  z[lc++]="#    See text below for additional Copyright statements";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#include <ctype.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/* beginning of MD5 code, extensively altered from Aladdin version */";
  z[lc++]="/*      GNU Public License applies to our modified form only       */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="  Copyright (C) 1999 Aladdin Enterprises.  All rights reserved.";
  z[lc++]="";
  z[lc++]="  This software is provided 'as-is', without any express or implied";
  z[lc++]="  warranty.  In no event will the authors be held liable for any damages";
  z[lc++]="  arising from the use of this software.";
  z[lc++]="";
  z[lc++]="  Permission is granted to anyone to use this software for any purpose,";
  z[lc++]="  including commercial applications, and to alter it and redistribute it";
  z[lc++]="  freely, subject to the following restrictions:";
  z[lc++]="";
  z[lc++]="  1. The origin of this software must not be misrepresented; you must not";
  z[lc++]="     claim that you wrote the original software. If you use this software";
  z[lc++]="     in a product, an acknowledgment in the product documentation would be";
  z[lc++]="     appreciated but is not required.";
  z[lc++]="  2. Altered source versions must be plainly marked as such, and must not be";
  z[lc++]="     misrepresented as being the original software.";
  z[lc++]="  3. This notice may not be removed or altered from any source distribution.";
  z[lc++]="";
  z[lc++]="  L. Peter Deutsch";
  z[lc++]="  ghost@aladdin.com";
  z[lc++]="";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               macros, typedefs, and global variables            */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="#define NSYS_ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32 - (n))))";
  z[lc++]="";
  z[lc++]="#define NSYS_FUNCT_F(x, y, z) (((x) & (y)) | (~(x) & (z)))";
  z[lc++]="#define NSYS_FUNCT_G(x, y, z) (((x) & (z)) | ((y) & ~(z)))";
  z[lc++]="#define NSYS_FUNCT_H(x, y, z) ((x) ^ (y) ^ (z))";
  z[lc++]="#define NSYS_FUNCT_I(x, y, z) ((y) ^ ((x) | ~(z)))";
  z[lc++]="";
  z[lc++]="#define NSYS_SETF(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_F(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="#define NSYS_SETG(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_G(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="#define NSYS_SETH(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_H(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="#define NSYS_SETI(a, b, c, d, k, s, Ti) t = a + NSYS_FUNCT_I(b,c,d) +X[k]+ Ti;\\";
  z[lc++]="                                        a = NSYS_ROTATE_LEFT(t, s) + b";
  z[lc++]="";
  z[lc++]="/* holds state for an MD5 computation */";
  z[lc++]="";
  z[lc++]="typedef struct nsys_md5_state_s {";
  z[lc++]="  unsigned int count[2];           /* message length in bits, lsw first */";
  z[lc++]="  unsigned int abcd[4];	           /* digest buffer */";
  z[lc++]="  unsigned char buf[64];           /* accumulate block */";
  z[lc++]="} nsys_md5_state_t;";
  z[lc++]="";
  z[lc++]="/* MD5 padding array */";
  z[lc++]="";
  z[lc++]="static unsigned char nsys_md5_pad[64] = {";
  z[lc++]="  0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,";
  z[lc++]="  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,";
  z[lc++]="  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,";
  z[lc++]="  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0";
  z[lc++]="};";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               initializes MD5 computation                       */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_init(nsys_md5_state_t * pms)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  pms->count[0] = pms->count[1] = 0;";
  z[lc++]="  pms->abcd[0] = 0x67452301;";
  z[lc++]="  pms->abcd[1] = 0xefcdab89;";
  z[lc++]="  pms->abcd[2] = 0x98badcfe;";
  z[lc++]="  pms->abcd[3] = 0x10325476;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************************/";
  z[lc++]="/*  process a block -- used in nsys_md5_append() and nsys_md5_finish() */";
  z[lc++]="/***********************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_process(nsys_md5_state_t * pms, unsigned char *data)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned int a, b, c, d, t, X[16], i;";
  z[lc++]="  unsigned char *xp = data;";
  z[lc++]="";
  z[lc++]="  a = pms->abcd[0]; ";
  z[lc++]="  b = pms->abcd[1];";
  z[lc++]="  c = pms->abcd[2]; ";
  z[lc++]="  d = pms->abcd[3];";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < 16; ++i, xp += 4)";
  z[lc++]="    X[i] = xp[0] + (xp[1] << 8) + (xp[2] << 16) + (xp[3] << 24);";
  z[lc++]="";
  z[lc++]="  NSYS_SETF(a, b, c, d,  0,  7,  0xd76aa478);";
  z[lc++]="  NSYS_SETF(d, a, b, c,  1, 12,  0xe8c7b756);";
  z[lc++]="  NSYS_SETF(c, d, a, b,  2, 17,  0x242070db);";
  z[lc++]="  NSYS_SETF(b, c, d, a,  3, 22,  0xc1bdceee);";
  z[lc++]="  NSYS_SETF(a, b, c, d,  4,  7,  0xf57c0faf);";
  z[lc++]="  NSYS_SETF(d, a, b, c,  5, 12,  0x4787c62a);";
  z[lc++]="  NSYS_SETF(c, d, a, b,  6, 17,  0xa8304613);";
  z[lc++]="  NSYS_SETF(b, c, d, a,  7, 22,  0xfd469501);";
  z[lc++]="  NSYS_SETF(a, b, c, d,  8,  7,  0x698098d8);";
  z[lc++]="  NSYS_SETF(d, a, b, c,  9, 12,  0x8b44f7af);";
  z[lc++]="  NSYS_SETF(c, d, a, b, 10, 17,  0xffff5bb1);";
  z[lc++]="  NSYS_SETF(b, c, d, a, 11, 22,  0x895cd7be);";
  z[lc++]="  NSYS_SETF(a, b, c, d, 12,  7,  0x6b901122);";
  z[lc++]="  NSYS_SETF(d, a, b, c, 13, 12,  0xfd987193);";
  z[lc++]="  NSYS_SETF(c, d, a, b, 14, 17,  0xa679438e);";
  z[lc++]="  NSYS_SETF(b, c, d, a, 15, 22,  0x49b40821);";
  z[lc++]="";
  z[lc++]="  NSYS_SETG(a, b, c, d,  1,  5, 0xf61e2562);";
  z[lc++]="  NSYS_SETG(d, a, b, c,  6,  9, 0xc040b340);";
  z[lc++]="  NSYS_SETG(c, d, a, b, 11, 14, 0x265e5a51);";
  z[lc++]="  NSYS_SETG(b, c, d, a,  0, 20, 0xe9b6c7aa);";
  z[lc++]="  NSYS_SETG(a, b, c, d,  5,  5, 0xd62f105d);";
  z[lc++]="  NSYS_SETG(d, a, b, c, 10,  9, 0x02441453);";
  z[lc++]="  NSYS_SETG(c, d, a, b, 15, 14, 0xd8a1e681);";
  z[lc++]="  NSYS_SETG(b, c, d, a,  4, 20, 0xe7d3fbc8);";
  z[lc++]="  NSYS_SETG(a, b, c, d,  9,  5, 0x21e1cde6);";
  z[lc++]="  NSYS_SETG(d, a, b, c, 14,  9, 0xc33707d6);";
  z[lc++]="  NSYS_SETG(c, d, a, b,  3, 14, 0xf4d50d87);";
  z[lc++]="  NSYS_SETG(b, c, d, a,  8, 20, 0x455a14ed);";
  z[lc++]="  NSYS_SETG(a, b, c, d, 13,  5, 0xa9e3e905);";
  z[lc++]="  NSYS_SETG(d, a, b, c,  2,  9, 0xfcefa3f8);";
  z[lc++]="  NSYS_SETG(c, d, a, b,  7, 14, 0x676f02d9);";
  z[lc++]="  NSYS_SETG(b, c, d, a, 12, 20, 0x8d2a4c8a);";
  z[lc++]="";
  z[lc++]="  NSYS_SETH(a, b, c, d,  5,  4, 0xfffa3942);";
  z[lc++]="  NSYS_SETH(d, a, b, c,  8, 11, 0x8771f681);";
  z[lc++]="  NSYS_SETH(c, d, a, b, 11, 16, 0x6d9d6122);";
  z[lc++]="  NSYS_SETH(b, c, d, a, 14, 23, 0xfde5380c);";
  z[lc++]="  NSYS_SETH(a, b, c, d,  1,  4, 0xa4beea44);";
  z[lc++]="  NSYS_SETH(d, a, b, c,  4, 11, 0x4bdecfa9);";
  z[lc++]="  NSYS_SETH(c, d, a, b,  7, 16, 0xf6bb4b60);";
  z[lc++]="  NSYS_SETH(b, c, d, a, 10, 23, 0xbebfbc70);";
  z[lc++]="  NSYS_SETH(a, b, c, d, 13,  4, 0x289b7ec6);";
  z[lc++]="  NSYS_SETH(d, a, b, c,  0, 11, 0xeaa127fa);";
  z[lc++]="  NSYS_SETH(c, d, a, b,  3, 16, 0xd4ef3085);";
  z[lc++]="  NSYS_SETH(b, c, d, a,  6, 23, 0x04881d05);";
  z[lc++]="  NSYS_SETH(a, b, c, d,  9,  4, 0xd9d4d039);";
  z[lc++]="  NSYS_SETH(d, a, b, c, 12, 11, 0xe6db99e5);";
  z[lc++]="  NSYS_SETH(c, d, a, b, 15, 16, 0x1fa27cf8);";
  z[lc++]="  NSYS_SETH(b, c, d, a,  2, 23, 0xc4ac5665);";
  z[lc++]="";
  z[lc++]="  NSYS_SETI(a, b, c, d,  0,  6, 0xf4292244);";
  z[lc++]="  NSYS_SETI(d, a, b, c,  7, 10, 0x432aff97);";
  z[lc++]="  NSYS_SETI(c, d, a, b, 14, 15, 0xab9423a7);";
  z[lc++]="  NSYS_SETI(b, c, d, a,  5, 21, 0xfc93a039);";
  z[lc++]="  NSYS_SETI(a, b, c, d, 12,  6, 0x655b59c3);";
  z[lc++]="  NSYS_SETI(d, a, b, c,  3, 10, 0x8f0ccc92);";
  z[lc++]="  NSYS_SETI(c, d, a, b, 10, 15, 0xffeff47d);";
  z[lc++]="  NSYS_SETI(b, c, d, a,  1, 21, 0x85845dd1);";
  z[lc++]="  NSYS_SETI(a, b, c, d,  8,  6, 0x6fa87e4f);";
  z[lc++]="  NSYS_SETI(d, a, b, c, 15, 10, 0xfe2ce6e0);";
  z[lc++]="  NSYS_SETI(c, d, a, b,  6, 15, 0xa3014314);";
  z[lc++]="  NSYS_SETI(b, c, d, a, 13, 21, 0x4e0811a1);";
  z[lc++]="  NSYS_SETI(a, b, c, d,  4,  6, 0xf7537e82);";
  z[lc++]="  NSYS_SETI(d, a, b, c, 11, 10, 0xbd3af235);";
  z[lc++]="  NSYS_SETI(c, d, a, b,  2, 15, 0x2ad7d2bb);";
  z[lc++]="  NSYS_SETI(b, c, d, a,  9, 21, 0xeb86d391);";
  z[lc++]="";
  z[lc++]="  pms->abcd[0] += a;";
  z[lc++]="  pms->abcd[1] += b;";
  z[lc++]="  pms->abcd[2] += c;";
  z[lc++]="  pms->abcd[3] += d;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#undef NSYS_ROTATE_LEFT";
  z[lc++]="#undef NSYS_FUNCT_F";
  z[lc++]="#undef NSYS_FUNCT_G";
  z[lc++]="#undef NSYS_FUNCT_H";
  z[lc++]="#undef NSYS_FUNCT_I";
  z[lc++]="#undef NSYS_SETF";
  z[lc++]="#undef NSYS_SETG";
  z[lc++]="#undef NSYS_SETH";
  z[lc++]="#undef NSYS_SETI";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               append phase of MD5 computation                   */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_append(nsys_md5_state_t * pms, unsigned char * data, int nbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char *p;";
  z[lc++]="  int left, offset, copy;";
  z[lc++]="  unsigned int nbits;";
  z[lc++]="";
  z[lc++]="  if (nbytes <= 0)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  p = data;";
  z[lc++]="  left = nbytes;";
  z[lc++]="  offset = (pms->count[0] >> 3) & 63;";
  z[lc++]="  nbits  = (unsigned int)(nbytes << 3);";
  z[lc++]="";
  z[lc++]="  /* Update the message length. */";
  z[lc++]="";
  z[lc++]="  pms->count[1] += nbytes >> 29;";
  z[lc++]="  pms->count[0] += nbits;";
  z[lc++]="";
  z[lc++]="  if (pms->count[0] < nbits)";
  z[lc++]="    pms->count[1]++;";
  z[lc++]="";
  z[lc++]="  /* Process an initial partial block. */";
  z[lc++]="  ";
  z[lc++]="  if (offset) ";
  z[lc++]="    {";
  z[lc++]="      copy = (offset + nbytes > 64 ? 64 - offset : nbytes);";
  z[lc++]="      ";
  z[lc++]="      memcpy(pms->buf + offset, p, copy);";
  z[lc++]="      if (offset + copy < 64)";
  z[lc++]="	return;";
  z[lc++]="";
  z[lc++]="      p += copy;";
  z[lc++]="      left -= copy;";
  z[lc++]="      nsys_md5_process(pms, pms->buf);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* Process full blocks. */";
  z[lc++]="  ";
  z[lc++]="  for (; left >= 64; p += 64, left -= 64)";
  z[lc++]="    nsys_md5_process(pms, p);";
  z[lc++]="  ";
  z[lc++]="  /* Process a final partial block. */";
  z[lc++]="  ";
  z[lc++]="  if (left)";
  z[lc++]="    memcpy(pms->buf, p, left);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               final phase of MD5 computation                   */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="void nsys_md5_finish(nsys_md5_state_t * pms, unsigned char digest[16])";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char data[8];";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /* Save the length before padding. */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < 8; ++i)";
  z[lc++]="    data[i] = (unsigned char)(pms->count[i >> 2] >> ((i & 3) << 3));";
  z[lc++]="";
  z[lc++]="  /* Pad to 56 bytes mod 64. */";
  z[lc++]="";
  z[lc++]="  nsys_md5_append(pms, nsys_md5_pad, ((55 - (pms->count[0] >> 3)) & 63) + 1);";
  z[lc++]="";
  z[lc++]="  /* Append the length. */";
  z[lc++]="";
  z[lc++]="  nsys_md5_append(pms, data, 8);";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < 16; ++i)";
  z[lc++]="    digest[i] = (unsigned char)(pms->abcd[i >> 2] >> ((i & 3) << 3));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*           end of code covered by Alladin Copyright              */";
  z[lc++]="/*_________________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*               function call to compute MD5                      */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_md5(unsigned char * digest, unsigned char * text, int len)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_md5_state_t state;";
  z[lc++]="";
  z[lc++]="  nsys_md5_init(&state);	";
  z[lc++]="  nsys_md5_append(&state, text, len);";
  z[lc++]="  nsys_md5_finish(&state, digest);";
  z[lc++]="  return digest;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*   computes hmac-md5, key is always a 16-byte digest   */";
  z[lc++]="/*                modified code from RFC2104             */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="char * nsys_hmac_md5(unsigned char* text, int text_len, ";
  z[lc++]="		     unsigned char * keydigest, unsigned char * digest)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  nsys_md5_state_t context;";
  z[lc++]="  unsigned char k_ipad[64], k_opad[64];";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  memcpy(k_ipad, keydigest, 16);";
  z[lc++]="  memset(&(k_ipad[16]), 0, 48);";
  z[lc++]="  memcpy(k_opad, keydigest, 16);";
  z[lc++]="  memset(&(k_opad[16]), 0, 48);";
  z[lc++]="";
  z[lc++]="  for (i=0; i<64; i++) ";
  z[lc++]="    {";
  z[lc++]="      k_ipad[i] ^= 0x36;";
  z[lc++]="      k_opad[i] ^= 0x5c;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  nsys_md5_init(&context);";
  z[lc++]="  nsys_md5_append(&context, k_ipad, 64); ";
  z[lc++]="  nsys_md5_append(&context, text, text_len);";
  z[lc++]="  nsys_md5_finish(&context, digest);  ";
  z[lc++]="";
  z[lc++]="  nsys_md5_init(&context);";
  z[lc++]="  nsys_md5_append(&context, k_opad, 64);";
  z[lc++]="  nsys_md5_append(&context, digest, 16);";
  z[lc++]="  nsys_md5_finish(&context, digest);";
  z[lc++]="  return digest;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/*          constant array for base64 translation                 */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char nsys_b64map[64] = {";
  z[lc++]="  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', ";
  z[lc++]="  'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',";
  z[lc++]="  'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', ";
  z[lc++]="  'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',";
  z[lc++]="  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'";
  z[lc++]="}; ";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/* converts 16-byte hash function to 25-byte output string */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="unsigned char * nsys_digest_base64(unsigned char * output, ";
  z[lc++]="				   unsigned char * input)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = 0;";
  z[lc++]="  for (i = 0; i <= 12; i += 3)";
  z[lc++]="    {";
  z[lc++]="      output[j++] = nsys_b64map[input[i] >> 2];";
  z[lc++]="      output[j++] = nsys_b64map[((input[i] & 3) << 4) | (input[i+1] >> 4)];";
  z[lc++]="      output[j++] = nsys_b64map[((input[i+1] & 15) << 2) | (input[i+2] >> 6)];";
  z[lc++]="      output[j++] = nsys_b64map[input[i+2] & 63];";
  z[lc++]="    }";
  z[lc++]="  output[j++] = nsys_b64map[input[i] >> 2];";
  z[lc++]="  output[j++] = nsys_b64map[(input[i] & 3) << 4];";
  z[lc++]="  output[j++] = '=';";
  z[lc++]="  output[j++] = '=';";
  z[lc++]="  output[j++] = '\\0';";
  z[lc++]="  return output;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           checks string for Base64 MD5 Digest format         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int nsys_digest_syntaxcheck(char * s)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret = 1;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if ((strlen(s) == 24) && (s[23] == '=') && (s[22] == '=') && ";
  z[lc++]="	  ((s[21] == 'A') || (s[21] == 'Q') || (s[21] == 'g') || ";
  z[lc++]="	   (s[21] == 'w')))";
  z[lc++]="    {";
  z[lc++]="      for (i=0; i < 21; i++)";
  z[lc++]="	ret &= (isalnum((int)s[i]) || (s[i] == '+') || (s[i] == '/')); ";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    ret = 0;";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/*                end of crypto network library                    */";
  z[lc++]="/*******************************************************************/";
  printlib(lc);
}


