/***************************************************************************
                          interface_popups.cpp  -  description
                             -------------------
    begin                : Thu Dec 21 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_popups.h"

PopUp_Pattern_Properties::PopUp_Pattern_Properties() : Gtk::Window(GTK_WINDOW_DIALOG), label1("HighLight Major:"), label2("HighLight Minor:"), label3("Pattern Length(rows):"), label4("HighLight Extra Patterns:"), label5("Lenght Extra Patterns:"), button_cancel("Cancel"), table1(8, 2, false), frame1("Pattern Properties") , button_apply("Apply")

{
   spinbutton_highlight_major_adj = new Gtk::Adjustment(1, 1, 128, 1, 10, 10);
   spinbutton_highlight_major = new Gtk::SpinButton(*spinbutton_highlight_major_adj, 1, 0);
   spinbutton_highlight_minor_adj = new Gtk::Adjustment(1, 1, 128, 1, 10, 10);
   spinbutton_highlight_minor = new Gtk::SpinButton(*spinbutton_highlight_minor_adj, 1, 0);
   spinbutton_pattern_length_adj = new Gtk::Adjustment(32, 32, 256, 1, 10, 10);
   spinbutton_pattern_length = new Gtk::SpinButton(*spinbutton_pattern_length_adj, 1, 0);
   spinbutton_highlight_extra_adj = new Gtk::Adjustment(1, 0, 500, 1, 10, 10);
   spinbutton_highlight_extra = new Gtk::SpinButton(*spinbutton_highlight_extra_adj, 1, 0);
   spinbutton_pattern_extra_adj = new Gtk::Adjustment(1, 0, 500, 1, 10, 10);
   spinbutton_pattern_extra = new Gtk::SpinButton(*spinbutton_pattern_extra_adj, 1, 0);
   label1.set_name("label1");
   label1.set_alignment(0.5, 0.5);
   label1.set_padding(3, 3);
   label2.set_name("label2");
   label2.set_alignment(0.5, 0.5);
   label2.set_padding(3, 3);
   spinbutton_highlight_major->set_name("spinbutton_highlight_major");
   spinbutton_highlight_major->set_editable(true);
   spinbutton_highlight_minor->set_name("spinbutton_highlight_minor");
   spinbutton_highlight_minor->set_editable(true);
   hseparator1.set_name("hseparator1");
   label3.set_name("label3");
   label3.set_alignment(0.5, 0.5);
   label3.set_padding(0, 0);
   spinbutton_pattern_length->set_name("spinbutton_pattern_length");
   spinbutton_pattern_length->set_editable(true);
   label4.set_name("label4");
   label4.set_alignment(0.5, 0.5);
   label4.set_padding(0, 0);
   spinbutton_highlight_extra->set_name("spinbutton_highlight_extra");
   spinbutton_highlight_extra->set_editable(true);
   label5.set_name("label5");
   label5.set_alignment(0.5, 0.5);
   label5.set_padding(0, 0);
   spinbutton_pattern_extra->set_name("spinbutton_pattern_extra");
   spinbutton_pattern_extra->set_editable(true);
   hseparator2.set_name("hseparator2");
   button_apply.set_name("button_apply");
   button_cancel.set_name("button_cancel");
   hseparator3.set_name("hseparator3");
   hseparator4.set_name("hseparator4");
   table1.set_name("table1");
   table1.set_border_width(7);
   table1.attach(label1, 0, 1, 0, 1, 0, 0, 0, 0);
   table1.attach(label2, 0, 1, 1, 2, 0, 0, 0, 0);
   table1.attach(*spinbutton_highlight_major, 1, 2, 0, 1, 0, 0, 20, 4);
   table1.attach(*spinbutton_highlight_minor, 1, 2, 1, 2, 0, 0, 20, 4);
   table1.attach(hseparator1, 0, 1, 3, 4, GTK_FILL, 0, 0, 9);
   table1.attach(label3, 0, 1, 4, 5, 0, 0, 0, 0);
   table1.attach(*spinbutton_pattern_length, 1, 2, 4, 5, 0, 0, 20, 4);
   table1.attach(label4, 0, 1, 2, 3, 0, 0, 0, 0);
   table1.attach(*spinbutton_highlight_extra, 1, 2, 2, 3, 0, 0, 20, 4);
   table1.attach(label5, 0, 1, 5, 6, 0, 0, 0, 0);
   table1.attach(*spinbutton_pattern_extra, 1, 2, 5, 6, GTK_FILL, 0, 20, 4);
   table1.attach(hseparator2, 0, 1, 6, 7, GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
   table1.attach(button_apply, 0, 1, 7, 8, 0, 0, 0, 0);
   table1.attach(button_cancel, 1, 2, 7, 8, 0, 0, 0, 0);
   table1.attach(hseparator3, 1, 2, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
   table1.attach(hseparator4, 1, 2, 6, 7, GTK_FILL, GTK_FILL, 0, 0);
   frame1.set_name("frame1");
   frame1.set_border_width(4);
   frame1.set_label_align(0, 0);
   frame1.set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame1.add(table1);
   set_name("Window_PatProps");
   set_border_width(4);
   set_title("Pattern Properties:");
   set_position(GTK_WIN_POS_CENTER);
   set_policy(false, false, false);
   add(frame1);
   label1.show();
   label2.show();
   spinbutton_highlight_major->show();
   spinbutton_highlight_minor->show();
   hseparator1.show();
   label3.show();
   spinbutton_pattern_length->show();
   label4.show();
   spinbutton_highlight_extra->show();
   label5.show();
   spinbutton_pattern_extra->show();
   hseparator2.show();
   button_apply.show();
   button_cancel.show();
   hseparator3.show();
   hseparator4.show();
   table1.show();
   frame1.show();
   set_modal(true);
   show();
   button_cancel.clicked.connect(slot(this,&PopUp_Pattern_Properties::cancel_callback));
}

void PopUp_Pattern_Properties::cancel_callback() {

	delete this;
}

PopUp_Pattern_Properties::~PopUp_Pattern_Properties() {

   delete spinbutton_highlight_major;
   delete spinbutton_highlight_major_adj;
   delete spinbutton_highlight_minor;
   delete spinbutton_highlight_minor_adj;
   delete spinbutton_pattern_length;
   delete spinbutton_pattern_length_adj;
   delete spinbutton_highlight_extra;
   delete spinbutton_highlight_extra_adj;
   delete spinbutton_pattern_extra;
   delete spinbutton_pattern_extra_adj;
}

Popup_Scale_Volume::Popup_Scale_Volume(int p_base_percent) : Gtk::Window(GTK_WINDOW_TOPLEVEL), label1("Scale Volume"), label2("%"), button_ok("Ok!")

{
   set_position(GTK_WIN_POS_CENTER);
   set_modal(true);

   spinbutton_volume_scale_adj = new Gtk::Adjustment(p_base_percent, 1, 200, 1, 10, 10);
   spinbutton_volume_scale = new Gtk::SpinButton(*spinbutton_volume_scale_adj, 1, 0);
   label1.set_name("label1");
   label1.set_alignment(0.5, 0.5);
   label1.set_padding(2, 2);
   spinbutton_volume_scale->set_usize(56, -1);
   spinbutton_volume_scale->set_name("spinbutton_volume_scale");
   spinbutton_volume_scale->set_editable(true);
   label2.set_name("label2");
   label2.set_alignment(0.5, 0.5);
   label2.set_padding(0, 0);
   hbox1.set_name("hbox1");
   hbox1.pack_start(*spinbutton_volume_scale, false, false, 0);
   hbox1.pack_start(label2, false, false, 0);
   button_ok.set_name("button_ok");
   button_ok.set_border_width(7);
   vbox1.set_name("vbox1");
   vbox1.set_border_width(7);
   vbox1.pack_start(label1, false, false, 0);
   vbox1.pack_start(hbox1);
   vbox1.pack_start(button_ok, false, false, 0);
   set_name("popup_volume_scale");
   set_title("window1");
   set_policy(false, false, false);
   add(vbox1);
   label1.show();
   spinbutton_volume_scale->show();
   label2.show();
   hbox1.show();
   button_ok.show();
   vbox1.show();
   show();
}

Popup_Scale_Volume::~Popup_Scale_Volume()
{
   delete spinbutton_volume_scale;
   delete spinbutton_volume_scale_adj;
}

Window_File_Popup::Window_File_Popup() : Gtk::Window(GTK_WINDOW_TOPLEVEL), button_popup_file_load("Load"), button_popup_file_new("New"), button_popup_file_save_current("Save Current"), button_popup_file_save_as("Save As"), button_popup_file_quit("Quit"), button_popup_file_export_midi("Export MIDI file"),  frame1("File Menu") {

//	button_popup_file_load.set_usize(67, -1);

   button_popup_file_load.set_name("button_popup_file_load");
   button_popup_file_new.set_name("button_popup_file_new");
   button_popup_file_save_current.set_name("button_popup_file_save_current");
   button_popup_file_save_as.set_name("button_popup_file_save_as");
   button_popup_file_quit.set_name("button_popup_file_quit");
   vbox2.set_usize(-1, -1);
   vbox2.set_name("vbox2");
   vbox2.set_border_width(6);
   vbox2.pack_start(button_popup_file_load, true, true, 1);
   vbox2.pack_start(button_popup_file_new, false, false, 1);
   vbox2.pack_start(button_popup_file_save_current, false, false, 1);
   vbox2.pack_start(button_popup_file_save_as, false, false, 1);
   vbox2.pack_start(button_popup_file_export_midi, false, false, 2);
   vbox2.pack_start(button_popup_file_quit, false, false, 1);
   frame1.set_name("frame1");
   frame1.set_border_width(6);
   frame1.set_label_align(0.5, 0);
   frame1.set_shadow_type(GTK_SHADOW_ETCHED_OUT);
   frame1.add(vbox2);
   set_name("file_popup");
   set_title("File");
   set_policy(false, false, false);
   add(frame1);
   button_popup_file_load.show();
   button_popup_file_new.show();
   button_popup_file_save_current.show();
   button_popup_file_save_as.show();
   button_popup_file_export_midi.show();
   button_popup_file_quit.show();
   vbox2.show();
   frame1.show();
   set_position(GTK_WIN_POS_CENTER);
   set_modal(true);
   show();
}

Window_File_Popup::~Window_File_Popup() {

}



Window_Variables_Popup::Window_Variables_Popup(Song* p_song,int p_index) : Gtk::Window(GTK_WINDOW_TOPLEVEL), clist_aviable(1),button_add("->"), button_delete("<-"), vbox2(false, 0), clist_used(1), button_move_up("Move Up"), button_move_down("Move Down"), hbox4(false, 0), vbox3(false, 0), hbox3(false, 0), button_ok("OK"), button_cancel("Cancel"), hbox2(false, 0), vbox1(false, 0) {


        Instrument::Initial_Value tmpval;
	Instrument::Initial_Value_List::iterator I;
	int i;

	song=p_song;
	index=p_index;
	value_list=song->get_instrument(index)->initial_value;

	clist_aviable.set_column_title(0, "Aviable");
	clist_aviable.set_column_justification(0, GTK_JUSTIFY_LEFT);
	clist_aviable.set_column_width(0, 80);
	clist_aviable.column_titles_show();
	scrolledwindow1.set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	scrolledwindow1.add(clist_aviable);
	button_add.set_usize(40, 40);
	button_add.set_border_width(5);
	button_delete.set_usize(40, 40);
	button_delete.set_border_width(5);
	vbox2.pack_start(vseparator1);
	vbox2.pack_start(button_add, false, false, 0);
//	vbox2.pack_start(button_delete, false, false, 0);
	vbox2.pack_start(vseparator2);
	clist_used.set_column_title(0, "Used");
	clist_used.set_column_justification(0, GTK_JUSTIFY_LEFT);
	clist_used.set_column_width(0, 80);
	clist_used.column_titles_show();
	scrolledwindow2.set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	scrolledwindow2.add(clist_used);
	button_move_up.set_border_width(2);
	button_move_down.set_border_width(2);
	hbox4.pack_start(button_move_up, false, false, 0);
	hbox4.pack_start(hseparator3);
	hbox4.pack_start(button_move_down, false, false, 0);
	vbox3.pack_start(scrolledwindow2);
	vbox3.pack_start(hbox4, false, false, 0);
	hbox3.pack_start(scrolledwindow1);
	hbox3.pack_start(vbox2, false, false, 0);
	hbox3.pack_start(vbox3);
	hseparator1.set_usize(-1, 11);
	hseparator2.set_usize(207, -1);
	hbox2.pack_start(button_ok);
	hbox2.pack_start(hseparator2, false, false, 0);
	hbox2.pack_start(button_cancel);
	vbox1.pack_start(hbox3);
	vbox1.pack_start(hseparator1, false, false, 0);
	vbox1.pack_start(hbox2, false, false, 0);
	set_usize(500, 430);
	set_border_width(9);
	set_title("New Variable");
	set_position(GTK_WIN_POS_CENTER);
	//set_policy(false, false, false);
	add(vbox1);
	clist_aviable.show();
	scrolledwindow1.show();
	vseparator1.show();
	button_add.show();
	button_delete.show();
	vseparator2.show();
	vbox2.show();
	clist_used.show();
	scrolledwindow2.show();
	button_move_up.show();
	hseparator3.show();
	button_move_down.show();
	hbox4.show();
	vbox3.show();
	hbox3.show();
	hseparator1.show();
	button_ok.show();
	hseparator2.show();
	button_cancel.show();
	hbox2.show();
	vbox1.show();

	show();
        set_modal(true);

	for (i=0;i<128;i++) {

		bool continue_loop=false;

		for (I=value_list.begin();I!=value_list.end();I++) {

			if ((I->type==Instrument::Initial_Value::CONTROLLER) && (I->controller==i)) {

				continue_loop=true;			
			}
		}

		if (continue_loop) continue;

		tmpval.type=Instrument::Initial_Value::CONTROLLER;
		tmpval.value=-1;
		tmpval.controller=i;
		var_list.push_back(tmpval);
	}

        fill_clist(&clist_used,&value_list);
        fill_clist(&clist_aviable,&var_list);
        button_add.clicked.connect(slot(this,&Window_Variables_Popup::button_add_pressed));
        button_cancel.clicked.connect(slot(this,&Window_Variables_Popup::button_cancel_pressed));
        clist_aviable.select_row.connect(slot(this,&Window_Variables_Popup::clist_track_aviable_clicked));

}

#define CURRENT_DEVICE song->user_devices.get_device(song->get_instrument(index)->midi.device.get())

void Window_Variables_Popup::fill_clist(Gtk::CList *p_clist,Instrument::Initial_Value_List *p_vlist) {

	int i=0;
	Instrument::Initial_Value_List::iterator I;

        p_clist->freeze();
	p_clist->clear();

	for (I=p_vlist->begin();I!=p_vlist->end();I++,i++) {

                gchar *pepe[1]={"kakaz"};
		string number;
                char numb[4]={'0','0','0',0};
		numb[0]='0'+(I->controller/100) %10;
		numb[1]='0'+(I->controller/10) %10;
		numb[2]='0'+I->controller %10;
		number=numb;

		string new_string;

		if (I->type==Instrument::Initial_Value::CONTROLLER) {

			new_string="C#"+number+" - "+CURRENT_DEVICE->instrument_map.controller_names[I->controller];
		}
                pepe[0]=(gchar*)new_string.c_str();
		p_clist->append(pepe);
	}

        p_clist->thaw();

	selected_left=-1;
}

void Window_Variables_Popup::button_add_pressed() {
        float vval;
	Instrument::Initial_Value tmpval;
	Instrument::Initial_Value_List::iterator I;
	int i=0;

	if ((selected_left<0) || (selected_left>=var_list.size())) return;

	vval=scrolledwindow1.get_vadjustment()->get_value();

	for(I=var_list.begin();I!=var_list.end();I++,i++) {

		if (i==selected_left) {

			value_list.push_back(*I);
			var_list.erase(I);

			break;
		}
	}
        selected_left=-1;
        fill_clist(&clist_aviable,&var_list);
        fill_clist(&clist_used,&value_list);
	scrolledwindow1.get_vadjustment()->set_value(vval);
}
void Window_Variables_Popup::button_cancel_pressed() {

	delete this;
}
void Window_Variables_Popup::clist_track_aviable_clicked(gint row,gint column,GdkEvent *event) {
	
	selected_left=row;
}
void Window_Variables_Popup::clist_track_used_clicked(gint row,gint column,GdkEvent *event) {

}

Window_Variables_Popup::~Window_Variables_Popup() {

}
