
(**********************************************************************)
(*          Streams of words or lines from text files:                *)
(**********************************************************************)

val read_words : string -> string stream;;
val read_lines : string -> string stream;;
val read_blocks : string -> string stream;;

val write_words : string -> string -> string stream;;
val write_lines : string -> string stream;;
val write_blocks : string -> string stream;;

(**********************************************************************)
(*                   Streams of file names:                           *)
(**********************************************************************)

type directory_option =
    List_hidden
  | List_self
  | List_parent
  | List_sorted of (string -> string -> int);;

val directory : string -> string stream;;
   (* without ., .., and w/o .files; sorted according to the "C" locale *)

val directory_with : directory_option list -> string -> string stream;;


type tree_option =
    Traverse_hidden
  | Traverse_preorder
  | Traverse_postorder
  | Traverse_sorted of (string -> string -> int);;
  | Prune_if of (string -> bool)
  | Unreadable of (string -> unit)
;;


val tree : string -> string stream;;
   (* without ., .., and w/o .files; sorted according to the "C" locale;
    * "preorder"
    *)

val tree_with : tree_option list -> string -> string stream;;

(**********************************************************************)
(*                         Common filters                             *)
(**********************************************************************)

val sort : string stream -> string stream;;
val sort_by : ('a -> 'a -> int) -> 'a stream -> 'a stream;;

(**********************************************************************)
(*                         File type filters                          *)
(**********************************************************************)

val only : ('a -> bool) -> 'a stream -> 'a stream;;
val except : ('a -> bool) -> 'a stream -> 'a stream;;

val file_exists
val is_directory 
val is_block_special
val is_char_special
val is_symlink
val is_regular
val is_socket

val is_readable
val is_writeable
val is_executable

val is_not_empty



