
/* Data for fishes */

#define FISH1 0
#define FISH2 1
#define FISH3 2
#define FISH4 3
#define FISH5 4
#define FISH6 5
#define SQUID 6
#define SWORDFISH 7
#define BLOWFISH 8
#define ERNEST 9
#define HUNTER 10
#define LORI 11
#define PREY 12
#define SHERMAN 13
#define FILLMORE 14
#define BDWELLER 15
#define HAWTHORNE 16

float fish1_speed[4] = { 1.0, 1.0, 1.0, 1.0 };
float fish2_speed[4] = { 0.6, 0.6, 0.6, 0.6 };
float fish3_speed[4] = { 1.1, 1.1, 1.1, 1.1 };
float fish4_speed[4] = { 1.0, 1.0, 1.0, 1.0 };
float fish5_speed[7] = { 0.8, 0.8, 0.7, 0.5, 0.7, 0.8, 0.8 };
float fish6_speed[4] = { 1.2, 1.2, 1.2, 1.2 };

float squid_speed[7] = { 0.1, 3.0, 3.0, 3.0, 3.0, 1.5, 1.0 };
float swordfish_speed[4] = { 1.4, 1.4, 1.4, 1.4 };
float blowfish_speed[4] = { 0.6, 0.6, 0.6, 0.6 };
float ernest_speed[4] = { 0.8, 0.8, 0.8, 0.8 };
float hunter_speed[4] = { 1.1, 1.1, 1.1, 1.1 };
float lori_speed[4] = { 0.8, 0.8, 0.8, 0.8 };
float prey_speed[4] = { 1.3, 1.3, 1.3, 1.3 };
float sherman_speed[14] =
    { 1.5, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.5, 1.75, 2.25, 2.5, 2.5, 2.5 };
float fillmore_speed[15] =
    { 0.7, 0.7, 0.7, 0.7, 0.8, 0.9, 1.0, 1.0, 1.0, 0.7, 0.5, 0.5, 0.5, 0.6, 0.7 };

float prey_hunter_speed[7] = {1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5};
float blowup_speed[2] = {0.1, 0.1};

float bdweller_speed[4] = {0.01, 0.01, 0.01, 0.01};


int normal_animation[4] =    { 0, 1, 2, 1 };
int sherman_animation[14] =  { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 0 };
int fillmore_animation[15] = { 0, 1, 2, 3, 4, 5, 6, 6, 6, 7, 8, 9, 10, 11,  0 };

int squid_animation[7]={ 0, 1, 1, 1, 1, 1, 2};
int fish5_animation[7]={ 0, 0, 1, 2, 1, 0, 0};
int prey_hunter_animation[7]={0, 1, 2, 3, 4, 5, 6};


Fish_animation fish_animation[NUMOFFISHTYPES] = {
    {"aquarium/sherman/fish1.png",     3, 4, normal_animation,   fish1_speed     },
    {"aquarium/sherman/fish2.png",     3, 4, normal_animation,   fish2_speed     },
    {"aquarium/sherman/fish3.png",     3, 4, normal_animation,   fish3_speed     },
    {"aquarium/sherman/fish4.png",     3, 4, normal_animation,   fish4_speed     },
    {"aquarium/sherman/fish5.png",     3, 7, fish5_animation,    fish5_speed     },
    {"aquarium/sherman/fish6.png",     3, 4, normal_animation,   fish6_speed     },
    {"aquarium/sherman/squid.png",     3, 7, squid_animation,    squid_speed     },
    {"aquarium/sherman/swordfish.png", 3, 4, normal_animation,   swordfish_speed },
    {"aquarium/sherman/blowfish.png",  3, 4, normal_animation,   blowfish_speed  },
    {"aquarium/sherman/ernest.png",    3, 4, normal_animation,   ernest_speed    },
    {"aquarium/sherman/hunter.png",    3, 4, normal_animation,   hunter_speed    },
    {"aquarium/sherman/lori.png",      3, 4, normal_animation,   lori_speed      },
    {"aquarium/sherman/prey.png",      3, 4, normal_animation,   prey_speed      },
    {"aquarium/sherman/sherman.png",  11,14, sherman_animation,  sherman_speed   },
    {"aquarium/sherman/fillmore.png", 12,15, fillmore_animation, fillmore_speed  },
    {"aquarium/sherman/bdweller.png",  3, 4, normal_animation,   bdweller_speed  },
    {"aquarium/sherman/hawthorne.png", 3, 4, normal_animation,   bdweller_speed  },

};

Bottom bottom_items[NUMOFBOTTOMITEMS] = {
  {"aquarium/bottom/plant1.png",        0},
  {"aquarium/bottom/plant2.png",        0},
  {"aquarium/bottom/plant3.png",        0},
  {"aquarium/bottom/plant4.png",        0},
  {"aquarium/bottom/plant5.png",        0},
  {"aquarium/bottom/plant6.png",        0},
  {"aquarium/bottom/plant7.png",        0},
  {"aquarium/bottom/stone1.png",        0},
  {"aquarium/bottom/stone2.png",        0},
  {"aquarium/bottom/stone3.png",        0},
};
