/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "describeAlbum.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfileinfo.h>

#include <klocale.h>
/* 
 *  Constructs a DescribeAlbum which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
DescribeAlbum::DescribeAlbum( QWidget* parent, QString dirname,  const char* name, bool modal, WFlags fl )
    : KDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "DescribeAlbum" );
    resize( 303, 330 ); 
    setCaption( i18n( "Describe :")+ dirname);

    GroupBox2 = new QGroupBox( this, "GroupBox2" );
    GroupBox2->setGeometry( QRect( 40, 50, 230, 230 ) );
    GroupBox2->setTitle( i18n( "Information" ) );

    TextLabel2_2 = new QLabel( GroupBox2, "TextLabel2_2" );
    TextLabel2_2->setGeometry( QRect( 10, 20, 210, 20 ) );
    TextLabel2_2->setText( i18n( "Short description" ) );

    TextLabel6 = new QLabel( GroupBox2, "TextLabel6" );
    TextLabel6->setGeometry( QRect( 10, 80, 210, 20 ) );
    TextLabel6->setText( i18n( "Long description" ) );

    shortDescr = new QLineEdit( GroupBox2, "shortDescr" );
    shortDescr->setGeometry( QRect( 10, 40, 210, 26 ) );
    QToolTip::add(  shortDescr, i18n( "A short description of the contents of the album contents" ) );

    longDescr = new QMultiLineEdit( GroupBox2, "longDescr" );
    longDescr->setGeometry( QRect( 10, 100, 210, 120 ) );
    QToolTip::add(  longDescr, i18n( "A longer description of the contents of the album contents" ) );

    QWidget* privateLayoutWidget = new QWidget( this, "Layout1" );
    privateLayoutWidget->setGeometry( QRect( 10, 10, 260, 24 ) );
    Layout1 = new QHBoxLayout( privateLayoutWidget );
    Layout1->setSpacing( 6 );
    Layout1->setMargin( 0 );

    TextLabel1 = new QLabel( privateLayoutWidget, "TextLabel1" );
    TextLabel1->setText( i18n( "Title" ) );
    Layout1->addWidget( TextLabel1 );
    QSpacerItem* spacer = new QSpacerItem( 16, 20, QSizePolicy::Fixed, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    title = new QLineEdit( privateLayoutWidget, "title" );
    QToolTip::add(  title, i18n( "A short title for the album" ) );
    Layout1->addWidget( title );

    okButton = new QPushButton( this, "okButton" );
    okButton->setGeometry( QRect( 100, 290, 91, 31 ) );
    okButton->setText( i18n( "&Ok" ) );

    cancelButton = new QPushButton( this, "cancelButton" );
    cancelButton->setGeometry( QRect( 210, 290, 81, 31 ) );
    cancelButton->setText( i18n( "&Cancel" ) );

    // signals and slots connections
    connect( title, SIGNAL( returnPressed() ), this, SLOT( accept() ) );
    connect( shortDescr, SIGNAL( returnPressed() ), this, SLOT( accept() ) );
    connect( okButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( cancelButton, SIGNAL( clicked() ), this, SLOT( reject() ) );

    // tab order
    setTabOrder( title, shortDescr );
    setTabOrder( shortDescr, longDescr );
    setTabOrder( longDescr, okButton );
    setTabOrder( okButton, cancelButton );
    
    /////////////
    QFileInfo finfo = QFileInfo(dirname);
    QString filename= finfo.absFilePath()+"/"+"album.txt";

    iinfo = new ImageFileInfo(filename, 1);
    title->setText(iinfo->getTitle());
    shortDescr->setText(iinfo->getShortDescription());
    longDescr->setText(iinfo->getLongDescription());

    title->setFocus();
    
}

/*  
 *  Destroys the object and frees any allocated resources
 */
DescribeAlbum::~DescribeAlbum()
{
    // no need to delete child widgets, Qt does it all for us
}

void 
DescribeAlbum::accept()
{
	iinfo->write(title->text(),
			shortDescr->text(),longDescr->text());
	QDialog::accept();	
}


