/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "main.h"
#include <kimageio.h>
#include <dcopclient.h>
   
int
main (int argc, char **argv)
{
  KAboutData* aboutData = new KAboutData("showimg", I18N_NOOP ("showimg"),
			"0.7", description, KAboutData::License_GPL,
			"(c) 2000, GROULT Richard","(thanks to Valerie and Benoist)\nPlease send me e-mail for bugs report... or encouragements :)",
			"http://www.jalix.org/projects/showimg", "rgroult@jalix.org" );
			
  aboutData->addAuthor ("GROULT Richard", 0, "rgroult@jalix.org");

  KCmdLineArgs::init (argc, argv, aboutData);
  KCmdLineArgs::addCmdLineOptions (options);

  KApplication::setColorSpec(KApplication::ManyColor );
  KApplication kApp;
  KImageIO::registerFormats();
  qInitTiffIO();
  QPixmap::setDefaultOptimization(QPixmap::BestOptim);

  MainWindow *frame=NULL;
  if (kApp.isRestored())
  {
    RESTORE(MainWindow);
  }
  else
  {
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs ();
    if (argc == 1)
    {
        frame = new MainWindow ("MainFrame");
    }
    else
    {
        frame = new MainWindow (QFile::decodeName (args->arg (0)), "MainFrame");
    }
    frame->setIcon(kApp.icon());
    kApp.setMainWidget (frame);
  }
  QObject::connect(qApp,SIGNAL(lastWindowClosed()),frame,SLOT(quit()));
  return kApp.exec ();
}
