/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    mtrr.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlemtrr ()
//	determine the correct procedure to use
void handlemtrr () {
	//  proc/mtrr in all kernels are compatible
	handlemtrrv20 ();
}

// handlemtrrv20() Function
void handlemtrrv20 () {
	char filename [INPUT_STRING];
	FILE *filep;
	char tmpstring [INPUT_STRING];
	int c=0;
	int comma=0;

	NUM_MTRR=-1;
	// Open /proc/mtrr
	sprintf (filename, "%smtrr", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgetstr (filep, tmpstring, INPUT_STRING);
		if (strlen(tmpstring)==0) break;
		MTRR[c]=malloc(MTRR_STRUCT_SIZE);
		if (MTRR[c]==NULL) error_handler(ERROR_MALLOC);
		MTRR[c]->REG=0;
		MTRR[c]->OFFHEX[0]=0;
		MTRR[c]->OFFMB=0;
		MTRR[c]->SIZE=0;
		MTRR[c]->OPTION[0]=0;
		MTRR[c]->COUNT=0;
		sscanf (tmpstring, "%*3s%2d%*1s %*5s%10s %*1s%4d%*4s %*5s%4d%*3s %s %*6s%d", &MTRR[c]->REG, MTRR[c]->OFFHEX, &MTRR[c]->OFFMB, &MTRR[c]->SIZE, tmpstring, &MTRR[c]->COUNT);
		comma=cinstr(tmpstring, ',');
		strncpy (MTRR[c]->OPTION, tmpstring, comma);
		MTRR[c]->OPTION[comma]=0;
		c++;
		if (c==MTRR_COUNT_MAX) break;
	} while (0==0);
	fclose (filep);
// any malloc after this point will result in MTRR->COUNT corruption
//	fprintf (stderr, "mtrr-count: %d\n", MTRR[0]->COUNT);
//	MTRR[c]=malloc(MTRR_STRUCT_SIZE);
//	fprintf (stderr, "mtrr-count: %d\n", MTRR[0]->COUNT);
	NUM_MTRR=c-1;
	// Return;
	return;
}

