/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    processes.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handleprocesses ()
//	determine the correct procedure to use
void handleprocesses () {
	//  proc/### in all kernels are compatible
	handleprocessesv20 ();
}

// handleprocessesv20() Function
void handleprocessesv20 () {
	DIR *procdir;
	struct dirent *dirname;
	char tmpstring [INPUT_STRING];
	int i=0;
	int c=0;
	int len=0;
	char filename [INPUT_STRING];
	char dirstr [INPUT_STRING];
	FILE *filep;
	time_t starttime;
	time_t curtime;
	long int totaltime;
	long int numday;
	long int numhour;
	long int nummin;
	long int numsec;
	char tty [INPUT_STRING];

	// Open Directory
	procdir=opendir(PROCLOC);
	if (procdir==NULL) return;
	// Read Entries
	do {
		dirname=readdir(procdir);
		if (dirname==NULL) break;
		strncpy (tmpstring, dirname->d_name, INPUT_STRING-1);
		tmpstring[INPUT_STRING-1]=0;
		if (isdigit(tmpstring[0])) {
			PROC[c]=malloc(PROC_STRUCT_SIZE);
			if (PROC[c]==NULL) error_handler(ERROR_MALLOC);
			initializeproc (PROC[c]);
			PROC[c]->PID=atoi(tmpstring);
			c++;
			if (c==PROC_COUNT_MAX) break;
		}
	} while (0==0);
	NUM_PROC=c-1;
	// Close Directory
	closedir (procdir);
	// Retrieve Basic Information on Each Process
	for (i=0; i<=NUM_PROC; i++) {
		// cmdline
		sprintf (filename, "%s%ld/cmdline", PROCLOC, PROC[i]->PID);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fgetstr (filep, PROC[i]->CMDLINE, STORAGE_STRING);
			fclose (filep);
		}
		// cwd
		sprintf (filename, "%s%ld/cwd", PROCLOC, PROC[i]->PID);
		len=readlink(filename, PROC[i]->CWD, STORAGE_STRING);
		PROC[i]->CWD[len]=0;
		// exe
		sprintf (filename, "%s%ld/exe", PROCLOC, PROC[i]->PID);
		len=readlink(filename, PROC[i]->EXE, STORAGE_STRING);
		PROC[i]->EXE[len]=0;
		// stat
		sprintf (filename, "%s%ld/stat", PROCLOC, PROC[i]->PID);
		filep=fopen(filename, "r");
		if (filep!=NULL) {
			fscanf (filep, "%*d %s %s %d %d %d %s %d %*u %*u", PROC[i]->NAME, PROC[i]->STATE, &PROC[i]->PPID, &PROC[i]->PGRP, &PROC[i]->SESSION, tty, &PROC[i]->TPGID);
			fscanf (filep, "%*u %*u %*u %d %d %*d %*d %*d %d %*u %*u %ld %u %*u %*u %u %u", &PROC[i]->UTIME, &PROC[i]->STIME, &PROC[i]->PRIORITY, &starttime, &PROC[i]->VSIZE, &PROC[i]->STARTCODE, &PROC[i]->ENDCODE);
			fscanf (filep, "%*u %*u %*u %*u %*u %*u %*u %*u %*u %*u");
			fclose (filep);
			// Drop Parentheses on Name
			rstring (PROC[i]->NAME, 1, PROC[i]->NAME);
			PROC[i]->NAME[strlen(PROC[i]->NAME)-1]=0;
			// Convert State
			if (strcmp(PROC[i]->STATE, "R")) sprintf(PROC[i]->STATE, "Running");
			if (strcmp(PROC[i]->STATE, "S")) sprintf(PROC[i]->STATE, "Uninterruptible");
			if (strcmp(PROC[i]->STATE, "D")) sprintf(PROC[i]->STATE, "Swapping");
			if (strcmp(PROC[i]->STATE, "Z")) sprintf(PROC[i]->STATE, "Zombie");
			if (strcmp(PROC[i]->STATE, "T")) sprintf(PROC[i]->STATE, "Stopped");
			// Fix Priority Level
			PROC[i]->PRIORITY = PROC[i]->PRIORITY + 1;
			// Fix Start Time
			starttime = (starttime / 100) + BOOTTIME;
			strncpy (PROC[i]->STARTTIME, ctime(&starttime), STORAGE_STRING-1);
			PROC[i]->STARTTIME[STORAGE_STRING-1]=0;
			killcrlf (PROC[i]->STARTTIME, strlen(PROC[i]->STARTTIME));
			// Fix TTY
			if (strcmp(tty, "0")==0)
				sprintf (PROC[i]->TTY, "unknown (%s)", tty);
			else
				sprintf (PROC[i]->TTY, "tty%d (%s)", (atoi(tty)-1024), tty);
			// Create Total Time
			time (&curtime);
			totaltime = curtime - starttime;
			numday=totaltime/86400;
			numhour=(totaltime-(numday*86400))/3600;
			nummin=(totaltime-(numday*86400)-(numhour*3600))/60;
			numsec=(totaltime-(numday*86400)-(numhour*3600)-(nummin*60));
			sprintf (PROC[i]->TOTALTIME, "%ld Days  %ld Hours  %ld Minutes  %ld Seconds", numday, numhour, nummin, numsec);
		}
		// files in use
		c=0;
		sprintf (filename, "%s%ld/fd", PROCLOC, PROC[i]->PID);
		procdir=opendir(filename);
		if (procdir!=NULL) {
			do {
				fillstring (tmpstring, 0, INPUT_STRING);
				dirname=readdir(procdir);
				if (dirname==NULL) break;
				strncpy (tmpstring, dirname->d_name, INPUT_STRING-1);
				tmpstring[INPUT_STRING-1]=0;
				if (strcmp(tmpstring, ".")==0) continue;
				if (strcmp(tmpstring, "..")==0) continue;
				if (strcmp(tmpstring, "0")==0) strcpy(tmpstring, "(stdin)");
				if (strcmp(tmpstring, "1")==0) strcpy(tmpstring, "(stdout)");
				if (strcmp(tmpstring, "2")==0) strcpy(tmpstring, "(stderr)");
				sprintf (PROC[i]->FILES[c], "%8s : ", tmpstring);
				sprintf (dirstr, "%s/%s", filename, dirname->d_name);
				fillstring (tmpstring, 0, INPUT_STRING);
				len=readlink(dirstr, tmpstring, INPUT_STRING);
				strncat (PROC[i]->FILES[c], tmpstring, len);
				c++;
				if (c==128) break;
			} while (0==0);
			closedir (procdir);
		}
		PROC[i]->NUM_FILES=c-1;
	}
	// Return
	return;
}


// initializeproc ()
void initializeproc (struct PROC_STRUCT *procstr) {
	int i;

	procstr->PID=0;
	procstr->NAME[0]=0;
	procstr->STATE[0]=0;
	procstr->CMDLINE[0]=0;
	procstr->CWD[0]=0;
	procstr->EXE[0]=0;
	for (i=0; i<128; i++)
		procstr->FILES[i][0]=0;
	procstr->NUM_FILES=0;
	procstr->PPID=0;
	procstr->PGRP=0;
	procstr->SESSION=0;
	procstr->TTY[0]=0;
	procstr->TPGID=0;
	procstr->UTIME=0;
	procstr->STIME=0;
	procstr->PRIORITY=0;
	procstr->STARTTIME[0]=0;
	procstr->VSIZE=0;
	procstr->STARTCODE=0;
	procstr->ENDCODE=0;
	procstr->TOTALTIME[0]=0;
	return;
}

