/*
 * Decompiled with CFR 0.152.
 */
package de.calcom.cclib.tree;

import de.calcom.cclib.tree.SimpleTreeNode;
import de.calcom.cclib.tree.event.SimpleTreeEvent;
import de.calcom.cclib.tree.event.SimpleTreeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleTree
extends Component {
    private SimpleTreeNode root = null;
    private Color[] partColor = new Color[7];
    private int hIndent = 20;
    private int rowHeight = 0;
    private int x0 = 15;
    private int y0 = 3;
    private int nodeGap = 4;
    private Image leafImg;
    private Image expandedParentImg;
    private Image collapsedParentImg;
    private Image collapseActionImg;
    private Image expandActionImg;
    private SimpleTreeNode selectedNode = null;
    private SimpleTreeNode lastSelectedNode = null;
    private int lastRow = -1;
    private int maxWidth = -1;
    private Vector listeners = new Vector(0);
    private URL codeBase = null;

    public SimpleTree() {
        this("Root node");
    }

    public SimpleTree(String string) {
        this.root = new SimpleTreeNode(string);
        this.root.setExpanded(true);
        this.selectedNode = this.root;
        this.initTree();
    }

    public SimpleTree(URL uRL) {
        this.codeBase = uRL;
        this.root = new SimpleTreeNode("Root node");
        this.root.setExpanded(true);
        this.selectedNode = this.root;
        this.initTree();
    }

    private void initTree() {
        try {
            MediaTracker mediaTracker = new MediaTracker(this);
            Toolkit toolkit = this.getToolkit();
            this.initEventHandling();
            this.partColor[0] = Color.lightGray;
            this.partColor[1] = Color.white;
            this.partColor[2] = Color.black;
            this.partColor[6] = new Color(0, 0, 128);
            this.partColor[5] = Color.white;
            this.leafImg = this.getImageResource(toolkit, "lf.gif");
            this.expandedParentImg = this.getImageResource(toolkit, "of.gif");
            this.collapsedParentImg = this.getImageResource(toolkit, "cf.gif");
            this.collapseActionImg = this.getImageResource(toolkit, "cl.gif");
            this.expandActionImg = this.getImageResource(toolkit, "ex.gif");
            mediaTracker.addImage(this.collapsedParentImg, 0);
            mediaTracker.addImage(this.leafImg, 1);
            mediaTracker.addImage(this.expandedParentImg, 2);
            mediaTracker.addImage(this.collapseActionImg, 3);
            mediaTracker.addImage(this.expandActionImg, 4);
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Image getImageResource(Toolkit toolkit, String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        Image image = null;
        if (inputStream != null) {
            try {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                image = toolkit.createImage(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return image;
    }

    private void initEventHandling() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SimpleTree.this.this_mouseReleased(mouseEvent);
            }
        });
    }

    private void this_mouseReleased(MouseEvent mouseEvent) {
        int n = (mouseEvent.getY() - this.y0) / this.rowHeight;
        SimpleTreeNode simpleTreeNode = this.getNodeOnRow(this.root, n);
        if (this.expandActionImg != null) {
            Rectangle rectangle = this.getActionSymbolRect(n, simpleTreeNode.getDepth(), this.expandActionImg);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.changeNodeExpansion(simpleTreeNode);
            } else {
                this.selectNode(simpleTreeNode);
            }
        } else {
            this.selectNode(simpleTreeNode);
        }
    }

    private void selectNode(SimpleTreeNode simpleTreeNode) {
        this.lastSelectedNode = this.selectedNode;
        this.selectedNode = simpleTreeNode;
        this.paintNodeText(this.getGraphics(), this.selectedNode, this.selectedNode.getDepth(), this.selectedNode.getRow());
        if (this.lastSelectedNode != null) {
            this.paintNodeText(this.getGraphics(), this.lastSelectedNode, this.lastSelectedNode.getDepth(), this.lastSelectedNode.getRow());
        }
        this.fireSelectionChanged(this.selectedNode);
    }

    private void changeNodeExpansion(SimpleTreeNode simpleTreeNode) {
        this.selectNode(simpleTreeNode);
        simpleTreeNode.setExpanded(!simpleTreeNode.isExpanded());
        this.paint(this.getGraphics());
        this.fireNodeExpansionChanged(simpleTreeNode);
    }

    public void addSimpleTreeListener(SimpleTreeListener simpleTreeListener) {
        this.listeners.addElement(simpleTreeListener);
    }

    public void removeSimpleTreeListener(SimpleTreeListener simpleTreeListener) {
        this.listeners.removeElement(simpleTreeListener);
    }

    private void fireNodeChanged(SimpleTreeNode simpleTreeNode) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SimpleTreeListener)enumeration.nextElement()).nodeChanged(new SimpleTreeEvent(this, simpleTreeNode));
        }
    }

    private void fireNodeInserted(SimpleTreeNode simpleTreeNode) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SimpleTreeListener)enumeration.nextElement()).nodeInserted(new SimpleTreeEvent(this, simpleTreeNode));
        }
    }

    private void fireNodeRemoved(SimpleTreeNode simpleTreeNode) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SimpleTreeListener)enumeration.nextElement()).nodeRemoved(new SimpleTreeEvent(this, simpleTreeNode));
        }
    }

    private void fireSelectionChanged(SimpleTreeNode simpleTreeNode) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SimpleTreeListener)enumeration.nextElement()).selectionChanged(new SimpleTreeEvent(this, simpleTreeNode));
        }
    }

    private void fireNodeExpansionChanged(SimpleTreeNode simpleTreeNode) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SimpleTreeListener)enumeration.nextElement()).nodeExpansionChanged(new SimpleTreeEvent(this, simpleTreeNode));
        }
    }

    public SimpleTreeNode addToSelectedNode(String string, Object object) {
        SimpleTreeNode simpleTreeNode = new SimpleTreeNode(string, object);
        this.selectedNode.add(simpleTreeNode);
        if (!this.selectedNode.isExpanded()) {
            this.selectedNode.setExpanded(true);
        }
        this.paint(this.getGraphics());
        this.fireNodeInserted(simpleTreeNode);
        return simpleTreeNode;
    }

    public SimpleTreeNode addToNode(SimpleTreeNode simpleTreeNode, String string, Object object) {
        SimpleTreeNode simpleTreeNode2 = new SimpleTreeNode(string, object);
        simpleTreeNode.add(simpleTreeNode2);
        this.paint(this.getGraphics());
        this.fireNodeInserted(simpleTreeNode2);
        return simpleTreeNode2;
    }

    public SimpleTreeNode insertBeforeNode(SimpleTreeNode simpleTreeNode, String string, Object object) {
        SimpleTreeNode simpleTreeNode2 = new SimpleTreeNode(string, object);
        simpleTreeNode.insert(simpleTreeNode2);
        this.paint(this.getGraphics());
        this.fireNodeInserted(simpleTreeNode2);
        return simpleTreeNode2;
    }

    public void removeFromSelectedNode(int n) {
        SimpleTreeNode simpleTreeNode = this.selectedNode.getChildAt(n);
        this.selectedNode.removeChildAt(n);
        this.paint(this.getGraphics());
        this.fireNodeRemoved(simpleTreeNode);
    }

    public void removeFromNode(SimpleTreeNode simpleTreeNode, int n) {
        SimpleTreeNode simpleTreeNode2 = simpleTreeNode.getChildAt(n);
        simpleTreeNode.removeChildAt(n);
        this.paint(this.getGraphics());
        this.fireNodeRemoved(simpleTreeNode2);
    }

    public void removeNodeFromNode(SimpleTreeNode simpleTreeNode, SimpleTreeNode simpleTreeNode2) {
        simpleTreeNode2.removeChild(simpleTreeNode);
        this.paint(this.getGraphics());
        this.fireNodeRemoved(simpleTreeNode);
    }

    private SimpleTreeNode getNodeOnRow(SimpleTreeNode simpleTreeNode, int n) {
        if (simpleTreeNode != null && !simpleTreeNode.isLeaf() && simpleTreeNode.isExpanded() && simpleTreeNode.getRow() != n) {
            Enumeration enumeration = simpleTreeNode.getChildren();
            while (enumeration.hasMoreElements() && simpleTreeNode.getRow() != n) {
                simpleTreeNode = this.getNodeOnRow((SimpleTreeNode)enumeration.nextElement(), n);
            }
        }
        return simpleTreeNode;
    }

    public SimpleTreeNode getRoot() {
        return this.root;
    }

    public SimpleTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public SimpleTreeNode getLastSelectedNode() {
        return this.lastSelectedNode;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.maxWidth + 50, this.y0 + this.lastRow * this.rowHeight + this.rowHeight * 2);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void paint(Graphics graphics) {
        if (graphics != null) {
            Dimension dimension = this.size();
            int n = dimension.width;
            int n2 = dimension.height;
            this.rowHeight = graphics.getFont().getSize() + this.nodeGap;
            graphics.setColor(this.partColor[1]);
            graphics.fillRect(0, 0, n, n2);
            this.lastRow = this.paintNode(graphics, this.root, 0, 0);
            int n3 = this.y0 + this.lastRow * this.rowHeight;
            if (n3 > n2) {
                this.setSize(n, n3);
            }
        }
    }

    private int paintNode(Graphics graphics, SimpleTreeNode simpleTreeNode, int n, int n2) {
        if (simpleTreeNode != null) {
            int n3 = n2;
            int n4 = 0;
            int n5 = n;
            this.paintHorizontalLine(graphics, n, n2);
            this.paintNodeSymbol(graphics, simpleTreeNode, n, n2);
            this.paintNodeText(graphics, simpleTreeNode, n, n2);
            if (simpleTreeNode.isExpanded()) {
                Enumeration enumeration = simpleTreeNode.getChildren();
                ++n;
                while (enumeration.hasMoreElements()) {
                    n4 = ++n2;
                    n2 = this.paintNode(graphics, (SimpleTreeNode)enumeration.nextElement(), n, n4);
                }
                this.paintVerticalLine(graphics, simpleTreeNode, n5, n3, n4);
            }
            this.paintActionSymbol(graphics, simpleTreeNode, n5, n3);
            simpleTreeNode.setRow(n3);
        }
        return n2;
    }

    private void paintVerticalLine(Graphics graphics, SimpleTreeNode simpleTreeNode, int n, int n2, int n3) {
        if (simpleTreeNode.isExpanded() && !simpleTreeNode.isLeaf()) {
            int n4 = n == 0 ? this.x0 : this.x0 + this.hIndent * n;
            int n5 = this.y0 + this.rowHeight * (n2 + 1);
            graphics.setColor(this.partColor[0]);
            graphics.drawLine(n4, n5, n4, n5 + this.rowHeight * (n3 - n2) - this.rowHeight / 2 + this.nodeGap / 2);
        }
    }

    private void paintHorizontalLine(Graphics graphics, int n, int n2) {
        if (n > 0) {
            int n3 = this.x0 + this.hIndent * (n - 1);
            int n4 = this.y0 + this.rowHeight * (n2 + 1) - this.rowHeight / 2 + this.nodeGap / 2;
            graphics.setColor(this.partColor[0]);
            graphics.drawLine(n3, n4, n3 + this.hIndent, n4);
        }
    }

    private void paintActionSymbol(Graphics graphics, SimpleTreeNode simpleTreeNode, int n, int n2) {
        Image image;
        if (!simpleTreeNode.isLeaf() && !simpleTreeNode.isRoot() && (image = simpleTreeNode.isExpanded() ? this.collapseActionImg : this.expandActionImg) != null) {
            Rectangle rectangle = this.getActionSymbolRect(n2, n, image);
            graphics.drawImage(image, rectangle.x, rectangle.y, this);
        }
    }

    private Rectangle getActionSymbolRect(int n, int n2, Image image) {
        int n3 = n2 == 1 ? this.x0 - image.getWidth(this) / 2 : this.x0 + this.hIndent * (n2 - 1) - image.getWidth(this) / 2;
        int n4 = this.y0 - image.getHeight(this) / 2 + this.rowHeight * (n + 1) - this.rowHeight / 2 + this.nodeGap / 2;
        return new Rectangle(n3, n4, image.getWidth(this), image.getHeight(this));
    }

    private void paintNodeSymbol(Graphics graphics, SimpleTreeNode simpleTreeNode, int n, int n2) {
        Image image = simpleTreeNode.isLeaf() ? this.leafImg : (simpleTreeNode.isExpanded() ? this.expandedParentImg : this.collapsedParentImg);
        if (image != null) {
            int n3 = n == 0 ? this.x0 - image.getWidth(this) / 2 : this.x0 + this.hIndent * n - image.getWidth(this) / 2;
            int n4 = this.y0 - image.getHeight(this) / 2 + this.rowHeight * (n2 + 1) - this.rowHeight / 2 + this.nodeGap / 2;
            graphics.drawImage(image, n3, n4, this);
        }
    }

    private void paintNodeText(Graphics graphics, SimpleTreeNode simpleTreeNode, int n, int n2) {
        int n3 = this.y0 + this.rowHeight * (n2 + 1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = simpleTreeNode.toString();
        int n4 = fontMetrics.getAscent();
        int n5 = fontMetrics.charsWidth(string.toCharArray(), 0, string.length());
        int n6 = n == 0 ? this.hIndent + this.nodeGap * 2 : this.x0 + this.hIndent * n + this.nodeGap * 3;
        if (simpleTreeNode.equals(this.selectedNode)) {
            graphics.setColor(this.partColor[6]);
            graphics.fillRect(n6, n3 - n4, n5, n4 + fontMetrics.getDescent());
            graphics.setColor(this.partColor[5]);
        } else {
            graphics.setColor(this.partColor[1]);
            graphics.fillRect(n6, n3 - n4, n5, n4 + fontMetrics.getDescent());
            graphics.setColor(this.partColor[2]);
        }
        graphics.drawString(simpleTreeNode.toString(), n6, n3);
        this.maxWidth = Math.max(n6 + n5, this.maxWidth);
    }

    public static final class SimpleTreePart {
        public static final int TREE_LINE = 0;
        public static final int TREE_BACKGROUND = 1;
        public static final int NODE_TEXT = 2;
        public static final int ACTION_SYMBOL = 3;
        public static final int NODE_SYMBOL = 4;
        public static final int SELECTION_TEXT = 5;
        public static final int SELECTION_BACKGROUND = 6;

        static {
            TREE_LINE = 0;
            TREE_BACKGROUND = 1;
            NODE_TEXT = 2;
            ACTION_SYMBOL = 3;
            NODE_SYMBOL = 4;
            SELECTION_TEXT = 5;
            SELECTION_BACKGROUND = 6;
        }
    }
}

