#include <boost/bind.hpp>
#include "udpmessageserver.h"


UDPMessageServer::UDPMessageServer(asio::io_service& io_service, unsigned short port_num )
    :ioservice(io_service),
    sock(io_service, asio::ip::udp::endpoint(asio::ip::udp::v4(), port_num) )
{
  sock.async_receive_from( asio::buffer(data, max_length), sender_endpoint,
                           boost::bind(&UDPMessageServer::handleReceiveFrom, this, asio::placeholders::error, asio::placeholders::bytes_transferred));

}


UDPMessageServer::UDPMessageServer(asio::io_service& io_service, const asio::ip::udp::endpoint & endpoint )
    :ioservice(io_service),
    sock(io_service)
{
  sock.open(endpoint.protocol());
  if (endpoint.address().is_v6())
  {
    sock.set_option(asio::ip::v6_only(true));
  }
  sock.bind(endpoint);

  sock.async_receive_from( asio::buffer(data, max_length), sender_endpoint,
                           boost::bind(&UDPMessageServer::handleReceiveFrom, this, asio::placeholders::error, asio::placeholders::bytes_transferred));

}


void UDPMessageServer::handleReceiveFrom(const asio::error_code& err, size_t length)
{
  if (err)
  {
    // cout << "receive error: " << err.message() << endl;
  }
  else
  {
    //cout << "UDPMessageServer::handle_receive_from received " << length << " bytes" << endl;
    Message message(length, data);
    Message returnMessage;
    receiveMessageSignal(returnMessage, message);

    // FIXME  add a queue (including timer for retransmission) for returnMessage handling - how to handle different sender_endpoints?

    if ((false==returnMessage.dontSendFlag) && (returnMessage.size()>0))
    {
      //cout << "UDPMessageServer::handle_receive_from sending " << returnMessage.size() << " bytes" << endl;
      sock.send_to(asio::buffer(returnMessage.getDataPtr(), returnMessage.size()), sender_endpoint);
    }

    sock.async_receive_from( asio::buffer(data, max_length), sender_endpoint,
                             boost::bind(&UDPMessageServer::handleReceiveFrom, this, asio::placeholders::error, asio::placeholders::bytes_transferred));

  }
}

