#ifndef _procinfo_h
#define _procinfo_h

#include <list>

#ifdef __linux__
#include <sys/time.h>
#endif


#ifdef __sun__
// we need the number of cpus for propper scaling of percent cpu-usage
#include <sinfo/cpuinfo.h>
#endif


#define COMMSIZE 17
//   synchronize with size of comm in struct task_struct in
//   /usr/include/linux/sched.h ... or equivalent on sun or BSD


#define USERNAMEMAX 10
// maximum length for user names


struct Procinfo
{
  int pid;                           // process ID
  char command[COMMSIZE];            // the name of the running process
  char state;                        // the process state 'R'=running, ...
  int priority;
  char username[USERNAMEMAX];        // translated UID
  float cpupercent;                  // CPU usage of this process
};


class ProcinfoMeter
{
public:
  struct ProcinfoInternal
  {
    Procinfo procinfo;

    int uid;

#ifdef __linux__
    int stat_utime;
    int stat_stime;
    int last_stat_utime;
    int last_stat_stime;
#endif

    bool updated;  // set to true if updated or new, false if process terminated
  }
  ;
private:

  std::list < ProcinfoInternal > procinfoInternalList;

  void unmarkProcinfoInternalList();  // set alle "updated" flags to false
  std::list < ProcinfoInternal > ::iterator getProcinfoInternalList(int pid);  // and set "updated"

#ifdef __linux__
  struct timeval oldtime;
  float get_elapsed_time();
  bool readProcinfo(ProcinfoInternal & pii);
#endif
#ifdef __sun__
  Cpuinfo cpuinfo;
  bool readProcinfo(ProcinfoInternal & pii);
#endif
  void updateProcinfoInternalList();  // different implementations for Linux, Solaris, FreeBSD available

  void cleanupProcinfoInternalList();  // erase all entries that are not "updated"


public:
  ProcinfoMeter();
  bool getTopList(int nr, Procinfo procinfo[]);  // Update and return the top nr entries of procinfoInternalList
}
;

bool operator<(const ProcinfoMeter::ProcinfoInternal& a, const ProcinfoMeter::ProcinfoInternal&b);


#endif
