#include <boost/bind.hpp>
#include <iostream>
#include "messagebasictypes.h"
#include "messagecomplextypes.h"
#include "messagesinfotypes.h"
#include "measureserver.h"
using namespace std;
using namespace Msg;


// constants for the broadcasting timing
////////////////////////////////////////


// if sinfo produces to much net load for your purposes,
// you may twiddle with the following factors.


// don't send informations to sinfo if the computer was last herad
// for the last 25 seconds
// FIXME ? implement this again?
// const unsigned long dropoldTimer = 25;


// check the cpu-load every second....
// if the load has not changed (less 3%),
// broadcast every 10 seconds otherwise broadcast every second.
// if the CPU load has changed much (groeter 30%) trigger the
// sending of the process informations.
const unsigned long cpustatTimer = 1;
const unsigned long cpustatTimerMax = 10;
const float cpustatTimerFastThr = 0.05;      // fastBcast threshold in percentage of idle time
const float cpustatTimerProcinfoThr = 0.3;   // sendProcinfo threshold in percentage of idle time

const unsigned long loadavgTimer = 10;
const unsigned long uptimeTimer = 10;
const unsigned long procinfoTimer = 10;
const unsigned long netloadTimer = 10;
const unsigned long diskloadTimer = 10;
const unsigned long meminfoTimer = 30;
const unsigned long usersTimer = 30;
const unsigned long unamestrTimer = 900;
const unsigned long cpuinfoTimer = 900;
const unsigned long markerTimer = 900;

// if we received a restart flag we will send out ALL informations
// several times with a broadcasting intervall of 10 seconds.
const unsigned long restartTimer = 10;


string bcast_address_global; // FIXME: bad global

// FIXME implement as method?
void term_handler(int signal)
{
  Message message;
  pushBackuint8(message,sigtermFlag);

  cout << "term_handler " << message.size() << "bytes" << endl;
  asio::io_service io_service;
  asio::ip::udp::endpoint sender_endpoint(asio::ip::address::from_string(bcast_address_global), SINFO_BROADCAST_PORT);
  asio::ip::udp::socket sock(io_service,sender_endpoint.protocol());
  sock.set_option(asio::socket_base::broadcast(true));

  //http://asio.sourceforge.net/boost_asio_1_0_0/libs/asio/doc/html/boost_asio/reference/basic_datagram_socket/broadcast.html
  sock.send_to(asio::buffer(message.getDataPtr(), message.size()), sender_endpoint);

  exit(0);
}


MeasureServer::MeasureServer(asio::io_service& io_service, const std::string & _bcast_address, const std::string & networkcard, const std::string & _marker):ioservice(io_service), timer(io_service), netloadMeter(networkcard), marker(_marker)
{
  timeCounter = 0;
  procinfonow = false;
  sendRestartFlag = true;
  lastidlepercent = 0.;

  bcast_address=_bcast_address;
  bcast_address_global=_bcast_address; // FIXME: bad global

  timer.expires_from_now(boost::posix_time::milliseconds(500));
  timer.async_wait(boost::bind(&MeasureServer::handle_timeout, this));

  restartcounter=0;

  // FIXME save old handler
  signal(SIGTERM, term_handler);
  signal(SIGQUIT, term_handler);
  signal(SIGINT, term_handler);
}


void MeasureServer::timerEvent()
{
  Message message;

  if (0 == (timeCounter%meminfoTimer))
  {
    Meminfo meminfo;
    if (getMeminfo(meminfo))
    {
      pushBackuint8(message, meminfoFlag);
      pushBackMeminfo(message, meminfo);
    }
  }

  if (0 == (timeCounter%loadavgTimer))
  {
    Loadavg loadavg;
    if (getLoadavg(loadavg))
    {
      pushBackuint8(message, loadavgFlag);
      pushBackLoadavg(message, loadavg);
    }
  }

  if (0 == (timeCounter%cpustatTimer))
  {
    Cpustat cpustat;
    if (cpustatMeter.getCpustat(cpustat))
    {
      if ((0 == timeCounter)
          || (fabs(lastidlepercent - cpustat.idlep) >= cpustatTimerFastThr)
          || (0==(timeCounter%cpustatTimerMax)) )
      {

        if (fabs(lastidlepercent - cpustat.idlep) >= cpustatTimerProcinfoThr)
          procinfonow = true;

        pushBackuint8(message, cpustatFlag);
        pushBackCpustat(message, cpustat);

        lastidlepercent = cpustat.idlep;
      }
    }
  }

  if (0 == (timeCounter%cpuinfoTimer))
  {
    Cpuinfo cpuinfo;
    if (getCpuinfo(cpuinfo))
    {
      pushBackuint8(message, cpuinfoFlag);
      pushBackCpuinfo(message, cpuinfo);
    }
  }

  if (0 == (timeCounter%markerTimer))
  {
    pushBackuint8(message, markerFlag);
    pushBackstring8(message, marker);
  }

  if (0 == (timeCounter%netloadTimer))
  {
    Netload netload;
    if (netloadMeter.getNetload(netload))
    {
      pushBackuint8(message, netloadFlag);
      pushBackNetload(message, netload);
    }
  }

  if (0 == (timeCounter%diskloadTimer))
  {
    Diskload diskload;
    if (diskloadMeter.getDiskload(diskload))
    {
      pushBackuint8(message, diskloadFlag);
      pushBackDiskload(message, diskload);
    }
  }

  if (0 == (timeCounter%unamestrTimer))
  {
    Unameinfo unameinfo = getUnameinfo();

    pushBackuint8(message, unameinfoFlag);
    pushBackUnameinfo(message, unameinfo);
  }

  if (0 == (timeCounter%uptimeTimer))
  {
    Uptime uptime;
    if (getUptime(uptime))
    {
      pushBackuint8(message, uptimeFlag);
      pushBackUptime(message, uptime);
    }
  }

  if (0 == (timeCounter%usersTimer))
  {
    Users users = getUsers();

    pushBackuint8(message, usersFlag);
    pushBackUsers(message, users);
  }


  if ( (0 == (timeCounter%procinfoTimer)) || (procinfonow) )
  {
    Procinfo pi[5];
    if (procinfoMeter.getTopList(5, pi))
    {
      pushBackuint8(message, procinfoFlag);
      for (int i = 0; i < 5; i++)
      {
        pushBackProcinfo(message, pi[i]);
      }
    }
    procinfonow = false;
  }

  if (sendRestartFlag)
  {
    pushBackuint8(message, restartFlag);
    sendRestartFlag = false;
  }

  if (message.size()>0)
  {
    // try-catch to avoid stop of program when udp port is not available due to
    // reconfiguration (e.g. ipatbles)
    try
    {
      cout << "MeasureServer::timerEvent sending " << message.size() << "bytes" << endl;
      asio::io_service io_service;
      asio::ip::udp::endpoint sender_endpoint(asio::ip::address::from_string(bcast_address), SINFO_BROADCAST_PORT);
      asio::ip::udp::socket sock(io_service,sender_endpoint.protocol());
      sock.set_option(asio::socket_base::broadcast(true));

      //http://asio.sourceforge.net/boost_asio_1_0_0/libs/asio/doc/html/boost_asio/reference/basic_datagram_socket/broadcast.html
      sock.send_to(asio::buffer(message.getDataPtr(), message.size()), sender_endpoint);
    }
    catch (std::exception& e)
    {
      cerr << "Exception: " << e.what() << endl;
    }
  }

  timeCounter++;

  if ( (restartcounter>0) &&  (0 == (timeCounter%restartTimer)) )
  {
    timeCounter = 0;
    restartcounter--;
  }
}


void MeasureServer::restartCounterEvent()
{
  restartcounter=3;
}


void MeasureServer::handle_timeout()
{
  cout << "MeasureServer::handle_timeout" << endl;
  timerEvent();

  timer.expires_from_now(boost::posix_time::milliseconds(1000));
  timer.async_wait(boost::bind(&MeasureServer::handle_timeout, this));
}

