/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.collections.AbstractList4;
import java.util.Collection;
import java.util.ConcurrentModificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubArrayList4<E>
extends AbstractList4<E> {
    private AbstractList4<E> _delegate;
    private int _fromIndex;
    private int _size;

    public SubArrayList4(AbstractList4<E> abstractList4, int n, int n2) {
        this._delegate = abstractList4;
        this._fromIndex = n;
        this.syncModCount();
        this.setSize(n2 - n);
    }

    @Override
    public void add(int n, E e) {
        this.checkIndex(n, 0, this.size());
        this.checkConcurrentModification();
        this._delegate.add(this.translatedIndex(n), e);
        this.increaseSize(1);
        this.syncModCount();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.checkIndex(n, 0, this.size());
        this.checkConcurrentModification();
        boolean bl = this._delegate.addAll(this.translatedIndex(n), collection);
        this.increaseSize(collection.size());
        this.syncModCount();
        return bl;
    }

    @Override
    public E get(int n) {
        this.checkIndex(n, 0, this.size() - 1);
        this.checkConcurrentModification();
        return this._delegate.get(this.translatedIndex(n));
    }

    @Override
    public E remove(int n) {
        this.checkIndex(n, 0, this.size() - 1);
        this.checkConcurrentModification();
        E e = this._delegate.remove(this.translatedIndex(n));
        this.decreaseSize(1);
        this.syncModCount();
        return e;
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n < 0 || n >= this.size() || n2 > this.size() || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        this._delegate.removeRange(n + this._fromIndex, n2 + this._fromIndex);
        this.decreaseSize(n2 - n);
        this.syncModCount();
    }

    @Override
    public E set(int n, E e) {
        this.checkIndex(n, 0, this.size() - 1);
        this.checkConcurrentModification();
        E e2 = this._delegate.set(this.translatedIndex(n), e);
        this.syncModCount();
        return e2;
    }

    @Override
    public int size() {
        return this._size;
    }

    private void checkConcurrentModification() {
        if (this.modCount != this._delegate.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void syncModCount() {
        this.modCount = this._delegate.modCount;
    }

    private int translatedIndex(int n) {
        return n + this._fromIndex;
    }

    private void setSize(int n) {
        this._size = n;
    }

    private void increaseSize(int n) {
        this._size += n;
    }

    private void decreaseSize(int n) {
        this._size -= n;
    }
}

