/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections.facades;

import com.db4o.collections.facades.CachedObject;
import com.db4o.collections.facades.FastListCache;
import com.db4o.foundation.Iterator4JdkIterator;
import com.db4o.foundation.JdkCollectionIterable4;
import com.db4o.internal.collections.PersistentList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastList
implements List {
    private PersistentList _persistentList;
    private transient FastListCache _cache;

    public FastList() {
    }

    public FastList(PersistentList persistentList) {
        this._persistentList = persistentList;
        this.ensureInitFastListCache();
    }

    private void ensureInitFastListCache() {
        if (this._cache == null) {
            this._cache = new FastListCache(this.size());
        }
    }

    public boolean add(Object object) {
        this.ensureInitFastListCache();
        this._cache.add(object);
        return this._persistentList.add(object);
    }

    public void add(int n, Object object) {
        this.validateIndex(n);
        this.ensureInitFastListCache();
        this._cache.add(n, object);
        this._persistentList.add(n, object);
    }

    public boolean addAll(Collection collection) {
        this.ensureInitFastListCache();
        this._cache.addAll(collection);
        return this._persistentList.addAll(new JdkCollectionIterable4(collection));
    }

    public boolean addAll(int n, Collection collection) {
        this.validateIndex(n);
        this.ensureInitFastListCache();
        this._cache.addAll(n, collection);
        return this._persistentList.addAll(n, new JdkCollectionIterable4(collection));
    }

    public void clear() {
        this.ensureInitFastListCache();
        this._cache.clear();
        this._persistentList.clear();
    }

    public boolean contains(Object object) {
        this.ensureInitFastListCache();
        if (this._cache.contains(object)) {
            return true;
        }
        return this._persistentList.contains(object);
    }

    public boolean containsAll(Collection collection) {
        this.ensureInitFastListCache();
        boolean bl = this._cache.containsAll(collection);
        if (bl) {
            return true;
        }
        return this._persistentList.containsAll(new JdkCollectionIterable4(collection));
    }

    public Object get(int n) {
        this.ensureInitFastListCache();
        CachedObject cachedObject = this._cache.get(n);
        if (cachedObject != CachedObject.NONE) {
            return cachedObject.obj;
        }
        return this._persistentList.get(n);
    }

    public int indexOf(Object object) {
        int n = this._cache.indexOf(object);
        if (n != -1) {
            return n;
        }
        return this._persistentList.indexOf(object);
    }

    public boolean isEmpty() {
        return this._persistentList.isEmpty();
    }

    public Iterator iterator() {
        return new Iterator4JdkIterator(this._persistentList.iterator());
    }

    public int lastIndexOf(Object object) {
        return this._persistentList.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        this.ensureInitFastListCache();
        this._cache.remove(object);
        return this._persistentList.remove(object);
    }

    public Object remove(int n) {
        this.ensureInitFastListCache();
        this._cache.remove(n);
        return this._persistentList.remove(n);
    }

    public boolean removeAll(Collection collection) {
        this.ensureInitFastListCache();
        this._cache.removeAll(collection);
        return this._persistentList.removeAll(new JdkCollectionIterable4(collection));
    }

    public boolean retainAll(Collection collection) {
        this.ensureInitFastListCache();
        this._cache.retainAll(collection);
        return this._persistentList.retainAll(new JdkCollectionIterable4(collection));
    }

    public Object set(int n, Object object) {
        this.validateIndex(n);
        this.ensureInitFastListCache();
        this._cache.set(n, object);
        return this._persistentList.set(n, object);
    }

    public int size() {
        return this._persistentList.size();
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        return this._persistentList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this._persistentList.toArray(objectArray);
    }

    private void validateIndex(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

