/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DatabaseReadOnlyException;
import com.db4o.Db4o;
import com.db4o.Rename;
import com.db4o.config.Alias;
import com.db4o.config.ClientServerConfiguration;
import com.db4o.config.ConfigScope;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.config.FreespaceConfiguration;
import com.db4o.config.FreespaceFiller;
import com.db4o.config.GlobalOnlyConfigException;
import com.db4o.config.ObjectClass;
import com.db4o.config.QueryConfiguration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.diagnostic.DiagnosticConfiguration;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.KeySpec;
import com.db4o.foundation.KeySpecHashtable4;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.cs.QueryResultIteratorFactory;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.io.CachedIoAdapter;
import com.db4o.io.IoAdapter;
import com.db4o.io.RandomAccessFileAdapter;
import com.db4o.messaging.MessageRecipient;
import com.db4o.messaging.MessageSender;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public final class Config4Impl
implements Configuration,
DeepClone,
MessageSender,
FreespaceConfiguration,
QueryConfiguration,
ClientServerConfiguration {
    private KeySpecHashtable4 _config = new KeySpecHashtable4(50);
    private static final KeySpec ACTIVATION_DEPTH = new KeySpec(5);
    private static final KeySpec ALLOW_VERSION_UPDATES = new KeySpec(false);
    private static final KeySpec AUTOMATIC_SHUTDOWN = new KeySpec(true);
    private static final KeySpec BLOCKSIZE = new KeySpec(1);
    private static final KeySpec BLOBPATH = new KeySpec(null);
    private static final KeySpec BTREE_NODE_SIZE = new KeySpec(119);
    private static final KeySpec BTREE_CACHE_HEIGHT = new KeySpec(1);
    private static final KeySpec CALLBACKS = new KeySpec(true);
    private static final KeySpec CALL_CONSTRUCTORS = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec CONFIGURATION_ITEMS = new KeySpec(null);
    private static final KeySpec CLASS_ACTIVATION_DEPTH_CONFIGURABLE = new KeySpec(true);
    private static final KeySpec CLASSLOADER = new KeySpec(null);
    private static final KeySpec DETECT_SCHEMA_CHANGES = new KeySpec(true);
    private static final KeySpec DIAGNOSTIC = new KeySpec(new DiagnosticProcessor());
    private static final KeySpec DISABLE_COMMIT_RECOVERY = new KeySpec(false);
    private static final KeySpec DISCARD_FREESPACE = new KeySpec(0);
    private static final KeySpec ENCODING = new KeySpec(2);
    private static final KeySpec ENCRYPT = new KeySpec(false);
    private static final KeySpec EXCEPTIONAL_CLASSES = new KeySpec(null);
    private static final KeySpec EXCEPTIONS_ON_NOT_STORABLE = new KeySpec(false);
    private static final KeySpec FLUSH_FILE_BUFFERS = new KeySpec(true);
    private static final KeySpec FREESPACE_FILLER = new KeySpec(null);
    private static final KeySpec FREESPACE_SYSTEM = new KeySpec(0);
    private static final KeySpec GENERATE_UUIDS = new KeySpec(ConfigScope.INDIVIDUALLY);
    private static final KeySpec GENERATE_VERSION_NUMBERS = new KeySpec(ConfigScope.INDIVIDUALLY);
    private static final KeySpec IS_SERVER = new KeySpec(false);
    private static final KeySpec QUERY_EVALUATION_MODE = new KeySpec(QueryEvaluationMode.IMMEDIATE);
    private static final KeySpec LOCK_FILE = new KeySpec(true);
    private static final KeySpec MESSAGE_RECIPIENT = new KeySpec(null);
    private static final KeySpec OPTIMIZE_NQ = new KeySpec(true);
    private static final KeySpec OUTSTREAM = new KeySpec(null);
    private static final KeySpec PASSWORD = new KeySpec(null);
    private static final KeySpec CLIENT_QUERY_RESULT_ITERATOR_FACTORY = new KeySpec(null);
    private static final KeySpec PREFETCH_ID_COUNT = new KeySpec(10);
    private static final KeySpec PREFETCH_OBJECT_COUNT = new KeySpec(10);
    private static final KeySpec READ_AS = new KeySpec(new Hashtable4(16));
    private static final KeySpec CONFIGURED_REFLECTOR = new KeySpec(null);
    private static final KeySpec REFLECTOR = new KeySpec(null);
    private static final KeySpec RENAME = new KeySpec(null);
    private static final KeySpec RESERVED_STORAGE_SPACE = new KeySpec(0);
    private static final KeySpec SINGLE_THREADED_CLIENT = new KeySpec(false);
    private static final KeySpec TEST_CONSTRUCTORS = new KeySpec(true);
    private static final KeySpec TIMEOUT_CLIENT_SOCKET = new KeySpec(600000);
    private static final KeySpec TIMEOUT_SERVER_SOCKET = new KeySpec(600000);
    private static final KeySpec UPDATE_DEPTH = new KeySpec(0);
    private static final KeySpec WEAK_REFERENCE_COLLECTION_INTERVAL = new KeySpec(1000);
    private static final KeySpec WEAK_REFERENCES = new KeySpec(true);
    private static final KeySpec IOADAPTER = new KeySpec(new CachedIoAdapter(new RandomAccessFileAdapter()));
    private static final KeySpec ALIASES = new KeySpec(null);
    private static final KeySpec BATCH_MESSAGES = new KeySpec(true);
    private static final KeySpec MAX_BATCH_QUEUE_SIZE = new KeySpec(Integer.MAX_VALUE);
    private ObjectContainerBase i_stream;
    private boolean _internStrings;
    private int _messageLevel;
    private boolean _readOnly;

    public int activationDepth() {
        return this._config.getAsInt(ACTIVATION_DEPTH);
    }

    public void activationDepth(int n) {
        this._config.put(ACTIVATION_DEPTH, n);
    }

    public void add(ConfigurationItem configurationItem) {
        configurationItem.prepare(this);
        this.safeConfigurationItems().put(configurationItem, (Object)configurationItem);
    }

    private Hashtable4 safeConfigurationItems() {
        Hashtable4 hashtable4 = this.configurationItems();
        if (hashtable4 == null) {
            hashtable4 = new Hashtable4(16);
            this._config.put(CONFIGURATION_ITEMS, hashtable4);
        }
        return hashtable4;
    }

    public void allowVersionUpdates(boolean bl) {
        this._config.put(ALLOW_VERSION_UPDATES, bl);
    }

    private Hashtable4 configurationItems() {
        return (Hashtable4)this._config.get(CONFIGURATION_ITEMS);
    }

    public void applyConfigurationItems(InternalObjectContainer internalObjectContainer) {
        Hashtable4 hashtable4 = this.configurationItems();
        if (hashtable4 == null) {
            return;
        }
        Iterator4 iterator4 = hashtable4.iterator();
        while (iterator4.moveNext()) {
            Entry4 entry4 = (Entry4)iterator4.current();
            ConfigurationItem configurationItem = (ConfigurationItem)entry4.value();
            configurationItem.apply(internalObjectContainer);
        }
    }

    public void automaticShutDown(boolean bl) {
        this._config.put(AUTOMATIC_SHUTDOWN, bl);
    }

    public void blockSize(int n) {
        if (n < 1 || n > 127) {
            throw new IllegalArgumentException();
        }
        this.globalSettingOnly();
        this._config.put(BLOCKSIZE, (byte)n);
    }

    public void bTreeNodeSize(int n) {
        this._config.put(BTREE_NODE_SIZE, n);
    }

    public void bTreeCacheHeight(int n) {
        this._config.put(BTREE_CACHE_HEIGHT, n);
    }

    public void callbacks(boolean bl) {
        this._config.put(CALLBACKS, bl);
    }

    public void callConstructors(boolean bl) {
        this._config.put(CALL_CONSTRUCTORS, TernaryBool.forBoolean(bl));
    }

    public void classActivationDepthConfigurable(boolean bl) {
        this._config.put(CLASS_ACTIVATION_DEPTH_CONFIGURABLE, bl);
    }

    Config4Class configClass(String string) {
        Config4Class config4Class = (Config4Class)this.exceptionalClasses().get(string);
        return config4Class;
    }

    public Object deepClone(Object object) {
        Config4Impl config4Impl = new Config4Impl();
        config4Impl._config = (KeySpecHashtable4)this._config.deepClone(this);
        config4Impl._internStrings = this._internStrings;
        config4Impl._messageLevel = this._messageLevel;
        config4Impl._readOnly = this._readOnly;
        return config4Impl;
    }

    public void stream(ObjectContainerBase objectContainerBase) {
        this.i_stream = objectContainerBase;
    }

    public void detectSchemaChanges(boolean bl) {
        this._config.put(DETECT_SCHEMA_CHANGES, bl);
    }

    public void disableCommitRecovery() {
        this._config.put(DISABLE_COMMIT_RECOVERY, true);
    }

    public void discardFreeSpace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._config.put(DISCARD_FREESPACE, n);
    }

    public void discardSmallerThan(int n) {
        this.discardFreeSpace(n);
    }

    public void encrypt(boolean bl) {
        this.globalSettingOnly();
        this._config.put(ENCRYPT, bl);
    }

    void oldEncryptionOff() {
        this._config.put(ENCRYPT, false);
    }

    void ensureDirExists(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException(Messages.get(37, string));
        }
    }

    PrintStream errStream() {
        PrintStream printStream = this.outStreamOrNull();
        return printStream == null ? System.err : printStream;
    }

    public void exceptionsOnNotStorable(boolean bl) {
        this._config.put(EXCEPTIONS_ON_NOT_STORABLE, bl);
    }

    public void flushFileBuffers(boolean bl) {
        this._config.put(FLUSH_FILE_BUFFERS, bl);
    }

    public FreespaceConfiguration freespace() {
        return this;
    }

    public void freespaceFiller(FreespaceFiller freespaceFiller) {
        this._config.put(FREESPACE_FILLER, freespaceFiller);
    }

    public FreespaceFiller freespaceFiller() {
        return (FreespaceFiller)this._config.get(FREESPACE_FILLER);
    }

    public void generateUUIDs(int n) {
        this.generateUUIDs(ConfigScope.forID(n));
    }

    public void generateUUIDs(ConfigScope configScope) {
        this._config.put(GENERATE_UUIDS, configScope);
    }

    public void generateVersionNumbers(int n) {
        this.generateVersionNumbers(ConfigScope.forID(n));
    }

    public void generateVersionNumbers(ConfigScope configScope) {
        this._config.put(GENERATE_VERSION_NUMBERS, configScope);
    }

    public MessageSender getMessageSender() {
        return this;
    }

    private void globalSettingOnly() {
        if (this.i_stream != null) {
            throw new GlobalOnlyConfigException();
        }
    }

    public void internStrings(boolean bl) {
        this._internStrings = bl;
    }

    public void io(IoAdapter ioAdapter) {
        this.globalSettingOnly();
        this._config.put(IOADAPTER, ioAdapter);
    }

    public void lockDatabaseFile(boolean bl) {
        this._config.put(LOCK_FILE, bl);
    }

    public void markTransient(String string) {
        Platform4.markTransient(string);
    }

    public void messageLevel(int n) {
        this._messageLevel = n;
        if (this.outStream() == null) {
            this.setOut(System.out);
        }
    }

    public void optimizeNativeQueries(boolean bl) {
        this._config.put(OPTIMIZE_NQ, bl);
    }

    public boolean optimizeNativeQueries() {
        return this._config.getAsBoolean(OPTIMIZE_NQ);
    }

    public ObjectClass objectClass(Object object) {
        Object object2;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else {
            object2 = this.reflectorFor(object);
            if (object2 == null) {
                return null;
            }
            string = object2.getName();
        }
        object2 = this.exceptionalClasses();
        Config4Class config4Class = (Config4Class)((Hashtable4)object2).get(string);
        if (config4Class == null) {
            config4Class = new Config4Class(this, string);
            ((Hashtable4)object2).put(string, (Object)config4Class);
        }
        return config4Class;
    }

    private PrintStream outStreamOrNull() {
        return (PrintStream)this._config.get(OUTSTREAM);
    }

    PrintStream outStream() {
        PrintStream printStream = this.outStreamOrNull();
        return printStream == null ? System.out : printStream;
    }

    public void password(String string) {
        this.globalSettingOnly();
        this._config.put(PASSWORD, string);
    }

    public void readOnly(boolean bl) {
        this._readOnly = bl;
    }

    public GenericReflector reflector() {
        GenericReflector genericReflector = (GenericReflector)this._config.get(REFLECTOR);
        if (genericReflector == null) {
            Reflector reflector = (Reflector)this._config.get(CONFIGURED_REFLECTOR);
            if (reflector == null) {
                reflector = Platform4.createReflector(this.classLoader());
                this._config.put(CONFIGURED_REFLECTOR, reflector);
            }
            genericReflector = new GenericReflector(null, reflector);
            this._config.put(REFLECTOR, genericReflector);
            reflector.setParent(genericReflector);
        }
        return genericReflector;
    }

    public void reflectWith(Reflector reflector) {
        if (this.i_stream != null) {
            Exceptions4.throwRuntimeException(46);
        }
        if (reflector == null) {
            throw new NullPointerException();
        }
        this._config.put(CONFIGURED_REFLECTOR, reflector);
        this._config.put(REFLECTOR, null);
    }

    public void refreshClasses() {
        if (this.i_stream != null) {
            this.i_stream.refreshClasses();
        }
    }

    void rename(Rename rename) {
        Collection4 collection4 = this.rename();
        if (collection4 == null) {
            collection4 = new Collection4();
            this._config.put(RENAME, collection4);
        }
        collection4.add(rename);
    }

    public void reserveStorageSpace(long l) throws DatabaseReadOnlyException {
        int n = (int)l;
        if (n < 0) {
            n = 0;
        }
        this._config.put(RESERVED_STORAGE_SPACE, n);
        if (this.i_stream != null) {
            this.i_stream.reserve(n);
        }
    }

    public void send(Object object) {
        if (this.i_stream != null) {
            this.i_stream.send(object);
        }
    }

    public void setBlobPath(String string) throws IOException {
        this.ensureDirExists(string);
        this._config.put(BLOBPATH, string);
    }

    public void setClassLoader(Object object) {
        this.reflectWith(Platform4.createReflector(object));
    }

    public void setMessageRecipient(MessageRecipient messageRecipient) {
        this._config.put(MESSAGE_RECIPIENT, messageRecipient);
    }

    public void setOut(PrintStream printStream) {
        this._config.put(OUTSTREAM, printStream);
        if (this.i_stream != null) {
            this.i_stream.logMsg(19, Db4o.version());
        } else {
            Messages.logMsg(Db4o.configure(), 19, Db4o.version());
        }
    }

    public void singleThreadedClient(boolean bl) {
        this._config.put(SINGLE_THREADED_CLIENT, bl);
    }

    public void testConstructors(boolean bl) {
        this._config.put(TEST_CONSTRUCTORS, bl);
    }

    public void timeoutClientSocket(int n) {
        this._config.put(TIMEOUT_CLIENT_SOCKET, n);
    }

    public void timeoutServerSocket(int n) {
        this._config.put(TIMEOUT_SERVER_SOCKET, n);
    }

    public void unicode(boolean bl) {
        this._config.put(ENCODING, bl ? (byte)2 : 1);
    }

    public void updateDepth(int n) {
        DiagnosticProcessor diagnosticProcessor = this.diagnosticProcessor();
        if (diagnosticProcessor.enabled()) {
            diagnosticProcessor.checkUpdateDepth(n);
        }
        this._config.put(UPDATE_DEPTH, n);
    }

    public void useBTreeSystem() {
        this._config.put(FREESPACE_SYSTEM, (byte)4);
    }

    public void useRamSystem() {
        this._config.put(FREESPACE_SYSTEM, (byte)2);
    }

    public void useIndexSystem() {
        this._config.put(FREESPACE_SYSTEM, (byte)3);
    }

    public void weakReferenceCollectionInterval(int n) {
        this._config.put(WEAK_REFERENCE_COLLECTION_INTERVAL, n);
    }

    public void weakReferences(boolean bl) {
        this._config.put(WEAK_REFERENCES, bl);
    }

    private Collection4 aliases() {
        Collection4 collection4 = (Collection4)this._config.get(ALIASES);
        if (null == collection4) {
            collection4 = new Collection4();
            this._config.put(ALIASES, collection4);
        }
        return collection4;
    }

    public void addAlias(Alias alias) {
        if (null == alias) {
            throw new ArgumentNullException("alias");
        }
        this.aliases().add(alias);
    }

    public void removeAlias(Alias alias) {
        if (null == alias) {
            throw new ArgumentNullException("alias");
        }
        this.aliases().remove(alias);
    }

    public String resolveAliasRuntimeName(String string) {
        Collection4 collection4 = this.aliases();
        if (null == collection4) {
            return string;
        }
        Iterator4 iterator4 = collection4.iterator();
        while (iterator4.moveNext()) {
            String string2 = ((Alias)iterator4.current()).resolveRuntimeName(string);
            if (null == string2) continue;
            return string2;
        }
        return string;
    }

    public String resolveAliasStoredName(String string) {
        Collection4 collection4 = this.aliases();
        if (null == collection4) {
            return string;
        }
        Iterator4 iterator4 = collection4.iterator();
        while (iterator4.moveNext()) {
            String string2 = ((Alias)iterator4.current()).resolveStoredName(string);
            if (null == string2) continue;
            return string2;
        }
        return string;
    }

    ReflectClass reflectorFor(Object object) {
        return ReflectorUtils.reflectClassFor(this.reflector(), object);
    }

    public boolean allowVersionUpdates() {
        return this._config.getAsBoolean(ALLOW_VERSION_UPDATES);
    }

    boolean automaticShutDown() {
        return this._config.getAsBoolean(AUTOMATIC_SHUTDOWN);
    }

    public byte blockSize() {
        return this._config.getAsByte(BLOCKSIZE);
    }

    public int bTreeNodeSize() {
        return this._config.getAsInt(BTREE_NODE_SIZE);
    }

    public int bTreeCacheHeight() {
        return this._config.getAsInt(BTREE_CACHE_HEIGHT);
    }

    String blobPath() {
        return this._config.getAsString(BLOBPATH);
    }

    boolean callbacks() {
        return this._config.getAsBoolean(CALLBACKS);
    }

    TernaryBool callConstructors() {
        return this._config.getAsTernaryBool(CALL_CONSTRUCTORS);
    }

    boolean classActivationDepthConfigurable() {
        return this._config.getAsBoolean(CLASS_ACTIVATION_DEPTH_CONFIGURABLE);
    }

    Object classLoader() {
        return this._config.get(CLASSLOADER);
    }

    boolean detectSchemaChanges() {
        return this._config.getAsBoolean(DETECT_SCHEMA_CHANGES);
    }

    boolean commitRecoveryDisabled() {
        return this._config.getAsBoolean(DISABLE_COMMIT_RECOVERY);
    }

    public DiagnosticConfiguration diagnostic() {
        return (DiagnosticConfiguration)this._config.get(DIAGNOSTIC);
    }

    public DiagnosticProcessor diagnosticProcessor() {
        return (DiagnosticProcessor)this._config.get(DIAGNOSTIC);
    }

    public int discardFreeSpace() {
        return this._config.getAsInt(DISCARD_FREESPACE);
    }

    byte encoding() {
        return this._config.getAsByte(ENCODING);
    }

    boolean encrypt() {
        return this._config.getAsBoolean(ENCRYPT);
    }

    public Hashtable4 exceptionalClasses() {
        Hashtable4 hashtable4 = (Hashtable4)this._config.get(EXCEPTIONAL_CLASSES);
        if (hashtable4 == null) {
            hashtable4 = new Hashtable4(16);
            this._config.put(EXCEPTIONAL_CLASSES, hashtable4);
        }
        return hashtable4;
    }

    public boolean exceptionsOnNotStorable() {
        return this._config.getAsBoolean(EXCEPTIONS_ON_NOT_STORABLE);
    }

    public boolean flushFileBuffers() {
        return this._config.getAsBoolean(FLUSH_FILE_BUFFERS);
    }

    byte freespaceSystem() {
        return this._config.getAsByte(FREESPACE_SYSTEM);
    }

    public ConfigScope generateUUIDs() {
        return (ConfigScope)this._config.get(GENERATE_UUIDS);
    }

    public ConfigScope generateVersionNumbers() {
        return (ConfigScope)this._config.get(GENERATE_VERSION_NUMBERS);
    }

    public boolean internStrings() {
        return this._internStrings;
    }

    public void isServer(boolean bl) {
        this._config.put(IS_SERVER, bl);
    }

    boolean isServer() {
        return this._config.getAsBoolean(IS_SERVER);
    }

    boolean lockFile() {
        return this._config.getAsBoolean(LOCK_FILE);
    }

    int messageLevel() {
        return this._messageLevel;
    }

    public MessageRecipient messageRecipient() {
        return (MessageRecipient)this._config.get(MESSAGE_RECIPIENT);
    }

    boolean optimizeNQ() {
        return this._config.getAsBoolean(OPTIMIZE_NQ);
    }

    String password() {
        return this._config.getAsString(PASSWORD);
    }

    public void prefetchIDCount(int n) {
        this._config.put(PREFETCH_ID_COUNT, n);
    }

    public int prefetchIDCount() {
        return this._config.getAsInt(PREFETCH_ID_COUNT);
    }

    public void prefetchObjectCount(int n) {
        this._config.put(PREFETCH_OBJECT_COUNT, n);
    }

    public int prefetchObjectCount() {
        return this._config.getAsInt(PREFETCH_OBJECT_COUNT);
    }

    Hashtable4 readAs() {
        return (Hashtable4)this._config.get(READ_AS);
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    Collection4 rename() {
        return (Collection4)this._config.get(RENAME);
    }

    int reservedStorageSpace() {
        return this._config.getAsInt(RESERVED_STORAGE_SPACE);
    }

    public boolean singleThreadedClient() {
        return this._config.getAsBoolean(SINGLE_THREADED_CLIENT);
    }

    boolean testConstructors() {
        return this._config.getAsBoolean(TEST_CONSTRUCTORS);
    }

    public int timeoutClientSocket() {
        return this._config.getAsInt(TIMEOUT_CLIENT_SOCKET);
    }

    public int timeoutServerSocket() {
        return this._config.getAsInt(TIMEOUT_SERVER_SOCKET);
    }

    int updateDepth() {
        return this._config.getAsInt(UPDATE_DEPTH);
    }

    int weakReferenceCollectionInterval() {
        return this._config.getAsInt(WEAK_REFERENCE_COLLECTION_INTERVAL);
    }

    boolean weakReferences() {
        return this._config.getAsBoolean(WEAK_REFERENCES);
    }

    IoAdapter ioAdapter() {
        return (IoAdapter)this._config.get(IOADAPTER);
    }

    public QueryConfiguration queries() {
        return this;
    }

    public void evaluationMode(QueryEvaluationMode queryEvaluationMode) {
        this._config.put(QUERY_EVALUATION_MODE, queryEvaluationMode);
    }

    public QueryEvaluationMode queryEvaluationMode() {
        return (QueryEvaluationMode)this._config.get(QUERY_EVALUATION_MODE);
    }

    public void queryResultIteratorFactory(QueryResultIteratorFactory queryResultIteratorFactory) {
        this._config.put(CLIENT_QUERY_RESULT_ITERATOR_FACTORY, queryResultIteratorFactory);
    }

    public QueryResultIteratorFactory queryResultIteratorFactory() {
        return (QueryResultIteratorFactory)this._config.get(CLIENT_QUERY_RESULT_ITERATOR_FACTORY);
    }

    public ClientServerConfiguration clientServer() {
        return this;
    }

    public void batchMessages(boolean bl) {
        this._config.put(BATCH_MESSAGES, bl);
    }

    public boolean batchMessages() {
        return this._config.getAsBoolean(BATCH_MESSAGES);
    }

    public void maxBatchQueueSize(int n) {
        this._config.put(MAX_BATCH_QUEUE_SIZE, n);
    }

    public int maxBatchQueueSize() {
        return this._config.getAsInt(MAX_BATCH_QUEUE_SIZE);
    }
}

