/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.LazyObjectReference;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LockedTree;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectInfoCollectionImpl;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeInt;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

public class LocalTransaction
extends Transaction {
    private final byte[] _pointerBuffer = new byte[8];
    protected final StatefulBuffer i_pointerIo;
    private int i_address;
    private final Collection4 _participants = new Collection4();
    private final LockedTree _slotChanges = new LockedTree();
    private Tree _writtenUpdateDeletedMembers;
    protected final LocalObjectContainer _file;

    public LocalTransaction(ObjectContainerBase objectContainerBase, Transaction transaction, TransactionalReferenceSystem transactionalReferenceSystem) {
        super(objectContainerBase, transaction, transactionalReferenceSystem);
        this._file = (LocalObjectContainer)objectContainerBase;
        this.i_pointerIo = new StatefulBuffer((Transaction)this, 8);
    }

    public LocalObjectContainer file() {
        return this._file;
    }

    public void commit() {
        this.commit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(ServerMessageDispatcher serverMessageDispatcher) {
        Object object = this.container()._lock;
        synchronized (object) {
            if (this.doCommittingCallbacks()) {
                this.callbacks().commitOnStarted(this, this.collectCallbackObjectInfos(serverMessageDispatcher));
            }
            this.freespaceBeginCommit();
            this.commitImpl();
            CallbackObjectInfoCollections callbackObjectInfoCollections = null;
            if (this.doCommittedCallbacks(serverMessageDispatcher)) {
                callbackObjectInfoCollections = this.collectCallbackObjectInfos(serverMessageDispatcher);
            }
            this.commitClearAll();
            this.freespaceEndCommit();
            if (this.doCommittedCallbacks(serverMessageDispatcher)) {
                if (serverMessageDispatcher == null) {
                    this.callbacks().commitOnCompleted(this, callbackObjectInfoCollections);
                } else {
                    serverMessageDispatcher.committedInfo(callbackObjectInfoCollections);
                }
            }
        }
    }

    private boolean doCommittedCallbacks(ServerMessageDispatcher serverMessageDispatcher) {
        if (this.isSystemTransaction()) {
            return false;
        }
        if (serverMessageDispatcher != null) {
            return serverMessageDispatcher.server().caresAboutCommitted();
        }
        return this.callbacks().caresAboutCommitted();
    }

    private boolean doCommittingCallbacks() {
        return !this.isSystemTransaction() && this.callbacks().caresAboutCommitting();
    }

    public void enlist(TransactionParticipant transactionParticipant) {
        if (null == transactionParticipant) {
            throw new ArgumentNullException();
        }
        this.checkSynchronization();
        if (!this._participants.containsByIdentity(transactionParticipant)) {
            this._participants.add(transactionParticipant);
        }
    }

    private void commitImpl() {
        this.commit2Listeners();
        this.commit3Stream();
        this.commit4FieldIndexes();
        this.commitParticipants();
        this.container().writeDirty();
        Slot slot = this.allocateTransactionLogSlot(false);
        this.freeSlotChanges(false);
        this.commitFreespace();
        this.freeSlotChanges(true);
        this.commit6WriteChanges(slot);
    }

    private final void freeSlotChanges(final boolean bl) {
        Visitor4 visitor4 = new Visitor4(){

            public void visit(Object object) {
                ((SlotChange)object).freeDuringCommit(LocalTransaction.this._file, bl);
            }
        };
        if (this.isSystemTransaction()) {
            this._slotChanges.traverseMutable(visitor4);
            return;
        }
        this._slotChanges.traverseLocked(visitor4);
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().freeSlotChanges(bl);
        }
    }

    private void commit2Listeners() {
        this.commitParentListeners();
        this.commitTransactionListeners();
    }

    private void commitParentListeners() {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().commit2Listeners();
        }
    }

    private void commitParticipants() {
        if (this.parentLocalTransaction() != null) {
            this.parentLocalTransaction().commitParticipants();
        }
        Iterator4 iterator4 = this._participants.iterator();
        while (iterator4.moveNext()) {
            ((TransactionParticipant)iterator4.current()).commit(this);
        }
    }

    private void commit3Stream() {
        this.container().processPendingClassUpdates();
        this.container().writeDirty();
        this.container().classCollection().write(this.container().systemTransaction());
    }

    private LocalTransaction parentLocalTransaction() {
        return (LocalTransaction)this._systemTransaction;
    }

    private void commitClearAll() {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().commitClearAll();
        }
        this.clearAll();
    }

    protected void clear() {
        this._slotChanges.clear();
        this.disposeParticipants();
        this._participants.clear();
    }

    private void disposeParticipants() {
        Iterator4 iterator4 = this._participants.iterator();
        while (iterator4.moveNext()) {
            ((TransactionParticipant)iterator4.current()).dispose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.container()._lock;
        synchronized (object) {
            this.rollbackParticipants();
            this.rollbackFieldIndexes();
            this.rollbackSlotChanges();
            this.rollBackTransactionListeners();
            this.clearAll();
        }
    }

    private void rollbackParticipants() {
        Iterator4 iterator4 = this._participants.iterator();
        while (iterator4.moveNext()) {
            ((TransactionParticipant)iterator4.current()).rollback(this);
        }
    }

    protected void rollbackSlotChanges() {
        this._slotChanges.traverseLocked(new Visitor4(){

            public void visit(Object object) {
                ((SlotChange)object).rollback(LocalTransaction.this._file);
            }
        });
    }

    public boolean isDeleted(int n) {
        return this.slotChangeIsFlaggedDeleted(n);
    }

    private Slot allocateTransactionLogSlot(boolean bl) {
        int n = this.transactionLogSlotLength();
        if (this.freespaceManager() != null) {
            int n2 = this._file.bytesToBlocks(n);
            Slot slot = this.freespaceManager().allocateTransactionLogSlot(n2);
            if (slot != null) {
                return this._file.toNonBlockedLength(slot);
            }
        }
        if (!bl) {
            return null;
        }
        return this._file.appendBytes(n);
    }

    private int transactionLogSlotLength() {
        return (this.countSlotChanges() * 3 + 2) * 4;
    }

    private boolean slotLongEnoughForLog(Slot slot) {
        return slot != null && slot.length() >= this.transactionLogSlotLength();
    }

    protected final void commit6WriteChanges(Slot slot) {
        this.checkSynchronization();
        int n = this.countSlotChanges();
        if (n > 0) {
            Slot slot2 = this.slotLongEnoughForLog(slot) ? slot : this.allocateTransactionLogSlot(true);
            StatefulBuffer statefulBuffer = new StatefulBuffer((Transaction)this, slot2);
            statefulBuffer.writeInt(slot2.length());
            statefulBuffer.writeInt(n);
            this.appendSlotChanges(statefulBuffer);
            statefulBuffer.write();
            this.flushFile();
            this.container().writeTransactionPointer(slot2.address());
            this.flushFile();
            if (this.writeSlots()) {
                this.flushFile();
            }
            this.container().writeTransactionPointer(0);
            this.flushFile();
            if (slot2 != slot) {
                this.freeTransactionLogSlot(slot2);
            }
        }
        this.freeTransactionLogSlot(slot);
    }

    private void freeTransactionLogSlot(Slot slot) {
        if (slot == null) {
            return;
        }
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().freeTransactionLogSlot(this._file.toBlockedLength(slot));
    }

    public void writeZeroPointer(int n) {
        this.writePointer(n, Slot.ZERO);
    }

    public void writePointer(Pointer4 pointer4) {
        this.writePointer(pointer4._id, pointer4._slot);
    }

    public void writePointer(int n, Slot slot) {
        this.checkSynchronization();
        this.i_pointerIo.useSlot(n);
        this.i_pointerIo.writeSlot(slot);
        this.i_pointerIo.write();
    }

    private boolean writeSlots() {
        final BooleanByRef booleanByRef = new BooleanByRef();
        this.traverseSlotChanges(new Visitor4(){

            public void visit(Object object) {
                ((SlotChange)object).writePointer(LocalTransaction.this);
                booleanByRef.value = true;
            }
        });
        return booleanByRef.value;
    }

    public void flushFile() {
        if (this._file.configImpl().flushFileBuffers()) {
            this._file.syncFiles();
        }
    }

    private SlotChange produceSlotChange(int n) {
        SlotChange slotChange = new SlotChange(n);
        this._slotChanges.add(slotChange);
        return (SlotChange)slotChange.addedOrExisting();
    }

    private final SlotChange findSlotChange(int n) {
        this.checkSynchronization();
        return (SlotChange)this._slotChanges.find(n);
    }

    public Slot getCurrentSlotOfID(int n) {
        Slot slot;
        this.checkSynchronization();
        if (n == 0) {
            return null;
        }
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null && slotChange.isSetPointer()) {
            return slotChange.newSlot();
        }
        if (this._systemTransaction != null && (slot = this.parentLocalTransaction().getCurrentSlotOfID(n)) != null) {
            return slot;
        }
        return this.readPointer((int)n)._slot;
    }

    public Slot getCommittedSlotOfID(int n) {
        Slot slot;
        if (n == 0) {
            return null;
        }
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null && (slot = slotChange.oldSlot()) != null) {
            return slot;
        }
        if (this._systemTransaction != null && (slot = this.parentLocalTransaction().getCommittedSlotOfID(n)) != null) {
            return slot;
        }
        return this.readPointer((int)n)._slot;
    }

    public Pointer4 readPointer(int n) {
        this._file.readBytes(this._pointerBuffer, n, 8);
        int n2 = this._pointerBuffer[3] & 0xFF | (this._pointerBuffer[2] & 0xFF) << 8 | (this._pointerBuffer[1] & 0xFF) << 16 | this._pointerBuffer[0] << 24;
        int n3 = this._pointerBuffer[7] & 0xFF | (this._pointerBuffer[6] & 0xFF) << 8 | (this._pointerBuffer[5] & 0xFF) << 16 | this._pointerBuffer[4] << 24;
        return new Pointer4(n, new Slot(n2, n3));
    }

    private Pointer4 debugReadPointer(int n) {
        return null;
    }

    public void setPointer(int n, Slot slot) {
        this.checkSynchronization();
        this.produceSlotChange(n).setPointer(slot);
    }

    private boolean slotChangeIsFlaggedDeleted(int n) {
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null) {
            return slotChange.isDeleted();
        }
        if (this._systemTransaction != null) {
            return this.parentLocalTransaction().slotChangeIsFlaggedDeleted(n);
        }
        return false;
    }

    private int countSlotChanges() {
        final IntByRef intByRef = new IntByRef();
        this.traverseSlotChanges(new Visitor4(){

            public void visit(Object object) {
                SlotChange slotChange = (SlotChange)object;
                if (slotChange.isSetPointer()) {
                    ++intByRef.value;
                }
            }
        });
        return intByRef.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeOld() {
        Object object = this.container()._lock;
        synchronized (object) {
            this.i_pointerIo.useSlot(this.i_address);
            this.i_pointerIo.read();
            int n = this.i_pointerIo.readInt();
            if (n > 0) {
                StatefulBuffer statefulBuffer = new StatefulBuffer(this, this.i_address, n);
                statefulBuffer.read();
                statefulBuffer.incrementOffset(4);
                this._slotChanges.read(statefulBuffer, new SlotChange(0));
                if (this.writeSlots()) {
                    this.flushFile();
                }
                this.container().writeTransactionPointer(0);
                this.flushFile();
                this.freeSlotChanges(false);
            } else {
                this.container().writeTransactionPointer(0);
                this.flushFile();
            }
        }
    }

    private void appendSlotChanges(final Buffer buffer) {
        this.traverseSlotChanges(new Visitor4(){

            public void visit(Object object) {
                ((SlotChange)object).write(buffer);
            }
        });
    }

    private void traverseSlotChanges(Visitor4 visitor4) {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().traverseSlotChanges(visitor4);
        }
        this._slotChanges.traverseLocked(visitor4);
    }

    public void slotDelete(int n, Slot slot) {
        this.checkSynchronization();
        if (n == 0) {
            return;
        }
        SlotChange slotChange = this.produceSlotChange(n);
        slotChange.freeOnCommit(this._file, slot);
        slotChange.setPointer(Slot.ZERO);
    }

    public void slotFreeOnCommit(int n, Slot slot) {
        this.checkSynchronization();
        if (n == 0) {
            return;
        }
        this.produceSlotChange(n).freeOnCommit(this._file, slot);
    }

    public void slotFreeOnRollback(int n, Slot slot) {
        this.checkSynchronization();
        this.produceSlotChange(n).freeOnRollback(slot);
    }

    void slotFreeOnRollbackCommitSetPointer(int n, Slot slot, boolean bl) {
        Slot slot2 = this.getCurrentSlotOfID(n);
        if (slot2 == null) {
            return;
        }
        this.checkSynchronization();
        SlotChange slotChange = this.produceSlotChange(n);
        slotChange.freeOnRollbackSetPointer(slot);
        slotChange.freeOnCommit(this._file, slot2);
        slotChange.forFreespace(bl);
    }

    void produceUpdateSlotChange(int n, Slot slot) {
        this.checkSynchronization();
        SlotChange slotChange = this.produceSlotChange(n);
        slotChange.freeOnRollbackSetPointer(slot);
    }

    public void slotFreePointerOnCommit(int n) {
        this.checkSynchronization();
        Slot slot = this.getCurrentSlotOfID(n);
        if (slot == null) {
            return;
        }
        this.slotFreeOnCommit(n, slot);
    }

    void slotFreePointerOnCommit(int n, Slot slot) {
        this.checkSynchronization();
        this.slotFreeOnCommit(slot.address(), slot);
        this.slotFreeOnCommit(n, slot);
    }

    public void slotFreePointerOnRollback(int n) {
        this.produceSlotChange(n).freePointerOnRollback();
    }

    public void processDeletes() {
        if (this._delete == null) {
            this._writtenUpdateDeletedMembers = null;
            return;
        }
        while (this._delete != null) {
            Tree tree = this._delete;
            this._delete = null;
            tree.traverse(new Visitor4(){

                public void visit(Object object) {
                    DeleteInfo deleteInfo = (DeleteInfo)object;
                    if (LocalTransaction.this.isDeleted(deleteInfo._key)) {
                        return;
                    }
                    Object object2 = null;
                    if (deleteInfo._reference != null) {
                        object2 = deleteInfo._reference.getObject();
                    }
                    if (object2 == null || deleteInfo._reference.getID() < 0) {
                        HardObjectReference hardObjectReference = LocalTransaction.this.container().getHardObjectReferenceById(LocalTransaction.this, deleteInfo._key);
                        if (hardObjectReference == HardObjectReference.INVALID) {
                            return;
                        }
                        deleteInfo._reference = hardObjectReference._reference;
                        deleteInfo._reference.flagForDelete(LocalTransaction.this.container().topLevelCallId());
                        object2 = deleteInfo._reference.getObject();
                    }
                    LocalTransaction.this.container().delete3(LocalTransaction.this, deleteInfo._reference, deleteInfo._cascade, false);
                }
            });
        }
        this._writtenUpdateDeletedMembers = null;
    }

    public void writeUpdateDeleteMembers(int n, ClassMetadata classMetadata, int n2, int n3) {
        this.checkSynchronization();
        TreeInt treeInt = new TreeInt(n);
        this._writtenUpdateDeletedMembers = Tree.add(this._writtenUpdateDeletedMembers, treeInt);
        if (!treeInt.wasAddedToTree()) {
            return;
        }
        if (classMetadata.canUpdateFast()) {
            this.slotFreeOnCommit(n, this.getCurrentSlotOfID(n));
            return;
        }
        StatefulBuffer statefulBuffer = this.container().readWriterByID(this, n);
        if (statefulBuffer == null) {
            if (classMetadata.hasClassIndex()) {
                this.dontRemoveFromClassIndex(classMetadata.getID(), n);
            }
            return;
        }
        ObjectHeader objectHeader = new ObjectHeader(this.container(), classMetadata, statefulBuffer);
        DeleteInfo deleteInfo = (DeleteInfo)TreeInt.find(this._delete, n);
        if (deleteInfo != null && deleteInfo._cascade > n3) {
            n3 = deleteInfo._cascade;
        }
        statefulBuffer.setCascadeDeletes(n3);
        classMetadata.deleteMembers(objectHeader._marshallerFamily, objectHeader._headerAttributes, statefulBuffer, n2, true);
        this.slotFreeOnCommit(n, new Slot(statefulBuffer.getAddress(), statefulBuffer.length()));
    }

    private Callbacks callbacks() {
        return this.container().callbacks();
    }

    private CallbackObjectInfoCollections collectCallbackObjectInfos(ServerMessageDispatcher serverMessageDispatcher) {
        if (null == this._slotChanges) {
            return CallbackObjectInfoCollections.EMTPY;
        }
        final Collection4 collection4 = new Collection4();
        final Collection4 collection42 = new Collection4();
        final Collection4 collection43 = new Collection4();
        this._slotChanges.traverseLocked(new Visitor4(){

            public void visit(Object object) {
                SlotChange slotChange = (SlotChange)object;
                LazyObjectReference lazyObjectReference = new LazyObjectReference(LocalTransaction.this, slotChange._key);
                if (slotChange.isDeleted()) {
                    collection42.add(lazyObjectReference);
                } else if (slotChange.isNew()) {
                    collection4.add(lazyObjectReference);
                } else {
                    collection43.add(lazyObjectReference);
                }
            }
        });
        return new CallbackObjectInfoCollections(serverMessageDispatcher, new ObjectInfoCollectionImpl(collection4), new ObjectInfoCollectionImpl(collection43), new ObjectInfoCollectionImpl(collection42));
    }

    private void setAddress(int n) {
        this.i_address = n;
    }

    public static Transaction readInterruptedTransaction(LocalObjectContainer localObjectContainer, Buffer buffer) {
        int n = buffer.readInt();
        int n2 = buffer.readInt();
        if (n > 0 && n == n2) {
            LocalTransaction localTransaction = (LocalTransaction)localObjectContainer.newTransaction(null, null);
            localTransaction.setAddress(n);
            return localTransaction;
        }
        return null;
    }

    private FreespaceManager freespaceManager() {
        return this._file.freespaceManager();
    }

    private void freespaceBeginCommit() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().beginCommit();
    }

    private void freespaceEndCommit() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().endCommit();
    }

    private void commitFreespace() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().commit();
    }
}

