/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.classindex;

import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BufferPair;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.TreeInt;
import com.db4o.internal.classindex.AbstractClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndex;
import com.db4o.internal.classindex.ClassIndexClient;

public class OldClassIndexStrategy
extends AbstractClassIndexStrategy
implements TransactionParticipant {
    private ClassIndex _index;
    private final Hashtable4 _perTransaction = new Hashtable4();

    public OldClassIndexStrategy(ClassMetadata classMetadata) {
        super(classMetadata);
    }

    public void read(ObjectContainerBase objectContainerBase, int n) {
        this._index = this.createClassIndex(objectContainerBase);
        if (n > 0) {
            this._index.setID(n);
        }
        this._index.setStateDeactivated();
    }

    private ClassIndex getActiveIndex(Transaction transaction) {
        if (null != this._index) {
            this._index.ensureActive(transaction);
        }
        return this._index;
    }

    public int entryCount(Transaction transaction) {
        if (this._index != null) {
            return this._index.entryCount(transaction);
        }
        return 0;
    }

    public void initialize(ObjectContainerBase objectContainerBase) {
        this._index = this.createClassIndex(objectContainerBase);
    }

    public void purge() {
        if (this._index != null && !this._index.isDirty()) {
            this._index.clear();
            this._index.setStateDeactivated();
        }
    }

    public int write(Transaction transaction) {
        if (this._index == null) {
            return 0;
        }
        this._index.write(transaction);
        return this._index.getID();
    }

    private void flushContext(final Transaction transaction) {
        TransactionState transactionState = this.getState(transaction);
        final ClassIndex classIndex = this.getActiveIndex(transaction);
        transactionState.traverseAdded(new Visitor4(){

            public void visit(Object object) {
                classIndex.add(OldClassIndexStrategy.this.idFromValue(object));
            }
        });
        transactionState.traverseRemoved(new Visitor4(){

            public void visit(Object object) {
                int n = OldClassIndexStrategy.this.idFromValue(object);
                ObjectReference objectReference = transaction.referenceForId(n);
                if (objectReference != null) {
                    transaction.removeReference(objectReference);
                }
                classIndex.remove(n);
            }
        });
    }

    private void writeIndex(Transaction transaction) {
        this._index.setStateDirty();
        this._index.write(transaction);
    }

    protected void internalAdd(Transaction transaction, int n) {
        this.getState(transaction).add(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionState getState(Transaction transaction) {
        Hashtable4 hashtable4 = this._perTransaction;
        synchronized (hashtable4) {
            TransactionState transactionState = (TransactionState)this._perTransaction.get(transaction);
            if (null == transactionState) {
                transactionState = new TransactionState();
                this._perTransaction.put(transaction, (Object)transactionState);
                ((LocalTransaction)transaction).enlist(this);
            }
            return transactionState;
        }
    }

    private Tree getAll(Transaction transaction) {
        ClassIndex classIndex = this.getActiveIndex(transaction);
        if (classIndex == null) {
            return null;
        }
        final Tree.ByRef byRef = new Tree.ByRef(Tree.deepClone(classIndex.getRoot(), null));
        TransactionState transactionState = this.getState(transaction);
        transactionState.traverseAdded(new Visitor4(){

            public void visit(Object object) {
                byRef.value = Tree.add(byRef.value, new TreeInt(OldClassIndexStrategy.this.idFromValue(object)));
            }
        });
        transactionState.traverseRemoved(new Visitor4(){

            public void visit(Object object) {
                byRef.value = Tree.removeLike(byRef.value, (TreeInt)object);
            }
        });
        return byRef.value;
    }

    protected void internalRemove(Transaction transaction, int n) {
        this.getState(transaction).remove(n);
    }

    public void traverseAll(Transaction transaction, final Visitor4 visitor4) {
        Tree tree = this.getAll(transaction);
        if (tree != null) {
            tree.traverse(new Visitor4(){

                public void visit(Object object) {
                    visitor4.visit(new Integer(OldClassIndexStrategy.this.idFromValue(object)));
                }
            });
        }
    }

    public int idFromValue(Object object) {
        return ((TreeInt)object)._key;
    }

    private ClassIndex createClassIndex(ObjectContainerBase objectContainerBase) {
        if (objectContainerBase.isClient()) {
            return new ClassIndexClient(this._yapClass);
        }
        return new ClassIndex(this._yapClass);
    }

    public void dontDelete(Transaction transaction, int n) {
        this.getState(transaction).dontDelete(n);
    }

    public void commit(Transaction transaction) {
        if (null != this._index) {
            this.flushContext(transaction);
            this.writeIndex(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Transaction transaction) {
        Hashtable4 hashtable4 = this._perTransaction;
        synchronized (hashtable4) {
            this._perTransaction.remove(transaction);
        }
    }

    public void rollback(Transaction transaction) {
    }

    public void defragReference(ClassMetadata classMetadata, BufferPair bufferPair, int n) {
    }

    public int id() {
        return this._index.getID();
    }

    public Iterator4 allSlotIDs(Transaction transaction) {
        throw new NotImplementedException();
    }

    public void defragIndex(BufferPair bufferPair) {
    }

    static final class TransactionState {
        private Tree i_addToClassIndex;
        private Tree i_removeFromClassIndex;

        TransactionState() {
        }

        public void add(int n) {
            this.i_removeFromClassIndex = Tree.removeLike(this.i_removeFromClassIndex, new TreeInt(n));
            this.i_addToClassIndex = Tree.add(this.i_addToClassIndex, new TreeInt(n));
        }

        public void remove(int n) {
            this.i_addToClassIndex = Tree.removeLike(this.i_addToClassIndex, new TreeInt(n));
            this.i_removeFromClassIndex = Tree.add(this.i_removeFromClassIndex, new TreeInt(n));
        }

        public void dontDelete(int n) {
            this.i_removeFromClassIndex = Tree.removeLike(this.i_removeFromClassIndex, new TreeInt(n));
        }

        void traverse(Tree tree, Visitor4 visitor4) {
            if (tree != null) {
                tree.traverse(visitor4);
            }
        }

        public void traverseAdded(Visitor4 visitor4) {
            this.traverse(this.i_addToClassIndex, visitor4);
        }

        public void traverseRemoved(Visitor4 visitor4) {
            this.traverse(this.i_removeFromClassIndex, visitor4);
        }
    }
}

