;;; sisu-mode.el.el --- Major mode for editing .sisu-files

;;; It mainly defines a grammar for syntax highlighting.
;;; SiSU http://www.jus.uio.no/sisu

;;; Copyright 2005 Ralph Amissah

;;; Author: Ralph Amissah <ralph.amissah@gmail.com>
;;; Version: $Id$
;;; Keywords: perl sisu

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;;; This mode is built with help of the
;;; "Emacs language mode creation tutorial" at
;;; http://two-wugs.net/emacs/mode-tutorial.html
;;;
;;; Regexes are defined for the following font-lock-faces:
;;;
;;;   font-lock-keyword-face
;;;   font-lock-type-face
;;;   font-lock-comment-face
;;;   font-lock-reference-face
;;;   font-lock-doc-string-face
;;;   font-lock-function-name-face
;;;

;;; Usage:

;;; Put this file into your load-path and the following into your ~/.emacs:
;;;
;;;    (require 'sisu-mode.el)
;;;
;;;
;;; To associate sisu-mode.el with .s[tmi] files add the following to your ~/.emacs
;;;
;;;    (setq auto-mode-alist
;;;       (append auto-mode-alist
;;;         '(("\\.ss[tmi]$" . sisu-mode.el))))
;;;
;;;
;;; To automatically turn on font-lock-mode add the following to your ~/.emacs
;;;
;;;    (add-hook 'sisu-mode.el-hook 'font-lock-mode)
;;;
;;; Code:

;; ;; default variables
;; (defvar sisu-mode.el-hook nil)
;; 
;; (defvar sisu-mode-map
;;   (let ((sisu-mode-map (make-keymap)))
;;     (define-key wpdl-mode-map "\C-j" 'newline-and-indent)
;;     sisu-mode-map)
;;   "Keymap for SiSU major mode")
;; 
;; (add-to-list 'auto-mode-alist '("\\.ss[tmi]\\'" . sisu-mode))

(defvar sisu-mode-hook nil)

(defvar sisu-mode-map
  (let ((sisu-mode-map (make-keymap)))
    (define-key sisu-mode-map "\C-j" 'newline-and-indent)
    sisu-mode-map)
  "Keymap for SiSU major mode")
(add-to-list 'auto-mode-alist '("\\.ss[tmi]\\'" . sisu-mode))

(defconst sisu-font-lock-keywords-1
  (list
   '("\\<\\(BOOK\\|CHAPTER\\).+" . font-lock-builtin-face)
;   '("\\<\\(BOOK\\|CHAPTER\\)\\>" . font-lock-builtin-face)
   '("\\('\\w*'\\)" . font-lock-variable-name-face))
  "Minimal highlighting expressions for SiSU mode")

(defconst sisu-font-lock-keywords-2
  (append sisu-font-lock-keywords-1
		  (list
; header
		   '("^0~.+" . font-lock-keyword-face)
; heading
		   '("^[1-6]~.+" . font-lock-keyword-face)
; bullet
		   '("\\<\\(_\\*\\|_[12]\\|_\\*[12]\\) " . font-lock-constant-face)
; font, bold italics etc.
		   '("^!_ .+" . font-lock-constant-face)
		   '("[/_+-^,]{.+?}[/_+-^,]" . font-lock-constant-face)
		   '("[!*]{.+?}[!*]" . font-lock-constant-face)
; endnotes
		   '("~{.+?}~" . font-lock-constant-face)
		   '("~\\^(\s\\|$)" . font-lock-constant-face)
		   '("^\\^~\s.+" . font-lock-constant-face)
; links
		   '("{.+?}http://[^ \n]+" . font-lock-constant-face)
		   '("http://[^ \n]+" . font-lock-constant-face)
; breaks
		   '("<:\\(pb\\|np\\)>" . font-lock-constant-face)
		   '("<\\(\s*/\\)?br>" . font-lock-constant-face)
; comments
		   '("[a-zA-Z0-9,.::?!&]+http://[^ \n]+" . font-lock-constant-face)
		   '("^%+ .+" . font-lock-constant-face)
; errors
       '("[a-zA-Z0-9,.::?!&]+http://[^ \n]+" . font-lock-constant-face)
; not done
; multiline matches !!
; poem code group alt
		   '("^code{.+?}code" . font-lock-constant-face)
;		   '("\\http://[a-zA-Z0-9]+" . font-lock-constant-face)
;		   '("\\<\\(\\_\\*\\|\\_[12]\\|\\_\\*[12]\\) \\>" . font-lock-constant-face)
; select more appropriate matches
      ))
  "Additional Keywords to highlight in SiSU mode")
 
 (defconst sisu-font-lock-keywords-3
   (append sisu-font-lock-keywords-2
 		  (list
; 		  '("\\<\\(0~\\|[1-6]~\\|!_ \\)\\>" . font-lock-constant-face)
      ))
   "Balls-out highlighting in SiSU mode")

(defvar sisu-font-lock-keywords sisu-font-lock-keywords-3
  "Default highlighting expressions for SiSU mode")
 
 (defvar sisu-mode-syntax-table
   (let ((sisu-mode-syntax-table (make-syntax-table)))
     (modify-syntax-entry ?_ "w" sisu-mode-syntax-table)
;     (modify-syntax-entry ?/ ". 124b" sisu-mode-syntax-table)
     (modify-syntax-entry ?* ". 23" sisu-mode-syntax-table)
     (modify-syntax-entry ?\n "> b" sisu-mode-syntax-table)
    sisu-mode-syntax-table)
  "Syntax table for sisu-mode")

(defun sisu-mode ()
  "Major mode for editing Workflow Process Description Language files"
  (interactive)
  (kill-all-local-variables)
  (set-syntax-table sisu-mode-syntax-table)
  (use-local-map sisu-mode-map)

(set (make-local-variable 'font-lock-defaults) '(sisu-font-lock-keywords))
(setq major-mode 'sisu-mode)
(setq mode-name "SiSU")
(run-hooks 'sisu-mode-hook))
(provide 'sisu-mode.el)

;; ;; keymap
;; (defvar sisu-mode.el-map nil "Keymap for SiSU major mode.")
;; (if sisu-mode.el-map nil
;;   (let ((map (make-sparse-keymap)))
;;     ;; insert (define-key map ...) stuff here
;;     (setq sisu-mode.el-map map)))
;; 
;; syntax highlighting: standard keywords
;; (defconst sisu-font-lock-keywords-1
;;   '(
;;     ("^\\(!_\\|_[12]\\|_*\\)" 0 font-lock-keyword-face)
;;     ("^_[12]\\(.*\\)$" 1 font-lock-type-face)
;; ;;   ("^[ \t]+\\(.*\\)$" 1 font-lock-type-face)
;;     )
;;   "Minimal highlighting expressions for SiSU mode.")
;; 
;; ;; syntax highlighting: additional keywords
;; (defconst sisu-font-lock-keywords-2
;;   (append sisu-font-lock-keywords-1
;; 	  '(
;; 	    ("%+ \\(.*\\)" 2 font-lock-comment-face)
;; 	    ))
;;   "Additional Keywords to highlight in SiSU mode.")
;; 
;; ;; syntax highlighting: even more keywords
;; (defconst sisu-font-lock-keywords-3
;;   (append sisu-font-lock-keywords-2
;; 	  '(
;; 	    ("^0~.+" 1 font-lock-reference-face)
;; 	    ("^[1-6]~.+" 2 font-lock-reference-face)
;; ;;	    ("[IBSCF]<\\([^>]*\\)>" 1 font-lock-reference-face)
;; ;;	    ("L<\\([^|>]*|\\)?\\([^>]+\\)>" 2 font-lock-reference-face)
;; 	    ("L<\\([^|>]*\\)|\\([^>]*\\)>" 1 font-lock-doc-string-face)
;; 	    ("E<\\([^>]*\\)>" 1 font-lock-function-name-face)
;; 	    ("\"\\([^\"]+\\)\"" 0 font-lock-string-face)
;; 	    ))
;;   "Balls-out highlighting in SiSU mode.")
;; 
;; ;; default level of highlight to maximum
;; (defvar sisu-font-lock-keywords sisu-font-lock-keywords-3
;;   "Default highlighting expressions for SiSU mode")
;; 
;; ;; no special indenting, just pure text mode
;; (defun sisu-indent-line ()
;;   "Indent current line as SiSU code. Does nothing yet."
;;   (interactive)
;;   )
;; 
;; ;; no special syntax table
;; (defvar sisu-mode.el-syntax-table nil
;;   "Syntax table for sisu-mode.el.")
;; 
;; ;; create and activate syntax table
;; (defun sisu-create-syntax-table ()
;;   (if sisu-mode.el-syntax-table
;;       ()
;;     (setq sisu-mode.el-syntax-table (make-syntax-table))
;;     (set-syntax-table sisu-mode.el-syntax-table)
;;     ))

;; main
; (defun sisu-mode.el ()
;   "Major mode for editing SiSU files."
;   (interactive)
;   (kill-all-local-variables)
;   (sisu-create-syntax-table)
;   (use-local-map sisu-mode.el-map)
;   (make-local-variable 'font-lock-defaults)
;   (setq font-lock-defaults '(sisu-font-lock-keywords 't))
;   ;; (make-local-variable 'indent-line-function)
;   ;; (setq indent-line-function 'sisu-indent-line)
;   (setq major-mode 'sisu-mode.el)
;   (setq mode-name "SiSU")
;   (run-hooks 'sisu-mode.el-hook))


;;; sisu-mode.el ends here
