=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: modules shared by the different db types, dbi, postgresql, sqlite

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_DB_columns
  class Column_size
    def lt_title
      320
    end
    def lt_subtitle
      320
    end
    def lt_creator
      200
    end
    def lt_illustrator
      200
    end
    def lt_translator
      200
    end
    def lt_prepared_by
      200
    end
    def lt_digitized_by
      200
    end
    def lt_subject
      400
    end
    def lt_date
      10
    end
    def lt_date_created
      10
    end
    def lt_date_issued
      10
    end
    def lt_date_available
      10
    end
    def lt_date_modified
      10
    end
    def lt_date_valid
      10
    end
    def lt_type
      100
    end
    def lt_description
      800
    end
    def lt_publisher
      120
    end
    def lt_contributor
      120
    end
    def lt_format
      100
    end
    def lt_identifier
      100
    end
    def lt_source
      100
    end
    def lt_language
      30
    end
    def lt_language_char
      3
    end
    def lt_language_original
      30
    end
    def lt_language_original_char
      3
    end
    def lt_relation
      100
    end
    def lt_coverage
      100
    end
    def lt_rights
      800
    end
    def lt_copyright
      200
    end
    def lt_owner
      100
    end
    def lt_keywords
      200
    end
    def lt_comment
      600
    end
    def lt_loc
      30
    end
    def lt_dewey
      30
    end
    def lt_isbn
      16
    end
    def lt_pg
      10
    end
    def lt_abstract
      600
    end
    def lt_skin
      100
    end
    def lt_markup
      100
    end
    def lt_links
      100
    end
    def lt_information
      100
    end
    def lt_contact
      100
    end
    def lt_suffix
      600
    end
    def lt_filename
      256
    end
    def lt_types
      1
    end
    def lt_subj
      64
    end
    def document_clean
      12000
      #2712                                                                      #% (problems with indexing when over 4200 - only a couple of documents affected, at least 12,000 is desireable) #new error message on indexing:  index row size 2900 exceeds btree maximum, 2713
    end
    def document_body
      16000
    end
    def document_seg
      120
    end
    def document_seg_full
      120
    end
    def endnote_clean
      12000
      #2712                                                                       #% (problems with indexing when over 4200 - only a couple of documents affected, at least 12,000 is desireable) #new error message on indexing:  index row size 2900 exceeds btree maximum, 2713
    end
    def endnote_body
      16000
    end
  end
end
__END__
