# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: epub generation, epub pre-processing

=end
require "#{SiSU_lib}/param"
module SiSU_EPUB_Tune
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  require "#{SiSU_lib}/epub_format"                        # epub_format.rb #watch
  @@line_mode=''
  @@endnote_array=[]
  @@endnote_call_counter=1
  @@table_align='<table summary='' width="96%" border="0" bgcolor="white" cellpadding="0" col="3">
<tr ...><td width="2%" align="right">
&nbsp\;</td>
<td width="94%" valign="top" align="justify">'
  @@table_align_close='</td>
<td width="4%" align="right" valign="top">
<font size="1" color="#777777">
&nbsp;&nbsp;&nbsp;</font> </td></tr></table>'
  @@counter,@@column,@columns=0,0,0
  class Output
    def initialize(data,md)
      @data,@md=data,md
      @cX=SiSU_Screen::Ansi.new(@md.cmd).cX
    end
    def hard_output
      my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      @filename_tune=my_make.file_tune
      data=[]
      @data.each{|x| x.obj.strip; data << x if not x.obj.empty?} #1.9 array?
      data.each do |dob|
        @filename_tune.puts dob, "\n" #check
      end
    end
    def marshal
      my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      @marshal_tune=my_make.marshal_tune
      File.open(@marshal_tune,'w') {|f| Marshal.dump(@data.to_a,f)}
    end
  end
  class Clean_xhtml
    def initialize(html='')
      @html=html
    end
    def clean
      html=@html
      str=if html.class==String
        html
      else html.obj
      end
      str.gsub!(/#{Mx[:gl_o]}(#[0-9]{3})#{Mx[:gl_c]}/u,'&\1;')
      str.gsub!(/#{Mx[:gl_o]}#([a-z]{2,4})#{Mx[:gl_c]}/u,'&\1;')
      str.gsub!(/\*/u,'&#042;')   # &#042;
      str.gsub!(/\+/u,'&#043;')   # &#043;
      str.gsub!(/¢/u,'&cent;')    # &#162;
      str.gsub!(/£/u,'&pound;')   # &#163;
      str.gsub!(/¥/u,'&yen;')     # &#165;
      str.gsub!(/§/u,'&sect;')    # &#167;
      str.gsub!(/©/u,'&copy;')    # &#169;
      str.gsub!(/ª/u,'&ordf;')    # &#170;
      str.gsub!(/«/u,'&laquo;')   # &#171;
      str.gsub!(/®/u,'&reg;')     # &#174;
      str.gsub!(/°/u,'&deg;')     # &#176;
      str.gsub!(/±/u,'&plusmn;')  # &#177;
      str.gsub!(/²/u,'&sup2;')    # &#178;
      str.gsub!(/³/u,'&sup3;')    # &#179;
      str.gsub!(/µ/u,'&micro;')   # &#181;
      str.gsub!(/¶/u,'&para;')    # &#182;
      str.gsub!(/¹/u,'&sup1;')    # &#185;
      str.gsub!(/º/u,'&ordm;')    # &#186;
      str.gsub!(/»/u,'&raquo;')   # &#187;
      str.gsub!(/¼/u,'&frac14;')  # &#188;
      str.gsub!(/½/u,'&frac12;')  # &#189;
      str.gsub!(/¾/u,'&frac34;')  # &#190;
      str.gsub!(/×/u,'&times;')   # &#215;
      str.gsub!(/÷/u,'&divide;')  # &#247;
      str.gsub!(/¿/u,'&iquest;')  # &#191;
      str.gsub!(/À/u,'&Agrave;')  # &#192;
      str.gsub!(/Á/u,'&Aacute;')  # &#193;
      str.gsub!(/Â/u,'&Acirc;')   # &#194;
      str.gsub!(/Ã/u,'&Atilde;')  # &#195;
      str.gsub!(/Ä/u,'&Auml;')    # &#196;
      str.gsub!(/Å/u,'&Aring;')   # &#197;
      str.gsub!(/Æ/u,'&AElig;')   # &#198;
      str.gsub!(/Ç/u,'&Ccedil;')  # &#199;
      str.gsub!(/È/u,'&Egrave;')  # &#200;
      str.gsub!(/É/u,'&Eacute;')  # &#201;
      str.gsub!(/Ê/u,'&Ecirc;')   # &#202;
      str.gsub!(/Ë/u,'&Euml;')    # &#203;
      str.gsub!(/Ì/u,'&Igrave;')  # &#204;
      str.gsub!(/Í/u,'&Iacute;')  # &#205;
      str.gsub!(/Î/u,'&Icirc;')   # &#206;
      str.gsub!(/Ï/u,'&Iuml;')    # &#207;
      str.gsub!(/Ð/u,'&ETH;')     # &#208;
      str.gsub!(/Ñ/u,'&Ntilde;')  # &#209;
      str.gsub!(/Ò/u,'&Ograve;')  # &#210;
      str.gsub!(/Ó/u,'&Oacute;')  # &#211;
      str.gsub!(/Ô/u,'&Ocirc;')   # &#212;
      str.gsub!(/Õ/u,'&Otilde;')  # &#213;
      str.gsub!(/Ö/u,'&Ouml;')    # &#214;
      str.gsub!(/Ø/u,'&Oslash;')  # &#216;
      str.gsub!(/Ù/u,'&Ugrave;')  # &#217;
      str.gsub!(/Ú/u,'&Uacute;')  # &#218;
      str.gsub!(/Û/u,'&Ucirc;')   # &#219;
      str.gsub!(/Ü/u,'&Uuml;')    # &#220;
      str.gsub!(/Ý/u,'&Yacute;')  # &#221;
      str.gsub!(/Þ/u,'&THORN;')   # &#222;
      str.gsub!(/ß/u,'&szlig;')   # &#223;
      str.gsub!(/à/u,'&agrave;')  # &#224;
      str.gsub!(/á/u,'&aacute;')  # &#225;
      str.gsub!(/â/u,'&acirc;')   # &#226;
      str.gsub!(/ã/u,'&atilde;')  # &#227;
      str.gsub!(/ä/u,'&auml;')    # &#228;
      str.gsub!(/å/u,'&aring;')   # &#229;
      str.gsub!(/æ/u,'&aelig;')   # &#230;
      str.gsub!(/ç/u,'&ccedil;')  # &#231;
      str.gsub!(/è/u,'&egrave;')  # &#232;
      str.gsub!(/é/u,'&eacute;')  # &#233;
      str.gsub!(/ê/u,'&ecirc;')   # &#234;
      str.gsub!(/ë/u,'&euml;')    # &#235;
      str.gsub!(/ì/u,'&igrave;')  # &#236;
      str.gsub!(/í/u,'&iacute;')  # &#237;
      str.gsub!(/î/u,'&icirc;')   # &#238;
      str.gsub!(/ï/u,'&iuml;')    # &#239;
      str.gsub!(/ð/u,'&eth;')     # &#240;
      str.gsub!(/ñ/u,'&ntilde;')  # &#241;
      str.gsub!(/ò/u,'&ograve;')  # &#242;
      str.gsub!(/ó/u,'&oacute;')  # &#243;
      str.gsub!(/ô/u,'&ocirc;')   # &#244;
      str.gsub!(/õ/u,'&otilde;')  # &#245;
      str.gsub!(/ö/u,'&ouml;')    # &#246;
      str.gsub!(/ø/u,'&oslash;')  # &#248;
      str.gsub!(/ù/u,'&ugrave;')  # &#250;
      str.gsub!(/ú/u,'&uacute;')  # &#251;
      str.gsub!(/û/u,'&ucirc;')   # &#252;
      str.gsub!(/ü/u,'&uuml;')    # &#253;
      str.gsub!(/þ/u,'&thorn;')   # &#254;
      str.gsub!(/ÿ/u,'&yuml;')    # &#255;
      str.gsub!(/ý/u,'&yacute;')
      str.gsub!(/<br>/u,'<br />')
      str.gsub(/#{Mx[:nbsp]}/u,'&nbsp;')
      str
    end
  end
  class Tune
    def initialize(data,md)
      @data,@md=data,md
      @vz=SiSU_Env::Get_init.instance.skin
      @env=SiSU_Env::Info_env.new(@md.fns)
      @sys=SiSU_Env::System_call.new
      @env=SiSU_Env::Info_env.new(@md.fns)
      @brace_url=SiSU_Viz::Skin.new.url_decoration
    end
    def songsheet
      begin
        @cX=SiSU_Screen::Ansi.new(@md.cmd).cX
        SiSU_Screen::Ansi.new(@md.cmd,'Tune').txt_grey if @md.cmd =~/[MVv]/
        data=Tune.new(@data,@md).amp_html
        data=Tune.new(data,@md).endnotes_html
        data=Tune.new(data,@md).url_markup
        data=Tune.new(data,@md).markup
        if @md.cmd =~/M/  #Hard Output Tune Optional on/off here
          data=Output.new(data,@md).hard_output
          Output.new(data,@md).marshal
        end
        tuned=Tune.new(@data,@md).output
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
    def para_numbers
      data=@data
      @tuned_file=[]
      data.each do |dob|
        dob.gsub!(/#{Mx[:lv_o]}\d:(\S?)#{Mx[:lv_c]}/,'\0#\1.&nbsp;') #fix Mx[:lv_o]
        @tuned_file << dob
      end
    end
    def markup
      @tuned_file=[]
      @data.each do |dob|
        dob.obj.gsub!(/#{Mx[:mk_o]}#([a-zA-Z]+)#{Mx[:mk_c]}/,'&\1;')
        dob.obj.gsub!(/#{Mx[:mk_o]}(#[0-9]+)#{Mx[:mk_c]}/,'&\1;')
        dob.obj.gsub!(/#{Mx[:br_line]}|#{Mx[:br_nl]}/,'<br />') unless dob.is=='table'
        dob.obj.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'<b>\1</b>')
        dob.obj.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'<i>\1</i>')
        dob.obj.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'<u>\1</u>')
        dob.obj.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,'<sup>\1</sup>')
        dob.obj.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,'<sub>\1</sub>')
        dob.obj.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'<ins>\1</ins>')
        dob.obj.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'<cite>\1</cite>')
        dob.obj.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'<del>\1</del>')
        dob.obj.gsub!(/#{Mx[:fa_monospace_o]}(.+?)#{Mx[:fa_monospace_c]}/,'<tt>\1</tt>') # tt, kbd
        dob.obj.gsub!(/#{Mx[:mk_o]}:name#(\S+?)#{Mx[:mk_c]}/,'')
        dob.obj.gsub!(/^#{Mx[:gl_bullet]}/m,'●&nbsp;&nbsp;')
        dob.obj.gsub!(/#{Mx[:nbsp]}/,'&nbsp;')
        dob.obj.gsub!(/<(p|br)>/,'<\1 />')
        dob=SiSU_EPUB_Tune::Clean_xhtml.new(dob).clean
        @tuned_file << dob
      end
    end
    def urls(data)
      @words=[]
      map_nametags=SiSU_Particulars::Combined_singleton.instance.get_map_nametags(@md).nametags_map #p map_nametags
      data.each do |word|
        @words << if word=~/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}|image)/
          http_=true
          if word =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
            m,u=/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/.match(word).captures
          elsif word =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/
            http_=false
            m,u=/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:rel_o]}(\S+?)#{Mx[:rel_c]}/.match(word).captures
          elsif word =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}image/
            m,u=/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}(image)/.match(word).captures
          end
          case m
          when /\.png|\.jpg|\.gif|c=|\s\d+x\d+/
            w,h=/\s(\d+)x(\d+)/.match(m).captures if m =~/\s\d+x\d+/
            w=%{width="#{w}"} if w
            h=%{height="#{h}"} if h
            c=m[/"(.+?)"/m,1]
            caption=%{<br /><p class="caption">#{c}</p>} if c
            png=m.scan(/\S+/)[0]
            image_path='./image'
            ins=if u \
            and u.strip !~/^image$/
              %{<a href="#{u}"><img src="#{@env.url.images_epub}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0" /></a>#{caption}}
            else %{<img src="#{@env.url.images_epub}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0" />#{caption}}
            end
            word.gsub!(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/,ins)
          else
            link=m[/(.+)/m]
            png=m.scan(/\S+/)[0].strip
            link=link.strip
            u.sub!(/^#*/,'') #make neater
            if map_nametags[u] \
            and map_nametags[u][:segname]
              if u=~/^\d+$/
                u.gsub!(/^(\d+)$/,"#{map_nametags[u][:segname]}#{Sfx[:xhtml]}#o\\1") if u !~/\// unless http_
              else
                u.gsub!(/(\S+)/,"#{map_nametags[u][:segname]}#{Sfx[:xhtml]}#\\1") if u !~/\// unless http_
              end
            elsif u =~/^:/
              u.gsub!(/^:/,"#{@env.url.root}/")
            elsif u =~/^\.\.\//
              u.gsub!(/^\.\.\//,"#{@env.url.root}/")
            elsif u =~/https?:\/\//
            else p "NOT FOUND name_tags: #{u}"
            end
            ins=%{<a href="#{u}">#{link}</a>}
            word.gsub!(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/,ins)
            word.gsub!(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/,ins)
          end
          word
        else word
        end
        word
      end
      @words=@words.join(' ')
    end
    def url_markup
      data=@data
      @tuned_file=[]
      data.each do |dob|
        unless dob.is=='code'
          if dob.obj =~/<::\s+/ #watch
            dob.obj.gsub!(/<::\s+(\S+?)\s+!>/,
              %{<img src="#{@env.url.images_epub}/c_\\1.png" alt="\\1" width="14" height="14" align="bottom" border="0" />})
          end
          if dob.obj =~/<:image\s+/
            dob.obj.gsub!(/<:image\s+(http\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+>/,
              %{<a href="\\1"><img src="#{@env.url.images_epub}/\\2" \\3 \\4 naturalsizeflag="0" align="bottom" border="0" /></a>})
            dob.obj.gsub!(/<:image\s+(http\S+)\s+(\S+)\s+>/,
              %{<a href="\\1"><img src="#{@env.url.images_epub}/\\2" naturalsizeflag="0" align="bottom" border="0" /></a>})
            dob.obj.gsub!(/<:image\s+(\S+)\s+(\S+)\s+(\S+)\s+>/,
              %{<img src="#{@env.url.images_epub}/\\1" \\2 \\3 naturalsizeflag="0" align="bottom" border="0" />})
            dob.obj.gsub!(/<:image\s+(\S+)\s+>/,
              %{<img src="#{@env.url.images_epub}/\\1" naturalsizeflag="0" align="bottom" border="0" />})
          end
          if dob.obj =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}|image)/
            @word_mode=dob.obj.scan(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}|image)[()\[\]]*[,.;:!?'"]{0,2}|(?:#{Mx[:gl_o]}\S+?#{Mx[:gl_c]})+|[^#{Mx[:lnk_o]}#{Mx[:lnk_c]}]+/mu)
            words=urls(@word_mode)
            dob.obj.gsub!(/.+/m,words)
          end
          dob.obj.gsub!(/\\copyright/i,%{<sup>&copy;</sup>})
          if (dob.obj !~/\<:ad\s+\.\.\//)
            dob.obj.gsub!(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*!\>/,
              %{\n<center><a href="http:\/\/\\1" target="external"><img src="#{@env.url.images_epub}/\\2" alt="\\3" /></a></center>\n})
          else
            dob.obj.gsub!(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*\>/,
              %{\n<center><a href="\\1" target="_top"><img src="#{@env.url.images_epub}/\\2" alt="\\3" /></a></center>\n})
          end
          dob.obj.gsub!(/!pick/,%{<img border="0" height="15" width="15" src="#{@env.url.images_epub}/#{@vz.icon_choice}" alt="stellar" />})
          dob.obj.gsub!(/!new/,%{&nbsp;<img border="0" height="15" width="15" src="#{@env.url.images_epub}/#{@vz.icon_new}" alt="new" />})
          dob.obj.gsub!(/<:h(.{1,7}?)>/,'<a href="#h\1">\1</a>')
          dob.obj.gsub!(/<:to(\d{1,7}?)>/,'<a href="#to\1">to&nbsp;{&nbsp;\1&nbsp;}</a> ')
          if dob.obj =~/\b\S+\@\S+?\.\S+/ \
          and dob.obj !~/(\"\S+\@\S+?\.\S+\"|>\S+\@\S+?\.\S+?<)/
            dob.obj.gsub!(/([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)/,'&lt;<a href="mailto:\1">\1</a>&gt;')
          end
          dob.obj.gsub!(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,'<a href="\1" target="_top">\1</a>') #http ftp matches escaped, no decoration
          dob.obj.gsub!(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,%{#{@brace_url.xml_open}<a href="\\1" target="_top">\\1</a>#{@brace_url.xml_close}}) #http ftp matches with decoration
          if dob.obj =~/..\/\S+/ \
          and dob.obj !~/(\"..\/\S+?\"|>\s*..\/\S+<)/
            dob.obj.gsub!(/(\.\.\/\S+)/,'<a href="\1">\1</a>')
          end
          dob.obj.gsub!(/<a href="\.\.\//,%{<a href="#{@vz.url_site}/})
        else
          dob.obj.gsub!(/(^|[^}])_</m,'\1&lt;'); dob.obj.gsub!(/(^|[^}])_>/m,'\1&gt;') #code-block: angle brackets special characters
          dob.obj.gsub!(/(^|[^}])_</m,'\1&lt;'); dob.obj.gsub!(/(^|[^}])_>/m,'\1&gt;')
        end
        @tuned_file << dob
      end
    end
    def amp_html
      data=@data
      data.each do |dob|
        dob.obj.gsub!(/&/u,'&amp;')
      end
      data
    end
    def endnotes_html
      data=@data
      @tuned_file=[]
      a,s='_a','_s'
      ast,pls='&#042;','&#043;'
      data.each do |dob|
        unless dob.is =~/^code/
          dob.obj.gsub!(/(#{Mx[:en_a_o]}|#{Mx[:en_b_o]})(\d+)\s+(.+?)(#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/,
            %{#{Mx[:nbsp]}<a href="#note\\2">#{Mx[:nbsp]}<sup id="note_ref\\2">\\2</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
            %{\\1\\2 <a href="#note_ref\\2">#{Mx[:nbsp]}<sup id="note\\2">\\2.</sup></a> \\3 \\4}) #endnote- note- (careful may have switched)
          dob.obj.gsub!(/(#{Mx[:en_b_o]})[*](\d+)\s+(.+?)(#{Mx[:en_b_c]})/,
            %{#{Mx[:nbsp]}<a href="#note_astx\\2">#{Mx[:nbsp]}<sup id="note_ref_astx\\2">#{ast}\\2</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
            %{\\1#{ast}\\2 <a href="#note_ref_astx\\2">#{Mx[:nbsp]}<sup id="note_astx\\2">#{ast}\\2.</sup></a> \\3 \\4}) #endnote- note- (careful may have switched)
          dob.obj.gsub!(/(#{Mx[:en_b_o]})[+](\d+)\s+(.+?)(#{Mx[:en_b_c]})/,
            %{#{Mx[:nbsp]}<a href="#note_plus\\2">#{Mx[:nbsp]}<sup id="note_ref_plus\\2">#{pls}\\2</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
            %{\\1#{pls}\\2 <a href="#note_ref_plus\\2">#{Mx[:nbsp]}<sup id="note_plus\\2">#{pls}\\2.</sup></a> \\3 \\4}) #endnote- note- (careful may have switched) # double-check there may here be a bug
          if dob.obj =~/#{Mx[:en_a_o]}([*+]+)\s+.+?#{Mx[:en_a_c]}/
            m=$1.length.to_i
            dob.obj.gsub!(/(#{Mx[:en_a_o]})[*]+\s+(.+?)(#{Mx[:en_a_c]})/,
              %{#{Mx[:nbsp]}<a href="#note#{a*m}">#{Mx[:nbsp]}<sup id="note_ref#{a*m}">#{ast*m}</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
              %{\\1#{ast*m} <a href="#note_ref#{a*m}">#{Mx[:nbsp]}<sup id="note#{a*m}">#{ast*m}</sup></a> \\2 \\3}) #endnote- note- (careful may have switched)
            dob.obj.gsub!(/(#{Mx[:en_a_o]})([+]+)\s+(.+?)(#{Mx[:en_a_c]})/,
              %{#{Mx[:nbsp]}<a href="#note#{s*m}">#{Mx[:nbsp]}<sup id="note_ref#{s*m}">#{pls*m}</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
              %{\\1#{pls*m} <a href="#note_ref#{s*m}">#{Mx[:nbsp]}<sup id="note#{s*m}">#{pls*m}</sup></a> \\2 \\3}) #endnote- note- (careful may have switched)
          end
        end
        @tuned_file << dob
      end
    end
    def output
      data=@data
      @tuned_file=[]
      data.each do |dob|
        dob.obj.strip!
        dob.obj.chomp!
        @tuned_file << dob
      end
      @tuned_file << "\n<EOF>" if (@md.fns =~/\.sst0/) #remove
      @tuned_file
    end
  end
end
__END__
