# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/db_indexes.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
   sqlite

=end
module SiSU_DbIndex
  class Index                                           # create documents Indexes def initialize(opt,conn='',sql_type)
    def initialize(opt,conn,file,sql_type)
      @opt,@conn,@file,@sql_type=opt,conn,file,sql_type
    end
    def create_indexes                                                           # check added from pg not tested
      def conn_execute_sql_pg(conn,sql)
        conn.exec_params(sql)
      end
      def conn_execute_sql_sqlite(conn,sql)
        conn.execute(sql)
      end
      def conn_execute_sql(conn,sql)
        if @sql_type==:pg
          conn_execute_sql_pg(conn,sql)
        elsif @sql_type==:sqlite
          conn_execute_sql_sqlite(conn,sql)
        else
        end
      end
      def conn_execute_array(sql_arr)
        begin
          @conn.transaction do |conn|
            sql_arr.each do |sql|
              conn_execute_sql(conn,sql)
            end
          end
        rescue
          if @conn.is_a?(NilClass)
            errmsg="No sqlite3 connection (check sqlite3 dependencies)"
            if @opt.act[:no_stop][:set]==:on
              SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                error("#{errmsg}, proceeding without sqlite output (as requested)")
            else
              SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                error("#{errmsg}, STOPPING")
              exit
            end
          end
        end
      end
      def base
        if (@opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          print "\n          create documents common indexes\n"
        end
        sql_arr=[
          %{CREATE INDEX idx_ocn ON doc_objects(ocn);},
          %{CREATE INDEX idx_digest_clean ON doc_objects(digest_clean);},
          %{CREATE INDEX idx_digest_all ON doc_objects(digest_all);},
          %{CREATE INDEX idx_lev0 ON doc_objects(lev0);},
          %{CREATE INDEX idx_lev1 ON doc_objects(lev1);},
          %{CREATE INDEX idx_lev2 ON doc_objects(lev2);},
          %{CREATE INDEX idx_lev3 ON doc_objects(lev3);},
          %{CREATE INDEX idx_lev4 ON doc_objects(lev4);},
          %{CREATE INDEX idx_lev5 ON doc_objects(lev5);},
          %{CREATE INDEX idx_lev6 ON doc_objects(lev6);},
          %{CREATE INDEX idx_endnote_nr ON endnotes(nr);},
          %{CREATE INDEX idx_digest_en ON endnotes(digest_clean);},
          %{CREATE INDEX idx_endnote_nr_asterisk ON endnotes_asterisk(nr);},
          %{CREATE INDEX idx_endnote_asterisk ON endnotes_asterisk(clean);},
          %{CREATE INDEX idx_digest_en_asterisk ON endnotes_asterisk(digest_clean);},
          %{CREATE INDEX idx_endnote_nr_plus ON endnotes_plus(nr);},
          %{CREATE INDEX idx_endnote_plus ON endnotes_plus(clean);},
          %{CREATE INDEX idx_digest_en_plus ON endnotes_plus(digest_clean);},
          %{CREATE INDEX idx_title ON metadata_and_text(title);},
          %{CREATE INDEX idx_author ON metadata_and_text(creator_author);},
          %{CREATE INDEX idx_filename ON metadata_and_text(src_filename);},
          %{CREATE INDEX idx_language ON metadata_and_text(language_document_char);},
          %{CREATE INDEX idx_topics ON metadata_and_text(classify_topic_register)},
        ]
        conn_execute_array(sql_arr)
      end
      def text
        if (@opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          print "\n          create documents TEXT indexes\n"
        end
        sql_arr=[
          %{CREATE INDEX idx_clean ON doc_objects(clean);},
          %{CREATE INDEX idx_endnote ON endnotes(clean);}
        ]
        conn_execute_array(sql_arr)
      end
      base
      @opt.act[:psql][:set]==:on ? '' : text
    end
  end
end
__END__
