# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/se_filemap.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_File_Map
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'se_info_env'                           # se_info_env.rb
  class FileMap < SiSU_Info_Env::InfoEnv                   # se_info_env.rb
    attr_accessor :local_sisu_source
    def initialize(opt='') #watch / REVIEW
      super()
      @opt=opt #,opt.fns,opt.selections.str
      @env=(@opt.fns && !(@opt.fns.empty?) \
      ? (SiSU_Env::InfoEnv.new(@opt.fns))
      : (SiSU_Env::InfoEnv.new('dummy.sst')))
      ft=[]
      if @opt.act[:ao][:set]==:on
        @md=SiSU_Param::Parameters.new(@opt).get
        if @md \
        and defined? @md.fn \
        and @md.fn        # used for by_language_code?
          if @md.opt.act[:html][:set]==:on                 #% --html, -h -H
            ft << @md.fn[:html]
          end
          if @md.opt.act[:concordance][:set]==:on          #% --concordance, -w
            ft << @md.fn[:concordance]
          end
          if @md.opt.act[:manifest][:set]==:on             #% --manifest, -y
            ft << @md.fn[:manifest]
          end
          if @md.opt.act[:txt][:set]==:on                  #% --txt, -t -a
            ft << @md.fn[:plain]
          end
          if @md.opt.act[:txt_textile][:set]==:on          #% --textile
            ft << @md.fn[:txt_textile]
          end
          if @md.opt.act[:txt_asciidoc][:set]==:on         #% --asciidoc
            ft << @md.fn[:txt_asciidoc]
          end
          if @md.opt.act[:txt_markdown][:set]==:on         #% --markdown
            ft << @md.fn[:txt_markdown]
          end
          if @md.opt.act[:txt_rst][:set]==:on              #% --rst, --rest
            ft << @md.fn[:txt_rst]
          end
          if @md.opt.act[:xhtml][:set]==:on                #% --xhtml, -b xhtml
            ft << @md.fn[:xhtml]
          end
          if @md.opt.act[:epub][:set]==:on                 #% --epub, -e
            ft << @md.fn[:epub]
          end
          if @md.opt.act[:manpage][:set]==:on              #% --manpage, -i
            ft << @md.fn[:manpage]
          end
          if @md.opt.act[:hash_digests][:set]==:on         #% --hash-digests, -N digest tree
            ft << @md.fn[:digest]
          end
          if @md.opt.act[:odt][:set]==:on                  #% --odt, -o opendocument
            ft << @md.fn[:odf]
          end
          if @md.opt.act[:pdf][:set]==:on                  #% --pdf-l --pdf, -p latex/ texpdf
            ft << @md.fn[:pdf_l] << @md.fn[:pdf_p]
          end
          if @md.opt.act[:share_source][:set]==:on
            ft << @md.fns
          end
          if @md.opt.act[:sisupod][:set]==:on              #% --sisupod, -S make sisupod
            ft << @md.fn[:sisupod]
          end
          if @md.opt.act[:xml_sax][:set]==:on              #% --xml-sax, -x xml sax type
            ft << @md.fn[:sax]
          end
          if @md.opt.act[:xml_dom][:set]==:on              #% --xml-dom, -X xml dom type
            ft << @md.fn[:dom]
          end
          if @md.opt.act[:xml_docbook_book][:set]==:on     #% --xml-docbook-book
            ft << @md.fn[:xml_docbook_book]
          end
          if @md.opt.act[:xml_fictionbook][:set]==:on      #% --xml-fictionbook
            ft << @md.fn[:xml_fictionbook]
          end
          if @md.opt.act[:xml_scaffold_structure_sisu][:set]==:on          #% --xml-scaffold --xml-scaffold-sisu
            ft << @md.fn[:xml_scaffold_structure_sisu]
          end
          if @md.opt.act[:xml_scaffold_structure_collapse][:set]==:on      #% --xml-scaffold-collapse
            ft << @md.fn[:xml_scaffold_structure_collapse]
          end
          @fnb=@md.fnb
        else   # still needed where/when dp document param is not parsed
          if @opt.act[:html][:set]==:on                    #% --html, -h -H
            ft << '.html' << '.html.??'
          end
          if @opt.act[:concordance][:set]==:on             #% --concordance, -w
            ft << 'concordance.html' << '??.concordance.html' << 'concordance.??.html'
          end
          if @opt.act[:manifest][:set]==:on                #% --manifest, -y
            ft << 'sisu_manifest.html' << '??.sisu_manifest.html' << 'sisu_manifest.??.html'
          end
          if @opt.act[:txt][:set]==:on                     #% --txt, -t -a
            ft << 'plain.txt' << '??.plain.txt' << 'plain.??.txt'
          end
          if @opt.act[:txt_textile][:set]==:on             #% --textile
            ft << 'plain.txt' << '??.plain.txt' << 'plain.??.txt'
          end
          if @opt.act[:txt_asciidoc][:set]==:on            #% --asciidoc
            ft << 'plain.txt' << '??.plain.txt' << 'plain.??.txt'
          end
          if @opt.act[:txt_markdown][:set]==:on            #% --markdown
            ft << 'plain.txt' << '??.plain.txt' << 'plain.??.txt'
          end
          if @opt.act[:txt_rst][:set]==:on                 #% --rst, --rest
            ft << 'plain.txt' << '??.plain.txt' << 'plain.??.txt'
          end
          if @opt.act[:xhtml][:set]==:on                   #% --xhtml, -b xhtml
            ft << 'scroll.xhtml' << '??.scroll.xhtml' << 'scroll.??.xhtml'
          end
          if @opt.act[:epub][:set]==:on                    #% --epub, -e
            ft  << @fnb << '.epub'
          end
          if @opt.act[:manpage][:set]==:on                 #% --manpage, -i
            ft << '.1' << '??.man.1' << 'man.??.1'
          end
          if @opt.act[:hash_digests][:set]==:on            #% --hash-digests, -N digest tree
            ft << 'digest.txt' << '??.digest.txt' << 'digest.??.txt'
          end
          if @opt.act[:odt][:set]==:on                     #% --odt, -o opendocument
            ft << 'opendocument.odt' << '??.opendocument.odt' << 'opendocument.??.odt'
          end
          if @opt.act[:pdf][:set]==:on                     #% --pdf-l --pdf, -p latex/ texpdf
            ft << 'landscape.pdf' << 'portrait.pdf' << '.pdf'
          end
          if @opt.act[:share_source][:set]==:on
            ft << '.sst' << '.ssi' << '.ssm'
          end
          if @opt.act[:sisupod][:set]==:on                 #% --sisupod, -S make sisupod
            ft << '.zip'
          end
          if @opt.act[:xml_sax][:set]==:on                 #% --xml-sax, -x xml sax type
            ft << 'sax.xml' << '??.sax.xml' << 'sax.??.xml'
          end
          if @opt.act[:xml_dom][:set]==:on                 #% --xml-dom, -X xml dom type
            ft << 'dom.xml' << '??.dom.xml' << 'dom.??.xml'
          end
          if @opt.act[:xml_docbook_book][:set]==:on        #% --xml-docbook-book
            ft << 'docbook.xml' << '??.docbook.xml' << 'docbook.??.xml'
          end
          if @opt.act[:xml_fictionbook][:set]==:on         #% --xml-fictionbook
            ft << 'fictionbook.xml' << '??.fictionbook.xml' << 'fictionbook.??.xml'
          end
          if @opt.act[:xml_scaffold_structure_sisu][:set]==:on          #% --xml-scaffold --xml-scaffold-sisu
            ft << 'scaffold.xml' << '??.scaffold.xml' << 'scaffold.??.xml'
          end
          if @opt.act[:xml_scaffold_structure_collapse][:set]==:on      #% --xml-scaffold-collapse
            ft << 'scaffold.xml' << '??.scaffold.xml' << 'scaffold.??.xml'
          end
        end
        ft=ft.uniq
        filetypes=ft.join(',')
        @filetypes=if filetypes !~/..+/ then ''   # -r called alone, copy all
        elsif @opt.selections.str =~/u/            then ''   # -u added, copy all, (used to create remote directory tree see output path), not the usual function of -u
        elsif filetypes =~/\S+?,\S+/    then '*{' + filetypes + '}' # more than one relevant file type
        else                                 '*' + filetypes # one relevant file type
        end
        @source_path=(@fnb && !(@fnb.empty?) \
        ? "#{@env.path.output}/#{@fnb}"
        : @env.path.output)
        @source_path_epub=(@fnb && !(@fnb.empty?) \
        ? "#{@env.path.output}/epub"
        : @env.path.output_epub)
        @source_path_src=(@fnb && !(@fnb.empty?) \
        ? "#{@env.path.output}/src"
        : @env.path.output_src)
        @source_path_pod=(@fnb && !(@fnb.empty?) \
        ? "#{@env.path.output}/pod"
        : @env.path.output_pod)
        @source_path_harvest=(@fnb && !(@fnb.empty?) \
        ? "#{@env.path.output}/manifest"
        : @env.path.output_harvest)
        @local_sisu_source=(@filetypes =~/\S/) \
        ? "#{@source_path}/#{@filetypes}"
        : @source_path
      end
      if @opt.act[:rsync][:set]==:on
      end
    end
  end
end
__END__
