# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/se_load.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Load
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  class Load
    def initialize(prog,mandatory=false)
      @prog,@mandatory=prog,mandatory
    end
    def prog
      load_prog=false
      $:.each do |reqpath|
        if FileTest.exist?("#{reqpath}/#{@prog}.rb")
          load_prog=true
          #SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).ok("#{reqpath}/#{@prog}.rb loaded")
          break
        #else SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).warn("#{reqpath}/#{@prog}.rb not found")
        end
      end
      if load_prog \
      and @prog=~/dbi/
        begin
          require 'dbi'
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            error('dbi NOT FOUND (LoadError)')
        end
      end
      if load_prog
        begin
          require @prog
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            error("#{@prog} NOT FOUND (LoadError)")
        end
      else
        @mandatory \
        ? (SiSU_Screen::Ansi.new(@prog,"*WARN* module required: #{@prog}").warn)
        : '' #(SiSU_Screen::Ansi.new(@prog,"*WARN* #{@prog} load requested").warn)
      end
      load_prog
    end
    def prog?
      load_prog=false
      $:.each do |reqpath|
        if FileTest.exist?("#{reqpath}/#{@prog}.rb"); load_prog=true
          break
        end
      end
      load_prog
    end
  end
end
__END__
