# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/shared_images.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: common file for xml generation
=end
module SiSU_Images
  require_relative 'se_hub_particulars'                 # se_hub_particulars.rb
  class Source
    def initialize(opt)
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      SiSU_Images::Source::Place.new(@particulars).songsheet
    end
    class Place
      def initialize(particulars)
        @particulars=particulars
        @md=@particulars.md
        @env=@particulars.env
        @o_str ||=SiSU_Env::ProcessingSettings.new(@md).output_dir_structure
      end
      def songsheet
        images_set.select_sisu_base
        images_set.select_with_document
      end
      def images_set
        @pwd=(/(\S+?)(?:\/(?:#{Px[:lng_lst_rgx]}))?$/).match(Dir.pwd)[1]
        def copy(src_path,dest_path,images=nil)
          if FileTest.directory?(src_path)
            FileUtils::cd(src_path)
            unless images
              images=Dir.glob("*.{png,jpg,gif,ico}")
            end
            unless FileTest.directory?(dest_path) \
            or FileTest.symlink?(dest_path)
              FileUtils::mkdir_p(dest_path)
              FileUtils::chmod(0755,dest_path)
            end
            if images.length > 0
              images.each do |i|
                if FileTest.file?(i)
                  FileUtils::cp_r(i,"#{dest_path}/#{i}")
                  FileUtils::chmod(0644,"#{dest_path}/#{i}")
                else STDERR.puts %{\t*WARN* did not find image - "#{i}" [#{__FILE__}:#{__LINE__}]}
                end
              end
            end
            FileUtils::cd(@pwd)
          else STDERR.puts %{\t*WARN* did not find - "#{src_path}" [#{__FILE__}:#{__LINE__}]}
          end
        end
        def dest_path(image_type)
          pth=if image_type==:image_sys
            pth=(@o_str.dump_or_redirect?) \
            ? "#{@md.file.output_path.html.dir}/image"
            : "#{@md.file.output_path.base.dir}/_sisu/image_sys"
          elsif image_type==:image
            pth=(@o_str.dump_or_redirect?) \
            ? "#{@md.file.output_path.html.dir}/image"
            : "#{@md.file.output_path.base.dir}/_sisu/image"
          end
          pth
        end
        def select_with_document
          images=@md.ec[:image]
          src_path=unless @md.opt.f_pth[:pth] =~/\/\S+?\/sisupod\/\S+?\/sisupod\/doc/
            "#{@pwd}/_sisu/image"
          else #sisupod
            pt=/(\/\S+?\/sisupod\/\S+?\/sisupod)\/doc/.match(@md.opt.f_pth[:pth])[1]
            pt + '/image'
          end
          dest=dest_path(:image)
          copy(src_path,dest,images)
        end
        def select_sisu_base
          images=%w[arrow_next_red.png arrow_prev_red.png arrow_up_red.png dot_clear.png dot_white.png b_doc.png b_epub.png b_odf.png b_pdf.png b_toc.png]
          src_path="#{SiSU_is[:path_base_system_data]}/image"
          dest=dest_path(:image_sys)
          copy(src_path,dest,images)
        end
        self
      end
    end
  end
end
__END__
