__all__=('PackageOption', 'True', 'False')
import string
from BoolOption import True, False
import SCons.Errors
__enable_strings =(str(True), 'yes', 'true',  'on', 'enable', 'search')
__disable_strings=(str(False), 'no',  'false', 'off', 'disable')
def _converter(val):
    lval=string.lower(val)
    if lval in __enable_strings: return True
    if lval in __disable_strings: return False
    return val
def _validator(key, val, env, searchfunc):
    import os
    if env[key]==False:
        pass
    elif env[key]==True:
        if searchfunc:
            env[key]=searchfunc(key, val)
    elif not os.path.exists(val):
        raise SCons.Errors.UserError(
            'Path does not exist for option %s: %s' % (key, val))
def PackageOption(key, help, default, searchfunc=None):
    help=string.join(
        (help, '( yes | no | /path/to/%s )' % key),
        '\n    ')
    return (key, help, default,
            lambda k, v, e, f=searchfunc: _validator(k,v,e,f),
            _converter)
