#if !defined(myeval_h)
#include "lispparse.h"
#include "kanji.h"

enum {
  ENTITY_EMPTY = -1,
  ENTITY_ATOM = 0, ENTITY_STRING, ENTITY_INTEGER, ENTITY_CONS,
  ENTITY_ARRAY,
  /* ϼºݤηȤ¸ߤʤΤˤʤ롣*/
  ENTITY_LIST,
} ;

enum {
  SKKLISP_STRING_NORMAL = 0, SKKLISP_STRING_BACKSLASH, 
  SKKLISP_STRING_HEX, SKKLISP_STRING_OCT,
} ;

#ifndef ERR
#define ERR	(-1)
#define NOERR	(0)
#endif

/*
 * conspair ɽ빽¤Ρ
 */
struct skkinputlisp_conspair {
  struct skkinputlisp_entity *left ;
  struct skkinputlisp_entity *right ;
} ;

/*
 * ɽ빽¤Ρ
 */
struct skkinputlisp_array {
  int length ;
  struct skkinputlisp_entity **array ;
} ;

struct skkinputlisp_entity {
  int type ;			/* ʸȤꥹȷȤΡ*/
  union {
    struct myChar *string ;     /* ʸ ⤷ atom ̾*/
    struct skkinputlisp_conspair conspair ;
    				/* ꥹȤǤ롣cons pair ΤȤ⤢롣*/
    struct skkinputlisp_array array ;
    int integer ;		/* ͡ʤ int Ǥġ*/
  } data ;
  unsigned long count ;		/* ȤƤ*/

  struct skkinputlisp_entity	/* ꥹȤˤƷҤѤ롣*/
  *prev, *next ;
} ;

/*
 * skkinputlisp ѿɽ빽¤Ρ
 */
struct skkinputlisp_variable {
  struct myChar *name ;
  struct skkinputlisp_entity *value ;
  struct skkinputlisp_variable *next ;
} ;

/*
 * skkinputlisp  user define ؿɽ빽¤Ρ
 */
struct skkinputlisp_ufunction {
  struct myChar *name ;		/* ̾*/
  struct conslist *function ;	/* ˴ؿμΤ롣ºݤˤϤ
				   ᤷư뤳Ȥˤʤ롣*/
  struct skkinputlisp_ufunction *next ;
} ;

/*
 * ؿơ֥Ѥ롣
 */
struct skkinputlisp_function {
  unsigned char *name ;
  struct skkinputlisp_entity *(*func)
    ( struct conslist *top, struct skkinputlisp_variable *vlisttop ) ;
} ;

#endif

