/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGPROCESSCREATOR_H
#define SKGPROCESSCREATOR_H
/** @file
 * A property editor for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "ui_skgprocesscreator.h"
#include "skgbankgui_export.h"

#include <QWidget>
#include <QtDesigner/QDesignerExportWidget>
#include "skgpropertyeditor.h"

class SKGDocument;


/**
 * This file is a property editor for skrooge
 */
class SKGBANKGUI_EXPORT SKGProcessCreator : public QWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGProcessCreator(QWidget *parent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGProcessCreator();

    /**
     * Set parameters
     * @param iDocument the document
     * @param iTable the table
     * @param iListAttribute the list of attribute (empty means all attributes supported of the table)
     */
    virtual void setParameters(SKGDocument* iDocument, const QString& iTable, const QStringList& iListAttribute = QStringList(), const QStringList& iListOtherAttribute = QStringList());

    /**
     * Set XML representing the query
     * @param iXML the XML representing the query
     */
    virtual void setXMLCondition(const QString& iXML);

    /**
     * Get XML representing the query
     * @return the XML representing the query
     */
    virtual QString getXMLCondition();

public slots:
    /**
     * Add a new line in the Process Definition
     */
    SKGPropertyEditor* addLine();


private:
    Q_DISABLE_COPY(SKGProcessCreator);


    Ui::skgprocesscreator_base ui;

    QString table;
    SKGDocument* document;
    QStringList listAtts;
    QStringList listOtherAtts;
};

#endif // SKGPROCESSCREATOR_H
