/* Simulator for the Renesas (formerly Hitachi) / SuperH Inc. SH architecture.

   Written by Steve Chamberlain of Cygnus Support.
   sac@cygnus.com

   This file is part of SH sim


		THIS SOFTWARE IS NOT COPYRIGHTED

   Cygnus offers the following for use in the public domain.  Cygnus
   makes no warranty with regard to the software or it's performance
   and the user accepts the software "AS IS" with all faults.

   CYGNUS DISCLAIMS ANY WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO
   THIS SOFTWARE INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/


#include <signal.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "bfin-sim.h"
#include "mem_map.h"
#include "mach.h"
#include "skyeye_types.h"
#include "skyeye_config.h"


#define NONCACHE  0

saved_state_type saved_state;
static char * arch_name = "blackfin";
static void
sim_size ()
{
	if (!saved_state.memory)
		saved_state.memory = (unsigned char *) malloc (SDRAM_SIZE);
	if (!saved_state.dsram)
		saved_state.dsram = (unsigned char *) malloc (DSRAM_SIZE);
	if (!saved_state.isram)
		saved_state.isram = (unsigned char *) malloc (ISRAM_SIZE);
	// PSW 061606
	if (!saved_state.ssram)
		saved_state.ssram = (unsigned char *) malloc (SSRAM_SIZE);
	if (!saved_state.memory) {
		fprintf (stderr, "Not enough VM for simulation of RAM\n");
	}
}


void
bfin_init_state ()
{
	mach_t *p_mach;
	printf ("begin init emulator()\n");
	p_mach = malloc (sizeof (mach_t));
	init_bf533_mach (p_mach);
	/*malloc memory */
	sim_size ();
	saved_state.p_mach = p_mach;
	if (!PF) {
		PF = fopen ("./kernel_prof.txt", "w");
	}
}
void
bfin_reset_state ()
{
	/*fixme */
	saved_state.usp = 0x1000000;
	SPREG = saved_state.usp;
	saved_state.pc = 0x0;
}

/* Set by an instruction emulation function if we performed a jump.  */
int did_jump;

/* Execute a single instruction.  */

static void
bfin_step_once ()
{
	OLDERPCREG = OLDPCREG;
	OLDPCREG = PCREG;


	did_jump = 0;
	interp_insn_bfin (PCREG);
	/* @@@ Not sure how the hardware really behaves when the last insn
	   of a loop is a jump.  */
	if (!did_jump) {
		if (LC1REG && OLDPCREG == LB1REG && --LC1REG)
			PCREG = LT1REG;
		else if (LC0REG && OLDPCREG == LB0REG && --LC0REG)
			PCREG = LT0REG;
	}
	saved_state.p_mach->io_do_cycle ();
}

static void
bfin_set_pc (WORD addr)
{
	PCREG = (bu32) addr;
}
static WORD bfin_get_pc(){
	return PCREG;
}
cpu_config_t bfin_cpu[] = {
	{"bf533", "bf533", 0xffffffff, 0xfffffff0, NONCACHE}
	,
	{NULL,NULL,0,0,0}
};
//chy 2006-04-15
static int 
bfin_ICE_write_byte (WORD addr, uint8_t v)
{
	put_byte (saved_state.memory, addr, (bu8) v);
	return 0;
}
static int
bfin_ICE_read_byte(WORD addr, uint8_t * pv){
	pv=(unsigned char)get_byte(saved_state.memory, addr);
	return 0;
}
static int
bfin_parse_cpu (cpu_config_t * cpu, const char *param[])
{
}

static machine_config_t bfin_machines[] = {
	{"stamp", NULL, NULL, NULL, NULL}
};

static int
bfin_parse_mach (machine_config_t * cpu, const char *param[])
{
}

void
init_bfin_arch ()
{
	static arch_config_t bfin_arch;

	bfin_arch.arch_name = arch_name;
	bfin_arch.init = bfin_init_state;
	bfin_arch.reset = bfin_reset_state;
	bfin_arch.step_once = bfin_step_once;
	bfin_arch.set_pc = bfin_set_pc;
	bfin_arch.get_pc = bfin_get_pc;
	bfin_arch.ICE_write_byte = bfin_ICE_write_byte;
	bfin_arch.ICE_read_byte = bfin_ICE_read_byte;
	bfin_arch.parse_cpu = bfin_parse_cpu;
	bfin_arch.parse_mach = bfin_parse_mach;
	//bfin_arch.parse_mem = bfin_parse_mem;

	register_arch (&bfin_arch);
}
