/* debugger: Remote server for GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "skyeye2gdb.h"
#include "skyeye_types.h"
#include <setjmp.h>
#include <stdio.h>
#include <string.h>
#include <sys/file.h>

//koodailar remove it for mingw 2005.12.18--------------------------------------
#ifndef __MINGW32__
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <sys/ioctl.h>
#endif
//end --------------------------------------------------------------------------

#include <signal.h>
#include <fcntl.h>

#undef DEBUG_RDI
//#define DEBUG_RDI
#ifdef DEBUG_RDI
	#define	DBG_RDI(args...) printf(args)
#else
	#define DBG_RDI(args...) 
#endif
typedef unsigned long CORE_ADDR;
//int remote_debug = 1;
int remote_debug = 0;
static int remote_desc;
jmp_buf toplevel;
int extended_protocol;
int general_thread;
int cont_thread;


unsigned char registers[REGISTER_BYTES];

struct SkyEye_ICE skyeye_ice;
/* Open a connection to a remote debugger.
   NAME is the filename used for communication.  */


//koodailar remove it for mingw-------------------------------------------------
//actually i can include <winsock.h> and <winsock2.h>
//but i am lazy ...
#ifdef __MINGW32__
void remote_open(char * name){}
#else
void
remote_open (char *name)
{
	int save_fcntl_flags;

	char *port_str;
	int port;
	struct sockaddr_in sockaddr;
	int tmp;
	struct protoent *protoent;
	int tmp_desc;

	port_str = strchr (name, ':');

	port = atoi (port_str + 1);

	tmp_desc = socket (PF_INET, SOCK_STREAM, 0);
	if (tmp_desc < 0)
		perror ("Can't open socket");

	/* Allow rapid reuse of this port. */
	tmp = 1;
	setsockopt (tmp_desc, SOL_SOCKET, SO_REUSEADDR, (char *) &tmp,
		    sizeof (tmp));

	sockaddr.sin_family = PF_INET;
	sockaddr.sin_port = htons (port);
	sockaddr.sin_addr.s_addr = INADDR_ANY;

	if (bind (tmp_desc, (struct sockaddr *) &sockaddr, sizeof (sockaddr))
	    || listen (tmp_desc, 1))
		perror ("Can't bind address");

	tmp = sizeof (sockaddr);
	remote_desc = accept (tmp_desc, (struct sockaddr *) &sockaddr, &tmp);
	if (remote_desc == -1)
		perror ("Accept failed");

	/* Enable TCP keep alive process. */
	tmp = 1;
	setsockopt (tmp_desc, SOL_SOCKET, SO_KEEPALIVE, (char *) &tmp,
		    sizeof (tmp));

	/* Tell TCP not to delay small packets.  This greatly speeds up
	   interactive response. */
	tmp = 1;
	setsockopt (remote_desc, 6 /* PROTO_TCP */ , TCP_NODELAY,
		    (char *) &tmp, sizeof (tmp));

	close (tmp_desc);	/* No longer need this */

	signal (SIGPIPE, SIG_IGN);	/* If we don't do this, then gdbserver simply
					   exits when the remote side dies.  */

#if 0				//chy 20050729-------------------
#if defined(F_SETFL) && defined (FASYNC)
	save_fcntl_flags = fcntl (remote_desc, F_GETFL, 0);
	fcntl (remote_desc, F_SETFL, save_fcntl_flags | FASYNC);
	disable_async_io ();
#endif /* FASYNC */
#endif //chy 20050729-------------------
	fprintf (stderr, "Remote debugging using %s\n", name);
}

#endif
//end koodailar ---------------------------------------------------------------


void
remote_close ()
{
	close (remote_desc);
}

/* Convert hex digit A to a number.  */

static int
fromhex (int a)
{
	if (a >= '0' && a <= '9')
		return a - '0';
	else if (a >= 'a' && a <= 'f')
		return a - 'a' + 10;
	else
		perror ("Reply contains invalid hex digit");
}

/* Convert number NIB to a hex digit.  */

static int
tohex (int nib)
{
	if (nib < 10)
		return '0' + nib;
	else
		return 'a' + nib - 10;
}

/* Send a packet to the remote machine, with error checking.
   The data of the packet is in BUF.  Returns >= 0 on success, -1 otherwise. */

int
putpkt (char *buf)
{
	int i;
	unsigned char csum = 0;
	char buf2[2000];
	char buf3[1];
	int cnt = strlen (buf);
	char *p;

	/* Copy the packet into buffer BUF2, encapsulating it
	   and giving it a checksum.  */

	p = buf2;
	*p++ = '$';

	for (i = 0; i < cnt; i++) {
		csum += buf[i];
		*p++ = buf[i];
	}
	*p++ = '#';
	*p++ = tohex ((csum >> 4) & 0xf);
	*p++ = tohex (csum & 0xf);

	*p = '\0';

	/* Send it over and over until we get a positive ack.  */

	do {
		int cc;

		if (write (remote_desc, buf2, p - buf2) != p - buf2) {
			perror ("putpkt(write)");
			return -1;
		}

		if (remote_debug)
			DBG_RDI ("putpkt (\"%s\"); [looking for ack]\n", buf2);
		cc = read (remote_desc, buf3, 1);
		if (remote_debug)
			DBG_RDI ("[received '%c' (0x%x)]\n", buf3[0], buf3[0]);
		if (cc <= 0) {
			if (cc == 0)
				fprintf (stderr, "putpkt(read): Got EOF\n");
			else
				perror ("putpkt(read)");

			return -1;
		}
	}
	while (buf3[0] != '+');

	return 1;		/* Success! */
}

/* Come here when we get an input interrupt from the remote side.  This
   interrupt should only be active while we are waiting for the child to do
   something.  About the only thing that should come through is a ^C, which
   will cause us to send a SIGINT to the child.  */

static void
input_interrupt ()
{
	int cc;
	char c;

	cc = read (remote_desc, &c, 1);

	if (cc != 1 || c != '\003') {
		fprintf (stderr, "input_interrupt, cc = %d c = %d\n", cc, c);
		return;
	}
	DBG_RDI ("SkyEye debugger: input_interrupt: get a ctrl-c\n");
	skyeye_exit (-1);
	//kill (inferior_pid, SIGINT);
}

void
enable_async_io ()
{
//koodailar remove it for mingw 2005.12.18--------------------------------------
#ifndef __MINGW32__                
	signal (SIGIO, input_interrupt);
#endif
//end --------------------------------------------------------------------------	
}

void
disable_async_io ()
{
//koodailar remove it for mingw 2005.12.18--------------------------------------
#ifndef __MINGW32__                  
	signal (SIGIO, SIG_IGN);
#endif	
//end --------------------------------------------------------------------------		
}

/* Returns next char from remote GDB.  -1 if error.  */

static int
readchar ()
{
	static char buf[BUFSIZ];
	static int bufcnt = 0;
	static char *bufp;

	if (bufcnt-- > 0)
		return *bufp++ & 0x7f;

	bufcnt = read (remote_desc, buf, sizeof (buf));

	if (bufcnt <= 0) {
		if (bufcnt == 0)
			fprintf (stderr, "readchar: Got EOF\n");
		else
			perror ("readchar");

		return -1;
	}

	bufp = buf;
	bufcnt--;
	return *bufp++ & 0x7f;
}

/* Read a packet from the remote machine, with error checking,
   and store it in BUF.  Returns length of packet, or negative if error. */

int
getpkt (char *buf)
{
	char *bp;
	unsigned char csum, c1, c2;
	int c;

	while (1) {
		csum = 0;

		while (1) {
			c = readchar ();
			if (c == '$')
				break;
			if (remote_debug)
				DBG_RDI ("[getpkt: discarding char '%c']\n",
					c);
			if (c < 0)
				return -1;
		}

		bp = buf;
		while (1) {
			c = readchar ();
			if (c < 0)
				return -1;
			if (c == '#')
				break;
			*bp++ = c;
			csum += c;
		}
		*bp = 0;

		c1 = fromhex (readchar ());
		c2 = fromhex (readchar ());

		if (csum == (c1 << 4) + c2)
			break;

		fprintf (stderr,
			 "Bad checksum, sentsum=0x%x, csum=0x%x, buf=%s\n",
			 (c1 << 4) + c2, csum, buf);
		write (remote_desc, "-", 1);
	}

	if (remote_debug)
		DBG_RDI ("getpkt (\"%s\");  [sending ack] \n", buf);

	write (remote_desc, "+", 1);

	if (remote_debug)
		DBG_RDI ("[sent ack]\n");
	return bp - buf;
}

void
write_ok (char *buf)
{
	buf[0] = 'O';
	buf[1] = 'K';
	buf[2] = '\0';
}

void
write_enn (char *buf)
{
	buf[0] = 'E';
	buf[1] = 'N';
	buf[2] = 'N';
	buf[3] = '\0';
}

void
convert_int_to_ascii (char *from, char *to, int n)
{
	int nib;
	char ch;
	while (n--) {
		ch = *from++;
		nib = ((ch & 0xf0) >> 4) & 0x0f;
		*to++ = tohex (nib);
		nib = ch & 0x0f;
		*to++ = tohex (nib);
	}
	*to++ = 0;
}


void
convert_ascii_to_int (char *from, char *to, int n)
{
	int nib1, nib2;
	while (n--) {
		nib1 = fromhex (*from++);
		nib2 = fromhex (*from++);
		*to++ = (((nib1 & 0x0f) << 4) & 0xf0) | (nib2 & 0x0f);
	}
}

static char *
outreg (int regno, char *buf)
{
	extern unsigned char registers[];
	int regsize = REGISTER_RAW_SIZE (regno);

	*buf++ = tohex (regno >> 4);
	*buf++ = tohex (regno & 0xf);
	*buf++ = ':';
	convert_int_to_ascii (&registers[REGISTER_BYTE (regno)], buf,
			      regsize);
	buf += 2 * regsize;
	*buf++ = ';';

	return buf;
}

void
prepare_resume_reply (char *buf, char status, unsigned char signo)
{
	int nib;

	*buf++ = status;

	/* FIXME!  Should be converting this signal number (numbered
	   according to the signal numbering of the system we are running on)
	   to the signal numbers used by the gdb protocol (see enum target_signal
	   in gdb/target.h).  */
	nib = ((signo & 0xf0) >> 4);
	*buf++ = tohex (nib);
	nib = signo & 0x0f;
	*buf++ = tohex (nib);

	if (status == 'T') {
		buf = outreg (PC_REGNUM, buf);
		buf = outreg (FP_REGNUM, buf);
		buf = outreg (SP_REGNUM, buf);

	}
	/* For W and X, we're done.  */
	*buf++ = 0;
}

void
decode_m_packet (char *from, CORE_ADDR * mem_addr_ptr, unsigned int *len_ptr)
{
	int i = 0, j = 0;
	char ch;
	*mem_addr_ptr = *len_ptr = 0;

	while ((ch = from[i++]) != ',') {
		*mem_addr_ptr = *mem_addr_ptr << 4;
		*mem_addr_ptr |= fromhex (ch) & 0x0f;
	}

	for (j = 0; j < 4; j++) {
		if ((ch = from[i++]) == 0)
			break;
		*len_ptr = *len_ptr << 4;
		*len_ptr |= fromhex (ch) & 0x0f;
	}
}

void
decode_M_packet (char *from, CORE_ADDR * mem_addr_ptr, unsigned int *len_ptr,
		 char *to)
{
	int i = 0;
	char ch;
	*mem_addr_ptr = *len_ptr = 0;

	while ((ch = from[i++]) != ',') {
		*mem_addr_ptr = *mem_addr_ptr << 4;
		*mem_addr_ptr |= fromhex (ch) & 0x0f;
	}

	while ((ch = from[i++]) != ':') {
		*len_ptr = *len_ptr << 4;
		*len_ptr |= fromhex (ch) & 0x0f;
	}

	convert_ascii_to_int (&from[i++], to, *len_ptr);
}




void
fetch_inferior_registers (int regno, unsigned char *memory)
{
//koodailar add for mingw 2005.12.20--------------------------------------
#ifndef __MINGW32__
	if (regno == -1 || regno == 0)
		for (regno = 0; regno < NUM_REGS; regno++)
			sim_fetch_register (regno,
					    &(memory[REGISTER_BYTE (regno)]));
	else
		sim_fetch_register (regno, &(memory[REGISTER_BYTE (regno)]));
#endif
//end koodailar ----------------------------------------------------------
}

void
store_inferior_registers (int regno, unsigned char *memory)
{
//koodailar add for mingw 2005.12.20--------------------------------------
#ifndef __MINGW32__	
	if (regno == -1 || regno == 0)
		for (regno = 0; regno < NUM_REGS; regno++)
			sim_store_register (regno,
					    &(memory[REGISTER_BYTE (regno)]));
	else
		sim_store_register (regno, &(memory[REGISTER_BYTE (regno)]));
#endif
//end koodailar ----------------------------------------------------------		
}
int
sim_debug ()
{
//koodailar add for mingw 2005.12.20--------------------------------------
#ifndef __MINGW32__		
	static char own_buf[8000], mem_buf[8000];
	char *p;
	char ch, status;
	int i = 0;
	unsigned char signal;
	unsigned int len,addr;
	CORE_ADDR mem_addr;
	int type,size;

	//chy 2006-04-12 init skyeye_ice
	skyeye_ice.num_bps=0;

	if (setjmp (toplevel)) {
		fprintf (stderr, "Exiting\n");
		skyeye_exit (1);
	}
	while (1) {
		remote_open ("host:12345");

	      restart:
		setjmp (toplevel);
		while (getpkt (own_buf) > 0) {
			unsigned char sig;
			i = 0;
			ch = own_buf[i++];
			switch (ch) {
			case 'd':
				remote_debug = !remote_debug;
				break;
#if 0				// chy 2005-07-30
			case '!':
				extended_protocol = 1;
				prepare_resume_reply (own_buf, status,
						      signal);
				break;
#endif //chy
			case '?':
				status = 'S';
				signal = 1;
				prepare_resume_reply (own_buf, status,
						      signal);
				break;
#if 0				// chy 2005-07-30
			case 'H':
				switch (own_buf[1]) {
				case 'g':
					general_thread =
						strtol (&own_buf[2], NULL,
							16);
					write_ok (own_buf);
					fetch_inferior_registers (0);
					break;
				case 'c':
					cont_thread =
						strtol (&own_buf[2], NULL,
							16);
					write_ok (own_buf);
					break;
				default:
					/* Silently ignore it so that gdb can extend the protocol
					   without compatibility headaches.  */
					own_buf[0] = '\0';
					break;
				}
				break;
#endif //chy 2005-07-30
			case 'g':
				fetch_inferior_registers (0, registers);
				convert_int_to_ascii (registers, own_buf,
						      REGISTER_BYTES);
				break;
			case 'G':
				convert_ascii_to_int (&own_buf[1], registers,
						      REGISTER_BYTES);
				store_inferior_registers (-1, registers);
				write_ok (own_buf);
				break;
			case 'm':
				decode_m_packet (&own_buf[1], &mem_addr,
						 &len);
				size=sim_read (mem_addr, mem_buf, len);
				if(size!=-1)
					convert_int_to_ascii (mem_buf, own_buf, len);
				else 
					write_enn (own_buf);
				break;
			case 'M':
				decode_M_packet (&own_buf[1], &mem_addr, &len,
						 mem_buf);
				//chy 2005-07-30  ARM_BREAKPOINT          0xe7ffdefe
				//bp_opcode_conv( (unsigned int) mem_addr, (unsigned int*)mem_buf );                    
				//chy 2006-04-12 debug
				//printf("SKYEYE, debugger M  addr 0x%x, word 0x%x, len 0x%x\n", mem_addr, *((unsigned int *)mem_buf), len);  
				if (sim_write (mem_addr, mem_buf, len) == len)
					write_ok (own_buf);
				else
					write_enn (own_buf);
				break;
				/* chy 2005-07-28
				   case 'q':
				   switch (own_buf[1]) {
				   case 'C':
				   own_buf[0] = '\0';
				   break;
				   case 'O':
				   send_area(own_buf);
				   break;
				   default:
				   own_buf[0] = '\0';
				   break;
				   }
				   break;
				   case 'C':
				   convert_ascii_to_int (own_buf + 1, &sig, 1);
				   myresume (0, sig);
				   signal = mywait (&status);
				   prepare_resume_reply (own_buf, status, signal);
				   break;
				   case 'S':
				   convert_ascii_to_int (own_buf + 1, &sig, 1);
				   myresume (1, sig);
				   signal = mywait (&status);
				   prepare_resume_reply (own_buf, status, signal);
				   break;
				   chy */
			case 'c':
				//chy 2005-07-30
				//ARMul_DoProg (state);
				//sim_resume(0);
				gdbserver_cont();
				prepare_resume_reply (own_buf, status,
						      signal);
				break;
			case 's':
				//chy 2005-07-30
				//sim_resume(1);
				//sim_step_debug();
				//myresume (1, 0);
				//signal = mywait (&status);
				gdbserver_step();
				prepare_resume_reply (own_buf, status,
						      signal);
				break;
			case 'z':
				{
					p=&(own_buf[1]);
					type = strtoul(p, (char **)&p, 16);
					if (*p == ',')
					p++;
					addr = strtoul(p, (char **)&p, 16);
					if (*p == ',')
					p++;
					len = strtoul(p, (char **)&p, 16);
					//printf("SKYEYE:gdbserver z, type %d, addr %x, len %x\n",type, addr,len); 
					if (type == 0 || type == 1) {
					       if (sim_ice_breakpoint_remove(addr) < 0)
					                    goto remove_breakpoint_error;
					       write_ok(own_buf);
					} else {
					   remove_breakpoint_error:
						write_enn(own_buf);
					}
				}
				break;
			case 'Z':
				{
					p=&(own_buf[1]);
					type = strtoul(p, (char **)&p, 16);
					if (*p == ',')
					p++;
					addr = strtoul(p, (char **)&p, 16);
					if (*p == ',')
					p++;
					len = strtoul(p, (char **)&p, 16);
					//printf("SKYEYE:gdbserver Z, type %d, addr %x, len %x\n",type, addr,len); 
					if (type == 0 || type == 1) {
					       if (sim_ice_breakpoint_insert(addr) < 0)
					                    goto insert_breakpoint_error;
					       write_ok(own_buf);
					} else {
					   insert_breakpoint_error:
						write_enn(own_buf);
					}
				}
				break;
#if 0				// chy 2005-07-30
			case 'k':
				fprintf (stderr, "Killing inferior\n");
				kill_inferior ();
				/* When using the extended protocol, we start up a new
				   debugging session.   The traditional protocol will
				   exit instead.  */
				if (extended_protocol) {
					write_ok (own_buf);
					fprintf (stderr,
						 "GDBserver restarting\n");

					/* Wait till we are at 1st instruction in prog.  */
					//chy 20050729 go to restart
					//signal = start_inferior (&argv[2], &status);
					goto restart;
					break;
				}
				else {
					exit (0);
					break;
				}
			case 'T':
				if (mythread_alive
				    (strtol (&own_buf[1], NULL, 16)))
					write_ok (own_buf);
				else
					write_enn (own_buf);
				break;
			case 'R':
				/* Restarting the inferior is only supported in the
				   extended protocol.  */
				if (extended_protocol) {
					kill_inferior ();
					write_ok (own_buf);
					fprintf (stderr,
						 "GDBserver restarting\n");

					/* Wait till we are at 1st instruction in prog.  */
					//chy 20050729 go to restart
					//signal = start_inferior (&argv[2], &status);
					goto restart;
					break;
				}
				else {
					/* It is a request we don't understand.  Respond with an
					   empty packet so that gdb knows that we don't support this
					   request.  */
					own_buf[0] = '\0';
					break;
				}
#endif //chy 2005-07-30
			default:
				/* It is a request we don't understand.  Respond with an
				   empty packet so that gdb knows that we don't support this
				   request.  */
				DBG_RDI(stderr,"unknown command: %c\n",ch);
				own_buf[0] = '\0';
				break;
			}

			putpkt (own_buf);

			if (status == 'W')
				fprintf (stderr,
					 "\nChild exited with status %d\n",
					 sig);
			if (status == 'X')
				fprintf (stderr,
					 "\nChild terminated with signal = 0x%x\n",
					 sig);
			if (status == 'W' || status == 'X') {
				if (extended_protocol) {
					//chy 2005-07-30
					fprintf (stderr,
						 "CHY SkyEye: not Killing inferior\n");
					//kill_inferior ();
					write_ok (own_buf);
					fprintf (stderr,
						 "GDBserver restarting\n");

					/* Wait till we are at 1st instruction in prog.  */
					//chy 20050729 go to restart
					//signal = start_inferior (&argv[2], &status);
					goto restart;
					break;
				}
				else {
					fprintf (stderr,
						 "GDBserver exiting\n");
					skyeye_exit (0);
				}
			}
		}

		/* We come here when getpkt fails.

		   For the extended remote protocol we exit (and this is the only
		   way we gracefully exit!).

		   For the traditional remote protocol close the connection,
		   and re-open it at the top of the loop.  */
		if (extended_protocol) {
			remote_close ();
			skyeye_exit (0);
		}
		else {
			fprintf (stderr,
				 "Remote side has terminated connection.  GDBserver will reopen the connection.\n");

			remote_close ();
		}
	}
#else
	return 0;
#endif
//end koodailar ----------------------------------------------------------		
}
//added by linxz:
int remote_interrupt()
{
       static fd_set rfds;
       static struct timeval tv;

       tv.tv_sec = 0;
       tv.tv_usec = 0;
       FD_ZERO( &rfds );
       FD_SET( remote_desc, &rfds );

       if ( select( remote_desc+1, &rfds, NULL, NULL, &tv ) == 1 )
       {
               int n;
               static char buf[100];

               n = read( remote_desc, buf, sizeof(buf) );
               if ( n>0 )
                       DBG_RDI("Got async char");
               if ( buf[0] == '\003' )
                       DBG_RDI(":Ctrl+C, interrupted.\n");
               return 1;
       }
       return 0;
}

