/* A symbol table. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <obstack.h>
#include <search.h>
#include "xmalloc.h"
#include "symbol.h"
#include "intern.h"

/* Initial hash table size */
#define HSIZE (1 << 13)

/* Allocation using obstack */

#define obstack_chunk_alloc xmalloc
#define obstack_chunk_free free

static struct obstack stack[1];

void
intern_init()
{
  hcreate(HSIZE);
  obstack_init(stack);
}

void
intern_free()
{
  obstack_free(stack, 0);
}

symbol_t
intern(const char *s)
{
  ENTRY e, *ep;
  e.key = (char *)s;
  ep = hsearch(e, FIND);
  if (!ep) {
    char *t = (char *)obstack_copy0(stack, s, strlen(s));
    e.key = t;
    e.data = make_symbol(s);
    ep = hsearch(e, ENTER);
  }
  if (!ep) {
    fprintf(stderr, 
	    "In symbol table, malloc failed during hash table entry\n");
    exit(1);
  }
  return (symbol_t)ep->data;
}
