#include "petsc.h"
#include "petscfix.h"
/* basic.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsregisterdestroy_ EPSREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsregisterdestroy_ epsregisterdestroy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdestroy_ EPSDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdestroy_ epsdestroy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssettarget_ EPSSETTARGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssettarget_ epssettarget
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgettarget_ EPSGETTARGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgettarget_ epsgettarget
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetst_ EPSSETST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetst_ epssetst
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetip_ EPSSETIP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetip_ epssetip
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsisgeneralized_ EPSISGENERALIZED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsisgeneralized_ epsisgeneralized
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsishermitian_ EPSISHERMITIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsishermitian_ epsishermitian
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epsregisterdestroy_(int *__ierr ){
*__ierr = EPSRegisterDestroy();
}
void PETSC_STDCALL  epsdestroy_(EPS *eps, int *__ierr ){
*__ierr = EPSDestroy(*eps);
}
void PETSC_STDCALL  epssettarget_(EPS *eps,PetscScalar *target, int *__ierr ){
*__ierr = EPSSetTarget(*eps,*target);
}
void PETSC_STDCALL  epsgettarget_(EPS *eps,PetscScalar* target, int *__ierr ){
*__ierr = EPSGetTarget(*eps,target);
}
void PETSC_STDCALL  epssetst_(EPS *eps,ST *st, int *__ierr ){
*__ierr = EPSSetST(*eps,*st);
}
void PETSC_STDCALL  epssetip_(EPS *eps,IP *ip, int *__ierr ){
*__ierr = EPSSetIP(*eps,*ip);
}
void PETSC_STDCALL  epsisgeneralized_(EPS *eps,PetscTruth* is, int *__ierr ){
*__ierr = EPSIsGeneralized(*eps,is);
}
void PETSC_STDCALL  epsishermitian_(EPS *eps,PetscTruth* is, int *__ierr ){
*__ierr = EPSIsHermitian(*eps,is);
}
#if defined(__cplusplus)
}
#endif
