define parse(annotations)
{
   variable n, len, pos = 1;

   annotations = strcompress( str_delete_chars(annotations," \t") ,",");

   forever {

	n = string_match(annotations,"[1-9]+[0-9]*:[a-zA-Z]+[a-zA-Z,]*",pos);
	!if (n) break;

	(pos,len) = string_match_nth(0);

	variable options = strtrim_end( annotations[[pos:pos+len-1]], ", \t");
	vmessage("parse(%S) matched at (%d,%d)", options, pos,len);
	pos += (len + 1);
   }
   vmessage("\n");

}

parse("1:OUT");
parse("2:OUT,null,1:vec");
parse("1:NULL, 2:vec,ptr, 3:OUT");

vmessage("\nnow for some questionable/bad input ...\n");

parse("1:NULL 2:vec,ptr, 3:OUT");
parse("1:NULL 2:vec,ptr,,, 3:OUT");
parse("1:NULL 2:vec,ptr, kablooey 3:OUT");
parse("		2 : vec, ptr, 1:kablooey,,ptooey, :gooey 3:OUT");
parse("2:::ewww!");
