/*
    This file is part of the sly ident daemon (slidentd).
   slidentd was written by Sean Hunter <sean@uncarved.com> as a minimal
    RFC1413 (ident) daemon.

   slidentd is copyright (c) 2001 Uncarved Systems Ltd.

   slidentd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

   slidentd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along withslidentd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef SLIDENTD_RANDOM_H
#define SLIDENTD_RANDOM_H
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "slid_config.h"
#include "slidentd.h"

extern void slid_get_raw(unsigned char *buffer, size_t len);
extern char *slid_alloc_hex_rand_buffer(size_t entropy_bytes);
extern void slid_free_hex_rand_buffer(char *buffer);
extern void slid_get_random_hex(char *buffer, size_t entropy_bytes);
extern void slid_open_rand_device(void);
extern void slid_close_rand_device(void);

#endif
