package SliMP3::Buttons::BrowseMenu;

# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;
use File::Spec::Functions qw(:ALL);
use File::Spec::Functions qw(updir);
use SliMP3::Buttons::Common;
use SliMP3::Buttons::Browse;
use SliMP3::Strings qw (string);

# button functions for browse directory
my @browseMenuChoices = ('GENRES','ARTISTS','ALBUMS','MUSIC');
my %functions = (
	
	'up' => sub  {
		my $client = shift;
		my $newposition = SliMP3::Buttons::Common::scroll($client, -1, ($#browseMenuChoices + 1), $client->browseMenuSelection);
		$client->browseMenuSelection($newposition);
		SliMP3::Display::update($client);
	},
	
	'down' => sub  {
		my $client = shift;
		my $newposition = SliMP3::Buttons::Common::scroll($client, +1, ($#browseMenuChoices + 1), $client->browseMenuSelection);
		$client->browseMenuSelection($newposition);
		SliMP3::Display::update($client);
	},
	
	'left' => sub  {
		my $client = shift;
		SliMP3::Buttons::Common::popModeRight($client);
	},
	
	'right' => sub  {
		my $client = shift;
	
		my @oldlines = SliMP3::Display::curLines($client);
		my $push = 1;
		# navigate to the current selected top level item:
		if ($browseMenuChoices[$client->browseMenuSelection] eq 'MUSIC') {
			# reset to the top level of the music
			SliMP3::Buttons::Common::pushMode($client, 'browse');
			SliMP3::Buttons::Browse::loadDir($client, '', "right", \@oldlines);
			$push = 0;
		} elsif ($browseMenuChoices[$client->browseMenuSelection] eq 'SAVED_PLAYLISTS') {
			SliMP3::Buttons::Common::pushMode($client, 'browse');
			SliMP3::Buttons::Browse::loadDir($client, '__playlists', "right", \@oldlines);
			$push = 0;
		} elsif ($browseMenuChoices[$client->browseMenuSelection] eq 'ALBUMS') {
			SliMP3::Buttons::Common::pushMode($client, 'browseid3', {'genre'=>'*', 'artist'=>'*'});
		} elsif ($browseMenuChoices[$client->browseMenuSelection] eq 'ARTISTS') {
			SliMP3::Buttons::Common::pushMode($client, 'browseid3',{'genre'=>'*'});
		} elsif ($browseMenuChoices[$client->browseMenuSelection] eq 'GENRES') {
			SliMP3::Buttons::Common::pushMode($client, 'browseid3',{});
		}
		if ($push) {
			SliMP3::Animation::pushLeft($client, @oldlines, SliMP3::Display::curLines($client));
		}
	}
);

sub getFunctions {
	return \%functions;
}

sub setMode {
	my $client = shift;

	if (!defined($client->browseMenuSelection)) { $client->browseMenuSelection(0); };
	$client->lines(\&lines);
}

#
# figure out the lines to be put up to display the directory
#
sub lines {
	my $client = shift;
	my ($line1, $line2);

	$line1 = string('BROWSEMENU');
	$line2 = string($browseMenuChoices[$client->browseMenuSelection]);

	return ($line1, $line2, undef, SliMP3::VFD::symbol('rightarrow'));
}

1;

__END__
