package SliMP3::Buttons::Power;

# $Id: Power.pm,v 1.38 2003/09/28 15:44:54 kevindf Exp $

# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License, 
# version 2.

use strict;
use File::Spec::Functions qw(:ALL);
use File::Spec::Functions qw(updir);
use SliMP3::Strings qw(string);
use POSIX qw(strftime);

# Each button on the remote has a function:

my %functions = (
	'play' => sub  {
		my $client = shift;
		SliMP3::Command::execute($client, ["play"]);
	},
	'offsize' => sub  {
		my $client = shift;
		my $button = shift;
		my $offsize = SliMP3::Prefs::clientGet($client, "offDisplaySize") ? 0 : 1;
		if ($button eq 'offsize_large') {
			$offsize = 1;
		} elsif ($button eq 'offtsize_small') {
			$offsize = 0;
		}
		SliMP3::Prefs::clientSet($client, "offDisplaySize", $offsize);
		SliMP3::Display::update($client);
	},
);

sub getFunctions {
	return \%functions;
}

sub setMode {
	my $client = shift;
	$client->lines(\&lines);
	SliMP3::Playlist::unsync($client);
	
	if (SliMP3::Playlist::playmode($client) eq 'play' && SliMP3::Playlist::song($client)) {
		if (SliMP3::Info::isHTTPURL(SliMP3::Playlist::song($client))) {
			SliMP3::Command::execute($client, ["stop"]);
		} else {
			SliMP3::Command::execute($client, ["pause", 1]);
		}
	}
	
	# switch to power off mode
	# use our last saved brightness
	SliMP3::VFD::vfdBrightness($client, SliMP3::Prefs::clientGet($client, "powerOffBrightness"));
	SliMP3::Display::update($client);	
}

sub lines {
	my $client = shift;
	return SliMP3::Buttons::Common::dateTime($client);
}

1;

__END__
