
/*
 * slmon
 *
 * Copyright (C) 2000 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is based on WMMon.app.
 *
 * WMMon.app is copyright (c) 1997, 1998 by Martijn Pieterse and
 * Antoine Nulle.
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 */

#include "draw.h"

#ifdef HAVE_SLANG
void init_slang(void)
{
    SLtt_get_terminfo();	/* S-Lang initialization */
    SLang_init_tty(-1, 0, 0);
    SLsmg_init_smg();
    SLtt_set_cursor_visibility(0);

    SLtt_set_color(5, NULL, col_stat, col_stba);	/* status line */
    SLtt_set_color(6, NULL, col_norm, col_back);	/* description */
    SLtt_set_color(7, NULL, col_valu, col_back);	/* value */

    /* Gauge gradient values  */

    SLtt_set_color(10, NULL, col_gra1, col_back);	/* 00 - 09 */
    SLtt_set_color(11, NULL, col_gra2, col_back);	/* 10 - 19 */
    SLtt_set_color(12, NULL, col_gra3, col_back);	/* 20 - 30 */

    /* Too much inverse video look terribly ugly on monochrome terminals */

    if (do_bold)
	SLtt_set_mono(6, NULL, SLTT_BOLD_MASK);
    else
	SLtt_set_mono(6, NULL, 0);
    SLtt_set_mono(7, NULL, 0);
    SLtt_set_mono(10, NULL, 0);
    SLtt_set_mono(11, NULL, 0);
    SLtt_set_mono(12, NULL, 0);

    if (height > SLtt_Screen_Rows)
	height = SLtt_Screen_Rows;
    else if (height < 20)
	height = 20;
}
#endif

void draw_gauge(int row, int col, int value, char *caption)
{
    int i;

#ifdef HAVE_SLANG
    int color;
    SLsmg_gotorc(row, col);
    SLsmg_set_color(7);
    SLsmg_erase_eol();
    SLsmg_printf("%3d%% ", value);
    SLsmg_printf("[");
    color = 10;
#else
    printf("%3d%% [", value);
#endif

    value *= gauge_len;
    value /= 100;
    if (value > 100)		/* Just in case someone tries to cheat us ;->> */
	value = 100;
    for (i = 0; i < value; i++) {
#ifdef HAVE_SLANG
	color = i / (gauge_len / 3) + 10;	/* Gauge colors: 10, 11, 12 */
	if (color > 12)		/* Let's try to be smart ;)) */
	    color = 12;
	SLsmg_set_color(color);
	SLsmg_printf("*");
#else
	printf("*");
#endif
    }
#ifdef HAVE_SLANG
    SLsmg_gotorc(row, col + gauge_len + 6);	/* 6 == strlen("xxx% ["); */
    SLsmg_set_color(7);
    SLsmg_printf("]");
    SLsmg_set_color(6);
    SLsmg_printf(" %s", caption);
#else
    for (i = value; i < gauge_len; i++)
	printf(" ");
    printf("] %s\n", caption);
#endif

}

#ifdef HAVE_SLANG
void draw_status(void)
{
    time_t curtime;		/* Current time */
    struct tm *loctime;		/* Local time */
    char time_str[64];
    struct utsname hi;		/* host info */
    int up_d, up_h, up_m, up_s;	/* Uptime */

    uname(&hi);			/* get host information */
    get_uptime(&up_d, &up_h, &up_m, &up_s);

    curtime = time(NULL);
    loctime = localtime(&curtime);
    strftime(time_str, 64, "%a, %d %B %Y, %H:%M:%S", loctime);

    /* Upper status line */

    SLsmg_gotorc(0, 0);
    SLsmg_set_color(5);
    SLsmg_erase_eol();
    if (mode == MODE_H)
	SLsmg_printf("%s %s\trspace: %d cspace: %d", PACKAGE, VERSION,
		     rspace, cspace);
    else if (mode == MODE_G)
	SLsmg_printf("%s %s\tgauge length: %d ", PACKAGE, VERSION,
		     gauge_len);
    SLsmg_gotorc(0, SLtt_Screen_Cols - strlen(time_str));
    SLsmg_printf("%s", time_str);	/* date/time */

    /* Lower status line */

    SLsmg_gotorc(height - 2, 0);
    SLsmg_printf("%s %s %s %s, %d users", hi.nodename, hi.sysname,
		 hi.release, hi.machine, users());
    SLsmg_erase_eol();
    if (up_d > 0) {
	SLsmg_gotorc(height - 2, SLtt_Screen_Cols - 20);
	SLsmg_printf("Uptime: %3dd %02d:%02d:%02d", up_d, up_h, up_m,
		     up_s);
    } else {
	SLsmg_gotorc(height - 2, SLtt_Screen_Cols - 16);
	SLsmg_printf("Uptime: %02d:%02d:%02d", up_h, up_m, up_s);
    }
}

void draw_histogram(char *caption)
{
    int r = height;
    int c = SLtt_Screen_Cols;
    int r2 = rspace * 2;
    int c2 = cspace * 2;

    /* Box */
    SLsmg_set_color(7);
    SLsmg_draw_box(rspace, cspace, r - r2, c - c2);

    /* If there is enouch space for the scale, than draw it */
    if (cspace >= 4) {
	SLsmg_gotorc(rspace, cspace - 4);
	SLsmg_printf("100%%");
	SLsmg_gotorc(r / 2, cspace - 4);
	SLsmg_printf(" 50%%");
	SLsmg_gotorc(r - rspace - 1, cspace - 4);
	SLsmg_printf("  0%%");
    }

    /* Caption */
    if (caption != NULL) {
	SLsmg_gotorc(rspace, (c / 2) - (strlen(caption) / 2) - 2);
	SLsmg_printf("[ ");
	SLsmg_set_color(6);
	SLsmg_printf("%s", caption);
	SLsmg_set_color(7);
	SLsmg_printf(" ]");
    }
}

void draw_histogram_value(int value, int pos)
{
    value *= height - rspace * 2 - 3;
    value /= 100;
    SLsmg_set_color(7);
    SLsmg_gotorc(height - value - rspace - 2, cspace + pos + 1);
    SLsmg_draw_vline(value + 1);
}

void clear_histogram(void)
{
    int r2 = rspace * 2;
    int c2 = cspace * 2;

    SLsmg_set_color(7);

    /* We have to be careful not to erase frame */
    SLsmg_fill_region(rspace + 1, cspace + 1, height - r2 - 2,
		      SLtt_Screen_Cols - c2 - 2, ' ');
}
#endif

void print_mem(int r, int c)
{
    u_int64_t m_free, m_total, m_used;
    u_int64_t s_total, s_free, s_used;
#ifdef HAVE_GTOP
    glibtop_mem m;
    glibtop_swap s;

    glibtop_get_mem(&m);
    glibtop_get_swap(&s);

    m_free = m.free;
    m_total = m.total;
    m_used = m.used;
    s_free = s.free;
    s_total = s.total;
    s_used = s.used;
#elif defined HAVE_LINUXPROC
    FILE *fp;
    char tmp[128] = { 0 };
    char *p;

    fp = fopen("/proc/meminfo", "r");
    fgets(tmp, 128, fp);

    fgets(tmp, 128, fp);
    p = strtok(tmp, " \n");
    p = strtok(NULL, " \n");
    m_total = atol(p);
    p = strtok(NULL, " \n");
    m_used = atol(p);
    p = strtok(NULL, " \n");
    m_free = atol(p);

    fgets(tmp, 128, fp);
    p = strtok(tmp, " \n");
    p = strtok(NULL, " \n");
    s_total = atol(p);
    p = strtok(NULL, " \n");
    s_used = atol(p);
    p = strtok(NULL, " \n");
    s_free = atol(p);

    fclose(fp);

#endif

#ifdef HAVE_SLANG
    SLsmg_set_color(6);
    SLsmg_gotorc(r++, c);
    SLsmg_printf("\tMemory:\t\t\tSwap:");
    SLsmg_gotorc(r++, c);
    SLsmg_erase_eol();
    SLsmg_printf("Total:\t");
    SLsmg_set_color(7);
    SLsmg_printf("%12Ld %c\t\t%12Ld %c", m_total / unit_div[mem],
		 unit_name[mem], s_total / unit_div[mem], unit_name[mem]);
    SLsmg_gotorc(r++, c);
    SLsmg_set_color(6);
    SLsmg_erase_eol();
    SLsmg_printf("Used:\t");
    SLsmg_set_color(7);
    SLsmg_printf("%12Ld %c\t\t%12Ld %c", m_used / unit_div[mem],
		 unit_name[mem], s_used / unit_div[mem], unit_name[mem]);
    SLsmg_gotorc(r++, c);
    SLsmg_set_color(6);
    SLsmg_erase_eol();
    SLsmg_printf("Free:\t");
    SLsmg_set_color(7);
    SLsmg_printf("%12Ld %c\t\t%12Ld %c", m_free / unit_div[mem],
		 unit_name[mem], s_free / unit_div[mem], unit_name[mem]);
#else
    printf("\n\tMemory:\t\t\tSwap:\n");
    printf("Total:\t");
    printf("%12Ld %c\t\t%12Ld %c\n", m_total / unit_div[mem],
	   unit_name[mem], s_total / unit_div[mem], unit_name[mem]);
    printf("Used:\t");
    printf("%12Ld %c\t\t%12Ld %c\n", m_used / unit_div[mem],
	   unit_name[mem], s_used / unit_div[mem], unit_name[mem]);
    printf("Free:\t");
    printf("%12Ld %c\t\t%12Ld %c\n", m_free / unit_div[mem],
	   unit_name[mem], s_free / unit_div[mem], unit_name[mem]);
#endif
}

#ifdef HAVE_SLANG
void print_keys(int mode)
{
    SLsmg_set_color(6);
    SLsmg_gotorc(height - 1, 0);
    SLsmg_erase_eol();
    if (mode == MODE_H) {
	SLsmg_write_string("q:quit m:graph mode h:histogram mode");
    } else if (mode == MODE_G) {
	SLsmg_write_string("q:quit m:graph mode u:memory unit");
    }
}
#endif


void print_ldavg(int r, int c)
{
#ifdef HAVE_GTOP
    glibtop_loadavg l;
    glibtop_get_loadavg(&l);
#ifdef HAVE_SLANG
    SLsmg_gotorc(r, c);
    SLsmg_set_color(6);
    SLsmg_printf("Load average:\t");
    SLsmg_set_color(7);
    SLsmg_printf("%.2f, %.2f, %.2f", l.loadavg[0], l.loadavg[1],
		 l.loadavg[2]);
#else
    printf("\nLoad average:\t");
    printf("%.2f, %.2f, %.2f", l.loadavg[0], l.loadavg[1], l.loadavg[2]);
#endif
#endif
}
