
/*
 * slmon
 *
 * Copyright (C) 2000 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is based on WMMon.app.
 *
 * WMMon.app is copyright (c) 1997, 1998 by Martijn Pieterse and
 * Antoine Nulle.
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 */

#include "stat.h"

int cpu_calc(int count, struct last *l)
{
    int value;
    double t = 0, i = 0;

#ifdef HAVE_GTOP
    unsigned long f;
    glibtop_cpu cpu;

    glibtop_get_cpu(&cpu);
    f = (unsigned long) cpu.frequency;
    if (count == 0) {
	t = ((unsigned long) cpu.total) ? ((double) cpu.total) : 1.0;
	i = ((unsigned long) cpu.idle) ? ((double) cpu.idle) : 1.0;
    } else {
	t =
	    ((unsigned long) cpu.
	     xcpu_total[count - 1]) ? ((double) cpu.xcpu_total[count -
							       1]) : 1.0;
	i =
	    ((unsigned long) cpu.xcpu_idle[count - 1]) ? ((double) cpu.
							  xcpu_idle[count -
								    1]) :
	    1.0;
    }
    t /= f;
    i /= f;
#elif defined HAVE_LINUXPROC

    char buf[128];
    char *p, procname[5], tmp[5];
    int j;
    char *tokens = " \t\n";
    FILE *fp;

    if (count == 0) {
	strcpy(procname, "cpu ");
    } else if (count > 0) {
	strcpy(procname, "cpu");
	sprintf(tmp, "%c\0", '0' + count - 1);
	strcat(procname, tmp);
    }

    /*
     * /proc/stat: user, nice, system, idle
     */

    fp = fopen("/proc/stat", "r");
    fseek(fp, 0L, SEEK_SET);
    while (fgets(buf, 128, fp)) {
	if (strstr(buf, procname)) {
	    p = strtok(buf, tokens);
	    for (j = 0; j < 3; j++) {
		p = strtok(NULL, tokens);
		t += (double) atof(p);
	    }
	    p = strtok(NULL, tokens);
	    i = (double) atof(p);
	}
    }
    fclose(fp);

    t = t + i;
    t /= 100.0;
    i /= 100.0;

#endif

    value =
	(int) ((t - i - l->totallast) * 100) /
	((t - i - l->totallast) + (i - l->idlelast));

    if (value > 100)		/* FIXME: is this really needed? */
	value = 100;

    l->totallast = t - i;
    l->idlelast = i;

    return value;
}

void get_uptime(int *days, int *hours, int *minutes, int *seconds)
{
    double total;
#ifdef HAVE_GTOP
    glibtop_uptime up;

    glibtop_get_uptime(&up);
    total = up.uptime;
#elif defined HAVE_LINUXPROC
    FILE *fp;
    char up[10] = { 0 };

    fp = fopen("/proc/uptime", "r");
    fseek(fp, 0L, SEEK_SET);
    fgets(up, 10, fp);
    fclose(fp);
    total = atol(up);
#endif

    *seconds = (int) total % 60;
    total /= 60.0;
    *minutes = (int) total % 60;
    total /= 60.0;
    *hours = (int) total % 24;
    total /= 24.0;
    *days = (int) total;
}

int users(void)
{
    int count = 0;
#ifdef HAVE_UTMP
    struct utmp *ut;

    setutent();
    while ((ut = getutent()) != NULL)
	if (ut->ut_type == USER_PROCESS)
	    count++;
    endutent();
#endif
    return count;
}

/*
 * libgtop compatibility: return 0 on non-SMP machines or number of CPUs on
 * SMP machines
 */

#ifdef HAVE_LINUXPROC
int count_cpus(void)
{
    int count = 0;
    char temp[256];
    FILE *fp;

    fp = fopen("/proc/cpuinfo", "r");
    fseek(fp, 0L, SEEK_SET);

    while (!feof(fp)) {
	fgets(temp, 256, fp);
	if (strstr(temp, "processor\t:") != NULL)
	    count++;
    }

    if (count == 1)
	count = 0;

    return count;
}
#endif
