#include <stdlib.h>
#include <string.h>
#include "cgdbm.h"

Cdatum::Cdatum()
{
    data_type = CD_VOID;
    dat.dptr = NULL;
    dat.dsize = 0;
}

Cdatum::Cdatum(const Cdatum &cd)
{
    data_type = cd.data_type;
    dat.dsize = 0;
    dat.dptr = (cd.dat.dsize) ? (char*)malloc(dat.dsize = cd.dat.dsize) : NULL;
    memcpy(dat.dptr, cd.dat.dptr, dat.dsize);
}

Cdatum::Cdatum(const datum &d)
{
    data_type = CD_VOID;
    if (d.dptr != NULL) {
       dat.dptr = (char*)malloc(dat.dsize = d.dsize);
       memcpy(dat.dptr, d.dptr, dat.dsize);
    } else {
       dat.dptr = NULL;
       dat.dsize = 0;
    }
}

Cdatum::Cdatum(const void *ptr, int size)
{
    data_type = CD_VOID;
    dat.dptr = (char*)malloc(dat.dsize = size);
    memcpy(dat.dptr, ptr, size);
}

Cdatum::Cdatum(const char *str)
{
    data_type = CD_STRING;
    dat.dptr = strdup(str);
    dat.dsize = strlen(str) + 1;
}

Cdatum::Cdatum(long val)
{
    data_type = CD_LONG;
    dat.dptr = (char*)malloc(dat.dsize = sizeof(val));
    memcpy(dat.dptr, &val, dat.dsize);
}

Cdatum::Cdatum(float val)
{
    data_type = CD_FLOAT;
    dat.dptr = (char*)malloc(dat.dsize = sizeof(val));
    memcpy(dat.dptr, &val, dat.dsize);
}

Cdatum::~Cdatum()
{
    if (dat.dptr != NULL && dat.dsize) free(dat.dptr);
    dat.dptr = NULL;
    dat.dsize = 0;
}

Cdatum::operator datum&()
{
    return dat;
}

Cdatum::operator const char*()
{
    return dat.dptr;
}

const void *Cdatum::Data()
{
    return dat.dptr;
}

//////////////////////////////////////

const int Cgdbm::Status()
{
    return (db != NULL);
}

Cgdbm::Cgdbm()
{
    filename = NULL;
    db = NULL;
}

Cgdbm::Cgdbm(const char *_filename, int block_size, int read_write, int mode = 0600)
{
    filename = NULL;
    db = NULL;
    Open(_filename, block_size, read_write, mode);
}

Cgdbm::~Cgdbm()
{
    Close();
}

int Cgdbm::Open(const char *_filename, int block_size, int read_write, int mode = 0600)
{
    if (db != NULL) Close();
    db = gdbm_open((char*)_filename, block_size, read_write, mode, NULL);
    if (db != NULL) filename = strdup(_filename);
}

void Cgdbm::Close()
{
    if (filename != NULL) {
       if (db != NULL) gdbm_close(db);
       db = NULL;
       free(filename);
       filename = NULL;
    }
}
   
int Cgdbm::Store(Cdatum &key, Cdatum &content, int flag)
{
    return gdbm_store(db, key, content, flag);
}

int Cgdbm::Insert(Cdatum &key, Cdatum &content)
{
    return Store(key, content, GDBM_INSERT);
}
 
int Cgdbm::Replace(Cdatum &key, Cdatum &content)
{
    return Store(key, content, GDBM_REPLACE);
}

Cdatum &Cgdbm::Fetch(Cdatum &key)
{
    return *new Cdatum(gdbm_fetch(db, key));
}

Cdatum &Cgdbm::FirstKey()
{
    return *new Cdatum(gdbm_firstkey(db));
}

Cdatum &Cgdbm::NextKey(Cdatum &key)
{
    return *new Cdatum(gdbm_nextkey(db, key));
}

int Cgdbm::Exists(Cdatum &key)
{
    return gdbm_exists(db, key);
}

int Cgdbm::Delete(Cdatum &key)
{
    return gdbm_delete(db, key);
}

int Cgdbm::Reorganize()
{
    return gdbm_reorganize(db);
}

void Cgdbm::Sync()
{
    gdbm_sync(db);
}
 
int Cgdbm::SetOpt(int option, int *value, int size)
{
    return gdbm_setopt(db, option, value, size);
}

const char *Cgdbm::StrError(gdbm_error err)
{
    if (err = (gdbm_error)-1) err = gdbm_errno;
    return gdbm_strerror(err);
}

const char *Cgdbm::Version()
{
    return gdbm_version;
}
